// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/documentai/v1beta1/document.proto

package documentai

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	color "google.golang.org/genproto/googleapis/type/color"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Detected human reading orientation.
type Document_Page_Layout_Orientation int32

const (
	// Unspecified orientation.
	Document_Page_Layout_ORIENTATION_UNSPECIFIED Document_Page_Layout_Orientation = 0
	// Orientation is aligned with page up.
	Document_Page_Layout_PAGE_UP Document_Page_Layout_Orientation = 1
	// Orientation is aligned with page right.
	// Turn the head 90 degrees clockwise from upright to read.
	Document_Page_Layout_PAGE_RIGHT Document_Page_Layout_Orientation = 2
	// Orientation is aligned with page down.
	// Turn the head 180 degrees from upright to read.
	Document_Page_Layout_PAGE_DOWN Document_Page_Layout_Orientation = 3
	// Orientation is aligned with page left.
	// Turn the head 90 degrees counterclockwise from upright to read.
	Document_Page_Layout_PAGE_LEFT Document_Page_Layout_Orientation = 4
)

var Document_Page_Layout_Orientation_name = map[int32]string{
	0: "ORIENTATION_UNSPECIFIED",
	1: "PAGE_UP",
	2: "PAGE_RIGHT",
	3: "PAGE_DOWN",
	4: "PAGE_LEFT",
}

var Document_Page_Layout_Orientation_value = map[string]int32{
	"ORIENTATION_UNSPECIFIED": 0,
	"PAGE_UP":                 1,
	"PAGE_RIGHT":              2,
	"PAGE_DOWN":               3,
	"PAGE_LEFT":               4,
}

func (x Document_Page_Layout_Orientation) String() string {
	return proto.EnumName(Document_Page_Layout_Orientation_name, int32(x))
}

func (Document_Page_Layout_Orientation) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5660e1b1964906ba, []int{0, 2, 1, 0}
}

// Enum to denote the type of break found.
type Document_Page_Token_DetectedBreak_Type int32

const (
	// Unspecified break type.
	Document_Page_Token_DetectedBreak_TYPE_UNSPECIFIED Document_Page_Token_DetectedBreak_Type = 0
	// A single whitespace.
	Document_Page_Token_DetectedBreak_SPACE Document_Page_Token_DetectedBreak_Type = 1
	// A wider whitespace.
	Document_Page_Token_DetectedBreak_WIDE_SPACE Document_Page_Token_DetectedBreak_Type = 2
	// A hyphen that indicates that a token has been split across lines.
	Document_Page_Token_DetectedBreak_HYPHEN Document_Page_Token_DetectedBreak_Type = 3
)

var Document_Page_Token_DetectedBreak_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "SPACE",
	2: "WIDE_SPACE",
	3: "HYPHEN",
}

var Document_Page_Token_DetectedBreak_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"SPACE":            1,
	"WIDE_SPACE":       2,
	"HYPHEN":           3,
}

func (x Document_Page_Token_DetectedBreak_Type) String() string {
	return proto.EnumName(Document_Page_Token_DetectedBreak_Type_name, int32(x))
}

func (Document_Page_Token_DetectedBreak_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5660e1b1964906ba, []int{0, 2, 5, 0, 0}
}

// Document represents the canonical document resource in Document Understanding
// AI.
// It is an interchange format that provides insights into documents and allows
// for collaboration between users and Document Understanding AI to iterate and
// optimize for quality.
type Document struct {
	// Original source document from the user.
	//
	// Types that are valid to be assigned to Source:
	//	*Document_Uri
	//	*Document_Content
	Source isDocument_Source `protobuf_oneof:"source"`
	// An IANA published MIME type (also referred to as media type). For more
	// information, see
	// https://www.iana.org/assignments/media-types/media-types.xhtml.
	MimeType string `protobuf:"bytes,3,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// UTF-8 encoded text in reading order from the document.
	Text string `protobuf:"bytes,4,opt,name=text,proto3" json:"text,omitempty"`
	// Styles for the
	// [Document.text][google.cloud.documentai.v1beta1.Document.text].
	TextStyles []*Document_Style `protobuf:"bytes,5,rep,name=text_styles,json=textStyles,proto3" json:"text_styles,omitempty"`
	// Visual page layout for the
	// [Document][google.cloud.documentai.v1beta1.Document].
	Pages []*Document_Page `protobuf:"bytes,6,rep,name=pages,proto3" json:"pages,omitempty"`
	// A list of entities detected on
	// [Document.text][google.cloud.documentai.v1beta1.Document.text]. For
	// document shards, entities in this list may cross shard boundaries.
	Entities []*Document_Entity `protobuf:"bytes,7,rep,name=entities,proto3" json:"entities,omitempty"`
	// Relationship among
	// [Document.entities][google.cloud.documentai.v1beta1.Document.entities].
	EntityRelations []*Document_EntityRelation `protobuf:"bytes,8,rep,name=entity_relations,json=entityRelations,proto3" json:"entity_relations,omitempty"`
	// Information about the sharding if this document is sharded part of a larger
	// document. If the document is not sharded, this message is not specified.
	ShardInfo *Document_ShardInfo `protobuf:"bytes,9,opt,name=shard_info,json=shardInfo,proto3" json:"shard_info,omitempty"`
	// Any error that occurred while processing this document.
	Error                *status.Status `protobuf:"bytes,10,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *Document) Reset()         { *m = Document{} }
func (m *Document) String() string { return proto.CompactTextString(m) }
func (*Document) ProtoMessage()    {}
func (*Document) Descriptor() ([]byte, []int) {
	return fileDescriptor_5660e1b1964906ba, []int{0}
}

func (m *Document) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document.Unmarshal(m, b)
}
func (m *Document) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document.Marshal(b, m, deterministic)
}
func (m *Document) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document.Merge(m, src)
}
func (m *Document) XXX_Size() int {
	return xxx_messageInfo_Document.Size(m)
}
func (m *Document) XXX_DiscardUnknown() {
	xxx_messageInfo_Document.DiscardUnknown(m)
}

var xxx_messageInfo_Document proto.InternalMessageInfo

type isDocument_Source interface {
	isDocument_Source()
}

type Document_Uri struct {
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3,oneof"`
}

type Document_Content struct {
	Content []byte `protobuf:"bytes,2,opt,name=content,proto3,oneof"`
}

func (*Document_Uri) isDocument_Source() {}

func (*Document_Content) isDocument_Source() {}

func (m *Document) GetSource() isDocument_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *Document) GetUri() string {
	if x, ok := m.GetSource().(*Document_Uri); ok {
		return x.Uri
	}
	return ""
}

func (m *Document) GetContent() []byte {
	if x, ok := m.GetSource().(*Document_Content); ok {
		return x.Content
	}
	return nil
}

func (m *Document) GetMimeType() string {
	if m != nil {
		return m.MimeType
	}
	return ""
}

func (m *Document) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *Document) GetTextStyles() []*Document_Style {
	if m != nil {
		return m.TextStyles
	}
	return nil
}

func (m *Document) GetPages() []*Document_Page {
	if m != nil {
		return m.Pages
	}
	return nil
}

func (m *Document) GetEntities() []*Document_Entity {
	if m != nil {
		return m.Entities
	}
	return nil
}

func (m *Document) GetEntityRelations() []*Document_EntityRelation {
	if m != nil {
		return m.EntityRelations
	}
	return nil
}

func (m *Document) GetShardInfo() *Document_ShardInfo {
	if m != nil {
		return m.ShardInfo
	}
	return nil
}

func (m *Document) GetError() *status.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Document) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Document_Uri)(nil),
		(*Document_Content)(nil),
	}
}

// For a large document, sharding may be performed to produce several
// document shards. Each document shard contains this field to detail which
// shard it is.
type Document_ShardInfo struct {
	// The 0-based index of this shard.
	ShardIndex int64 `protobuf:"varint,1,opt,name=shard_index,json=shardIndex,proto3" json:"shard_index,omitempty"`
	// Total number of shards.
	ShardCount int64 `protobuf:"varint,2,opt,name=shard_count,json=shardCount,proto3" json:"shard_count,omitempty"`
	// The index of the first character in
	// [Document.text][google.cloud.documentai.v1beta1.Document.text] in the
	// overall document global text.
	TextOffset           int64    `protobuf:"varint,3,opt,name=text_offset,json=textOffset,proto3" json:"text_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Document_ShardInfo) Reset()         { *m = Document_ShardInfo{} }
func (m *Document_ShardInfo) String() string { return proto.CompactTextString(m) }
func (*Document_ShardInfo) ProtoMessage()    {}
func (*Document_ShardInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_5660e1b1964906ba, []int{0, 0}
}

func (m *Document_ShardInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_ShardInfo.Unmarshal(m, b)
}
func (m *Document_ShardInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_ShardInfo.Marshal(b, m, deterministic)
}
func (m *Document_ShardInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_ShardInfo.Merge(m, src)
}
func (m *Document_ShardInfo) XXX_Size() int {
	return xxx_messageInfo_Document_ShardInfo.Size(m)
}
func (m *Document_ShardInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_ShardInfo.DiscardUnknown(m)
}

var xxx_messageInfo_Document_ShardInfo proto.InternalMessageInfo

func (m *Document_ShardInfo) GetShardIndex() int64 {
	if m != nil {
		return m.ShardIndex
	}
	return 0
}

func (m *Document_ShardInfo) GetShardCount() int64 {
	if m != nil {
		return m.ShardCount
	}
	return 0
}

func (m *Document_ShardInfo) GetTextOffset() int64 {
	if m != nil {
		return m.TextOffset
	}
	return 0
}

// Annotation for common text style attributes. This adheres to CSS
// conventions as much as possible.
type Document_Style struct {
	// Text anchor indexing into the
	// [Document.text][google.cloud.documentai.v1beta1.Document.text].
	TextAnchor *Document_TextAnchor `protobuf:"bytes,1,opt,name=text_anchor,json=textAnchor,proto3" json:"text_anchor,omitempty"`
	// Text color.
	Color *color.Color `protobuf:"bytes,2,opt,name=color,proto3" json:"color,omitempty"`
	// Text background color.
	BackgroundColor *color.Color `protobuf:"bytes,3,opt,name=background_color,json=backgroundColor,proto3" json:"background_color,omitempty"`
	// Font weight. Possible values are normal, bold, bolder, and lighter.
	// https://www.w3schools.com/cssref/pr_font_weight.asp
	FontWeight string `protobuf:"bytes,4,opt,name=font_weight,json=fontWeight,proto3" json:"font_weight,omitempty"`
	// Text style. Possible values are normal, italic, and oblique.
	// https://www.w3schools.com/cssref/pr_font_font-style.asp
	TextStyle string `protobuf:"bytes,5,opt,name=text_style,json=textStyle,proto3" json:"text_style,omitempty"`
	// Text decoration. Follows CSS standard.
	// <text-decoration-line> <text-decoration-color> <text-decoration-style>
	// https://www.w3schools.com/cssref/pr_text_text-decoration.asp
	TextDecoration string `protobuf:"bytes,6,opt,name=text_decoration,json=textDecoration,proto3" json:"text_decoration,omitempty"`
	// Font size.
	FontSize             *Document_Style_FontSize `protobuf:"bytes,7,opt,name=font_size,json=fontSize,proto3" json:"font_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *Document_Style) Reset()         { *m = Document_Style{} }
func (m *Document_Style) String() string { return proto.CompactTextString(m) }
func (*Document_Style) ProtoMessage()    {}
func (*Document_Style) Descriptor() ([]byte, []int) {
	return fileDescriptor_5660e1b1964906ba, []int{0, 1}
}

func (m *Document_Style) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Style.Unmarshal(m, b)
}
func (m *Document_Style) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Style.Marshal(b, m, deterministic)
}
func (m *Document_Style) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Style.Merge(m, src)
}
func (m *Document_Style) XXX_Size() int {
	return xxx_messageInfo_Document_Style.Size(m)
}
func (m *Document_Style) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Style.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Style proto.InternalMessageInfo

func (m *Document_Style) GetTextAnchor() *Document_TextAnchor {
	if m != nil {
		return m.TextAnchor
	}
	return nil
}

func (m *Document_Style) GetColor() *color.Color {
	if m != nil {
		return m.Color
	}
	return nil
}

func (m *Document_Style) GetBackgroundColor() *color.Color {
	if m != nil {
		return m.BackgroundColor
	}
	return nil
}

func (m *Document_Style) GetFontWeight() string {
	if m != nil {
		return m.FontWeight
	}
	return ""
}

func (m *Document_Style) GetTextStyle() string {
	if m != nil {
		return m.TextStyle
	}
	return ""
}

func (m *Document_Style) GetTextDecoration() string {
	if m != nil {
		return m.TextDecoration
	}
	return ""
}

func (m *Document_Style) GetFontSize() *Document_Style_FontSize {
	if m != nil {
		return m.FontSize
	}
	return nil
}

// Font size with unit.
type Document_Style_FontSize struct {
	// Font size for the text.
	Size float32 `protobuf:"fixed32,1,opt,name=size,proto3" json:"size,omitempty"`
	// Unit for the font size. Follows CSS naming (in, px, pt, etc.).
	Unit                 string   `protobuf:"bytes,2,opt,name=unit,proto3" json:"unit,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Document_Style_FontSize) Reset()         { *m = Document_Style_FontSize{} }
func (m *Document_Style_FontSize) String() string { return proto.CompactTextString(m) }
func (*Document_Style_FontSize) ProtoMessage()    {}
func (*Document_Style_FontSize) Descriptor() ([]byte, []int) {
	return fileDescriptor_5660e1b1964906ba, []int{0, 1, 0}
}

func (m *Document_Style_FontSize) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Style_FontSize.Unmarshal(m, b)
}
func (m *Document_Style_FontSize) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Style_FontSize.Marshal(b, m, deterministic)
}
func (m *Document_Style_FontSize) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Style_FontSize.Merge(m, src)
}
func (m *Document_Style_FontSize) XXX_Size() int {
	return xxx_messageInfo_Document_Style_FontSize.Size(m)
}
func (m *Document_Style_FontSize) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Style_FontSize.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Style_FontSize proto.InternalMessageInfo

func (m *Document_Style_FontSize) GetSize() float32 {
	if m != nil {
		return m.Size
	}
	return 0
}

func (m *Document_Style_FontSize) GetUnit() string {
	if m != nil {
		return m.Unit
	}
	return ""
}

// A page in a [Document][google.cloud.documentai.v1beta1.Document].
type Document_Page struct {
	// 1-based index for current
	// [Page][google.cloud.documentai.v1beta1.Document.Page] in a parent
	// [Document][google.cloud.documentai.v1beta1.Document]. Useful when a page
	// is taken out of a [Document][google.cloud.documentai.v1beta1.Document]
	// for individual processing.
	PageNumber int32 `protobuf:"varint,1,opt,name=page_number,json=pageNumber,proto3" json:"page_number,omitempty"`
	// Physical dimension of the page.
	Dimension *Document_Page_Dimension `protobuf:"bytes,2,opt,name=dimension,proto3" json:"dimension,omitempty"`
	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
	// page.
	Layout *Document_Page_Layout `protobuf:"bytes,3,opt,name=layout,proto3" json:"layout,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,4,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
	// A list of visually detected text blocks on the page.
	// A block has a set of lines (collected into paragraphs) that have a common
	// line-spacing and orientation.
	Blocks []*Document_Page_Block `protobuf:"bytes,5,rep,name=blocks,proto3" json:"blocks,omitempty"`
	// A list of visually detected text paragraphs on the page.
	// A collection of lines that a human would perceive as a paragraph.
	Paragraphs []*Document_Page_Paragraph `protobuf:"bytes,6,rep,name=paragraphs,proto3" json:"paragraphs,omitempty"`
	// A list of visually detected text lines on the page.
	// A collection of tokens that a human would perceive as a line.
	Lines []*Document_Page_Line `protobuf:"bytes,7,rep,name=lines,proto3" json:"lines,omitempty"`
	// A list of visually detected tokens on the page.
	Tokens []*Document_Page_Token `protobuf:"bytes,8,rep,name=tokens,proto3" json:"tokens,omitempty"`
	// A list of detected non-text visual elements e.g. checkbox,
	// signature etc. on the page.
	VisualElements []*Document_Page_VisualElement `protobuf:"bytes,9,rep,name=visual_elements,json=visualElements,proto3" json:"visual_elements,omitempty"`
	// A list of visually detected tables on the page.
	Tables []*Document_Page_Table `protobuf:"bytes,10,rep,name=tables,proto3" json:"tables,omitempty"`
	// A list of visually detected form fields on the page.
	FormFields           []*Document_Page_FormField `protobuf:"bytes,11,rep,name=form_fields,json=formFields,proto3" json:"form_fields,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *Document_Page) Reset()         { *m = Document_Page{} }
func (m *Document_Page) String() string { return proto.CompactTextString(m) }
func (*Document_Page) ProtoMessage()    {}
func (*Document_Page) Descriptor() ([]byte, []int) {
	return fileDescriptor_5660e1b1964906ba, []int{0, 2}
}

func (m *Document_Page) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page.Unmarshal(m, b)
}
func (m *Document_Page) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page.Marshal(b, m, deterministic)
}
func (m *Document_Page) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page.Merge(m, src)
}
func (m *Document_Page) XXX_Size() int {
	return xxx_messageInfo_Document_Page.Size(m)
}
func (m *Document_Page) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page proto.InternalMessageInfo

func (m *Document_Page) GetPageNumber() int32 {
	if m != nil {
		return m.PageNumber
	}
	return 0
}

func (m *Document_Page) GetDimension() *Document_Page_Dimension {
	if m != nil {
		return m.Dimension
	}
	return nil
}

func (m *Document_Page) GetLayout() *Document_Page_Layout {
	if m != nil {
		return m.Layout
	}
	return nil
}

func (m *Document_Page) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if m != nil {
		return m.DetectedLanguages
	}
	return nil
}

func (m *Document_Page) GetBlocks() []*Document_Page_Block {
	if m != nil {
		return m.Blocks
	}
	return nil
}

func (m *Document_Page) GetParagraphs() []*Document_Page_Paragraph {
	if m != nil {
		return m.Paragraphs
	}
	return nil
}

func (m *Document_Page) GetLines() []*Document_Page_Line {
	if m != nil {
		return m.Lines
	}
	return nil
}

func (m *Document_Page) GetTokens() []*Document_Page_Token {
	if m != nil {
		return m.Tokens
	}
	return nil
}

func (m *Document_Page) GetVisualElements() []*Document_Page_VisualElement {
	if m != nil {
		return m.VisualElements
	}
	return nil
}

func (m *Document_Page) GetTables() []*Document_Page_Table {
	if m != nil {
		return m.Tables
	}
	return nil
}

func (m *Document_Page) GetFormFields() []*Document_Page_FormField {
	if m != nil {
		return m.FormFields
	}
	return nil
}

// Dimension for the page.
type Document_Page_Dimension struct {
	// Page width.
	Width float32 `protobuf:"fixed32,1,opt,name=width,proto3" json:"width,omitempty"`
	// Page height.
	Height float32 `protobuf:"fixed32,2,opt,name=height,proto3" json:"height,omitempty"`
	// Dimension unit.
	Unit                 string   `protobuf:"bytes,3,opt,name=unit,proto3" json:"unit,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Document_Page_Dimension) Reset()         { *m = Document_Page_Dimension{} }
func (m *Document_Page_Dimension) String() string { return proto.CompactTextString(m) }
func (*Document_Page_Dimension) ProtoMessage()    {}
func (*Document_Page_Dimension) Descriptor() ([]byte, []int) {
	return fileDescriptor_5660e1b1964906ba, []int{0, 2, 0}
}

func (m *Document_Page_Dimension) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_Dimension.Unmarshal(m, b)
}
func (m *Document_Page_Dimension) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_Dimension.Marshal(b, m, deterministic)
}
func (m *Document_Page_Dimension) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_Dimension.Merge(m, src)
}
func (m *Document_Page_Dimension) XXX_Size() int {
	return xxx_messageInfo_Document_Page_Dimension.Size(m)
}
func (m *Document_Page_Dimension) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_Dimension.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_Dimension proto.InternalMessageInfo

func (m *Document_Page_Dimension) GetWidth() float32 {
	if m != nil {
		return m.Width
	}
	return 0
}

func (m *Document_Page_Dimension) GetHeight() float32 {
	if m != nil {
		return m.Height
	}
	return 0
}

func (m *Document_Page_Dimension) GetUnit() string {
	if m != nil {
		return m.Unit
	}
	return ""
}

// Visual element describing a layout unit on a page.
type Document_Page_Layout struct {
	// Text anchor indexing into the
	// [Document.text][google.cloud.documentai.v1beta1.Document.text].
	TextAnchor *Document_TextAnchor `protobuf:"bytes,1,opt,name=text_anchor,json=textAnchor,proto3" json:"text_anchor,omitempty"`
	// Confidence of the current
	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] within
	// context of the object this layout is for. e.g. confidence can be for a
	// single token, a table, a visual element, etc. depending on context.
	// Range [0, 1].
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// The bounding polygon for the
	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
	BoundingPoly *BoundingPoly `protobuf:"bytes,3,opt,name=bounding_poly,json=boundingPoly,proto3" json:"bounding_poly,omitempty"`
	// Detected orientation for the
	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout].
	Orientation          Document_Page_Layout_Orientation `protobuf:"varint,4,opt,name=orientation,proto3,enum=google.cloud.documentai.v1beta1.Document_Page_Layout_Orientation" json:"orientation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *Document_Page_Layout) Reset()         { *m = Document_Page_Layout{} }
func (m *Document_Page_Layout) String() string { return proto.CompactTextString(m) }
func (*Document_Page_Layout) ProtoMessage()    {}
func (*Document_Page_Layout) Descriptor() ([]byte, []int) {
	return fileDescriptor_5660e1b1964906ba, []int{0, 2, 1}
}

func (m *Document_Page_Layout) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_Layout.Unmarshal(m, b)
}
func (m *Document_Page_Layout) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_Layout.Marshal(b, m, deterministic)
}
func (m *Document_Page_Layout) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_Layout.Merge(m, src)
}
func (m *Document_Page_Layout) XXX_Size() int {
	return xxx_messageInfo_Document_Page_Layout.Size(m)
}
func (m *Document_Page_Layout) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_Layout.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_Layout proto.InternalMessageInfo

func (m *Document_Page_Layout) GetTextAnchor() *Document_TextAnchor {
	if m != nil {
		return m.TextAnchor
	}
	return nil
}

func (m *Document_Page_Layout) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *Document_Page_Layout) GetBoundingPoly() *BoundingPoly {
	if m != nil {
		return m.BoundingPoly
	}
	return nil
}

func (m *Document_Page_Layout) GetOrientation() Document_Page_Layout_Orientation {
	if m != nil {
		return m.Orientation
	}
	return Document_Page_Layout_ORIENTATION_UNSPECIFIED
}

// A block has a set of lines (collected into paragraphs) that have a
// common line-spacing and orientation.
type Document_Page_Block struct {
	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
	// [Block][google.cloud.documentai.v1beta1.Document.Page.Block].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages    []*Document_Page_DetectedLanguage `protobuf:"bytes,2,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *Document_Page_Block) Reset()         { *m = Document_Page_Block{} }
func (m *Document_Page_Block) String() string { return proto.CompactTextString(m) }
func (*Document_Page_Block) ProtoMessage()    {}
func (*Document_Page_Block) Descriptor() ([]byte, []int) {
	return fileDescriptor_5660e1b1964906ba, []int{0, 2, 2}
}

func (m *Document_Page_Block) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_Block.Unmarshal(m, b)
}
func (m *Document_Page_Block) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_Block.Marshal(b, m, deterministic)
}
func (m *Document_Page_Block) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_Block.Merge(m, src)
}
func (m *Document_Page_Block) XXX_Size() int {
	return xxx_messageInfo_Document_Page_Block.Size(m)
}
func (m *Document_Page_Block) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_Block.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_Block proto.InternalMessageInfo

func (m *Document_Page_Block) GetLayout() *Document_Page_Layout {
	if m != nil {
		return m.Layout
	}
	return nil
}

func (m *Document_Page_Block) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if m != nil {
		return m.DetectedLanguages
	}
	return nil
}

// A collection of lines that a human would perceive as a paragraph.
type Document_Page_Paragraph struct {
	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
	// [Paragraph][google.cloud.documentai.v1beta1.Document.Page.Paragraph].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages    []*Document_Page_DetectedLanguage `protobuf:"bytes,2,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *Document_Page_Paragraph) Reset()         { *m = Document_Page_Paragraph{} }
func (m *Document_Page_Paragraph) String() string { return proto.CompactTextString(m) }
func (*Document_Page_Paragraph) ProtoMessage()    {}
func (*Document_Page_Paragraph) Descriptor() ([]byte, []int) {
	return fileDescriptor_5660e1b1964906ba, []int{0, 2, 3}
}

func (m *Document_Page_Paragraph) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_Paragraph.Unmarshal(m, b)
}
func (m *Document_Page_Paragraph) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_Paragraph.Marshal(b, m, deterministic)
}
func (m *Document_Page_Paragraph) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_Paragraph.Merge(m, src)
}
func (m *Document_Page_Paragraph) XXX_Size() int {
	return xxx_messageInfo_Document_Page_Paragraph.Size(m)
}
func (m *Document_Page_Paragraph) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_Paragraph.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_Paragraph proto.InternalMessageInfo

func (m *Document_Page_Paragraph) GetLayout() *Document_Page_Layout {
	if m != nil {
		return m.Layout
	}
	return nil
}

func (m *Document_Page_Paragraph) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if m != nil {
		return m.DetectedLanguages
	}
	return nil
}

// A collection of tokens that a human would perceive as a line.
// Does not cross column boundaries, can be horizontal, vertical, etc.
type Document_Page_Line struct {
	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
	// [Line][google.cloud.documentai.v1beta1.Document.Page.Line].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages    []*Document_Page_DetectedLanguage `protobuf:"bytes,2,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *Document_Page_Line) Reset()         { *m = Document_Page_Line{} }
func (m *Document_Page_Line) String() string { return proto.CompactTextString(m) }
func (*Document_Page_Line) ProtoMessage()    {}
func (*Document_Page_Line) Descriptor() ([]byte, []int) {
	return fileDescriptor_5660e1b1964906ba, []int{0, 2, 4}
}

func (m *Document_Page_Line) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_Line.Unmarshal(m, b)
}
func (m *Document_Page_Line) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_Line.Marshal(b, m, deterministic)
}
func (m *Document_Page_Line) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_Line.Merge(m, src)
}
func (m *Document_Page_Line) XXX_Size() int {
	return xxx_messageInfo_Document_Page_Line.Size(m)
}
func (m *Document_Page_Line) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_Line.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_Line proto.InternalMessageInfo

func (m *Document_Page_Line) GetLayout() *Document_Page_Layout {
	if m != nil {
		return m.Layout
	}
	return nil
}

func (m *Document_Page_Line) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if m != nil {
		return m.DetectedLanguages
	}
	return nil
}

// A detected token.
type Document_Page_Token struct {
	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
	// [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// Detected break at the end of a
	// [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
	DetectedBreak *Document_Page_Token_DetectedBreak `protobuf:"bytes,2,opt,name=detected_break,json=detectedBreak,proto3" json:"detected_break,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages    []*Document_Page_DetectedLanguage `protobuf:"bytes,3,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *Document_Page_Token) Reset()         { *m = Document_Page_Token{} }
func (m *Document_Page_Token) String() string { return proto.CompactTextString(m) }
func (*Document_Page_Token) ProtoMessage()    {}
func (*Document_Page_Token) Descriptor() ([]byte, []int) {
	return fileDescriptor_5660e1b1964906ba, []int{0, 2, 5}
}

func (m *Document_Page_Token) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_Token.Unmarshal(m, b)
}
func (m *Document_Page_Token) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_Token.Marshal(b, m, deterministic)
}
func (m *Document_Page_Token) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_Token.Merge(m, src)
}
func (m *Document_Page_Token) XXX_Size() int {
	return xxx_messageInfo_Document_Page_Token.Size(m)
}
func (m *Document_Page_Token) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_Token.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_Token proto.InternalMessageInfo

func (m *Document_Page_Token) GetLayout() *Document_Page_Layout {
	if m != nil {
		return m.Layout
	}
	return nil
}

func (m *Document_Page_Token) GetDetectedBreak() *Document_Page_Token_DetectedBreak {
	if m != nil {
		return m.DetectedBreak
	}
	return nil
}

func (m *Document_Page_Token) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if m != nil {
		return m.DetectedLanguages
	}
	return nil
}

// Detected break at the end of a
// [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
type Document_Page_Token_DetectedBreak struct {
	// Detected break type.
	Type                 Document_Page_Token_DetectedBreak_Type `protobuf:"varint,1,opt,name=type,proto3,enum=google.cloud.documentai.v1beta1.Document_Page_Token_DetectedBreak_Type" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                               `json:"-"`
	XXX_unrecognized     []byte                                 `json:"-"`
	XXX_sizecache        int32                                  `json:"-"`
}

func (m *Document_Page_Token_DetectedBreak) Reset()         { *m = Document_Page_Token_DetectedBreak{} }
func (m *Document_Page_Token_DetectedBreak) String() string { return proto.CompactTextString(m) }
func (*Document_Page_Token_DetectedBreak) ProtoMessage()    {}
func (*Document_Page_Token_DetectedBreak) Descriptor() ([]byte, []int) {
	return fileDescriptor_5660e1b1964906ba, []int{0, 2, 5, 0}
}

func (m *Document_Page_Token_DetectedBreak) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_Token_DetectedBreak.Unmarshal(m, b)
}
func (m *Document_Page_Token_DetectedBreak) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_Token_DetectedBreak.Marshal(b, m, deterministic)
}
func (m *Document_Page_Token_DetectedBreak) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_Token_DetectedBreak.Merge(m, src)
}
func (m *Document_Page_Token_DetectedBreak) XXX_Size() int {
	return xxx_messageInfo_Document_Page_Token_DetectedBreak.Size(m)
}
func (m *Document_Page_Token_DetectedBreak) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_Token_DetectedBreak.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_Token_DetectedBreak proto.InternalMessageInfo

func (m *Document_Page_Token_DetectedBreak) GetType() Document_Page_Token_DetectedBreak_Type {
	if m != nil {
		return m.Type
	}
	return Document_Page_Token_DetectedBreak_TYPE_UNSPECIFIED
}

// Detected non-text visual elements e.g. checkbox, signature etc. on the
// page.
type Document_Page_VisualElement struct {
	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
	// [Token][google.cloud.documentai.v1beta1.Document.Page.Token].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// Type of the
	// [VisualElement][google.cloud.documentai.v1beta1.Document.Page.VisualElement].
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages    []*Document_Page_DetectedLanguage `protobuf:"bytes,3,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *Document_Page_VisualElement) Reset()         { *m = Document_Page_VisualElement{} }
func (m *Document_Page_VisualElement) String() string { return proto.CompactTextString(m) }
func (*Document_Page_VisualElement) ProtoMessage()    {}
func (*Document_Page_VisualElement) Descriptor() ([]byte, []int) {
	return fileDescriptor_5660e1b1964906ba, []int{0, 2, 6}
}

func (m *Document_Page_VisualElement) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_VisualElement.Unmarshal(m, b)
}
func (m *Document_Page_VisualElement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_VisualElement.Marshal(b, m, deterministic)
}
func (m *Document_Page_VisualElement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_VisualElement.Merge(m, src)
}
func (m *Document_Page_VisualElement) XXX_Size() int {
	return xxx_messageInfo_Document_Page_VisualElement.Size(m)
}
func (m *Document_Page_VisualElement) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_VisualElement.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_VisualElement proto.InternalMessageInfo

func (m *Document_Page_VisualElement) GetLayout() *Document_Page_Layout {
	if m != nil {
		return m.Layout
	}
	return nil
}

func (m *Document_Page_VisualElement) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Document_Page_VisualElement) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if m != nil {
		return m.DetectedLanguages
	}
	return nil
}

// A table representation similar to HTML table structure.
type Document_Page_Table struct {
	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
	// [Table][google.cloud.documentai.v1beta1.Document.Page.Table].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// Header rows of the table.
	HeaderRows []*Document_Page_Table_TableRow `protobuf:"bytes,2,rep,name=header_rows,json=headerRows,proto3" json:"header_rows,omitempty"`
	// Body rows of the table.
	BodyRows []*Document_Page_Table_TableRow `protobuf:"bytes,3,rep,name=body_rows,json=bodyRows,proto3" json:"body_rows,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages    []*Document_Page_DetectedLanguage `protobuf:"bytes,4,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *Document_Page_Table) Reset()         { *m = Document_Page_Table{} }
func (m *Document_Page_Table) String() string { return proto.CompactTextString(m) }
func (*Document_Page_Table) ProtoMessage()    {}
func (*Document_Page_Table) Descriptor() ([]byte, []int) {
	return fileDescriptor_5660e1b1964906ba, []int{0, 2, 7}
}

func (m *Document_Page_Table) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_Table.Unmarshal(m, b)
}
func (m *Document_Page_Table) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_Table.Marshal(b, m, deterministic)
}
func (m *Document_Page_Table) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_Table.Merge(m, src)
}
func (m *Document_Page_Table) XXX_Size() int {
	return xxx_messageInfo_Document_Page_Table.Size(m)
}
func (m *Document_Page_Table) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_Table.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_Table proto.InternalMessageInfo

func (m *Document_Page_Table) GetLayout() *Document_Page_Layout {
	if m != nil {
		return m.Layout
	}
	return nil
}

func (m *Document_Page_Table) GetHeaderRows() []*Document_Page_Table_TableRow {
	if m != nil {
		return m.HeaderRows
	}
	return nil
}

func (m *Document_Page_Table) GetBodyRows() []*Document_Page_Table_TableRow {
	if m != nil {
		return m.BodyRows
	}
	return nil
}

func (m *Document_Page_Table) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if m != nil {
		return m.DetectedLanguages
	}
	return nil
}

// A row of table cells.
type Document_Page_Table_TableRow struct {
	// Cells that make up this row.
	Cells                []*Document_Page_Table_TableCell `protobuf:"bytes,1,rep,name=cells,proto3" json:"cells,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *Document_Page_Table_TableRow) Reset()         { *m = Document_Page_Table_TableRow{} }
func (m *Document_Page_Table_TableRow) String() string { return proto.CompactTextString(m) }
func (*Document_Page_Table_TableRow) ProtoMessage()    {}
func (*Document_Page_Table_TableRow) Descriptor() ([]byte, []int) {
	return fileDescriptor_5660e1b1964906ba, []int{0, 2, 7, 0}
}

func (m *Document_Page_Table_TableRow) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_Table_TableRow.Unmarshal(m, b)
}
func (m *Document_Page_Table_TableRow) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_Table_TableRow.Marshal(b, m, deterministic)
}
func (m *Document_Page_Table_TableRow) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_Table_TableRow.Merge(m, src)
}
func (m *Document_Page_Table_TableRow) XXX_Size() int {
	return xxx_messageInfo_Document_Page_Table_TableRow.Size(m)
}
func (m *Document_Page_Table_TableRow) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_Table_TableRow.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_Table_TableRow proto.InternalMessageInfo

func (m *Document_Page_Table_TableRow) GetCells() []*Document_Page_Table_TableCell {
	if m != nil {
		return m.Cells
	}
	return nil
}

// A cell representation inside the table.
type Document_Page_Table_TableCell struct {
	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for
	// [TableCell][google.cloud.documentai.v1beta1.Document.Page.Table.TableCell].
	Layout *Document_Page_Layout `protobuf:"bytes,1,opt,name=layout,proto3" json:"layout,omitempty"`
	// How many rows this cell spans.
	RowSpan int32 `protobuf:"varint,2,opt,name=row_span,json=rowSpan,proto3" json:"row_span,omitempty"`
	// How many columns this cell spans.
	ColSpan int32 `protobuf:"varint,3,opt,name=col_span,json=colSpan,proto3" json:"col_span,omitempty"`
	// A list of detected languages together with confidence.
	DetectedLanguages    []*Document_Page_DetectedLanguage `protobuf:"bytes,4,rep,name=detected_languages,json=detectedLanguages,proto3" json:"detected_languages,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *Document_Page_Table_TableCell) Reset()         { *m = Document_Page_Table_TableCell{} }
func (m *Document_Page_Table_TableCell) String() string { return proto.CompactTextString(m) }
func (*Document_Page_Table_TableCell) ProtoMessage()    {}
func (*Document_Page_Table_TableCell) Descriptor() ([]byte, []int) {
	return fileDescriptor_5660e1b1964906ba, []int{0, 2, 7, 1}
}

func (m *Document_Page_Table_TableCell) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_Table_TableCell.Unmarshal(m, b)
}
func (m *Document_Page_Table_TableCell) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_Table_TableCell.Marshal(b, m, deterministic)
}
func (m *Document_Page_Table_TableCell) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_Table_TableCell.Merge(m, src)
}
func (m *Document_Page_Table_TableCell) XXX_Size() int {
	return xxx_messageInfo_Document_Page_Table_TableCell.Size(m)
}
func (m *Document_Page_Table_TableCell) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_Table_TableCell.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_Table_TableCell proto.InternalMessageInfo

func (m *Document_Page_Table_TableCell) GetLayout() *Document_Page_Layout {
	if m != nil {
		return m.Layout
	}
	return nil
}

func (m *Document_Page_Table_TableCell) GetRowSpan() int32 {
	if m != nil {
		return m.RowSpan
	}
	return 0
}

func (m *Document_Page_Table_TableCell) GetColSpan() int32 {
	if m != nil {
		return m.ColSpan
	}
	return 0
}

func (m *Document_Page_Table_TableCell) GetDetectedLanguages() []*Document_Page_DetectedLanguage {
	if m != nil {
		return m.DetectedLanguages
	}
	return nil
}

// A form field detected on the page.
type Document_Page_FormField struct {
	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
	// [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
	// name. e.g. `Address`, `Email`, `Grand total`, `Phone number`, etc.
	FieldName *Document_Page_Layout `protobuf:"bytes,1,opt,name=field_name,json=fieldName,proto3" json:"field_name,omitempty"`
	// [Layout][google.cloud.documentai.v1beta1.Document.Page.Layout] for the
	// [FormField][google.cloud.documentai.v1beta1.Document.Page.FormField]
	// value.
	FieldValue *Document_Page_Layout `protobuf:"bytes,2,opt,name=field_value,json=fieldValue,proto3" json:"field_value,omitempty"`
	// A list of detected languages for name together with confidence.
	NameDetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,3,rep,name=name_detected_languages,json=nameDetectedLanguages,proto3" json:"name_detected_languages,omitempty"`
	// A list of detected languages for value together with confidence.
	ValueDetectedLanguages []*Document_Page_DetectedLanguage `protobuf:"bytes,4,rep,name=value_detected_languages,json=valueDetectedLanguages,proto3" json:"value_detected_languages,omitempty"`
	XXX_NoUnkeyedLiteral   struct{}                          `json:"-"`
	XXX_unrecognized       []byte                            `json:"-"`
	XXX_sizecache          int32                             `json:"-"`
}

func (m *Document_Page_FormField) Reset()         { *m = Document_Page_FormField{} }
func (m *Document_Page_FormField) String() string { return proto.CompactTextString(m) }
func (*Document_Page_FormField) ProtoMessage()    {}
func (*Document_Page_FormField) Descriptor() ([]byte, []int) {
	return fileDescriptor_5660e1b1964906ba, []int{0, 2, 8}
}

func (m *Document_Page_FormField) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_FormField.Unmarshal(m, b)
}
func (m *Document_Page_FormField) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_FormField.Marshal(b, m, deterministic)
}
func (m *Document_Page_FormField) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_FormField.Merge(m, src)
}
func (m *Document_Page_FormField) XXX_Size() int {
	return xxx_messageInfo_Document_Page_FormField.Size(m)
}
func (m *Document_Page_FormField) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_FormField.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_FormField proto.InternalMessageInfo

func (m *Document_Page_FormField) GetFieldName() *Document_Page_Layout {
	if m != nil {
		return m.FieldName
	}
	return nil
}

func (m *Document_Page_FormField) GetFieldValue() *Document_Page_Layout {
	if m != nil {
		return m.FieldValue
	}
	return nil
}

func (m *Document_Page_FormField) GetNameDetectedLanguages() []*Document_Page_DetectedLanguage {
	if m != nil {
		return m.NameDetectedLanguages
	}
	return nil
}

func (m *Document_Page_FormField) GetValueDetectedLanguages() []*Document_Page_DetectedLanguage {
	if m != nil {
		return m.ValueDetectedLanguages
	}
	return nil
}

// Detected language for a structural component.
type Document_Page_DetectedLanguage struct {
	// The BCP-47 language code, such as "en-US" or "sr-Latn". For more
	// information, see
	// http://www.unicode.org/reports/tr35/#Unicode_locale_identifier.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Confidence of detected language. Range [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Document_Page_DetectedLanguage) Reset()         { *m = Document_Page_DetectedLanguage{} }
func (m *Document_Page_DetectedLanguage) String() string { return proto.CompactTextString(m) }
func (*Document_Page_DetectedLanguage) ProtoMessage()    {}
func (*Document_Page_DetectedLanguage) Descriptor() ([]byte, []int) {
	return fileDescriptor_5660e1b1964906ba, []int{0, 2, 9}
}

func (m *Document_Page_DetectedLanguage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Page_DetectedLanguage.Unmarshal(m, b)
}
func (m *Document_Page_DetectedLanguage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Page_DetectedLanguage.Marshal(b, m, deterministic)
}
func (m *Document_Page_DetectedLanguage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Page_DetectedLanguage.Merge(m, src)
}
func (m *Document_Page_DetectedLanguage) XXX_Size() int {
	return xxx_messageInfo_Document_Page_DetectedLanguage.Size(m)
}
func (m *Document_Page_DetectedLanguage) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Page_DetectedLanguage.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Page_DetectedLanguage proto.InternalMessageInfo

func (m *Document_Page_DetectedLanguage) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *Document_Page_DetectedLanguage) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// A phrase in the text that is a known entity type, such as a person, an
// organization, or location.
type Document_Entity struct {
	// Provenance of the entity.
	// Text anchor indexing into the
	// [Document.text][google.cloud.documentai.v1beta1.Document.text].
	TextAnchor *Document_TextAnchor `protobuf:"bytes,1,opt,name=text_anchor,json=textAnchor,proto3" json:"text_anchor,omitempty"`
	// Entity type from a schema e.g. `Address`.
	Type string `protobuf:"bytes,2,opt,name=type,proto3" json:"type,omitempty"`
	// Text value in the document e.g. `1600 Amphitheatre Pkwy`.
	MentionText string `protobuf:"bytes,3,opt,name=mention_text,json=mentionText,proto3" json:"mention_text,omitempty"`
	// Canonical mention name. This will be a unique value in the entity list
	// for this document.
	MentionId            string   `protobuf:"bytes,4,opt,name=mention_id,json=mentionId,proto3" json:"mention_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Document_Entity) Reset()         { *m = Document_Entity{} }
func (m *Document_Entity) String() string { return proto.CompactTextString(m) }
func (*Document_Entity) ProtoMessage()    {}
func (*Document_Entity) Descriptor() ([]byte, []int) {
	return fileDescriptor_5660e1b1964906ba, []int{0, 3}
}

func (m *Document_Entity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_Entity.Unmarshal(m, b)
}
func (m *Document_Entity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_Entity.Marshal(b, m, deterministic)
}
func (m *Document_Entity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_Entity.Merge(m, src)
}
func (m *Document_Entity) XXX_Size() int {
	return xxx_messageInfo_Document_Entity.Size(m)
}
func (m *Document_Entity) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_Entity.DiscardUnknown(m)
}

var xxx_messageInfo_Document_Entity proto.InternalMessageInfo

func (m *Document_Entity) GetTextAnchor() *Document_TextAnchor {
	if m != nil {
		return m.TextAnchor
	}
	return nil
}

func (m *Document_Entity) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Document_Entity) GetMentionText() string {
	if m != nil {
		return m.MentionText
	}
	return ""
}

func (m *Document_Entity) GetMentionId() string {
	if m != nil {
		return m.MentionId
	}
	return ""
}

// Relationship between
// [Entities][google.cloud.documentai.v1beta1.Document.Entity].
type Document_EntityRelation struct {
	// Subject entity mention_id.
	SubjectId string `protobuf:"bytes,1,opt,name=subject_id,json=subjectId,proto3" json:"subject_id,omitempty"`
	// Object entity mention_id.
	ObjectId string `protobuf:"bytes,2,opt,name=object_id,json=objectId,proto3" json:"object_id,omitempty"`
	// Relationship description.
	Relation             string   `protobuf:"bytes,3,opt,name=relation,proto3" json:"relation,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Document_EntityRelation) Reset()         { *m = Document_EntityRelation{} }
func (m *Document_EntityRelation) String() string { return proto.CompactTextString(m) }
func (*Document_EntityRelation) ProtoMessage()    {}
func (*Document_EntityRelation) Descriptor() ([]byte, []int) {
	return fileDescriptor_5660e1b1964906ba, []int{0, 4}
}

func (m *Document_EntityRelation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_EntityRelation.Unmarshal(m, b)
}
func (m *Document_EntityRelation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_EntityRelation.Marshal(b, m, deterministic)
}
func (m *Document_EntityRelation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_EntityRelation.Merge(m, src)
}
func (m *Document_EntityRelation) XXX_Size() int {
	return xxx_messageInfo_Document_EntityRelation.Size(m)
}
func (m *Document_EntityRelation) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_EntityRelation.DiscardUnknown(m)
}

var xxx_messageInfo_Document_EntityRelation proto.InternalMessageInfo

func (m *Document_EntityRelation) GetSubjectId() string {
	if m != nil {
		return m.SubjectId
	}
	return ""
}

func (m *Document_EntityRelation) GetObjectId() string {
	if m != nil {
		return m.ObjectId
	}
	return ""
}

func (m *Document_EntityRelation) GetRelation() string {
	if m != nil {
		return m.Relation
	}
	return ""
}

// Text reference indexing into the
// [Document.text][google.cloud.documentai.v1beta1.Document.text].
type Document_TextAnchor struct {
	// The text segments from the
	// [Document.text][google.cloud.documentai.v1beta1.Document.text].
	TextSegments         []*Document_TextAnchor_TextSegment `protobuf:"bytes,1,rep,name=text_segments,json=textSegments,proto3" json:"text_segments,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *Document_TextAnchor) Reset()         { *m = Document_TextAnchor{} }
func (m *Document_TextAnchor) String() string { return proto.CompactTextString(m) }
func (*Document_TextAnchor) ProtoMessage()    {}
func (*Document_TextAnchor) Descriptor() ([]byte, []int) {
	return fileDescriptor_5660e1b1964906ba, []int{0, 5}
}

func (m *Document_TextAnchor) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_TextAnchor.Unmarshal(m, b)
}
func (m *Document_TextAnchor) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_TextAnchor.Marshal(b, m, deterministic)
}
func (m *Document_TextAnchor) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_TextAnchor.Merge(m, src)
}
func (m *Document_TextAnchor) XXX_Size() int {
	return xxx_messageInfo_Document_TextAnchor.Size(m)
}
func (m *Document_TextAnchor) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_TextAnchor.DiscardUnknown(m)
}

var xxx_messageInfo_Document_TextAnchor proto.InternalMessageInfo

func (m *Document_TextAnchor) GetTextSegments() []*Document_TextAnchor_TextSegment {
	if m != nil {
		return m.TextSegments
	}
	return nil
}

// A text segment in the
// [Document.text][google.cloud.documentai.v1beta1.Document.text]. The
// indices may be out of bounds which indicate that the text extends into
// another document shard for large sharded documents. See
// [ShardInfo.text_offset][google.cloud.documentai.v1beta1.Document.ShardInfo.text_offset]
type Document_TextAnchor_TextSegment struct {
	// [TextSegment][google.cloud.documentai.v1beta1.Document.TextAnchor.TextSegment]
	// start UTF-8 char index in the
	// [Document.text][google.cloud.documentai.v1beta1.Document.text].
	StartIndex int64 `protobuf:"varint,1,opt,name=start_index,json=startIndex,proto3" json:"start_index,omitempty"`
	// [TextSegment][google.cloud.documentai.v1beta1.Document.TextAnchor.TextSegment]
	// half open end UTF-8 char index in the
	// [Document.text][google.cloud.documentai.v1beta1.Document.text].
	EndIndex             int64    `protobuf:"varint,2,opt,name=end_index,json=endIndex,proto3" json:"end_index,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Document_TextAnchor_TextSegment) Reset()         { *m = Document_TextAnchor_TextSegment{} }
func (m *Document_TextAnchor_TextSegment) String() string { return proto.CompactTextString(m) }
func (*Document_TextAnchor_TextSegment) ProtoMessage()    {}
func (*Document_TextAnchor_TextSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_5660e1b1964906ba, []int{0, 5, 0}
}

func (m *Document_TextAnchor_TextSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Document_TextAnchor_TextSegment.Unmarshal(m, b)
}
func (m *Document_TextAnchor_TextSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Document_TextAnchor_TextSegment.Marshal(b, m, deterministic)
}
func (m *Document_TextAnchor_TextSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Document_TextAnchor_TextSegment.Merge(m, src)
}
func (m *Document_TextAnchor_TextSegment) XXX_Size() int {
	return xxx_messageInfo_Document_TextAnchor_TextSegment.Size(m)
}
func (m *Document_TextAnchor_TextSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_Document_TextAnchor_TextSegment.DiscardUnknown(m)
}

var xxx_messageInfo_Document_TextAnchor_TextSegment proto.InternalMessageInfo

func (m *Document_TextAnchor_TextSegment) GetStartIndex() int64 {
	if m != nil {
		return m.StartIndex
	}
	return 0
}

func (m *Document_TextAnchor_TextSegment) GetEndIndex() int64 {
	if m != nil {
		return m.EndIndex
	}
	return 0
}

func init() {
	proto.RegisterEnum("google.cloud.documentai.v1beta1.Document_Page_Layout_Orientation", Document_Page_Layout_Orientation_name, Document_Page_Layout_Orientation_value)
	proto.RegisterEnum("google.cloud.documentai.v1beta1.Document_Page_Token_DetectedBreak_Type", Document_Page_Token_DetectedBreak_Type_name, Document_Page_Token_DetectedBreak_Type_value)
	proto.RegisterType((*Document)(nil), "google.cloud.documentai.v1beta1.Document")
	proto.RegisterType((*Document_ShardInfo)(nil), "google.cloud.documentai.v1beta1.Document.ShardInfo")
	proto.RegisterType((*Document_Style)(nil), "google.cloud.documentai.v1beta1.Document.Style")
	proto.RegisterType((*Document_Style_FontSize)(nil), "google.cloud.documentai.v1beta1.Document.Style.FontSize")
	proto.RegisterType((*Document_Page)(nil), "google.cloud.documentai.v1beta1.Document.Page")
	proto.RegisterType((*Document_Page_Dimension)(nil), "google.cloud.documentai.v1beta1.Document.Page.Dimension")
	proto.RegisterType((*Document_Page_Layout)(nil), "google.cloud.documentai.v1beta1.Document.Page.Layout")
	proto.RegisterType((*Document_Page_Block)(nil), "google.cloud.documentai.v1beta1.Document.Page.Block")
	proto.RegisterType((*Document_Page_Paragraph)(nil), "google.cloud.documentai.v1beta1.Document.Page.Paragraph")
	proto.RegisterType((*Document_Page_Line)(nil), "google.cloud.documentai.v1beta1.Document.Page.Line")
	proto.RegisterType((*Document_Page_Token)(nil), "google.cloud.documentai.v1beta1.Document.Page.Token")
	proto.RegisterType((*Document_Page_Token_DetectedBreak)(nil), "google.cloud.documentai.v1beta1.Document.Page.Token.DetectedBreak")
	proto.RegisterType((*Document_Page_VisualElement)(nil), "google.cloud.documentai.v1beta1.Document.Page.VisualElement")
	proto.RegisterType((*Document_Page_Table)(nil), "google.cloud.documentai.v1beta1.Document.Page.Table")
	proto.RegisterType((*Document_Page_Table_TableRow)(nil), "google.cloud.documentai.v1beta1.Document.Page.Table.TableRow")
	proto.RegisterType((*Document_Page_Table_TableCell)(nil), "google.cloud.documentai.v1beta1.Document.Page.Table.TableCell")
	proto.RegisterType((*Document_Page_FormField)(nil), "google.cloud.documentai.v1beta1.Document.Page.FormField")
	proto.RegisterType((*Document_Page_DetectedLanguage)(nil), "google.cloud.documentai.v1beta1.Document.Page.DetectedLanguage")
	proto.RegisterType((*Document_Entity)(nil), "google.cloud.documentai.v1beta1.Document.Entity")
	proto.RegisterType((*Document_EntityRelation)(nil), "google.cloud.documentai.v1beta1.Document.EntityRelation")
	proto.RegisterType((*Document_TextAnchor)(nil), "google.cloud.documentai.v1beta1.Document.TextAnchor")
	proto.RegisterType((*Document_TextAnchor_TextSegment)(nil), "google.cloud.documentai.v1beta1.Document.TextAnchor.TextSegment")
}

func init() {
	proto.RegisterFile("google/cloud/documentai/v1beta1/document.proto", fileDescriptor_5660e1b1964906ba)
}

var fileDescriptor_5660e1b1964906ba = []byte{
	// 1608 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x58, 0x4f, 0x6f, 0x1b, 0x45,
	0x14, 0xef, 0x7a, 0x6d, 0xc7, 0xfb, 0x1c, 0x27, 0x66, 0x54, 0xda, 0x65, 0x43, 0x69, 0x68, 0x0f,
	0x44, 0x42, 0xac, 0x69, 0x5a, 0xa4, 0x4a, 0x50, 0x20, 0x89, 0x9d, 0xc6, 0x22, 0x4d, 0xac, 0x89,
	0x93, 0xd0, 0x22, 0xb1, 0xac, 0x77, 0xc7, 0xf6, 0x92, 0xf5, 0x8e, 0xb5, 0xbb, 0x8e, 0xe3, 0x9e,
	0xe0, 0x8b, 0xc0, 0x27, 0xe0, 0xc0, 0x81, 0x13, 0x17, 0x2e, 0x70, 0xe0, 0x63, 0x20, 0x21, 0xee,
	0x7c, 0x02, 0x34, 0x7f, 0x76, 0xed, 0xa4, 0x54, 0xa9, 0xdd, 0xa4, 0x52, 0x4f, 0x9e, 0x79, 0x7f,
	0x7e, 0xf3, 0xde, 0xcc, 0xbc, 0x9f, 0x67, 0x1f, 0x98, 0x1d, 0x4a, 0x3b, 0x3e, 0xa9, 0x38, 0x3e,
	0x1d, 0xb8, 0x15, 0x97, 0x3a, 0x83, 0x1e, 0x09, 0x62, 0xdb, 0xab, 0x1c, 0xdf, 0x69, 0x91, 0xd8,
	0xbe, 0x93, 0x8a, 0xcc, 0x7e, 0x48, 0x63, 0x8a, 0x6e, 0x0a, 0x7b, 0x93, 0xdb, 0x9b, 0x63, 0x7b,
	0x53, 0xda, 0x1b, 0x6f, 0x4b, 0x40, 0xbb, 0xef, 0x55, 0xec, 0x20, 0xa0, 0xb1, 0x1d, 0x7b, 0x34,
	0x88, 0x84, 0xbb, 0x71, 0xee, 0x72, 0x1d, 0x42, 0x7b, 0x24, 0x0e, 0x47, 0xd2, 0xfe, 0xba, 0xb4,
	0x0f, 0xfb, 0x4e, 0x25, 0x8a, 0xed, 0x78, 0x10, 0x9d, 0x51, 0xc4, 0xa3, 0x3e, 0xa9, 0x38, 0xd4,
	0xa7, 0xa1, 0x50, 0xdc, 0xfa, 0xf7, 0x7d, 0x28, 0x54, 0x25, 0x2e, 0x42, 0xa0, 0x0e, 0x42, 0x4f,
	0x57, 0x96, 0x95, 0x15, 0x6d, 0xeb, 0x0a, 0x66, 0x13, 0x64, 0xc0, 0x9c, 0x43, 0x83, 0x98, 0x04,
	0xb1, 0x9e, 0x59, 0x56, 0x56, 0xe6, 0xb7, 0xae, 0xe0, 0x44, 0x80, 0x96, 0x40, 0xeb, 0x79, 0x3d,
	0x62, 0x31, 0x54, 0x5d, 0x65, 0x5e, 0xb8, 0xc0, 0x04, 0xcd, 0x51, 0x9f, 0x20, 0x04, 0xd9, 0x98,
	0x9c, 0xc4, 0x7a, 0x96, 0xcb, 0xf9, 0x18, 0x35, 0xa0, 0xc8, 0x7e, 0xad, 0x28, 0x1e, 0xf9, 0x24,
	0xd2, 0x73, 0xcb, 0xea, 0x4a, 0x71, 0xb5, 0x62, 0x9e, 0xb3, 0x49, 0x66, 0x12, 0xa0, 0xb9, 0xc7,
	0xfc, 0x30, 0x30, 0x0c, 0x3e, 0x8c, 0x50, 0x15, 0x72, 0x7d, 0xbb, 0x43, 0x22, 0x3d, 0xcf, 0xb1,
	0xcc, 0x17, 0xc7, 0x6a, 0xd8, 0x1d, 0x82, 0x85, 0x33, 0xda, 0x86, 0x02, 0x09, 0x62, 0x2f, 0xf6,
	0x48, 0xa4, 0xcf, 0x71, 0xa0, 0x0f, 0x5f, 0x1c, 0xa8, 0xc6, 0x3c, 0x47, 0x38, 0x45, 0x40, 0x0e,
	0x94, 0xf9, 0x78, 0x64, 0x85, 0xc4, 0x17, 0xe7, 0xa9, 0x17, 0x38, 0xea, 0xfd, 0xa9, 0x51, 0x25,
	0x00, 0x5e, 0x24, 0xa7, 0xe6, 0x11, 0xc2, 0x00, 0x51, 0xd7, 0x0e, 0x5d, 0xcb, 0x0b, 0xda, 0x54,
	0xd7, 0x96, 0x95, 0x95, 0xe2, 0xea, 0xdd, 0x29, 0x76, 0x92, 0xf9, 0xd6, 0x83, 0x36, 0xc5, 0x5a,
	0x94, 0x0c, 0xd1, 0x0a, 0xe4, 0x48, 0x18, 0xd2, 0x50, 0x07, 0x0e, 0x87, 0x12, 0xb8, 0xb0, 0xef,
	0x98, 0x7b, 0xfc, 0x3a, 0x61, 0x61, 0x60, 0x04, 0xa0, 0xa5, 0x08, 0xe8, 0x26, 0x14, 0x93, 0x50,
	0x5c, 0x72, 0xc2, 0xaf, 0x8f, 0x8a, 0x41, 0xc2, 0xba, 0xe4, 0x64, 0x6c, 0xe0, 0xd0, 0x81, 0xbc,
	0x47, 0x89, 0xc1, 0x06, 0x93, 0x30, 0x03, 0x7e, 0x2f, 0x68, 0xbb, 0x1d, 0x91, 0x98, 0x5f, 0x25,
	0x55, 0x1c, 0xf3, 0x2e, 0x97, 0x18, 0xbf, 0xaa, 0x90, 0xe3, 0x27, 0x8e, 0xf6, 0xa5, 0xa9, 0x1d,
	0x38, 0x5d, 0x1a, 0xf2, 0xc5, 0x8a, 0xab, 0xf7, 0x5e, 0x3c, 0xf1, 0x26, 0x39, 0x89, 0xd7, 0xb8,
	0xaf, 0x58, 0x40, 0x8c, 0x59, 0xea, 0xbc, 0x2c, 0x78, 0x70, 0x13, 0xa9, 0xb3, 0xab, 0x6d, 0x6e,
	0x30, 0x0d, 0x16, 0x06, 0xe8, 0x01, 0x94, 0x5b, 0xb6, 0x73, 0xd4, 0x09, 0xe9, 0x20, 0x60, 0x19,
	0x31, 0x27, 0xf5, 0xb9, 0x4e, 0x8b, 0x63, 0x5b, 0x2e, 0x60, 0xa9, 0xb6, 0x69, 0x10, 0x5b, 0x43,
	0xe2, 0x75, 0xba, 0x49, 0x75, 0x00, 0x13, 0x1d, 0x72, 0x09, 0xba, 0x01, 0x30, 0xae, 0x11, 0x3d,
	0xc7, 0xf5, 0x5a, 0x7a, 0xe3, 0xd1, 0x7b, 0xb0, 0xc8, 0xd5, 0x2e, 0x71, 0x68, 0xc8, 0xef, 0x82,
	0x9e, 0xe7, 0x36, 0x0b, 0x4c, 0x5c, 0x4d, 0xa5, 0x68, 0x1f, 0x34, 0xbe, 0x50, 0xe4, 0x3d, 0x25,
	0xfa, 0x1c, 0x0f, 0xf0, 0xfe, 0x94, 0x95, 0x66, 0x6e, 0xd2, 0x20, 0xde, 0xf3, 0x9e, 0x12, 0x5c,
	0x68, 0xcb, 0x91, 0xb1, 0x0a, 0x85, 0x44, 0xca, 0x4a, 0x9c, 0xa3, 0xb3, 0x43, 0xc8, 0x60, 0x3e,
	0x66, 0xb2, 0x41, 0xe0, 0x89, 0x43, 0xd6, 0x30, 0x1f, 0x1b, 0x3f, 0xdc, 0x84, 0x2c, 0x2b, 0x37,
	0x96, 0x3c, 0x2b, 0x38, 0x2b, 0x18, 0xf4, 0x5a, 0x44, 0x1c, 0x5e, 0x0e, 0x03, 0x13, 0xed, 0x70,
	0x09, 0x3a, 0x00, 0xcd, 0xf5, 0x7a, 0x24, 0x88, 0x58, 0x5e, 0x99, 0x69, 0x83, 0x66, 0x6b, 0x98,
	0xd5, 0xc4, 0x1f, 0x8f, 0xa1, 0xd0, 0x23, 0xc8, 0xfb, 0xf6, 0x88, 0x0e, 0x62, 0x79, 0x54, 0x1f,
	0x4d, 0x09, 0xba, 0xcd, 0x9d, 0xb1, 0x04, 0x41, 0x01, 0x20, 0x97, 0xc4, 0xc4, 0x89, 0x89, 0x6b,
	0xf9, 0x76, 0xd0, 0x19, 0x70, 0x0a, 0xca, 0xf2, 0x1a, 0xff, 0x6c, 0xda, 0x78, 0x25, 0xd0, 0xb6,
	0xc4, 0xc1, 0x6f, 0xb8, 0x67, 0x24, 0x8c, 0x9f, 0xf2, 0x2d, 0x9f, 0x3a, 0x47, 0x09, 0x65, 0xde,
	0x9b, 0x72, 0x8d, 0x75, 0xe6, 0x8c, 0x25, 0x06, 0xfa, 0x12, 0xa0, 0x6f, 0x87, 0x76, 0x27, 0xb4,
	0xfb, 0xdd, 0x84, 0x38, 0xa7, 0xdd, 0xe5, 0x46, 0x02, 0x80, 0x27, 0xb0, 0x50, 0x1d, 0x72, 0xbe,
	0x17, 0xa4, 0x24, 0x7a, 0x77, 0xda, 0x5d, 0xf6, 0x02, 0x82, 0x05, 0x02, 0x4b, 0x39, 0xa6, 0x47,
	0x24, 0xa5, 0xce, 0x69, 0x53, 0x6e, 0x32, 0x67, 0x2c, 0x31, 0x10, 0x81, 0xc5, 0x63, 0x2f, 0x1a,
	0xd8, 0xbe, 0x45, 0x7c, 0xc2, 0x8c, 0x22, 0x5d, 0xe3, 0xb0, 0x9f, 0x4c, 0x09, 0x7b, 0xc0, 0x51,
	0x6a, 0x02, 0x04, 0x2f, 0x1c, 0x4f, 0x4e, 0x45, 0xd0, 0x76, 0x8b, 0xfd, 0xb5, 0xc1, 0x6c, 0x41,
	0x33, 0x67, 0x2c, 0x31, 0xd0, 0x63, 0x46, 0x15, 0x61, 0xcf, 0x6a, 0x7b, 0xc4, 0x77, 0x23, 0xbd,
	0x38, 0xd3, 0x41, 0x6d, 0xd2, 0xb0, 0xb7, 0xc9, 0x00, 0x18, 0xc9, 0xc8, 0x61, 0x64, 0x3c, 0x02,
	0x2d, 0xad, 0x13, 0x74, 0x15, 0x72, 0x43, 0xcf, 0x8d, 0xbb, 0xb2, 0x8e, 0xc5, 0x04, 0x5d, 0x83,
	0x7c, 0x57, 0x70, 0x54, 0x86, 0x8b, 0xe5, 0x2c, 0x2d, 0x70, 0x75, 0xa2, 0xc0, 0x7f, 0x54, 0x21,
	0x2f, 0x4a, 0xe4, 0xb2, 0xf8, 0xf9, 0x1d, 0x00, 0x87, 0x06, 0x6d, 0xcf, 0x25, 0x81, 0x43, 0x64,
	0x44, 0x13, 0x12, 0x84, 0xa1, 0xd4, 0x62, 0x24, 0xeb, 0x05, 0x1d, 0xab, 0x4f, 0xfd, 0x91, 0xac,
	0xf3, 0x0f, 0xce, 0x5d, 0x78, 0x5d, 0x7a, 0x35, 0xa8, 0x3f, 0xc2, 0xf3, 0xad, 0x89, 0x19, 0x72,
	0xa0, 0x48, 0x43, 0x8f, 0x99, 0x73, 0x9a, 0x65, 0x54, 0xbd, 0xb0, 0xba, 0x36, 0x13, 0x73, 0x98,
	0xbb, 0x63, 0x20, 0x3c, 0x89, 0x7a, 0x8b, 0x40, 0x71, 0x42, 0x87, 0x96, 0xe0, 0xfa, 0x2e, 0xae,
	0xd7, 0x76, 0x9a, 0x6b, 0xcd, 0xfa, 0xee, 0x8e, 0xb5, 0xbf, 0xb3, 0xd7, 0xa8, 0x6d, 0xd4, 0x37,
	0xeb, 0xb5, 0x6a, 0xf9, 0x0a, 0x2a, 0xc2, 0x5c, 0x63, 0xed, 0x61, 0xcd, 0xda, 0x6f, 0x94, 0x15,
	0xb4, 0x00, 0xc0, 0x27, 0xb8, 0xfe, 0x70, 0xab, 0x59, 0xce, 0xa0, 0x12, 0x68, 0x7c, 0x5e, 0xdd,
	0x3d, 0xdc, 0x29, 0xab, 0xe9, 0x74, 0xbb, 0xb6, 0xd9, 0x2c, 0x67, 0x8d, 0x3f, 0x14, 0xc8, 0x71,
	0x16, 0x98, 0xa0, 0x42, 0xe5, 0xf2, 0xa8, 0x30, 0x73, 0x59, 0x54, 0x68, 0xfc, 0xa9, 0x80, 0x96,
	0x92, 0xcf, 0xeb, 0x9e, 0xcc, 0xef, 0x0a, 0x64, 0x19, 0xe9, 0xbd, 0xee, 0x79, 0xfc, 0xad, 0x42,
	0x8e, 0x13, 0xee, 0x45, 0x27, 0xe2, 0xc1, 0x42, 0x9a, 0x48, 0x2b, 0x24, 0xf6, 0x91, 0x7c, 0x14,
	0xac, 0xcf, 0xf2, 0x6f, 0x90, 0xa6, 0xb2, 0xce, 0x90, 0x70, 0xc9, 0x9d, 0x9c, 0x3e, 0x67, 0xcf,
	0xd4, 0x4b, 0xdb, 0xb3, 0x9f, 0x15, 0x28, 0x9d, 0x0a, 0x08, 0x7d, 0x05, 0x59, 0xfe, 0x25, 0xa5,
	0x70, 0xa2, 0x79, 0xf8, 0xf2, 0x29, 0x9a, 0xec, 0x43, 0x0c, 0x73, 0xd0, 0x5b, 0x1b, 0x90, 0xe5,
	0x9f, 0x65, 0x57, 0xa1, 0xdc, 0x7c, 0xdc, 0xa8, 0x9d, 0x61, 0x16, 0x0d, 0x72, 0x7b, 0x8d, 0xb5,
	0x8d, 0x9a, 0xe0, 0x95, 0xc3, 0x7a, 0xb5, 0x66, 0x89, 0x79, 0x06, 0x01, 0xe4, 0xb7, 0x1e, 0x37,
	0xb6, 0x6a, 0x3b, 0x65, 0xd5, 0xf8, 0x4b, 0x81, 0xd2, 0xa9, 0x7f, 0xc0, 0x8b, 0x3e, 0x6f, 0x24,
	0xb7, 0x40, 0xbe, 0x1e, 0xd9, 0xf8, 0x95, 0x1f, 0xcc, 0x3f, 0x39, 0xc8, 0xf1, 0x3f, 0xe2, 0x8b,
	0x4e, 0xee, 0x6b, 0x28, 0x76, 0x89, 0xed, 0x92, 0xd0, 0x0a, 0xe9, 0x30, 0x29, 0xc7, 0x07, 0xb3,
	0x3c, 0x11, 0xe4, 0x43, 0x81, 0x0e, 0x31, 0x08, 0x44, 0x4c, 0x87, 0x11, 0x7a, 0x02, 0x5a, 0x8b,
	0xba, 0x23, 0x81, 0xae, 0x5e, 0x04, 0x7a, 0x81, 0xe1, 0x71, 0xec, 0x57, 0xfc, 0xe2, 0x35, 0xbe,
	0x81, 0x42, 0x12, 0x05, 0x6a, 0x42, 0xce, 0x21, 0xbe, 0x1f, 0xe9, 0x0a, 0x5f, 0xee, 0xd3, 0xd9,
	0x73, 0xda, 0x20, 0xbe, 0x8f, 0x05, 0x98, 0xf1, 0x5d, 0x06, 0xb4, 0x54, 0x78, 0xd1, 0x47, 0xfd,
	0x16, 0x14, 0x42, 0x3a, 0xb4, 0xa2, 0xbe, 0x2d, 0x3e, 0x63, 0x72, 0x78, 0x2e, 0xa4, 0xc3, 0xbd,
	0xbe, 0x1d, 0x30, 0x95, 0x43, 0x7d, 0xa1, 0x52, 0x85, 0xca, 0xa1, 0x3e, 0x57, 0xbd, 0xea, 0x4d,
	0xfe, 0x49, 0x05, 0x2d, 0x7d, 0x1f, 0xa2, 0x26, 0x00, 0x7f, 0x69, 0x5a, 0x81, 0xdd, 0x23, 0x2f,
	0xb7, 0x0d, 0x1a, 0x07, 0xda, 0xb1, 0x7b, 0x04, 0x1d, 0x40, 0x51, 0xa0, 0x1e, 0xdb, 0xfe, 0x80,
	0x48, 0xfa, 0x9e, 0x11, 0x56, 0xc4, 0x77, 0xc0, 0x80, 0xd0, 0x10, 0xae, 0xb3, 0x38, 0xad, 0xcb,
	0xa3, 0x86, 0x37, 0x19, 0x7e, 0xf5, 0x99, 0x6f, 0xb1, 0x11, 0xe8, 0x3c, 0x15, 0xeb, 0xf2, 0x8e,
	0xea, 0x1a, 0x5f, 0xe0, 0x99, 0xa5, 0x8d, 0x43, 0x28, 0x9f, 0x15, 0xa2, 0xdb, 0x50, 0x4a, 0xd6,
	0xb7, 0x1c, 0xea, 0x8a, 0x83, 0xd3, 0xf0, 0x7c, 0x22, 0xdc, 0xa0, 0x2e, 0x39, 0xef, 0xf5, 0x6c,
	0xfc, 0xa2, 0x40, 0x5e, 0x34, 0x9c, 0x2e, 0xeb, 0xfd, 0xfe, 0x7f, 0xc4, 0xfe, 0x2e, 0xcc, 0x33,
	0x17, 0x8f, 0x06, 0x16, 0xef, 0x14, 0x8a, 0x2f, 0x8a, 0xa2, 0x94, 0x31, 0x20, 0x74, 0x03, 0x20,
	0x31, 0xf1, 0x5c, 0xd9, 0x2c, 0xd1, 0xa4, 0xa4, 0xee, 0x1a, 0x5d, 0x58, 0x38, 0xdd, 0x27, 0x63,
	0x0e, 0xd1, 0xa0, 0xf5, 0x2d, 0x71, 0x62, 0xe6, 0x20, 0xf6, 0x42, 0x93, 0x92, 0xba, 0x8b, 0x96,
	0x40, 0xa3, 0xa9, 0x56, 0xc4, 0x52, 0xa0, 0x89, 0xd2, 0x80, 0x42, 0xd2, 0xb0, 0x4b, 0xba, 0x99,
	0xc9, 0xdc, 0xf8, 0x4d, 0x01, 0x18, 0xa7, 0x86, 0x08, 0x94, 0x44, 0x93, 0x86, 0x74, 0xc4, 0xd7,
	0xa4, 0xa0, 0xa6, 0xcf, 0x67, 0xd9, 0x27, 0x3e, 0xdc, 0x13, 0x40, 0x78, 0x3e, 0x1e, 0x4f, 0x22,
	0xe3, 0x0b, 0x28, 0x4e, 0x28, 0x79, 0x1f, 0x2d, 0xb6, 0xc3, 0xf8, 0x4c, 0xa3, 0x8d, 0x89, 0x44,
	0xa3, 0x6d, 0x09, 0x34, 0x12, 0x24, 0x7d, 0x38, 0xd1, 0x66, 0x2b, 0x90, 0x40, 0x74, 0xe1, 0xd6,
	0x0b, 0x90, 0x8f, 0xe8, 0x20, 0x74, 0xc8, 0xfa, 0xf7, 0x0a, 0xdc, 0x76, 0x68, 0xef, 0xbc, 0x60,
	0xd7, 0x4b, 0x49, 0xb4, 0x8d, 0x90, 0xc6, 0xb4, 0xa1, 0x3c, 0xa9, 0x4b, 0x8f, 0x0e, 0x65, 0xd7,
	0xcb, 0xa4, 0x61, 0xa7, 0xd2, 0x21, 0x01, 0xef, 0x24, 0x57, 0x84, 0xca, 0xee, 0x7b, 0xd1, 0x73,
	0xdb, 0xd5, 0x1f, 0x8f, 0x45, 0xad, 0x3c, 0xf7, 0xba, 0xfb, 0x5f, 0x00, 0x00, 0x00, 0xff, 0xff,
	0x4b, 0x8b, 0xef, 0x7b, 0x52, 0x17, 0x00, 0x00,
}
