// This file was generated by go generate; DO NOT EDIT

package number

import "golang.org/x/text/internal/stringset"

// CLDRVersion is the CLDR version from which the tables in this package are derived.
const CLDRVersion = "30"

var numSysData = []systemData{ // 58 elements
	0:  {id: 0x0, digitSize: 0x1, zero: [4]uint8{0x30, 0x0, 0x0, 0x0}},
	1:  {id: 0x1, digitSize: 0x4, zero: [4]uint8{0xf0, 0x9e, 0xa5, 0x90}},
	2:  {id: 0x2, digitSize: 0x4, zero: [4]uint8{0xf0, 0x91, 0x9c, 0xb0}},
	3:  {id: 0x3, digitSize: 0x2, zero: [4]uint8{0xd9, 0xa0, 0x0, 0x0}},
	4:  {id: 0x4, digitSize: 0x2, zero: [4]uint8{0xdb, 0xb0, 0x0, 0x0}},
	5:  {id: 0x5, digitSize: 0x3, zero: [4]uint8{0xe1, 0xad, 0x90, 0x0}},
	6:  {id: 0x6, digitSize: 0x3, zero: [4]uint8{0xe0, 0xa7, 0xa6, 0x0}},
	7:  {id: 0x7, digitSize: 0x4, zero: [4]uint8{0xf0, 0x91, 0xb1, 0x90}},
	8:  {id: 0x8, digitSize: 0x4, zero: [4]uint8{0xf0, 0x91, 0x81, 0xa6}},
	9:  {id: 0x9, digitSize: 0x4, zero: [4]uint8{0xf0, 0x91, 0x84, 0xb6}},
	10: {id: 0xa, digitSize: 0x3, zero: [4]uint8{0xea, 0xa9, 0x90, 0x0}},
	11: {id: 0xb, digitSize: 0x3, zero: [4]uint8{0xe0, 0xa5, 0xa6, 0x0}},
	12: {id: 0xc, digitSize: 0x3, zero: [4]uint8{0xef, 0xbc, 0x90, 0x0}},
	13: {id: 0xd, digitSize: 0x3, zero: [4]uint8{0xe0, 0xab, 0xa6, 0x0}},
	14: {id: 0xe, digitSize: 0x3, zero: [4]uint8{0xe0, 0xa9, 0xa6, 0x0}},
	15: {id: 0xf, digitSize: 0x4, zero: [4]uint8{0xf0, 0x96, 0xad, 0x90}},
	16: {id: 0x10, digitSize: 0x3, zero: [4]uint8{0xea, 0xa7, 0x90, 0x0}},
	17: {id: 0x11, digitSize: 0x3, zero: [4]uint8{0xea, 0xa4, 0x80, 0x0}},
	18: {id: 0x12, digitSize: 0x3, zero: [4]uint8{0xe1, 0x9f, 0xa0, 0x0}},
	19: {id: 0x13, digitSize: 0x3, zero: [4]uint8{0xe0, 0xb3, 0xa6, 0x0}},
	20: {id: 0x14, digitSize: 0x3, zero: [4]uint8{0xe1, 0xaa, 0x80, 0x0}},
	21: {id: 0x15, digitSize: 0x3, zero: [4]uint8{0xe1, 0xaa, 0x90, 0x0}},
	22: {id: 0x16, digitSize: 0x3, zero: [4]uint8{0xe0, 0xbb, 0x90, 0x0}},
	23: {id: 0x17, digitSize: 0x3, zero: [4]uint8{0xe1, 0xb1, 0x80, 0x0}},
	24: {id: 0x18, digitSize: 0x3, zero: [4]uint8{0xe1, 0xa5, 0x86, 0x0}},
	25: {id: 0x19, digitSize: 0x4, zero: [4]uint8{0xf0, 0x9d, 0x9f, 0x8e}},
	26: {id: 0x1a, digitSize: 0x4, zero: [4]uint8{0xf0, 0x9d, 0x9f, 0x98}},
	27: {id: 0x1b, digitSize: 0x4, zero: [4]uint8{0xf0, 0x9d, 0x9f, 0xb6}},
	28: {id: 0x1c, digitSize: 0x4, zero: [4]uint8{0xf0, 0x9d, 0x9f, 0xac}},
	29: {id: 0x1d, digitSize: 0x4, zero: [4]uint8{0xf0, 0x9d, 0x9f, 0xa2}},
	30: {id: 0x1e, digitSize: 0x3, zero: [4]uint8{0xe0, 0xb5, 0xa6, 0x0}},
	31: {id: 0x1f, digitSize: 0x4, zero: [4]uint8{0xf0, 0x91, 0x99, 0x90}},
	32: {id: 0x20, digitSize: 0x3, zero: [4]uint8{0xe1, 0xa0, 0x90, 0x0}},
	33: {id: 0x21, digitSize: 0x4, zero: [4]uint8{0xf0, 0x96, 0xa9, 0xa0}},
	34: {id: 0x22, digitSize: 0x3, zero: [4]uint8{0xea, 0xaf, 0xb0, 0x0}},
	35: {id: 0x23, digitSize: 0x3, zero: [4]uint8{0xe1, 0x81, 0x80, 0x0}},
	36: {id: 0x24, digitSize: 0x3, zero: [4]uint8{0xe1, 0x82, 0x90, 0x0}},
	37: {id: 0x25, digitSize: 0x3, zero: [4]uint8{0xea, 0xa7, 0xb0, 0x0}},
	38: {id: 0x26, digitSize: 0x4, zero: [4]uint8{0xf0, 0x91, 0x91, 0x90}},
	39: {id: 0x27, digitSize: 0x2, zero: [4]uint8{0xdf, 0x80, 0x0, 0x0}},
	40: {id: 0x28, digitSize: 0x3, zero: [4]uint8{0xe1, 0xb1, 0x90, 0x0}},
	41: {id: 0x29, digitSize: 0x3, zero: [4]uint8{0xe0, 0xad, 0xa6, 0x0}},
	42: {id: 0x2a, digitSize: 0x4, zero: [4]uint8{0xf0, 0x90, 0x92, 0xa0}},
	43: {id: 0x2b, digitSize: 0x3, zero: [4]uint8{0xea, 0xa3, 0x90, 0x0}},
	44: {id: 0x2c, digitSize: 0x4, zero: [4]uint8{0xf0, 0x91, 0x87, 0x90}},
	45: {id: 0x2d, digitSize: 0x4, zero: [4]uint8{0xf0, 0x91, 0x8b, 0xb0}},
	46: {id: 0x2e, digitSize: 0x3, zero: [4]uint8{0xe0, 0xb7, 0xa6, 0x0}},
	47: {id: 0x2f, digitSize: 0x4, zero: [4]uint8{0xf0, 0x91, 0x83, 0xb0}},
	48: {id: 0x30, digitSize: 0x3, zero: [4]uint8{0xe1, 0xae, 0xb0, 0x0}},
	49: {id: 0x31, digitSize: 0x4, zero: [4]uint8{0xf0, 0x91, 0x9b, 0x80}},
	50: {id: 0x32, digitSize: 0x3, zero: [4]uint8{0xe1, 0xa7, 0x90, 0x0}},
	51: {id: 0x33, digitSize: 0x3, zero: [4]uint8{0xe0, 0xaf, 0xa6, 0x0}},
	52: {id: 0x34, digitSize: 0x3, zero: [4]uint8{0xe0, 0xb1, 0xa6, 0x0}},
	53: {id: 0x35, digitSize: 0x3, zero: [4]uint8{0xe0, 0xb9, 0x90, 0x0}},
	54: {id: 0x36, digitSize: 0x3, zero: [4]uint8{0xe0, 0xbc, 0xa0, 0x0}},
	55: {id: 0x37, digitSize: 0x4, zero: [4]uint8{0xf0, 0x91, 0x93, 0x90}},
	56: {id: 0x38, digitSize: 0x3, zero: [4]uint8{0xea, 0x98, 0xa0, 0x0}},
	57: {id: 0x39, digitSize: 0x4, zero: [4]uint8{0xf0, 0x91, 0xa3, 0xa0}},
} // Size: 372 bytes

const (
	numAdlm     = 0x1
	numAhom     = 0x2
	numArab     = 0x3
	numArabext  = 0x4
	numArmn     = 0x3a
	numArmnlow  = 0x3b
	numBali     = 0x5
	numBeng     = 0x6
	numBhks     = 0x7
	numBrah     = 0x8
	numCakm     = 0x9
	numCham     = 0xa
	numCyrl     = 0x3c
	numDeva     = 0xb
	numEthi     = 0x3d
	numFullwide = 0xc
	numGeor     = 0x3e
	numGrek     = 0x3f
	numGreklow  = 0x40
	numGujr     = 0xd
	numGuru     = 0xe
	numHanidays = 0x41
	numHanidec  = 0x42
	numHans     = 0x43
	numHansfin  = 0x44
	numHant     = 0x45
	numHantfin  = 0x46
	numHebr     = 0x47
	numHmng     = 0xf
	numJava     = 0x10
	numJpan     = 0x48
	numJpanfin  = 0x49
	numKali     = 0x11
	numKhmr     = 0x12
	numKnda     = 0x13
	numLana     = 0x14
	numLanatham = 0x15
	numLaoo     = 0x16
	numLatn     = 0x0
	numLepc     = 0x17
	numLimb     = 0x18
	numMathbold = 0x19
	numMathdbl  = 0x1a
	numMathmono = 0x1b
	numMathsanb = 0x1c
	numMathsans = 0x1d
	numMlym     = 0x1e
	numModi     = 0x1f
	numMong     = 0x20
	numMroo     = 0x21
	numMtei     = 0x22
	numMymr     = 0x23
	numMymrshan = 0x24
	numMymrtlng = 0x25
	numNewa     = 0x26
	numNkoo     = 0x27
	numOlck     = 0x28
	numOrya     = 0x29
	numOsma     = 0x2a
	numRoman    = 0x4a
	numRomanlow = 0x4b
	numSaur     = 0x2b
	numShrd     = 0x2c
	numSind     = 0x2d
	numSinh     = 0x2e
	numSora     = 0x2f
	numSund     = 0x30
	numTakr     = 0x31
	numTalu     = 0x32
	numTaml     = 0x4c
	numTamldec  = 0x33
	numTelu     = 0x34
	numThai     = 0x35
	numTibt     = 0x36
	numTirh     = 0x37
	numVaii     = 0x38
	numWara     = 0x39
	numNumberSystems
)

var systemMap = map[string]system{
	"adlm":     numAdlm,
	"ahom":     numAhom,
	"arab":     numArab,
	"arabext":  numArabext,
	"armn":     numArmn,
	"armnlow":  numArmnlow,
	"bali":     numBali,
	"beng":     numBeng,
	"bhks":     numBhks,
	"brah":     numBrah,
	"cakm":     numCakm,
	"cham":     numCham,
	"cyrl":     numCyrl,
	"deva":     numDeva,
	"ethi":     numEthi,
	"fullwide": numFullwide,
	"geor":     numGeor,
	"grek":     numGrek,
	"greklow":  numGreklow,
	"gujr":     numGujr,
	"guru":     numGuru,
	"hanidays": numHanidays,
	"hanidec":  numHanidec,
	"hans":     numHans,
	"hansfin":  numHansfin,
	"hant":     numHant,
	"hantfin":  numHantfin,
	"hebr":     numHebr,
	"hmng":     numHmng,
	"java":     numJava,
	"jpan":     numJpan,
	"jpanfin":  numJpanfin,
	"kali":     numKali,
	"khmr":     numKhmr,
	"knda":     numKnda,
	"lana":     numLana,
	"lanatham": numLanatham,
	"laoo":     numLaoo,
	"latn":     numLatn,
	"lepc":     numLepc,
	"limb":     numLimb,
	"mathbold": numMathbold,
	"mathdbl":  numMathdbl,
	"mathmono": numMathmono,
	"mathsanb": numMathsanb,
	"mathsans": numMathsans,
	"mlym":     numMlym,
	"modi":     numModi,
	"mong":     numMong,
	"mroo":     numMroo,
	"mtei":     numMtei,
	"mymr":     numMymr,
	"mymrshan": numMymrshan,
	"mymrtlng": numMymrtlng,
	"newa":     numNewa,
	"nkoo":     numNkoo,
	"olck":     numOlck,
	"orya":     numOrya,
	"osma":     numOsma,
	"roman":    numRoman,
	"romanlow": numRomanlow,
	"saur":     numSaur,
	"shrd":     numShrd,
	"sind":     numSind,
	"sinh":     numSinh,
	"sora":     numSora,
	"sund":     numSund,
	"takr":     numTakr,
	"talu":     numTalu,
	"taml":     numTaml,
	"tamldec":  numTamldec,
	"telu":     numTelu,
	"thai":     numThai,
	"tibt":     numTibt,
	"tirh":     numTirh,
	"vaii":     numVaii,
	"wara":     numWara,
}

var symIndex = [][12]uint8{ // 71 elements
	0:  [12]uint8{0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb},
	1:  [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb},
	2:  [12]uint8{0x0, 0x1, 0x2, 0xd, 0xe, 0xf, 0x6, 0x7, 0x8, 0x9, 0x10, 0xb},
	3:  [12]uint8{0x1, 0x0, 0x2, 0xd, 0xe, 0xf, 0x6, 0x7, 0x8, 0x9, 0x10, 0xb},
	4:  [12]uint8{0x0, 0x1, 0x2, 0x11, 0xe, 0xf, 0x6, 0x7, 0x8, 0x9, 0x10, 0xb},
	5:  [12]uint8{0x1, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x12, 0xb},
	6:  [12]uint8{0x1, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb},
	7:  [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x13, 0x8, 0x9, 0xa, 0xb},
	8:  [12]uint8{0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x14, 0xb},
	9:  [12]uint8{0x0, 0x1, 0x2, 0x3, 0xe, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb},
	10: [12]uint8{0x1, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0x0},
	11: [12]uint8{0x1, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x13, 0x8, 0x9, 0xa, 0xb},
	12: [12]uint8{0x0, 0x15, 0x2, 0x3, 0x4, 0x5, 0x6, 0x13, 0x8, 0x9, 0xa, 0xb},
	13: [12]uint8{0x0, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb},
	14: [12]uint8{0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x16, 0xb},
	15: [12]uint8{0x1, 0x0, 0x2, 0x3, 0x4, 0x5, 0x17, 0x7, 0x8, 0x9, 0xa, 0xb},
	16: [12]uint8{0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x17, 0x7, 0x8, 0x9, 0xa, 0xb},
	17: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0x0},
	18: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x18, 0x7, 0x8, 0x9, 0xa, 0xb},
	19: [12]uint8{0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x19, 0x1a, 0xa, 0xb},
	20: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x1b, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb},
	21: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x1b, 0x18, 0x7, 0x8, 0x9, 0xa, 0xb},
	22: [12]uint8{0x0, 0x1, 0x2, 0x3, 0xe, 0x1c, 0x6, 0x7, 0x8, 0x9, 0x1d, 0xb},
	23: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x1b, 0x6, 0x7, 0x8, 0x9, 0x1e, 0x0},
	24: [12]uint8{0x1, 0x0, 0x2, 0x3, 0x4, 0x1b, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb},
	25: [12]uint8{0x0, 0x1f, 0x2, 0x3, 0x4, 0x1b, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb},
	26: [12]uint8{0x0, 0x1, 0x2, 0x3, 0xe, 0xf, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb},
	27: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x20, 0xb},
	28: [12]uint8{0x0, 0x15, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb},
	29: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x21, 0xb},
	30: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x22, 0xb},
	31: [12]uint8{0x1, 0x0, 0x2, 0x3, 0x4, 0x1b, 0x18, 0x13, 0x8, 0x9, 0x23, 0xb},
	32: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x1b, 0x18, 0x7, 0x8, 0x9, 0x23, 0xb},
	33: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x24, 0xb},
	34: [12]uint8{0x1, 0x0, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x25, 0xb},
	35: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x26, 0xb},
	36: [12]uint8{0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x27, 0xb},
	37: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x28, 0xb},
	38: [12]uint8{0x1, 0x0, 0x2, 0x3, 0xe, 0x1c, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb},
	39: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x29, 0xb},
	40: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x2a, 0xb},
	41: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x1b, 0x2b, 0x13, 0x8, 0x9, 0x23, 0xb},
	42: [12]uint8{0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0x0},
	43: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x17, 0x7, 0x8, 0x9, 0xa, 0xb},
	44: [12]uint8{0x1, 0x0, 0x2, 0x3, 0x4, 0x2c, 0x17, 0x7, 0x8, 0x9, 0xa, 0xb},
	45: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x2d, 0x0},
	46: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x2e, 0xb},
	47: [12]uint8{0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x2f, 0xb},
	48: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x30, 0x7, 0x8, 0x9, 0xa, 0xb},
	49: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x31, 0xb},
	50: [12]uint8{0x1, 0xc, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x32, 0xb},
	51: [12]uint8{0x1, 0x1f, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xa, 0xb},
	52: [12]uint8{0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x33, 0xb},
	53: [12]uint8{0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x7, 0x3b, 0x9, 0xa, 0xb},
	54: [12]uint8{0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x7, 0x3b, 0x9, 0x3c, 0xb},
	55: [12]uint8{0x34, 0x35, 0x36, 0x11, 0x38, 0x39, 0x3a, 0x7, 0x3b, 0x9, 0xa, 0xb},
	56: [12]uint8{0x34, 0x35, 0x36, 0x11, 0x38, 0x3d, 0x3a, 0x7, 0x3b, 0x9, 0xa, 0xb},
	57: [12]uint8{0x34, 0xc, 0x36, 0x37, 0x38, 0x3e, 0x3a, 0x7, 0x3b, 0x9, 0xa, 0x0},
	58: [12]uint8{0x34, 0x35, 0x36, 0x37, 0x38, 0x3e, 0x3a, 0x7, 0x3f, 0x9, 0x23, 0xb},
	59: [12]uint8{0x34, 0x35, 0x36, 0x11, 0x40, 0x41, 0x42, 0x7, 0x3b, 0x9, 0xa, 0x34},
	60: [12]uint8{0x34, 0x35, 0x36, 0x43, 0xe, 0x1c, 0x42, 0x7, 0x3b, 0x9, 0x1d, 0xb},
	61: [12]uint8{0x34, 0x35, 0x36, 0x11, 0xe, 0x1c, 0x42, 0x7, 0x3b, 0x9, 0xa, 0x34},
	62: [12]uint8{0x1, 0xc, 0x36, 0x11, 0x40, 0x44, 0x42, 0x7, 0x3b, 0x9, 0xa, 0x0},
	63: [12]uint8{0x34, 0x1, 0x36, 0x11, 0x4, 0x5, 0x42, 0x7, 0x3b, 0x9, 0xa, 0x34},
	64: [12]uint8{0x34, 0x35, 0x36, 0x11, 0x40, 0x44, 0x42, 0x7, 0x3b, 0x9, 0x23, 0xb},
	65: [12]uint8{0x0, 0x1, 0x2, 0x3, 0x40, 0x41, 0x42, 0x7, 0x8, 0x9, 0xa, 0x34},
	66: [12]uint8{0x34, 0x35, 0x36, 0x11, 0x4, 0x5, 0x42, 0x7, 0x3b, 0x9, 0x31, 0x34},
	67: [12]uint8{0x34, 0x35, 0x36, 0x11, 0x4, 0x5, 0x42, 0x7, 0x3b, 0x9, 0x32, 0x34},
	68: [12]uint8{0x0, 0x1, 0x45, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x27, 0xb},
	69: [12]uint8{0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0x46, 0xb},
	70: [12]uint8{0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x47, 0x48, 0xb},
} // Size: 876 bytes

var symData = stringset.Set{
	Data: "" + // Size: 584 bytes
		".,;%+-E×‰∞NaN:\u00a0\u200e%\u200e\u200e+\u200e-ليس\u00a0رقمًا٪ND·Терхьаш" +
		"\u00a0дац'mnne×10^0/00INF−\u200e−ناعددepäluku’ՈչԹარ\u00a0არის\u00a0რიცხვ" +
		"იсан\u00a0емес¤¤¤сан\u00a0эмесບໍ່\u200bແມ່ນ\u200bໂຕ\u200bເລກNSဂဏန်းမဟု" +
		"တ်သောННне\u00a0числочыыһыла\u00a0буотах·10^–epilohosan\u00a0dälTFЕhaqi" +
		"qiy\u00a0son\u00a0emasҳақиқий\u00a0сон\u00a0эмас非數值٫٬؛٪\u061c\u061c+" +
		"\u061c-اس؉ليس\u00a0رقم\u200f−\u061c−؉\u200f\u200e+\u200e\u200e-\u200e×۱۰" +
		"^\u200e٪\u200e−\u200e၊ཨང་མེན་གྲངས་མེདཨང་མད",
	Index: []uint16{ // 74 elements
		// Entry 0 - 3F
		0x0000, 0x0001, 0x0002, 0x0003, 0x0004, 0x0005, 0x0006, 0x0007,
		0x0009, 0x000c, 0x000f, 0x0012, 0x0013, 0x0015, 0x001c, 0x0020,
		0x0024, 0x0036, 0x0038, 0x003a, 0x003c, 0x0052, 0x0053, 0x0056,
		0x0057, 0x005c, 0x0060, 0x0063, 0x0066, 0x006c, 0x0076, 0x007e,
		0x0081, 0x0087, 0x00af, 0x00bf, 0x00c5, 0x00d5, 0x0102, 0x0104,
		0x012b, 0x012f, 0x013f, 0x015b, 0x0160, 0x0163, 0x016a, 0x0173,
		0x0175, 0x0177, 0x0189, 0x01a9, 0x01b2, 0x01b4, 0x01b6, 0x01b8,
		0x01bc, 0x01bf, 0x01c2, 0x01c6, 0x01c8, 0x01d6, 0x01dc, 0x01e1,
		// Entry 40 - 7F
		0x01e6, 0x01ed, 0x01f4, 0x01fb, 0x0200, 0x0209, 0x020c, 0x0221,
		0x0239, 0x0248,
	},
} // Size: 772 bytes

// langToDefaults maps a compact language index to the default numbering system
// and default symbol set
var langToDefaults = [752]uint8{
	// Entry 0 - 3F
	0x80, 0x06, 0x13, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x83, 0x02, 0x02, 0x02,
	0x02, 0x03, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x03, 0x03, 0x03, 0x03, 0x02, 0x02,
	0x02, 0x04, 0x02, 0x04, 0x02, 0x02, 0x02, 0x03,
	0x02, 0x00, 0x85, 0x00, 0x00, 0x00, 0x86, 0x05,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01, 0x01,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x00,
	// Entry 40 - 7F
	0x00, 0x00, 0x89, 0x00, 0x00, 0x8a, 0x00, 0x00,
	0x8c, 0x01, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x08, 0x08,
	0x00, 0x00, 0x00, 0x00, 0x8e, 0x09, 0x09, 0x90,
	0x01, 0x01, 0x01, 0x93, 0x00, 0x0a, 0x0a, 0x0a,
	0x00, 0x00, 0x0b, 0x07, 0x0b, 0x0c, 0x0b, 0x0b,
	0x0c, 0x0b, 0x0d, 0x0d, 0x0b, 0x0b, 0x01, 0x01,
	0x00, 0x01, 0x01, 0x95, 0x00, 0x00, 0x00, 0x0e,
	// Entry 80 - BF
	0x0e, 0x0e, 0x0f, 0x0f, 0x0f, 0x00, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x0b, 0x10, 0x00, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x00,
	0x00, 0x00, 0x00, 0x0b, 0x00, 0x0a, 0x00, 0x00,
	0x11, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry C0 - FF
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x12, 0x00, 0x00,
	0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x14, 0x14,
	0x06, 0x00, 0x06, 0x06, 0x00, 0x06, 0x06, 0x01,
	0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x00, 0x00,
	// Entry 100 - 13F
	0x06, 0x00, 0x00, 0x00, 0x00, 0x06, 0x00, 0x06,
	0x00, 0x00, 0x06, 0x06, 0x15, 0x15, 0x06, 0x06,
	0x01, 0x01, 0x97, 0x16, 0x16, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x17, 0x17, 0x00, 0x00, 0x18, 0x18,
	0x18, 0x9a, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x0d, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x06, 0x06, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	// Entry 140 - 17F
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x06, 0x06, 0x06, 0x06, 0x00, 0x00, 0x9d, 0x00,
	0x06, 0x06, 0x19, 0x19, 0x19, 0x19, 0xa0, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x1a, 0x1a, 0x00, 0x00, 0x06,
	0x06, 0x06, 0x0b, 0x0b, 0x01, 0x01, 0x1b, 0x1b,
	0x0a, 0x0a, 0xa2, 0x00, 0x00, 0x00, 0x06, 0x06,
	// Entry 180 - 1BF
	0x06, 0x1c, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00,
	0x06, 0x06, 0x00, 0x00, 0x00, 0x1d, 0x1d, 0x01,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x01, 0x0d, 0x0d, 0x00, 0x00, 0x1e, 0x1e, 0x06,
	0x06, 0x1f, 0x1f, 0x00, 0x00, 0x06, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xa5, 0x1a,
	0x00, 0x00, 0x01, 0x01, 0x20, 0x20, 0x00, 0x00,
	0x00, 0x21, 0x21, 0x00, 0x00, 0x06, 0x06, 0x00,
	// Entry 1C0 - 1FF
	0x00, 0x00, 0x00, 0x06, 0x06, 0x06, 0x06, 0x06,
	0x22, 0x22, 0xa7, 0x00, 0x00, 0x15, 0x15, 0x06,
	0x06, 0x00, 0x00, 0x00, 0x00, 0x23, 0x23, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0d, 0x0d, 0x00, 0x00,
	0x06, 0x06, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00,
	0x00, 0x00, 0xa9, 0x00, 0x00, 0x06, 0x00, 0x00,
	0x00, 0x00, 0x06, 0x06, 0xaa, 0x24, 0xac, 0x00,
	0x00, 0x00, 0x00, 0xad, 0x14, 0x14, 0x00, 0x00,
	// Entry 200 - 23F
	0x06, 0x06, 0x06, 0xb0, 0x00, 0x00, 0xb1, 0x06,
	0x06, 0x06, 0x06, 0x06, 0x06, 0x06, 0x01, 0x01,
	0x14, 0x14, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x25, 0x25, 0x25, 0xb4, 0xb6, 0x1a,
	0x00, 0x00, 0x00, 0x01, 0x01, 0x01, 0x01, 0xb8,
	0x26, 0x06, 0x01, 0x06, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x00, 0x06,
	// Entry 240 - 27F
	0x00, 0x00, 0x19, 0x19, 0x06, 0x06, 0x06, 0x06,
	0x06, 0x00, 0x00, 0x27, 0x27, 0x27, 0x27, 0x27,
	0x27, 0x27, 0x06, 0x06, 0x00, 0x00, 0x28, 0x28,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x29, 0x29, 0x29,
	0x29, 0x06, 0x06, 0x0d, 0x0d, 0x06, 0x06, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x2a, 0x2a, 0x2b, 0x2b,
	0x2c, 0x2c, 0x00, 0x00, 0x00, 0x2d, 0x2d, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	// Entry 280 - 2BF
	0x01, 0x01, 0x01, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a,
	0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x0a, 0x00, 0x00,
	0x00, 0xba, 0x20, 0x20, 0x20, 0x00, 0x06, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x2e, 0x2e, 0x00, 0x2f, 0x2f,
	0x06, 0x06, 0x06, 0x00, 0x0d, 0x0d, 0x01, 0x01,
	0x00, 0x00, 0x30, 0x30, 0xbd, 0xbf, 0x1a, 0xc0,
	// Entry 2C0 - 2FF
	0xc2, 0x26, 0xc4, 0x32, 0x31, 0x31, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x06, 0x06, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x33, 0x33, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x34, 0x34, 0x01, 0x01, 0xc6, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x34, 0x34, 0x34, 0x34, 0x00, 0x00,
} // Size: 752 bytes

// langToAlt is a list of numbering system and symbol set pairs, sorted and
// marked by compact language index.
var langToAlt = []altSymData{ // 73 elements
	1:  {compactTag: 0x0, system: 0x3, symIndex: 0x35},
	2:  {compactTag: 0x0, system: 0x4, symIndex: 0x3b},
	3:  {compactTag: 0xc, system: 0x3, symIndex: 0x36},
	4:  {compactTag: 0xc, system: 0x0, symIndex: 0x2},
	5:  {compactTag: 0x2a, system: 0x6, symIndex: 0x0},
	6:  {compactTag: 0x2e, system: 0x0, symIndex: 0x5},
	7:  {compactTag: 0x2e, system: 0x3, symIndex: 0x37},
	8:  {compactTag: 0x2e, system: 0x4, symIndex: 0x3b},
	9:  {compactTag: 0x42, system: 0x6, symIndex: 0x0},
	10: {compactTag: 0x45, system: 0x0, symIndex: 0x0},
	11: {compactTag: 0x45, system: 0x36, symIndex: 0x45},
	12: {compactTag: 0x48, system: 0x0, symIndex: 0x1},
	13: {compactTag: 0x48, system: 0x3, symIndex: 0x35},
	14: {compactTag: 0x5c, system: 0x3, symIndex: 0x37},
	15: {compactTag: 0x5c, system: 0x0, symIndex: 0x9},
	16: {compactTag: 0x5f, system: 0x0, symIndex: 0x1},
	17: {compactTag: 0x5f, system: 0x3, symIndex: 0x35},
	18: {compactTag: 0x5f, system: 0x4, symIndex: 0x3b},
	19: {compactTag: 0x63, system: 0x0, symIndex: 0x0},
	20: {compactTag: 0x63, system: 0x3, symIndex: 0x35},
	21: {compactTag: 0x7b, system: 0x36, symIndex: 0x46},
	22: {compactTag: 0x7b, system: 0x0, symIndex: 0x0},
	23: {compactTag: 0x112, system: 0x4, symIndex: 0x3c},
	24: {compactTag: 0x112, system: 0x0, symIndex: 0x16},
	25: {compactTag: 0x112, system: 0x3, symIndex: 0x37},
	26: {compactTag: 0x121, system: 0x0, symIndex: 0x1},
	27: {compactTag: 0x121, system: 0x3, symIndex: 0x38},
	28: {compactTag: 0x121, system: 0x4, symIndex: 0x3d},
	29: {compactTag: 0x156, system: 0x0, symIndex: 0x0},
	30: {compactTag: 0x156, system: 0x3, symIndex: 0x37},
	31: {compactTag: 0x156, system: 0x4, symIndex: 0x3b},
	32: {compactTag: 0x15e, system: 0x0, symIndex: 0x0},
	33: {compactTag: 0x15e, system: 0x3, symIndex: 0x35},
	34: {compactTag: 0x17a, system: 0x0, symIndex: 0x0},
	35: {compactTag: 0x17a, system: 0x3, symIndex: 0x35},
	36: {compactTag: 0x17a, system: 0x4, symIndex: 0x3b},
	37: {compactTag: 0x1ae, system: 0x4, symIndex: 0x3b},
	38: {compactTag: 0x1ae, system: 0x0, symIndex: 0x1a},
	39: {compactTag: 0x1ca, system: 0x4, symIndex: 0x3b},
	40: {compactTag: 0x1ca, system: 0x0, symIndex: 0x0},
	41: {compactTag: 0x1ea, system: 0xb, symIndex: 0x0},
	42: {compactTag: 0x1f4, system: 0x23, symIndex: 0x44},
	43: {compactTag: 0x1f4, system: 0x0, symIndex: 0x24},
	44: {compactTag: 0x1f6, system: 0x4, symIndex: 0x3b},
	45: {compactTag: 0x1fb, system: 0x0, symIndex: 0x14},
	46: {compactTag: 0x1fb, system: 0x3, symIndex: 0x39},
	47: {compactTag: 0x1fb, system: 0x4, symIndex: 0x3e},
	48: {compactTag: 0x203, system: 0xb, symIndex: 0x0},
	49: {compactTag: 0x206, system: 0x0, symIndex: 0x6},
	50: {compactTag: 0x206, system: 0x3, symIndex: 0x35},
	51: {compactTag: 0x206, system: 0x4, symIndex: 0x3b},
	52: {compactTag: 0x225, system: 0x0, symIndex: 0x0},
	53: {compactTag: 0x225, system: 0x4, symIndex: 0x3f},
	54: {compactTag: 0x226, system: 0x4, symIndex: 0x3b},
	55: {compactTag: 0x226, system: 0x0, symIndex: 0x1a},
	56: {compactTag: 0x22f, system: 0x4, symIndex: 0x3b},
	57: {compactTag: 0x22f, system: 0x0, symIndex: 0x26},
	58: {compactTag: 0x291, system: 0x0, symIndex: 0x20},
	59: {compactTag: 0x291, system: 0x3, symIndex: 0x3a},
	60: {compactTag: 0x291, system: 0x4, symIndex: 0x40},
	61: {compactTag: 0x2bc, system: 0x0, symIndex: 0x1a},
	62: {compactTag: 0x2bc, system: 0x4, symIndex: 0x41},
	63: {compactTag: 0x2bd, system: 0x4, symIndex: 0x41},
	64: {compactTag: 0x2bf, system: 0x0, symIndex: 0x31},
	65: {compactTag: 0x2bf, system: 0x4, symIndex: 0x42},
	66: {compactTag: 0x2c0, system: 0x4, symIndex: 0x3b},
	67: {compactTag: 0x2c0, system: 0x0, symIndex: 0x26},
	68: {compactTag: 0x2c2, system: 0x0, symIndex: 0x32},
	69: {compactTag: 0x2c2, system: 0x4, symIndex: 0x43},
	70: {compactTag: 0x2e4, system: 0x0, symIndex: 0x0},
	71: {compactTag: 0x2e4, system: 0x3, symIndex: 0x35},
	72: {compactTag: 0x2e4, system: 0x4, symIndex: 0x3b},
} // Size: 316 bytes

var ordinalRules = []pluralCheck{ // 58 elements
	0:  {cat: 0x2f, setID: 0x4},
	1:  {cat: 0x3a, setID: 0x5},
	2:  {cat: 0x22, setID: 0x1},
	3:  {cat: 0x22, setID: 0x6},
	4:  {cat: 0x22, setID: 0x7},
	5:  {cat: 0x2f, setID: 0x8},
	6:  {cat: 0x3c, setID: 0x9},
	7:  {cat: 0x2f, setID: 0xa},
	8:  {cat: 0x3c, setID: 0xb},
	9:  {cat: 0x2d, setID: 0xc},
	10: {cat: 0x2d, setID: 0xd},
	11: {cat: 0x2f, setID: 0xe},
	12: {cat: 0x35, setID: 0x3},
	13: {cat: 0xc5, setID: 0xf},
	14: {cat: 0x2, setID: 0x1},
	15: {cat: 0x5, setID: 0x3},
	16: {cat: 0xd, setID: 0x10},
	17: {cat: 0x22, setID: 0x1},
	18: {cat: 0x2f, setID: 0x11},
	19: {cat: 0x3d, setID: 0x12},
	20: {cat: 0x2f, setID: 0x13},
	21: {cat: 0x3a, setID: 0x14},
	22: {cat: 0x2f, setID: 0x15},
	23: {cat: 0x3b, setID: 0x16},
	24: {cat: 0x2f, setID: 0xa},
	25: {cat: 0x3c, setID: 0xb},
	26: {cat: 0x22, setID: 0x1},
	27: {cat: 0x23, setID: 0x17},
	28: {cat: 0x24, setID: 0x18},
	29: {cat: 0x22, setID: 0x19},
	30: {cat: 0x23, setID: 0x2},
	31: {cat: 0x24, setID: 0x18},
	32: {cat: 0xf, setID: 0x13},
	33: {cat: 0x1a, setID: 0x14},
	34: {cat: 0xf, setID: 0x15},
	35: {cat: 0x1b, setID: 0x16},
	36: {cat: 0xf, setID: 0x1a},
	37: {cat: 0x1d, setID: 0x1b},
	38: {cat: 0xa, setID: 0x1c},
	39: {cat: 0xa, setID: 0x1d},
	40: {cat: 0xc, setID: 0x1e},
	41: {cat: 0xe4, setID: 0x0},
	42: {cat: 0x5, setID: 0x3},
	43: {cat: 0xd, setID: 0xc},
	44: {cat: 0xd, setID: 0x1f},
	45: {cat: 0x22, setID: 0x1},
	46: {cat: 0x23, setID: 0x17},
	47: {cat: 0x24, setID: 0x18},
	48: {cat: 0x25, setID: 0x20},
	49: {cat: 0x22, setID: 0x21},
	50: {cat: 0x23, setID: 0x17},
	51: {cat: 0x24, setID: 0x18},
	52: {cat: 0x25, setID: 0x20},
	53: {cat: 0x21, setID: 0x22},
	54: {cat: 0x22, setID: 0x1},
	55: {cat: 0x23, setID: 0x2},
	56: {cat: 0x24, setID: 0x23},
	57: {cat: 0x25, setID: 0x24},
} // Size: 140 bytes

var ordinalIndex = []uint8{ // 20 elements
	0x00, 0x00, 0x02, 0x03, 0x04, 0x05, 0x07, 0x09,
	0x0d, 0x0e, 0x11, 0x14, 0x1a, 0x1d, 0x20, 0x26,
	0x2d, 0x31, 0x35, 0x3a,
} // Size: 44 bytes

var ordinalLangToIndex = []uint8{ // 752 elements
	// Entry 0 - 3F
	0x00, 0x0d, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x11, 0x11, 0x00, 0x00, 0x00, 0x00,
	0x0f, 0x00, 0x00, 0x0f, 0x0f, 0x00, 0x00, 0x05,
	0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 40 - 7F
	0x00, 0x00, 0x11, 0x11, 0x11, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x0d, 0x0d, 0x0d, 0x0d, 0x0d, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x12, 0x12, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 80 - BF
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x0b, 0x0b,
	0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
	0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
	0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
	0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
	0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
	0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
	0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
	// Entry C0 - FF
	0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
	0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
	0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
	0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
	0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b,
	0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x0b, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 100 - 13F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00,
	0x00, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	// Entry 140 - 17F
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x03, 0x03, 0x02, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 180 - 1BF
	0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x09, 0x09, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x07, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 1C0 - 1FF
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x02, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x00, 0x00,
	0x00, 0x00, 0x0c, 0x0c, 0x02, 0x02, 0x02, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 200 - 23F
	0x00, 0x00, 0x00, 0x04, 0x04, 0x04, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	// Entry 240 - 27F
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x02,
	0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a,
	// Entry 280 - 2BF
	0x0a, 0x0a, 0x0a, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x06, 0x06, 0x00, 0x00, 0x00, 0x00,
	// Entry 2C0 - 2FF
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x02, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
} // Size: 776 bytes

var ordinalInclusionMasks = []uint64{ // 100 elements
	// Entry 0 - 1F
	0x0000000400004009, 0x00000002120800d3, 0x0000000010a10195, 0x0000000842810581,
	0x0000000841030081, 0x0000001210010041, 0x0000001100011001, 0x0000000614010001,
	0x0000000614018001, 0x0000000600012001, 0x0000000200014001, 0x0000000010198031,
	0x0000000010610331, 0x0000000040010f01, 0x0000000040070001, 0x0000000010010001,
	0x0000000000011001, 0x000000001c010001, 0x000000001c010001, 0x0000000000012001,
	0x0000000020014001, 0x0000000010080011, 0x0000000010200111, 0x0000000040000501,
	0x0000000040020001, 0x0000000010000001, 0x0000000000001001, 0x0000000014000001,
	0x0000000014000001, 0x0000000000002001, 0x0000000000004001, 0x0000000010080011,
	// Entry 20 - 3F
	0x0000000010200111, 0x0000000040000501, 0x0000000040020001, 0x0000000010000001,
	0x0000000000001001, 0x0000000014000001, 0x0000000014000001, 0x0000000000002001,
	0x0000000080014001, 0x0000000010080011, 0x0000000010200111, 0x0000000040000501,
	0x0000000040020001, 0x0000000010000001, 0x0000000000001001, 0x0000000014000001,
	0x0000000014000001, 0x0000000000002001, 0x0000000020004001, 0x0000000010080011,
	0x0000000010200111, 0x0000000040000501, 0x0000000040020001, 0x0000000010000001,
	0x0000000000001001, 0x0000000014000001, 0x0000000014000001, 0x0000000000002001,
	0x0000000080014001, 0x0000000010080011, 0x0000000010200111, 0x0000000040000501,
	// Entry 40 - 5F
	0x0000000040020001, 0x0000000010000001, 0x0000000000001001, 0x0000000014000001,
	0x0000000014000001, 0x0000000000002001, 0x0000000020004001, 0x0000000010080011,
	0x0000000010200111, 0x0000000040000501, 0x0000000040020001, 0x0000000010000001,
	0x0000000000001001, 0x0000000014000001, 0x0000000014000001, 0x0000000000002001,
	0x000000002001c001, 0x0000000010080011, 0x0000000010200111, 0x0000000040000501,
	0x0000000040020001, 0x0000000010000001, 0x0000000000001001, 0x0000000014000001,
	0x0000000014000001, 0x0000000000002001, 0x0000000080004001, 0x0000000010080011,
	0x0000000010200111, 0x0000000040000501, 0x0000000040020001, 0x0000000010000001,
	// Entry 60 - 7F
	0x0000000000001001, 0x0000000014000001, 0x0000000014000001, 0x0000000000002001,
} // Size: 824 bytes

// Slots used for ordinal: 3A of 0xFF rules; 14 of 0xFF indexes; 37 of 64 sets

var cardinalRules = []pluralCheck{ // 169 elements
	0:   {cat: 0x2, setID: 0x3},
	1:   {cat: 0x22, setID: 0x1},
	2:   {cat: 0x2, setID: 0x4},
	3:   {cat: 0x7, setID: 0x1},
	4:   {cat: 0x62, setID: 0x3},
	5:   {cat: 0x22, setID: 0x4},
	6:   {cat: 0x7, setID: 0x3},
	7:   {cat: 0x42, setID: 0x1},
	8:   {cat: 0x22, setID: 0x4},
	9:   {cat: 0x22, setID: 0x4},
	10:  {cat: 0x22, setID: 0x5},
	11:  {cat: 0x27, setID: 0x6},
	12:  {cat: 0x32, setID: 0x2},
	13:  {cat: 0x22, setID: 0x1},
	14:  {cat: 0x27, setID: 0x1},
	15:  {cat: 0x62, setID: 0x3},
	16:  {cat: 0x22, setID: 0x1},
	17:  {cat: 0x7, setID: 0x4},
	18:  {cat: 0x92, setID: 0x3},
	19:  {cat: 0xf, setID: 0x7},
	20:  {cat: 0x1f, setID: 0x8},
	21:  {cat: 0x82, setID: 0x3},
	22:  {cat: 0x92, setID: 0x3},
	23:  {cat: 0xf, setID: 0x7},
	24:  {cat: 0x62, setID: 0x3},
	25:  {cat: 0x4a, setID: 0x7},
	26:  {cat: 0x7, setID: 0x9},
	27:  {cat: 0x62, setID: 0x3},
	28:  {cat: 0x1f, setID: 0xa},
	29:  {cat: 0x62, setID: 0x3},
	30:  {cat: 0x5f, setID: 0xa},
	31:  {cat: 0x72, setID: 0x3},
	32:  {cat: 0x29, setID: 0xb},
	33:  {cat: 0x29, setID: 0xc},
	34:  {cat: 0x4f, setID: 0xc},
	35:  {cat: 0x61, setID: 0x2},
	36:  {cat: 0x2f, setID: 0x7},
	37:  {cat: 0x3a, setID: 0x8},
	38:  {cat: 0x4f, setID: 0x7},
	39:  {cat: 0x5f, setID: 0x8},
	40:  {cat: 0x62, setID: 0x2},
	41:  {cat: 0x4f, setID: 0x7},
	42:  {cat: 0x72, setID: 0x2},
	43:  {cat: 0x21, setID: 0x3},
	44:  {cat: 0x7, setID: 0x4},
	45:  {cat: 0x32, setID: 0x3},
	46:  {cat: 0x21, setID: 0x3},
	47:  {cat: 0x22, setID: 0x1},
	48:  {cat: 0x22, setID: 0x1},
	49:  {cat: 0x23, setID: 0x2},
	50:  {cat: 0x2, setID: 0x3},
	51:  {cat: 0x22, setID: 0x1},
	52:  {cat: 0x24, setID: 0xd},
	53:  {cat: 0x7, setID: 0x1},
	54:  {cat: 0x62, setID: 0x3},
	55:  {cat: 0x74, setID: 0x3},
	56:  {cat: 0x24, setID: 0x3},
	57:  {cat: 0x2f, setID: 0xe},
	58:  {cat: 0x34, setID: 0x1},
	59:  {cat: 0xf, setID: 0x7},
	60:  {cat: 0x1f, setID: 0x8},
	61:  {cat: 0x62, setID: 0x3},
	62:  {cat: 0x4f, setID: 0x7},
	63:  {cat: 0x5a, setID: 0x8},
	64:  {cat: 0xf, setID: 0xf},
	65:  {cat: 0x1f, setID: 0x10},
	66:  {cat: 0x64, setID: 0x3},
	67:  {cat: 0x4f, setID: 0xf},
	68:  {cat: 0x5c, setID: 0x10},
	69:  {cat: 0x22, setID: 0x11},
	70:  {cat: 0x23, setID: 0x12},
	71:  {cat: 0x24, setID: 0x13},
	72:  {cat: 0xf, setID: 0x1},
	73:  {cat: 0x62, setID: 0x3},
	74:  {cat: 0xf, setID: 0x2},
	75:  {cat: 0x63, setID: 0x3},
	76:  {cat: 0xf, setID: 0x14},
	77:  {cat: 0x64, setID: 0x3},
	78:  {cat: 0x74, setID: 0x3},
	79:  {cat: 0xf, setID: 0x1},
	80:  {cat: 0x62, setID: 0x3},
	81:  {cat: 0x4a, setID: 0x1},
	82:  {cat: 0xf, setID: 0x2},
	83:  {cat: 0x63, setID: 0x3},
	84:  {cat: 0x4b, setID: 0x2},
	85:  {cat: 0xf, setID: 0x14},
	86:  {cat: 0x64, setID: 0x3},
	87:  {cat: 0x4c, setID: 0x14},
	88:  {cat: 0x7, setID: 0x1},
	89:  {cat: 0x62, setID: 0x3},
	90:  {cat: 0x7, setID: 0x2},
	91:  {cat: 0x63, setID: 0x3},
	92:  {cat: 0x2f, setID: 0xb},
	93:  {cat: 0x37, setID: 0x15},
	94:  {cat: 0x65, setID: 0x3},
	95:  {cat: 0x7, setID: 0x1},
	96:  {cat: 0x62, setID: 0x3},
	97:  {cat: 0x7, setID: 0x16},
	98:  {cat: 0x64, setID: 0x3},
	99:  {cat: 0x75, setID: 0x3},
	100: {cat: 0x7, setID: 0x1},
	101: {cat: 0x62, setID: 0x3},
	102: {cat: 0xf, setID: 0xf},
	103: {cat: 0x1f, setID: 0x10},
	104: {cat: 0x64, setID: 0x3},
	105: {cat: 0xf, setID: 0x17},
	106: {cat: 0x17, setID: 0x1},
	107: {cat: 0x65, setID: 0x3},
	108: {cat: 0xf, setID: 0x18},
	109: {cat: 0x65, setID: 0x3},
	110: {cat: 0xf, setID: 0x10},
	111: {cat: 0x65, setID: 0x3},
	112: {cat: 0x2f, setID: 0x7},
	113: {cat: 0x3a, setID: 0x8},
	114: {cat: 0x2f, setID: 0xf},
	115: {cat: 0x3c, setID: 0x10},
	116: {cat: 0x2d, setID: 0xb},
	117: {cat: 0x2d, setID: 0x18},
	118: {cat: 0x2d, setID: 0x19},
	119: {cat: 0x2f, setID: 0x7},
	120: {cat: 0x3a, setID: 0xc},
	121: {cat: 0x2f, setID: 0x1a},
	122: {cat: 0x3c, setID: 0xc},
	123: {cat: 0x55, setID: 0x3},
	124: {cat: 0x22, setID: 0x1},
	125: {cat: 0x24, setID: 0x3},
	126: {cat: 0x2c, setID: 0xd},
	127: {cat: 0x2d, setID: 0xc},
	128: {cat: 0xf, setID: 0x7},
	129: {cat: 0x1f, setID: 0x8},
	130: {cat: 0x62, setID: 0x3},
	131: {cat: 0xf, setID: 0xf},
	132: {cat: 0x1f, setID: 0x10},
	133: {cat: 0x64, setID: 0x3},
	134: {cat: 0xf, setID: 0xb},
	135: {cat: 0x65, setID: 0x3},
	136: {cat: 0xf, setID: 0x18},
	137: {cat: 0x65, setID: 0x3},
	138: {cat: 0xf, setID: 0x19},
	139: {cat: 0x65, setID: 0x3},
	140: {cat: 0x2f, setID: 0x7},
	141: {cat: 0x3a, setID: 0x1b},
	142: {cat: 0x2f, setID: 0x1c},
	143: {cat: 0x3b, setID: 0x1d},
	144: {cat: 0x2f, setID: 0x1e},
	145: {cat: 0x3c, setID: 0x1f},
	146: {cat: 0x37, setID: 0x3},
	147: {cat: 0xa5, setID: 0x0},
	148: {cat: 0x22, setID: 0x1},
	149: {cat: 0x23, setID: 0x2},
	150: {cat: 0x24, setID: 0x20},
	151: {cat: 0x25, setID: 0x21},
	152: {cat: 0xf, setID: 0x7},
	153: {cat: 0x62, setID: 0x3},
	154: {cat: 0xf, setID: 0x1c},
	155: {cat: 0x63, setID: 0x3},
	156: {cat: 0xf, setID: 0x22},
	157: {cat: 0x64, setID: 0x3},
	158: {cat: 0x75, setID: 0x3},
	159: {cat: 0x21, setID: 0x3},
	160: {cat: 0x22, setID: 0x1},
	161: {cat: 0x23, setID: 0x2},
	162: {cat: 0x2c, setID: 0x23},
	163: {cat: 0x2d, setID: 0x5},
	164: {cat: 0x21, setID: 0x3},
	165: {cat: 0x22, setID: 0x1},
	166: {cat: 0x23, setID: 0x2},
	167: {cat: 0x24, setID: 0x24},
	168: {cat: 0x25, setID: 0x25},
} // Size: 362 bytes

var cardinalIndex = []uint8{ // 37 elements
	0x00, 0x00, 0x02, 0x03, 0x05, 0x08, 0x09, 0x0b,
	0x0d, 0x0e, 0x10, 0x13, 0x17, 0x1a, 0x20, 0x2b,
	0x2e, 0x30, 0x32, 0x35, 0x3b, 0x45, 0x48, 0x4f,
	0x58, 0x5f, 0x64, 0x70, 0x77, 0x7c, 0x80, 0x8c,
	0x94, 0x98, 0x9f, 0xa4, 0xa9,
} // Size: 61 bytes

var cardinalLangToIndex = []uint8{ // 752 elements
	// Entry 0 - 3F
	0x00, 0x03, 0x03, 0x08, 0x08, 0x08, 0x00, 0x00,
	0x05, 0x05, 0x01, 0x01, 0x22, 0x22, 0x22, 0x22,
	0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
	0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
	0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
	0x22, 0x22, 0x01, 0x01, 0x08, 0x08, 0x03, 0x03,
	0x08, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x1b,
	0x1b, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x05,
	// Entry 40 - 7F
	0x00, 0x00, 0x01, 0x01, 0x01, 0x00, 0x00, 0x00,
	0x1f, 0x1f, 0x08, 0x08, 0x14, 0x00, 0x00, 0x14,
	0x14, 0x03, 0x03, 0x03, 0x03, 0x03, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x19,
	0x19, 0x00, 0x00, 0x23, 0x23, 0x0a, 0x0a, 0x0a,
	0x00, 0x00, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x00, 0x00, 0x17, 0x17, 0x00, 0x00,
	0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08,
	// Entry 80 - BF
	0x08, 0x08, 0x08, 0x08, 0x08, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	// Entry C0 - FF
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
	// Entry 100 - 13F
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x03, 0x03, 0x08, 0x08,
	0x00, 0x00, 0x01, 0x01, 0x01, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x03, 0x03, 0x0d, 0x0d, 0x08, 0x08,
	0x08, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	// Entry 140 - 17F
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x08, 0x08, 0x03, 0x03, 0x20, 0x20, 0x15, 0x15,
	0x03, 0x03, 0x08, 0x08, 0x08, 0x08, 0x01, 0x01,
	0x05, 0x00, 0x00, 0x21, 0x21, 0x08, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x18, 0x18, 0x01, 0x01, 0x14,
	0x14, 0x14, 0x17, 0x17, 0x08, 0x08, 0x02, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x0b,
	// Entry 180 - 1BF
	0x03, 0x03, 0x03, 0x03, 0x11, 0x00, 0x00, 0x00,
	0x08, 0x08, 0x08, 0x08, 0x00, 0x08, 0x08, 0x02,
	0x02, 0x08, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x08,
	0x08, 0x08, 0x00, 0x00, 0x10, 0x10, 0x08, 0x11,
	0x11, 0x08, 0x08, 0x0f, 0x0f, 0x08, 0x08, 0x08,
	// Entry 1C0 - 1FF
	0x08, 0x00, 0x00, 0x05, 0x05, 0x05, 0x05, 0x05,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x1c, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x0e, 0x0e, 0x08,
	0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x05, 0x05,
	0x00, 0x00, 0x08, 0x08, 0x0c, 0x0c, 0x08, 0x08,
	0x08, 0x08, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00,
	0x1d, 0x1d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x11, 0x11, 0x08, 0x08, 0x08, 0x08, 0x08,
	// Entry 200 - 23F
	0x00, 0x00, 0x00, 0x08, 0x08, 0x08, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x00, 0x00,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x08, 0x05,
	0x00, 0x00, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x05, 0x00, 0x00,
	0x05, 0x05, 0x08, 0x1a, 0x1a, 0x0e, 0x0e, 0x08,
	0x08, 0x07, 0x09, 0x07, 0x09, 0x09, 0x09, 0x09,
	0x09, 0x09, 0x09, 0x09, 0x09, 0x09, 0x00, 0x00,
	// Entry 240 - 27F
	0x00, 0x00, 0x08, 0x08, 0x00, 0x00, 0x13, 0x13,
	0x13, 0x08, 0x08, 0x1e, 0x1e, 0x1e, 0x1e, 0x1e,
	0x1e, 0x1e, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00,
	0x08, 0x08, 0x00, 0x00, 0x08, 0x11, 0x11, 0x11,
	0x11, 0x08, 0x08, 0x00, 0x00, 0x00, 0x00, 0x12,
	0x00, 0x00, 0x12, 0x12, 0x04, 0x04, 0x19, 0x19,
	0x16, 0x16, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
	// Entry 280 - 2BF
	0x08, 0x08, 0x08, 0x14, 0x14, 0x14, 0x14, 0x14,
	0x14, 0x14, 0x14, 0x14, 0x14, 0x14, 0x08, 0x08,
	0x08, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x08, 0x08, 0x08, 0x08, 0x08, 0x08,
	0x08, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x05,
	0x05, 0x05, 0x08, 0x08, 0x08, 0x08, 0x00, 0x00,
	0x08, 0x08, 0x08, 0x08, 0x00, 0x00, 0x06, 0x06,
	0x08, 0x08, 0x1e, 0x1e, 0x03, 0x03, 0x03, 0x08,
	// Entry 2C0 - 2FF
	0x00, 0x00, 0x00, 0x00, 0x08, 0x08, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x08, 0x08,
	0x08, 0x08, 0x05, 0x08, 0x08, 0x00, 0x08, 0x08,
	0x08, 0x00, 0x00, 0x03, 0x03, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x01,
} // Size: 776 bytes

var cardinalInclusionMasks = []uint64{ // 100 elements
	// Entry 0 - 1F
	0x0000000400a00859, 0x0000000000a242d3, 0x000000001464e245, 0x000000194478e201,
	0x000000094478e401, 0x0000000905286001, 0x0000002905286401, 0x0000000a05286001,
	0x0000000a05286001, 0x0000000a45286401, 0x0000000a80a86801, 0x000000008a8251a1,
	0x00000000b605d021, 0x00000000c609d021, 0x00000000c609d421, 0x0000000085085021,
	0x0000000085085421, 0x0000000085085021, 0x0000000085085021, 0x00000000c5085421,
	0x0000000400800821, 0x00000000008000a1, 0x0000000014008021, 0x0000000044008021,
	0x0000000044008421, 0x0000000005000021, 0x0000000005000421, 0x0000000005000021,
	0x0000000005000021, 0x0000000045000421, 0x0000000000800821, 0x00000000008000a1,
	// Entry 20 - 3F
	0x0000000014008021, 0x0000000044008021, 0x0000000044008421, 0x0000000005000021,
	0x0000000005000421, 0x0000000005000021, 0x0000000005000021, 0x0000000045000421,
	0x0000000400800821, 0x00000000008000a1, 0x0000000014008021, 0x0000000044008021,
	0x0000000044008421, 0x0000000005000021, 0x0000000005000421, 0x0000000005000021,
	0x0000000005000021, 0x0000000045000421, 0x0000000000800821, 0x00000000008000a1,
	0x0000000014008021, 0x0000000044008021, 0x0000000044008421, 0x0000000005000021,
	0x0000000005000421, 0x0000000005000021, 0x0000000005000021, 0x0000000045000421,
	0x0000000400800821, 0x00000000008000a1, 0x0000000014008021, 0x0000000044008021,
	// Entry 40 - 5F
	0x0000000044008421, 0x0000000005000021, 0x0000000005000421, 0x0000000005000021,
	0x0000000005000021, 0x0000000045000421, 0x0000000080800821, 0x00000000888000a1,
	0x00000000b4008021, 0x00000000c4008021, 0x00000000c4008421, 0x0000000085000021,
	0x0000000085000421, 0x0000000085000021, 0x0000000085000021, 0x00000000c5000421,
	0x0000000400800821, 0x00000000008000a1, 0x0000000014008021, 0x0000000044008021,
	0x0000000044008421, 0x0000000005000021, 0x0000000005000421, 0x0000000005000021,
	0x0000000005000021, 0x0000000045000421, 0x0000000080800821, 0x00000000888000a1,
	0x00000000b4008021, 0x00000000c4008021, 0x00000000c4008421, 0x0000000085000021,
	// Entry 60 - 7F
	0x0000000085000421, 0x0000000085000021, 0x0000000085000021, 0x00000000c5000421,
} // Size: 824 bytes

// Slots used for cardinal: A9 of 0xFF rules; 25 of 0xFF indexes; 38 of 64 sets

var tagToDecimal = []uint8{ // 752 elements
	// Entry 0 - 3F
	0x01, 0x01, 0x08, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	// Entry 40 - 7F
	0x01, 0x01, 0x05, 0x05, 0x05, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x05, 0x05, 0x01, 0x01, 0x01,
	// Entry 80 - BF
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	// Entry C0 - FF
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	// Entry 100 - 13F
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	// Entry 140 - 17F
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	// Entry 180 - 1BF
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x05, 0x05, 0x05, 0x05,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	// Entry 1C0 - 1FF
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x05, 0x05,
	0x01, 0x01, 0x05, 0x05, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	// Entry 200 - 23F
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x05, 0x05, 0x01, 0x01, 0x01, 0x05, 0x01, 0x01,
	0x05, 0x05, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	// Entry 240 - 27F
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	// Entry 280 - 2BF
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x05, 0x05, 0x05, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	// Entry 2C0 - 2FF
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
} // Size: 776 bytes

var tagToScientific = []uint8{ // 752 elements
	// Entry 0 - 3F
	0x02, 0x02, 0x09, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	// Entry 40 - 7F
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	// Entry 80 - BF
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	// Entry C0 - FF
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	// Entry 100 - 13F
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	// Entry 140 - 17F
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x0d, 0x0d,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x0d, 0x0d, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	// Entry 180 - 1BF
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	// Entry 1C0 - 1FF
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x0e, 0x0e, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x0d, 0x0d, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	// Entry 200 - 23F
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x0d, 0x02, 0x02,
	0x0d, 0x0d, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	// Entry 240 - 27F
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x0e, 0x0e, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	// Entry 280 - 2BF
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	// Entry 2C0 - 2FF
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02,
} // Size: 776 bytes

var tagToPercent = []uint8{ // 752 elements
	// Entry 0 - 3F
	0x04, 0x04, 0x0a, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x06, 0x06, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x03,
	0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	// Entry 40 - 7F
	0x04, 0x04, 0x06, 0x06, 0x06, 0x04, 0x04, 0x04,
	0x03, 0x03, 0x06, 0x06, 0x03, 0x04, 0x04, 0x03,
	0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03,
	0x03, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x03,
	0x04, 0x04, 0x03, 0x03, 0x03, 0x04, 0x03, 0x03,
	0x04, 0x03, 0x04, 0x04, 0x03, 0x03, 0x03, 0x03,
	0x04, 0x04, 0x04, 0x07, 0x07, 0x04, 0x04, 0x04,
	// Entry 80 - BF
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x03, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x03, 0x04, 0x03, 0x04, 0x04,
	0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	// Entry C0 - FF
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x04, 0x03,
	0x03, 0x04, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	// Entry 100 - 13F
	0x03, 0x04, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x04, 0x04, 0x0b, 0x0b,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x03, 0x03, 0x04, 0x04, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x04, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	// Entry 140 - 17F
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x06, 0x06,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x04,
	0x04, 0x04, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	// Entry 180 - 1BF
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x06,
	0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x04,
	// Entry 1C0 - 1FF
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x03, 0x03, 0x03, 0x04, 0x04,
	// Entry 200 - 23F
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x06, 0x06, 0x04, 0x04, 0x04, 0x06, 0x04, 0x04,
	0x06, 0x06, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03,
	// Entry 240 - 27F
	0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x04, 0x04, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x03, 0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03, 0x03,
	0x03, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x03, 0x03,
	0x03, 0x03, 0x04, 0x04, 0x04, 0x03, 0x03, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	// Entry 280 - 2BF
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x03, 0x03, 0x03, 0x03, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x03, 0x03, 0x04, 0x04, 0x04,
	0x0f, 0x0f, 0x0f, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x06, 0x06, 0x06, 0x04,
	// Entry 2C0 - 2FF
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x03, 0x03, 0x04, 0x04, 0x04, 0x04,
	0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,
} // Size: 776 bytes

var formats = []Format{Format{Affix: "",
	Offset:         0x0,
	NegOffset:      0x0,
	Multiplier:     0x0,
	RoundIncrement: 0x0,
	PadRune:        0,
	FormatWidth:    0x0,
	GroupingSize: [2]uint8{0x0,
		0x0},
	Flags:                0x0,
	MinIntegerDigits:     0x0,
	MaxIntegerDigits:     0x0,
	MinFractionDigits:    0x0,
	MaxFractionDigits:    0x0,
	MinSignificantDigits: 0x0,
	MaxSignificantDigits: 0x0,
	MinExponentDigits:    0x0},
	Format{Affix: "",
		Offset:         0x0,
		NegOffset:      0x0,
		Multiplier:     0x0,
		RoundIncrement: 0x0,
		PadRune:        0,
		FormatWidth:    0x9,
		GroupingSize: [2]uint8{0x3,
			0x0},
		Flags:                0x0,
		MinIntegerDigits:     0x1,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x3,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x0},
	Format{Affix: "",
		Offset:         0x0,
		NegOffset:      0x0,
		Multiplier:     0x0,
		RoundIncrement: 0x0,
		PadRune:        0,
		FormatWidth:    0x3,
		GroupingSize: [2]uint8{0x0,
			0x0},
		Flags:                0x0,
		MinIntegerDigits:     0x0,
		MaxIntegerDigits:     0x1,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x0,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x1},
	Format{Affix: "\x00\x03\u00a0%",
		Offset:         0x0,
		NegOffset:      0x0,
		Multiplier:     0x64,
		RoundIncrement: 0x0,
		PadRune:        0,
		FormatWidth:    0x7,
		GroupingSize: [2]uint8{0x3,
			0x0},
		Flags:                0x0,
		MinIntegerDigits:     0x1,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x0,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x0},
	Format{Affix: "\x00\x01%",
		Offset:         0x0,
		NegOffset:      0x0,
		Multiplier:     0x64,
		RoundIncrement: 0x0,
		PadRune:        0,
		FormatWidth:    0x6,
		GroupingSize: [2]uint8{0x3,
			0x0},
		Flags:                0x0,
		MinIntegerDigits:     0x1,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x0,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x0},
	Format{Affix: "",
		Offset:         0x0,
		NegOffset:      0x0,
		Multiplier:     0x0,
		RoundIncrement: 0x0,
		PadRune:        0,
		FormatWidth:    0xc,
		GroupingSize: [2]uint8{0x3,
			0x2},
		Flags:                0x0,
		MinIntegerDigits:     0x1,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x3,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x0},
	Format{Affix: "\x00\x01%",
		Offset:         0x0,
		NegOffset:      0x0,
		Multiplier:     0x64,
		RoundIncrement: 0x0,
		PadRune:        0,
		FormatWidth:    0x9,
		GroupingSize: [2]uint8{0x3,
			0x2},
		Flags:                0x0,
		MinIntegerDigits:     0x1,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x0,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x0},
	Format{Affix: "\x00\x03\u00a0%",
		Offset:         0x0,
		NegOffset:      0x0,
		Multiplier:     0x64,
		RoundIncrement: 0x0,
		PadRune:        0,
		FormatWidth:    0xa,
		GroupingSize: [2]uint8{0x3,
			0x2},
		Flags:                0x0,
		MinIntegerDigits:     0x1,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x0,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x0},
	Format{Affix: "",
		Offset:         0x0,
		NegOffset:      0x0,
		Multiplier:     0x0,
		RoundIncrement: 0x0,
		PadRune:        0,
		FormatWidth:    0x9,
		GroupingSize: [2]uint8{0x0,
			0x0},
		Flags:                0x0,
		MinIntegerDigits:     0x1,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x6,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x0},
	Format{Affix: "",
		Offset:         0x0,
		NegOffset:      0x0,
		Multiplier:     0x0,
		RoundIncrement: 0x0,
		PadRune:        0,
		FormatWidth:    0xd,
		GroupingSize: [2]uint8{0x0,
			0x0},
		Flags:                0x2,
		MinIntegerDigits:     0x1,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x6,
		MaxFractionDigits:    0x6,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x3},
	Format{Affix: "\x00\x01%",
		Offset:         0x0,
		NegOffset:      0x0,
		Multiplier:     0x64,
		RoundIncrement: 0x0,
		PadRune:        0,
		FormatWidth:    0x3,
		GroupingSize: [2]uint8{0x0,
			0x0},
		Flags:                0x0,
		MinIntegerDigits:     0x1,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x0,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x0},
	Format{Affix: "\x03%\u00a0\x00",
		Offset:         0x0,
		NegOffset:      0x0,
		Multiplier:     0x64,
		RoundIncrement: 0x0,
		PadRune:        0,
		FormatWidth:    0x7,
		GroupingSize: [2]uint8{0x0,
			0x0},
		Flags:                0x0,
		MinIntegerDigits:     0x1,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x0,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x0},
	Format{Affix: "\x03%\u00a0\x00\x04%\u00a0-\x00",
		Offset:         0x0,
		NegOffset:      0x5,
		Multiplier:     0x64,
		RoundIncrement: 0x0,
		PadRune:        0,
		FormatWidth:    0x7,
		GroupingSize: [2]uint8{0x3,
			0x0},
		Flags:                0x0,
		MinIntegerDigits:     0x1,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x0,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x0},
	Format{Affix: "\x01[\x01]",
		Offset:         0x0,
		NegOffset:      0x0,
		Multiplier:     0x0,
		RoundIncrement: 0x0,
		PadRune:        0,
		FormatWidth:    0x5,
		GroupingSize: [2]uint8{0x0,
			0x0},
		Flags:                0x0,
		MinIntegerDigits:     0x0,
		MaxIntegerDigits:     0x1,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x0,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x1},
	Format{Affix: "",
		Offset:         0x0,
		NegOffset:      0x0,
		Multiplier:     0x0,
		RoundIncrement: 0x0,
		PadRune:        0,
		FormatWidth:    0x1,
		GroupingSize: [2]uint8{0x0,
			0x0},
		Flags:                0x0,
		MinIntegerDigits:     0x0,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x0,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x0},
	Format{Affix: "\x01%\x00",
		Offset:         0x0,
		NegOffset:      0x0,
		Multiplier:     0x64,
		RoundIncrement: 0x0,
		PadRune:        0,
		FormatWidth:    0x6,
		GroupingSize: [2]uint8{0x0,
			0x0},
		Flags:                0x0,
		MinIntegerDigits:     0x1,
		MaxIntegerDigits:     0x0,
		MinFractionDigits:    0x0,
		MaxFractionDigits:    0x0,
		MinSignificantDigits: 0x0,
		MaxSignificantDigits: 0x0,
		MinExponentDigits:    0x0}}

// Total table size 10908 bytes (10KiB); checksum: B1AF61E6
