/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
#ifndef INCLUDED_SVTOOLS_FILEVIEW_HXX
#define INCLUDED_SVTOOLS_FILEVIEW_HXX

#include <memory>
#include <vcl/weld.hxx>
#include <rtl/ustring.hxx>
#include <svtools/svtdllapi.h>

namespace svtools
{
// QueryDeleteDlg_Impl

enum QueryDeleteResult_Impl
{
    QUERYDELETE_YES = RET_YES,
    QUERYDELETE_ALL = 101
};

class SVT_DLLPUBLIC QueryDeleteDlg_Impl final : public weld::MessageDialogController
{
private:
    std::unique_ptr<weld::Button> m_xAllButton;

public:
    QueryDeleteDlg_Impl(weld::Widget* pParent, const OUString& rName);
    virtual ~QueryDeleteDlg_Impl() override;

    void EnableAllButton() { m_xAllButton->set_sensitive(true); }
};
}

#endif // INCLUDED_SVTOOLS_FILEVIEW_HXX

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
