// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v3/services/ad_parameter_service.proto

package services

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	resources "google.golang.org/genproto/googleapis/ads/googleads/v3/resources"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [AdParameterService.GetAdParameter][google.ads.googleads.v3.services.AdParameterService.GetAdParameter]
type GetAdParameterRequest struct {
	// Required. The resource name of the ad parameter to fetch.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAdParameterRequest) Reset()         { *m = GetAdParameterRequest{} }
func (m *GetAdParameterRequest) String() string { return proto.CompactTextString(m) }
func (*GetAdParameterRequest) ProtoMessage()    {}
func (*GetAdParameterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_eee1e6c793ab006d, []int{0}
}

func (m *GetAdParameterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAdParameterRequest.Unmarshal(m, b)
}
func (m *GetAdParameterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAdParameterRequest.Marshal(b, m, deterministic)
}
func (m *GetAdParameterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAdParameterRequest.Merge(m, src)
}
func (m *GetAdParameterRequest) XXX_Size() int {
	return xxx_messageInfo_GetAdParameterRequest.Size(m)
}
func (m *GetAdParameterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAdParameterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAdParameterRequest proto.InternalMessageInfo

func (m *GetAdParameterRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [AdParameterService.MutateAdParameters][google.ads.googleads.v3.services.AdParameterService.MutateAdParameters]
type MutateAdParametersRequest struct {
	// Required. The ID of the customer whose ad parameters are being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// Required. The list of operations to perform on individual ad parameters.
	Operations []*AdParameterOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// If true, successful operations will be carried out and invalid
	// operations will return errors. If false, all operations will be carried
	// out in one transaction if and only if they are all valid.
	// Default is false.
	PartialFailure bool `protobuf:"varint,3,opt,name=partial_failure,json=partialFailure,proto3" json:"partial_failure,omitempty"`
	// If true, the request is validated but not executed. Only errors are
	// returned, not results.
	ValidateOnly         bool     `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateAdParametersRequest) Reset()         { *m = MutateAdParametersRequest{} }
func (m *MutateAdParametersRequest) String() string { return proto.CompactTextString(m) }
func (*MutateAdParametersRequest) ProtoMessage()    {}
func (*MutateAdParametersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_eee1e6c793ab006d, []int{1}
}

func (m *MutateAdParametersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdParametersRequest.Unmarshal(m, b)
}
func (m *MutateAdParametersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdParametersRequest.Marshal(b, m, deterministic)
}
func (m *MutateAdParametersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdParametersRequest.Merge(m, src)
}
func (m *MutateAdParametersRequest) XXX_Size() int {
	return xxx_messageInfo_MutateAdParametersRequest.Size(m)
}
func (m *MutateAdParametersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdParametersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdParametersRequest proto.InternalMessageInfo

func (m *MutateAdParametersRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateAdParametersRequest) GetOperations() []*AdParameterOperation {
	if m != nil {
		return m.Operations
	}
	return nil
}

func (m *MutateAdParametersRequest) GetPartialFailure() bool {
	if m != nil {
		return m.PartialFailure
	}
	return false
}

func (m *MutateAdParametersRequest) GetValidateOnly() bool {
	if m != nil {
		return m.ValidateOnly
	}
	return false
}

// A single operation (create, update, remove) on ad parameter.
type AdParameterOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The mutate operation.
	//
	// Types that are valid to be assigned to Operation:
	//	*AdParameterOperation_Create
	//	*AdParameterOperation_Update
	//	*AdParameterOperation_Remove
	Operation            isAdParameterOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *AdParameterOperation) Reset()         { *m = AdParameterOperation{} }
func (m *AdParameterOperation) String() string { return proto.CompactTextString(m) }
func (*AdParameterOperation) ProtoMessage()    {}
func (*AdParameterOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_eee1e6c793ab006d, []int{2}
}

func (m *AdParameterOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdParameterOperation.Unmarshal(m, b)
}
func (m *AdParameterOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdParameterOperation.Marshal(b, m, deterministic)
}
func (m *AdParameterOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdParameterOperation.Merge(m, src)
}
func (m *AdParameterOperation) XXX_Size() int {
	return xxx_messageInfo_AdParameterOperation.Size(m)
}
func (m *AdParameterOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_AdParameterOperation.DiscardUnknown(m)
}

var xxx_messageInfo_AdParameterOperation proto.InternalMessageInfo

func (m *AdParameterOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isAdParameterOperation_Operation interface {
	isAdParameterOperation_Operation()
}

type AdParameterOperation_Create struct {
	Create *resources.AdParameter `protobuf:"bytes,1,opt,name=create,proto3,oneof"`
}

type AdParameterOperation_Update struct {
	Update *resources.AdParameter `protobuf:"bytes,2,opt,name=update,proto3,oneof"`
}

type AdParameterOperation_Remove struct {
	Remove string `protobuf:"bytes,3,opt,name=remove,proto3,oneof"`
}

func (*AdParameterOperation_Create) isAdParameterOperation_Operation() {}

func (*AdParameterOperation_Update) isAdParameterOperation_Operation() {}

func (*AdParameterOperation_Remove) isAdParameterOperation_Operation() {}

func (m *AdParameterOperation) GetOperation() isAdParameterOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *AdParameterOperation) GetCreate() *resources.AdParameter {
	if x, ok := m.GetOperation().(*AdParameterOperation_Create); ok {
		return x.Create
	}
	return nil
}

func (m *AdParameterOperation) GetUpdate() *resources.AdParameter {
	if x, ok := m.GetOperation().(*AdParameterOperation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *AdParameterOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*AdParameterOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AdParameterOperation) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AdParameterOperation_Create)(nil),
		(*AdParameterOperation_Update)(nil),
		(*AdParameterOperation_Remove)(nil),
	}
}

// Response message for an ad parameter mutate.
type MutateAdParametersResponse struct {
	// Errors that pertain to operation failures in the partial failure mode.
	// Returned only when partial_failure = true and all errors occur inside the
	// operations. If any errors occur outside the operations (e.g. auth errors),
	// we return an RPC level error.
	PartialFailureError *status.Status `protobuf:"bytes,3,opt,name=partial_failure_error,json=partialFailureError,proto3" json:"partial_failure_error,omitempty"`
	// All results for the mutate.
	Results              []*MutateAdParameterResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *MutateAdParametersResponse) Reset()         { *m = MutateAdParametersResponse{} }
func (m *MutateAdParametersResponse) String() string { return proto.CompactTextString(m) }
func (*MutateAdParametersResponse) ProtoMessage()    {}
func (*MutateAdParametersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_eee1e6c793ab006d, []int{3}
}

func (m *MutateAdParametersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdParametersResponse.Unmarshal(m, b)
}
func (m *MutateAdParametersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdParametersResponse.Marshal(b, m, deterministic)
}
func (m *MutateAdParametersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdParametersResponse.Merge(m, src)
}
func (m *MutateAdParametersResponse) XXX_Size() int {
	return xxx_messageInfo_MutateAdParametersResponse.Size(m)
}
func (m *MutateAdParametersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdParametersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdParametersResponse proto.InternalMessageInfo

func (m *MutateAdParametersResponse) GetPartialFailureError() *status.Status {
	if m != nil {
		return m.PartialFailureError
	}
	return nil
}

func (m *MutateAdParametersResponse) GetResults() []*MutateAdParameterResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The result for the ad parameter mutate.
type MutateAdParameterResult struct {
	// The resource name returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateAdParameterResult) Reset()         { *m = MutateAdParameterResult{} }
func (m *MutateAdParameterResult) String() string { return proto.CompactTextString(m) }
func (*MutateAdParameterResult) ProtoMessage()    {}
func (*MutateAdParameterResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_eee1e6c793ab006d, []int{4}
}

func (m *MutateAdParameterResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateAdParameterResult.Unmarshal(m, b)
}
func (m *MutateAdParameterResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateAdParameterResult.Marshal(b, m, deterministic)
}
func (m *MutateAdParameterResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateAdParameterResult.Merge(m, src)
}
func (m *MutateAdParameterResult) XXX_Size() int {
	return xxx_messageInfo_MutateAdParameterResult.Size(m)
}
func (m *MutateAdParameterResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateAdParameterResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateAdParameterResult proto.InternalMessageInfo

func (m *MutateAdParameterResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*GetAdParameterRequest)(nil), "google.ads.googleads.v3.services.GetAdParameterRequest")
	proto.RegisterType((*MutateAdParametersRequest)(nil), "google.ads.googleads.v3.services.MutateAdParametersRequest")
	proto.RegisterType((*AdParameterOperation)(nil), "google.ads.googleads.v3.services.AdParameterOperation")
	proto.RegisterType((*MutateAdParametersResponse)(nil), "google.ads.googleads.v3.services.MutateAdParametersResponse")
	proto.RegisterType((*MutateAdParameterResult)(nil), "google.ads.googleads.v3.services.MutateAdParameterResult")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v3/services/ad_parameter_service.proto", fileDescriptor_eee1e6c793ab006d)
}

var fileDescriptor_eee1e6c793ab006d = []byte{
	// 786 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x55, 0xc1, 0x6e, 0xdb, 0x46,
	0x10, 0x2d, 0xa9, 0xc2, 0xad, 0x57, 0xb6, 0x0b, 0x6c, 0xeb, 0x5a, 0x56, 0x0b, 0x54, 0x60, 0x85,
	0xd6, 0x10, 0x0c, 0xb2, 0x95, 0x0a, 0x17, 0xa5, 0xea, 0x00, 0x14, 0x10, 0xd9, 0x39, 0x38, 0x76,
	0x68, 0xc4, 0x87, 0x44, 0x00, 0xb1, 0x26, 0xd7, 0x0a, 0x63, 0x92, 0xcb, 0xec, 0x2e, 0x05, 0x18,
	0x86, 0x2f, 0xf9, 0x80, 0x5c, 0xf2, 0x07, 0x39, 0xe6, 0x0f, 0x72, 0xcc, 0xd5, 0xd7, 0xdc, 0x7c,
	0x08, 0x7c, 0x08, 0x72, 0x08, 0xf2, 0x05, 0x39, 0x04, 0x01, 0xb9, 0x5c, 0x89, 0xb2, 0x25, 0x08,
	0xf1, 0x6d, 0xb8, 0xf3, 0xde, 0x9b, 0x99, 0x9d, 0x99, 0x25, 0x68, 0xf7, 0x09, 0xe9, 0x07, 0xd8,
	0x40, 0x1e, 0x33, 0x84, 0x99, 0x5a, 0x83, 0x96, 0xc1, 0x30, 0x1d, 0xf8, 0x2e, 0x66, 0x06, 0xf2,
	0x9c, 0x18, 0x51, 0x14, 0x62, 0x8e, 0xa9, 0x93, 0x9f, 0xea, 0x31, 0x25, 0x9c, 0xc0, 0x9a, 0x60,
	0xe8, 0xc8, 0x63, 0xfa, 0x90, 0xac, 0x0f, 0x5a, 0xba, 0x24, 0x57, 0xff, 0x99, 0x26, 0x4f, 0x31,
	0x23, 0x09, 0xbd, 0xaa, 0x2f, 0x74, 0xab, 0xbf, 0x4a, 0x56, 0xec, 0x1b, 0x28, 0x8a, 0x08, 0x47,
	0xdc, 0x27, 0x11, 0xcb, 0xbd, 0x2b, 0x05, 0xaf, 0x1b, 0xf8, 0x38, 0xe2, 0xb9, 0xe3, 0xb7, 0x82,
	0xe3, 0xc8, 0xc7, 0x81, 0xe7, 0x1c, 0xe2, 0x47, 0x68, 0xe0, 0x13, 0xa9, 0xbb, 0x5a, 0x00, 0xc8,
	0x04, 0x72, 0x57, 0x5e, 0x8a, 0x91, 0x7d, 0x1d, 0x26, 0x47, 0xb9, 0x40, 0x88, 0xd8, 0xf1, 0x95,
	0xb0, 0x34, 0x76, 0x0d, 0xc6, 0x11, 0x4f, 0xf2, 0x7c, 0xb4, 0xc7, 0x60, 0x79, 0x0b, 0x73, 0xcb,
	0xdb, 0x93, 0x55, 0xd8, 0xf8, 0x49, 0x82, 0x19, 0x87, 0xf7, 0xc0, 0xa2, 0x8c, 0xe2, 0x44, 0x28,
	0xc4, 0x15, 0xa5, 0xa6, 0xac, 0xcd, 0x77, 0xd6, 0x2f, 0x2d, 0xf5, 0x93, 0xf5, 0x07, 0xa8, 0x8f,
	0xae, 0x2c, 0xb7, 0x62, 0x9f, 0xe9, 0x2e, 0x09, 0x8d, 0xa2, 0xd6, 0x82, 0x94, 0xb8, 0x8b, 0x42,
	0xac, 0x7d, 0x54, 0xc0, 0xea, 0x4e, 0xc2, 0x11, 0xc7, 0x05, 0x0c, 0x93, 0x01, 0xeb, 0xa0, 0xec,
	0x26, 0x8c, 0x93, 0x10, 0x53, 0xc7, 0xf7, 0xf2, 0x70, 0xa5, 0x4b, 0x4b, 0xb5, 0x81, 0x3c, 0xbf,
	0xe3, 0xc1, 0x87, 0x00, 0x90, 0x18, 0x53, 0x71, 0xa7, 0x15, 0xb5, 0x56, 0x5a, 0x2b, 0x37, 0x37,
	0xf4, 0x59, 0xad, 0xd4, 0x0b, 0x01, 0x77, 0x25, 0x3d, 0x17, 0x1f, 0xc9, 0xc1, 0x3f, 0xc1, 0x0f,
	0x31, 0xa2, 0xdc, 0x47, 0x81, 0x73, 0x84, 0xfc, 0x20, 0xa1, 0xb8, 0x52, 0xaa, 0x29, 0x6b, 0xdf,
	0xdb, 0x4b, 0xf9, 0x71, 0x57, 0x9c, 0xc2, 0xdf, 0xc1, 0xe2, 0x00, 0x05, 0xbe, 0x87, 0x38, 0x76,
	0x48, 0x14, 0x9c, 0x54, 0xbe, 0xcd, 0x60, 0x0b, 0xf2, 0x70, 0x37, 0x0a, 0x4e, 0xb4, 0x67, 0x2a,
	0xf8, 0x69, 0x52, 0x5c, 0xd8, 0x06, 0xe5, 0x24, 0xce, 0xb8, 0x69, 0x87, 0x32, 0x6e, 0xb9, 0x59,
	0x95, 0x45, 0xc8, 0x26, 0xea, 0xdd, 0xb4, 0x89, 0x3b, 0x88, 0x1d, 0xdb, 0x40, 0xc0, 0x53, 0x1b,
	0x6e, 0x83, 0x39, 0x97, 0x62, 0xc4, 0x45, 0x43, 0xca, 0x4d, 0x7d, 0x6a, 0xf1, 0xc3, 0x29, 0x2d,
	0x56, 0xbf, 0xfd, 0x8d, 0x9d, 0xf3, 0x53, 0x25, 0xa1, 0x5b, 0x51, 0x6f, 0xaa, 0x24, 0xf8, 0xb0,
	0x02, 0xe6, 0x28, 0x0e, 0xc9, 0x40, 0x5c, 0xd7, 0x7c, 0xea, 0x11, 0xdf, 0x9d, 0x32, 0x98, 0x1f,
	0xde, 0xaf, 0xf6, 0x4a, 0x01, 0xd5, 0x49, 0xfd, 0x67, 0x31, 0x89, 0x18, 0x86, 0x5d, 0xb0, 0x7c,
	0xe5, 0xf6, 0x1d, 0x4c, 0x29, 0xa1, 0x99, 0x68, 0xb9, 0x09, 0x65, 0x7a, 0x34, 0x76, 0xf5, 0xfd,
	0x6c, 0x86, 0xed, 0x1f, 0xc7, 0xfb, 0x72, 0x3b, 0x85, 0xc3, 0x7d, 0xf0, 0x1d, 0xc5, 0x2c, 0x09,
	0xb8, 0x9c, 0x8f, 0xff, 0x66, 0xcf, 0xc7, 0xb5, 0xb4, 0xec, 0x4c, 0xc1, 0x96, 0x4a, 0xda, 0x2d,
	0xb0, 0x32, 0x05, 0x93, 0x0e, 0xc3, 0x84, 0x4d, 0x19, 0x9f, 0xfd, 0xe6, 0xdb, 0x12, 0x80, 0x05,
	0xea, 0xbe, 0x08, 0x0c, 0x5f, 0x2b, 0x60, 0x69, 0x7c, 0xff, 0xe0, 0xbf, 0xb3, 0xb3, 0x9d, 0xb8,
	0xb1, 0xd5, 0xaf, 0xec, 0x9f, 0xd6, 0xbd, 0xb0, 0xc6, 0x13, 0x7f, 0xfa, 0xe6, 0xdd, 0x73, 0xf5,
	0x2f, 0xa8, 0xa7, 0x4f, 0xdc, 0xe9, 0x98, 0x67, 0x53, 0x6e, 0x20, 0x33, 0x1a, 0x06, 0x2a, 0x34,
	0xcf, 0x68, 0x9c, 0xc1, 0xf7, 0x0a, 0x80, 0xd7, 0xdb, 0x0a, 0xdb, 0x37, 0xb8, 0x75, 0xf9, 0x18,
	0x54, 0xff, 0xbf, 0x19, 0x59, 0x4c, 0x92, 0x76, 0xff, 0xc2, 0xfa, 0xb9, 0xf0, 0x96, 0xac, 0x8f,
	0x56, 0x3c, 0x2b, 0x71, 0x43, 0xfb, 0x3b, 0x2d, 0x71, 0x54, 0xd3, 0x69, 0x01, 0xbc, 0xd9, 0x38,
	0x1b, 0xab, 0xd0, 0x0c, 0xb3, 0x38, 0xa6, 0xd2, 0xa8, 0xfe, 0x72, 0x6e, 0x55, 0xa6, 0x3d, 0x7b,
	0x9d, 0xcf, 0x0a, 0xa8, 0xbb, 0x24, 0x9c, 0x99, 0x77, 0x67, 0xe5, 0xfa, 0x18, 0xec, 0xa5, 0x2b,
	0xbf, 0xa7, 0x3c, 0xd8, 0xce, 0xc9, 0x7d, 0x12, 0xa0, 0xa8, 0xaf, 0x13, 0xda, 0x37, 0xfa, 0x38,
	0xca, 0x1e, 0x04, 0x63, 0x14, 0x6e, 0xfa, 0xef, 0xae, 0x2d, 0x8d, 0x17, 0x6a, 0x69, 0xcb, 0xb2,
	0x5e, 0xaa, 0xb5, 0x2d, 0x21, 0x68, 0x79, 0x4c, 0x17, 0x66, 0x6a, 0x1d, 0xb4, 0xf4, 0x3c, 0x30,
	0x3b, 0x97, 0x90, 0x9e, 0xe5, 0xb1, 0xde, 0x10, 0xd2, 0x3b, 0x68, 0xf5, 0x24, 0xe4, 0x83, 0x5a,
	0x17, 0xe7, 0xa6, 0x69, 0x79, 0xcc, 0x34, 0x87, 0x20, 0xd3, 0x3c, 0x68, 0x99, 0xa6, 0x84, 0x1d,
	0xce, 0x65, 0x79, 0xb6, 0xbe, 0x04, 0x00, 0x00, 0xff, 0xff, 0xd5, 0xd5, 0x2b, 0xb9, 0x95, 0x07,
	0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AdParameterServiceClient is the client API for AdParameterService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AdParameterServiceClient interface {
	// Returns the requested ad parameter in full detail.
	GetAdParameter(ctx context.Context, in *GetAdParameterRequest, opts ...grpc.CallOption) (*resources.AdParameter, error)
	// Creates, updates, or removes ad parameters. Operation statuses are
	// returned.
	MutateAdParameters(ctx context.Context, in *MutateAdParametersRequest, opts ...grpc.CallOption) (*MutateAdParametersResponse, error)
}

type adParameterServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAdParameterServiceClient(cc grpc.ClientConnInterface) AdParameterServiceClient {
	return &adParameterServiceClient{cc}
}

func (c *adParameterServiceClient) GetAdParameter(ctx context.Context, in *GetAdParameterRequest, opts ...grpc.CallOption) (*resources.AdParameter, error) {
	out := new(resources.AdParameter)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.AdParameterService/GetAdParameter", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *adParameterServiceClient) MutateAdParameters(ctx context.Context, in *MutateAdParametersRequest, opts ...grpc.CallOption) (*MutateAdParametersResponse, error) {
	out := new(MutateAdParametersResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v3.services.AdParameterService/MutateAdParameters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AdParameterServiceServer is the server API for AdParameterService service.
type AdParameterServiceServer interface {
	// Returns the requested ad parameter in full detail.
	GetAdParameter(context.Context, *GetAdParameterRequest) (*resources.AdParameter, error)
	// Creates, updates, or removes ad parameters. Operation statuses are
	// returned.
	MutateAdParameters(context.Context, *MutateAdParametersRequest) (*MutateAdParametersResponse, error)
}

// UnimplementedAdParameterServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAdParameterServiceServer struct {
}

func (*UnimplementedAdParameterServiceServer) GetAdParameter(ctx context.Context, req *GetAdParameterRequest) (*resources.AdParameter, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetAdParameter not implemented")
}
func (*UnimplementedAdParameterServiceServer) MutateAdParameters(ctx context.Context, req *MutateAdParametersRequest) (*MutateAdParametersResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method MutateAdParameters not implemented")
}

func RegisterAdParameterServiceServer(s *grpc.Server, srv AdParameterServiceServer) {
	s.RegisterService(&_AdParameterService_serviceDesc, srv)
}

func _AdParameterService_GetAdParameter_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAdParameterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdParameterServiceServer).GetAdParameter(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.AdParameterService/GetAdParameter",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdParameterServiceServer).GetAdParameter(ctx, req.(*GetAdParameterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AdParameterService_MutateAdParameters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateAdParametersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdParameterServiceServer).MutateAdParameters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v3.services.AdParameterService/MutateAdParameters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdParameterServiceServer).MutateAdParameters(ctx, req.(*MutateAdParametersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AdParameterService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v3.services.AdParameterService",
	HandlerType: (*AdParameterServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetAdParameter",
			Handler:    _AdParameterService_GetAdParameter_Handler,
		},
		{
			MethodName: "MutateAdParameters",
			Handler:    _AdParameterService_MutateAdParameters_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v3/services/ad_parameter_service.proto",
}
