#ifndef __LINUX_NETFILTER_CONNTRACK_SCTP_WRAPPER_H
#define __LINUX_NETFILTER_CONNTRACK_SCTP_WRAPPER_H 1

#if defined(__KERNEL__) || defined(HAVE_SCTP_CONNTRACK_HEARTBEATS)
#include_next <linux/netfilter/nf_conntrack_sctp.h>
#else

/* These are the states defined in the kernel UAPI for connection
 * tracking. */
enum sctp_conntrack {
	SCTP_CONNTRACK_NONE,
	SCTP_CONNTRACK_CLOSED,
	SCTP_CONNTRACK_COOKIE_WAIT,
	SCTP_CONNTRACK_COOKIE_ECHOED,
	SCTP_CONNTRACK_ESTABLISHED,
	SCTP_CONNTRACK_SHUTDOWN_SENT,
	SCTP_CONNTRACK_SHUTDOWN_RECD,
	SCTP_CONNTRACK_SHUTDOWN_ACK_SENT,
	SCTP_CONNTRACK_HEARTBEAT_SENT,
	SCTP_CONNTRACK_HEARTBEAT_ACKED,
	SCTP_CONNTRACK_MAX
};

#endif

#endif
