#!/bin/sh
set -o errexit

###
# Copyright (c) 2015-2021, Antoine Le Gonidec <vv221@dotslashplay.it>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# This software is provided by the copyright holders and contributors "as is"
# and any express or implied warranties, including, but not limited to, the
# implied warranties of merchantability and fitness for a particular purpose
# are disclaimed. In no event shall the copyright holder or contributors be
# liable for any direct, indirect, incidental, special, exemplary, or
# consequential damages (including, but not limited to, procurement of
# substitute goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether in
# contract, strict liability, or tort (including negligence or otherwise)
# arising in any way out of the use of this software, even if advised of the
# possibility of such damage.
###

###
# Startopia
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20210510.1

# Set game-specific variables

GAME_ID='startopia'
GAME_NAME='Startopia'

ARCHIVES_LIST='
ARCHIVE_BASE_0'

ARCHIVE_BASE_0='setup_startopia_2.0.0.17.exe'
ARCHIVE_BASE_0_MD5='4fe8d194afc1012e136ed3e82f1de171'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_VERSION='1.01b-gog2.0.0.17'
ARCHIVE_BASE_0_SIZE='600000'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/startopia'

ARCHIVE_DOC_DATA_PATH='app'
ARCHIVE_DOC_DATA_FILES='eula weblinks *.html *.pdf *.rtf *.txt'

ARCHIVE_GAME_BIN_PATH='app'
ARCHIVE_GAME_BIN_FILES='binkw32.dll startopia.exe startopia.ini'

ARCHIVE_GAME_DATA_PATH='app'
ARCHIVE_GAME_DATA_FILES='cardid.tom data intro languageinis missions startopia.jpg text'

CONFIG_FILES='./startopia.ini'
DATA_DIRS='./profiles'
DATA_FILES='./*.txt'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE='startopia.exe'
APP_MAIN_ICON='startopia.exe'

PACKAGES_LIST='PKG_DATA PKG_BIN'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ID="$GAME_ID"
PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine glx"

# Load common functions

target_version='2.12'

if [ -z "$PLAYIT_LIB2" ]; then
	for path in \
		"$PWD" \
		"${XDG_DATA_HOME:="$HOME/.local/share"}/play.it" \
		'/usr/local/share/games/play.it' \
		'/usr/local/share/play.it' \
		'/usr/share/games/play.it' \
		'/usr/share/play.it'
	do
		if [ -e "$path/libplayit2.sh" ]; then
			PLAYIT_LIB2="$path/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=play.it-2/lib/libplayit2.sh
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout
rm --recursive "$PLAYIT_WORKDIR/gamedata"

# Get game icon

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'
icons_move_to 'PKG_DATA'

# Tweak default configuration file
# This is required for the introduction movie to play

###
# TODO
# Some function dedicated to ini files edition would be useful here
###

ini_file="${PKG_BIN_PATH}${PATH_GAME}/startopia.ini"

ini_field='IntroPath'
ini_value="C:\\\\${GAME_ID}\\\\intro\\\\"

pattern="^${ini_field}=.*"
replacement="${ini_field}=${ini_value}"
expression="s/${pattern}/${replacement}/"

ini_field='DrivePathMusic'
ini_value="C:\\\\${GAME_ID}\\\\data\\\\"

pattern="^${ini_field}=.*"
replacement="${ini_field}=${ini_value}"
expression="${expression};s/${pattern}/${replacement}/"

ini_field='DrivePathSound'
ini_value="C:\\\\${GAME_ID}\\\\data\\\\"

pattern="^${ini_field}=.*"
replacement="${ini_field}=${ini_value}"
expression="${expression};s/${pattern}/${replacement}/"

ini_field='SoundPathVoice'
ini_value="C:\\\\${GAME_ID}\\\\data\\\\"

pattern="^${ini_field}=.*"
replacement="${ini_field}=${ini_value}"
expression="${expression};s/${pattern}/${replacement}/"

dos2unix --quiet "$ini_file"
sed --in-place --expression="$expression" "$ini_file"
unix2dos --quiet "$ini_file"

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
