;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.

;; Test that new-style nominal types are parsed correctly.
;; TODO: Remove --nominal below once nominal types are parsed as nominal by default.

;; RUN: foreach %s %t wasm-opt --nominal -all -S -o - | filecheck %s
;; RUN: foreach %s %t wasm-opt --nominal -all --roundtrip -S -o - | filecheck %s

;; void function type
(module
  ;; CHECK:      (type $super (func_subtype func))

  ;; CHECK:      (type $sub (func_subtype $super))
  (type $sub (func) (extends $super))

  (type $super (func))

  ;; CHECK:      (global $g (ref null $super) (ref.null $sub))
  (global $g (ref null $super) (ref.null $sub))
)

;; function type with params and results
(module
  ;; CHECK:      (type $super (func_subtype (param i32) (result i32) func))

  ;; CHECK:      (type $sub (func_subtype (param i32) (result i32) $super))
  (type $sub (func (param i32) (result i32)) (extends $super))

  (type $super (func (param i32) (result i32)))

  ;; CHECK:      (global $g (ref null $super) (ref.null $sub))
  (global $g (ref null $super) (ref.null $sub))
)

;; empty struct type
(module
  ;; CHECK:      (type $super (struct_subtype  data))

  ;; CHECK:      (type $sub (struct_subtype  $super))
  (type $sub (struct) (extends $super))

  (type $super (struct))

  ;; CHECK:      (global $g (ref null $super) (ref.null $sub))
  (global $g (ref null $super) (ref.null $sub))
)

;; struct type with fields
(module
  ;; CHECK:      (type $super (struct_subtype (field i32) (field i64) data))

  ;; CHECK:      (type $sub (struct_subtype (field i32) (field i64) $super))
  (type $sub (struct i32 (field i64)) (extends $super))

  (type $super (struct (field i32) i64))

  ;; CHECK:      (global $g (ref null $super) (ref.null $sub))
  (global $g (ref null $super) (ref.null $sub))
)

;; array type
(module
  ;; CHECK:      (type $super (array_subtype i8 data))

  ;; CHECK:      (type $sub (array_subtype i8 $super))
  (type $sub (array i8) (extends $super))

  (type $super (array i8))

  ;; CHECK:      (global $g (ref null $super) (ref.null $sub))
  (global $g (ref null $super) (ref.null $sub))
)
