;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; RUN: wasm-ctor-eval %s --ctors=test --kept-exports=test --quiet -all -S -o - | filecheck %s

(module
 ;; CHECK:      (type $0 (func))

 ;; CHECK:      (global $global (mut i32) (i32.const 0))
 (global $global (mut i32) (i32.const 0))

 (func $test (export "test")
  ;; The nop can be evalled away, but not the loop. We should not apply any
  ;; partial results from the loop - in particular, the global must remain at
  ;; 0. That is, the global.set of 999 below must not be applied to the global.
  ;;
  ;; (It is true that in this simple module it would be ok to set 999 to the
  ;; global, but if the global were exported for example then that would not
  ;; be the case, nor would it be the case if the code did $global = $global + 1
  ;; or such. That is, since the global.set is not evalled away, its effects
  ;; must not be applied; we do both atomically or neither, so that the
  ;; global.set's execution only happens once.)

  (nop)
  (loop
   (global.set $global
    (i32.const 999)
   )
   (unreachable)
  )
 )
)

;; CHECK:      (export "test" (func $test_1))

;; CHECK:      (func $test_1 (type $0)
;; CHECK-NEXT:  (global.set $global
;; CHECK-NEXT:   (i32.const 999)
;; CHECK-NEXT:  )
;; CHECK-NEXT:  (unreachable)
;; CHECK-NEXT: )
