/*!

\if MANPAGES
\page img2dcm Convert standard image formats into DICOM format
\else
\page img2dcm img2dcm: Convert standard image formats into DICOM format
\endif

\section img2dcm_synopsis SYNOPSIS

\verbatim
img2dcm [options] imgfile-in dcmfile-out
\endverbatim

\section img2dcm_description DESCRIPTION

The \b img2dcm tool serves as a conversion tool from a standard image format
like JPEG or BMP to DICOM. Different output SOP Classes can be selected. The
additional information (regarding patients, series, etc.) stored in the DICOM
output file can be extracted from other DICOM files which serve as a "template"
for the resulting DICOM object. \b img2dcm can also be configured to invent
missing DICOM type 1 and type 2 attributes to work even without any template
dataset.

\b img2dcm only supports single-frame output so far, i.e. it is not possible to
create multi-frame objects. Thus, also output SOP Classes that potentially
allow multiple frames within one object (such as the new Secondary Capture SOP
Classes) can only be created containing a single frame.

\section img2dcm_parameters PARAMETERS
\verbatim
imgfile-in   image file to be imported

dcmfile-out  DICOM output file
\endverbatim

\section img2dcm_options OPTIONS
\subsection img2dcm_general_options general options
\verbatim
  -h    --help
          print this help text and exit

        --version
          print version information and exit

        --arguments
          print expanded command line arguments

  -q    --quiet
          quiet mode, print no warnings and errors

  -v    --verbose
          verbose mode, print processing details

  -d    --debug
          debug mode, print debug information

  -ll   --log-level  [l]evel: string constant
          (fatal, error, warn, info, debug, trace)
          use level l for the logger

  -lc   --log-config  [f]ilename: string
          use config file f for the logger
\endverbatim

\subsection img2dcm_input_options input options
\verbatim
general:

  -i    --input-format  [i]nput file format: string
          supported formats: JPEG (default), BMP

  -df   --dataset-from  [f]ilename: string
          use dataset from DICOM file f

  -stf  --study-from  [f]ilename: string
          read patient/study from DICOM file f

  -sef  --series-from  [f]ilename: string
          read patient/study/series from DICOM file f

  -ii   --instance-inc
          increase instance number read from DICOM file

JPEG format:

  -dp   --disable-progr
          disable support for progressive JPEG

  -de   --disable-ext
          disable support for extended sequential JPEG

  -jf   --insist-on-jfif
          insist on JFIF header existence

  -ka   --keep-appn
          keep APPn sections (except JFIF)
\endverbatim

\subsection img2dcm_processing_options processing options
\verbatim
attribute checking:

        --do-checks
          enable attribute validity checking (default)

        --no-checks
          disable attribute validity checking

  +i2   --insert-type2
          insert missing type 2 attributes (default)
          (only with --do-checks)

  -i2   --no-type2-insert
          do not insert missing type 2 attributes
          (only with --do-checks)

  +i1   --invent-type1
          invent missing type 1 attributes
          (only with --do-checks)

  -i1   --no-type1-invent
          do not invent missing type 1 attributes
          (only with --do-checks)

character set:

  +l1   --latin1
          set latin-1 as standard character set (default)

  -l1   --no-latin1
          keep 7-bit ASCII as standard character set

other processing options:

  -k    --key  [k]ey: gggg,eeee="str", path or dictionary name="str"
          add further attribute
\endverbatim

\subsection img2dcm_output_options output options
\verbatim
target SOP class:

  -sc   --sec-capture
          write Secondary Capture SOP class

  -nsc  --new-sc
          write new Secondary Capture SOP classes

  -vlp  --vl-photo
          write Visible Light Photographic SOP class (default)

output file format:

  +F    --write-file
          write file format (default)

  -F    --write-dataset
          write data set without file meta information

group length encoding:

  +g=   --group-length-recalc
          recalculate group lengths if present (default)

  +g    --group-length-create
          always write with group length elements

  -g    --group-length-remove
          always write without group length elements

length encoding in sequences and items:

  +e    --length-explicit
          write with explicit lengths (default)

  -e    --length-undefined
          write with undefined lengths

data set trailing padding (not with --write-dataset):

  -p    --padding-off
          no padding (implicit if --write-dataset)

  +p    --padding-create  [f]ile-pad [i]tem-pad: integer
          align file on multiple of f bytes
          and items on multiple of i bytes
\endverbatim

\section img2dcm_notes NOTES

\subsection img2dcm_attribute_sources Attribute Sources

For converting a general image format into DICOM format, the \b img2dcm
application may be fed with some additional input for filling mandatory (and
optional) attributes in the new DICOM file like patient, study and series
information. This information can be collected using different approaches,
which can be combined and are applied to the result file in the following
order:

\li Using the \e --dataset-from option \b img2dcm is forced to import
    attributes from an existing DICOM file. The given DICOM file is fully
    imported and serves as the basis for all further export operations.
    As an exception, the SOP Instance UID is not copied by this option.
    Also image related data like Rows, Columns etc. is exchanged during
    conversion. Note that \b img2dcm does not check any other attribute
    values for validity, e. g. it does not look into sequences to adapt any
    attributes to the new object (referenced images etc.). Therefore, it is
    recommended to use the templates in the data directory for (old) SC and
    VLP objects. See also section "Input Templates".

\li The \e --study-from and \e --series-from options (mutually exclusive) can
    be used to import patient, study and series information from an existing
    DICOM file. If \e --series-from is specified, then the given DICOM file
    is opened by \b img2dcm and all mandatory information down to the series
    level is imported. Note that this includes patient, study and series
    information. In case of \e --study-from, the series information is
    excluded. The following attributes are taken over:
    \verbatim
      Patient Level:
        Patient's Name
        Patient ID
        Patient's Sex
        Patient's Birth Date
        Specific Character Set

      Study Level:
        Study Instance UID
        Study Date
        Study Time
        Referring Physician's Name
        Study ID
        Accession Number

      Series Level (only in case of option --series-from):
        Series Instance UID
        Series Number
        Manufacturer
    \endverbatim

\li With the \e --insert-type2 and \e --invent-type1 options (both enabled per
    default), missing attributes (type 2 attributes) and/or missing attribute
    values (for type 1 attributes) are automatically added and invented by
    \b img2dcm. Please note that these options are only evaluated if option
    \e --do-checks is enabled (default). If the \e --no-checks options is
    enabled, no automatic attribute insertion will take place.

\li The \e --key option can be used to add further attributes to the DICOM
    output file. This option is applied at the very end, just before saving the
    DICOM file. It is also possible to specify sequences, items and nested
    attributes using the \e --key option. In these cases, a special "path"
    notation has to be used. Details on this path notation can be found in the
    documentation of \b dcmodify.

\subsection img2dcm_uids UIDs

New Study and Series Instance UIDs are generated <b>if necessary</b> after
applying the \e --study-from and \e --series options. If Study Instance UID or
Series Instance UID are not present after these steps, they are newly generated,
independently from each other.
A contrary behavior is chosen for the SOP Instance UID that one could expect
to be taken over when using the \e --dataset-from option. This is \b not the
case, the SOP Instance UID is \b not copied to the new object. This should
be the desirable behavior for most use cases. However, if a certain SOP
Instance UID should be inserted into the new object, the \e --key option should
be used.

\subsection img2dcm_input_templates Input Templates

For supporting the conversion into DICOM, \b img2dcm comes with some
pre-defined templates which can be used for the \e --dataset-from option (see
sample files \e SC.dump and \e VLP.dump). These templates should be filled with
the desired values and then must be dumped (converted) to a DICOM file before
actually being used with \b img2dcm. Use \b dump2dcm to convert the dump to
DICOM. Example:
\verbatim
  dump2dcm SC.dump SC.dcm
\endverbatim

It is possible to use any DICOM file as a template. Please note that the
complete DICOM dataset is imported; hence, it should be assured that only
attributes are present which should be part of the constructed DICOM object.
The SOP Class UID and the Pixel Data attributes (including attributes like
Rows, Columns etc.) are not copied but replaced by \b img2dcm during conversion.

\subsection img2dcm_input_plugins Input Plugins

The \b img2dcm application currently supports the JPEG and the BMP image format
as input.

\subsubsection img2dcm_jpeg_input_plugin JPEG Input Plugin

For JPEG, the original JPEG from the source file is not decoded but extracted
and slightly transformed (e. g. JFIF header is cut off) to allow fast
conversion of even big JPEG files without the need of decoding and re-encoding.
The JPEG plugin chooses the necessary output transfer syntax automatically
depending on the actual encoding of the data inside the JPEG file. Therefore,
the following Transfer Syntaxes (and their corresponding JPEG encodings) are
used by the JPEG plugin:

\li JPEG Coding Process 1
    Baseline, Lossy, Non-Hierarchical, Sequential, DCT, Huffman, 8 Bit
    SOP Class = 1.2.840.10008.1.2.4.50

\li JPEG Coding Process 2 (8-bit) and 4 (12-bit)
    Extended, Lossy, Non-Hierarchical, Sequential, DCT, Huffman, 8/12 Bit
    SOP Class = 1.2.840.10008.1.2.4.51

\li JPEG Coding Process 10 (8-bit) and 12 (12-bit)
    Full Progression, lossy, Non-Hierarch., Progressive, DCT, Huffman, 8/12 Bit
    SOP Class = 1.2.840.10008.1.2.4.55

Color and grayscale images are supported.

The support for the Extended JPEG Transfer Syntax can be disabled
(\e --disable-ext option) as well as the support for the (retired) Progressive
JPEG Transfer Syntax (\e --disable-progr option).

JPEG lossless encoding as well as any arithmetic or hierarchical JPEG encoding
modes are not supported by the plugin.

JFIF (JPEG File Interchange Format) information facilitates optional APPn
markers in a JPEG file. Many digital cameras do not integrate such JFIF
information into the JPEG output they create. For example, JFIF contains
information about the pixel aspect ratio of the compressed image. If you want
the \b img2dcm application to insist on a JFIF header in the JPEG stream, you
can use the option \e --insist-on-jfif which will abort if no JFIF information
can be found. By default, missing JFIF information is ignored.

For DICOM it is kind of a "gray zone", whether the integration of JFIF (or any
other APPn) data into the DICOM object's internal JPEG stream is allowed or
not. However, the most reliable approach is to cut those markers and their
information off the JPEG stream. This approach is also taken by the \b img2dcm
application. By default, all APPn markers are cut off from the original JPEG
stream. However, if you want to keep other APPn markers than JFIF (e. g.
EXIF information) inside the DICOM stream, the option \e --keep-appn
does the trick. It should also be slightly faster than cutting off APPn
information, because it is not necessary to scan the whole JPEG stream for
such data. JFIF information is \b always removed by \b img2dcm.

\subsubsection img2dcm_bmp_input_plugin BMP Input Plugin

\b img2dcm supports BMP as input format. However, so far only the most common
BMP images are supported.  In particular, BMP images which use bit fields or
run length encoding will be rejected. Such images are uncommon. All input images
will be converted into a DICOM image with RGB color model and a bit depth of 24.
There are no specific options for fine-tuning BMP format conversion.

\subsection img2dcm_output_plugins Output Plugins

The desired output SOP Class can be selected on the command line. Currently,
an export plugin for the Secondary Capture Image SOP class (default, option
\e -sc), the new Secondary Capture Image SOP classes (option \e -nsc) and
Visible Light Photographic Image SOP class (option \e -vl) are available.
Please note that the first one is deprecated according to the DICOM standard
but is selected as a default because it is widely supported. Future versions
of \b img2dcm might provide further output plugins for other SOP Classes.

For the new Secondary Capture SOP classes, it is not possible to specify which
specific SOP class should be used for output. That is because these new SOP
classes are differentiated from each other by color depth (1/8/16) and the
fact whether the image is black/white or color. That is why \b img2dcm decides
during conversion, which output SOP class is suitable for a given source image.

\section img2dcm_examples EXAMPLES

Here are some examples that show how the \b img2dcm application can be used.

<ol>

<li>
img2dcm image.jpg out.dcm
<br>Read JPEG file "image.jpg", convert to the old Secondary Capture SOP class
and save the result to DICOM file "out.dcm". This is the easiest way of using
\b img2dcm. Any type 1 and type 2 attributes required for writing valid objects
of this SOP class are inserted automatically.
</li>

<li>
img2dcm -i BMP image.bmp out.dcm
<br>Same as above but tells img2dcm to read a BMP file instead of JPEG.
</li>

<li>
img2dcm image.jpg out.dcm -vlp -k "PatientName=Bond^James"
<br>Same as first example, but writes Visible Light Photographic Image object
to "out.dcm" and sets PatientName to "Bond^James" which otherwise would be
left empty.
</li>

<li>
img2dcm image.jpg out.dcm --series-from template.dcm -k
"PatientName=Bond^James"
<br>Same as 1), but imports patient/study/series information from DICOM file
"template.dcm". Please note that attribute PatientName will contain
"Bond^James" at the end, any value from "template.dcm" will be overwritten.
That is, because the -k option is applied at the very end of the conversion
pipeline (see above).
</li>

<li>
img2dcm image.jpg out.dcm --no-checks
<br>Same as 1), but does not perform any attribute checking and no type 1 and
type 2 attribute insertion! So in this case, an invalid DICOM object would be
generated. This can be interesting if the output file is not meant to be
completed but will undergo further transformations, e. g. adding attributes
using \b dcmodify. Only use option \e --no-checks if you know what you are
doing!
</li>

<li>
img2dcm image.jpg out.dcm --no-type1-invent
<br>Same as 1), but does not insert missing type 1 attributes and/or their
values. Type 2 attributes will be inserted. Note that in this case it must be
assured that all type 1 attributes are provided by other means, i. e. by adding
them with the \e --key option. Otherwise, \b img2dcm will report an error and
will stop converting.
</li>

<li>
img2dcm image.jpg out.dcm --keep-appn --insist-on-jfif
<br>Same as 1), but takes over APPn information like EXIF into the DICOM
object's resulting JPEG stream. Further, \e --insist-on-jfif will force
\b img2dcm to abort if no JFIF information is existent in the source file.
</li>

</ol>

\section img2dcm_logging LOGGING

The level of logging output of the various command line tools and underlying
libraries can be specified by the user.  By default, only errors and warnings
are written to the standard error stream.  Using option \e --verbose also
informational messages like processing details are reported.  Option
\e --debug can be used to get more details on the internal activity, e.g. for
debugging purposes.  Other logging levels can be selected using option
\e --log-level.  In \e --quiet mode only fatal errors are reported.  In such
very severe error events, the application will usually terminate.  For more
details on the different logging levels, see documentation of module "oflog".

In case the logging output should be written to file (optionally with logfile
rotation), to syslog (Unix) or the event log (Windows) option \e --log-config
can be used.  This configuration file also allows for directing only certain
messages to a particular output stream and for filtering certain messages
based on the module or application where they are generated.  An example
configuration file is provided in <em>\<etcdir\>/logger.cfg</em>.

\section img2dcm_command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behavior conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator unless they appear between two
quotation marks) prior to any further evaluation.  Please note that a command
file cannot contain another command file.  This simple but effective approach
allows one to summarize common combinations of options/parameters and avoids
longish and confusing command lines (an example is provided in file
<em>\<datadir\>/dumppat.txt</em>).

\section img2dcm_environment ENVIRONMENT

The \b img2dcm utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<datadir\>/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behavior should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  On Windows systems,
a semicolon (";") is used as a separator.  The data dictionary code will
attempt to load each file specified in the \e DCMDICTPATH environment variable.
It is an error if no data dictionary can be loaded.

\section img2dcm_files FILES

<em>\<datadir\>/SC.dump</em> - Sample dump file for Secondary Capture images
\n<em>\<datadir\>/VLP.dump</em> - Sample dump file for Visible Light Photographic
images

\section img2dcm_see_also SEE ALSO

<b>dcm2pnm</b>(1), <b>dcmj2pnm</b>(1), <b>dump2dcm</b>(1), <b>dcmconv</b>(1),
<b>dcmodify</b>(1)

\section img2dcm_copyright COPYRIGHT

Copyright (C) 2007-2019 by OFFIS e.V., Escherweg 2, 26121 Oldenburg, Germany.

*/
