package CDecl::Enumerator;

use 5.6.0;
use strict;
use warnings;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;

    my $enum = shift;
    my $name = shift;

    my $self = {enum => $enum,
                name => $name,
               };
    bless $self, $class;
    return $self;
  }

sub identifier
  {
    my $self = shift;
    return $self->{name};
  }

sub enum
  {
    my $self = shift;
    return $self->{enum};
  }

sub value
  {
    my $self = shift;
    return $self->enum->get_value($self->{name});
  }

sub file
  {
    my $self = shift;
    return $self->enum->{file};
  }

sub location
  {
    my $self = shift;

    return '' unless $self->enum->{file};
    return $self->enum->{file} . ':' . $self->enum->{line};
  }

sub describe_name
  {
    my $self = shift;

    return "enumerator $self->{name}";
  }

sub dump_c
  {
    my $self = shift;
    my $skip_cpp = shift;

    return $self->{name};
  }

sub layout
  {
    my $self = shift;
    my $accept_incomplete = shift;
    my $namespace = shift;
  }

sub describe
  {
    my $self = shift;

    return "enumerator $self->{name}";
  }

sub get_refs
  {
    my $self = shift;
    return $self->value->get_refs;
  }

1;
