(setq ispell-dictionary-alist
  '((nil				; default (english.aff)
     "[A-Za-z]" "[^A-Za-z]" "[']" nil ("-B") nil)
    ("english"				; make english explicitly selectable
     "[A-Za-z]" "[^A-Za-z]" "[']" nil ("-B") nil)
    ("british"				; british version
     "[A-Za-z]" "[^A-Za-z]" "[']" nil ("-B" "-d" "british") nil)
    ("deutsch"				; deutsch.aff
     "[a-zA-Z\"]" "[^a-zA-Z\"]" "[']" t ("-C") "~tex")
    ("deutsch8"
     "[a-zA-Z\304\326\334\344\366\337\374]"
     "[^a-zA-Z\304\326\334\344\366\337\374]"
     "[']" t ("-C" "-d" "deutsch") "~latin1")
    ("nederlands"				; nederlands.aff
     "[A-Za-z\300-\305\307\310-\317\322-\326\331-\334\340-\345\347\350-\357\361\362-\366\371-\374]"
     "[^A-Za-z\300-\305\307\310-\317\322-\326\331-\334\340-\345\347\350-\357\361\362-\366\371-\374]"
     "[']" t ("-C") nil)
    ("nederlands8"				; dutch8.aff
     "[A-Za-z\300-\305\307\310-\317\322-\326\331-\334\340-\345\347\350-\357\361\362-\366\371-\374]"
     "[^A-Za-z\300-\305\307\310-\317\322-\326\331-\334\340-\345\347\350-\357\361\362-\366\371-\374]"
     "[']" t ("-C") nil)
    ("svenska"				;7 bit swedish mode
     "[A-Za-z}{|\\133\\135\\\\]" "[^A-Za-z}{|\\133\\135\\\\]"
     "[']" nil ("-C") nil)
    ("svenska8"				;8 bit swedish mode
     "[A-Za-z\345\344\366\305\304\366]"  "[^A-Za-z\345\344\366\305\304\366]"
     "[']" nil ("-C" "-d" "svenska") "~list") ; Add `"-T" "list"' instead?
    ("francais7"
     "[A-Za-z]" "[^A-Za-z]" "[`'^---]" t nil nil)
    ("francais"				; francais.aff
     "[A-Za-z\300\302\306\307\310\311\312\313\316\317\324\331\333\334\340\342\347\350\351\352\353\356\357\364\371\373\374]"
     "[^A-Za-z\300\302\306\307\310\311\312\313\316\317\324\331\333\334\340\342\347\350\351\352\353\356\357\364\371\373\374]"
     "[---']" t nil "~list")
    ("italian"                          ;8 bit italian.aff
     "[A-Za-z\\]"
     "[^A-Za-z\\]"
     "[---'^`\"]" t nil "~tex")
    ("francais-tex"			; francais.aff
     "[A-Za-z\300\302\306\307\310\311\312\313\316\317\324\331\333\334\340\342\347\350\351\352\353\356\357\364\371\373\374\\]"
     "[^A-Za-z\300\302\306\307\310\311\312\313\316\317\324\331\333\334\340\342\347\350\351\352\353\356\357\364\371\373\374\\]"
     "[---'^`\"]" t nil "~tex")
    ("dansk"				; dansk.aff
     "[A-Z\306\330\305a-z\346\370\345]" "[^A-Z\306\330\305a-z\346\370\345]"
     "" nil ("-C") nil)
    ))

(define-key-after ispell-menu-map [italian]
  (quote ("Select Italian" . (lambda nil
                               (interactive)
                               (ispell-change-dictionary "italian"))))
  (quote british))