/*
 * Copyright (C) 2020 Intel Corporation
 *
 * SPDX-License-Identifier: MIT
 *
 */

#pragma once
#include <level_zero/zes_api.h>

#include <vector>

struct _zes_ras_handle_t {
    virtual ~_zes_ras_handle_t() = default;
};

namespace L0 {

struct OsSysman;

class Ras : _zes_ras_handle_t {
  public:
    virtual ze_result_t rasGetProperties(zes_ras_properties_t *pProperties) = 0;
    virtual ze_result_t rasGetConfig(zes_ras_config_t *pConfig) = 0;
    virtual ze_result_t rasSetConfig(const zes_ras_config_t *pConfig) = 0;
    virtual ze_result_t rasGetState(zes_ras_state_t *pState) = 0;

    static Ras *fromHandle(zes_ras_handle_t handle) {
        return static_cast<Ras *>(handle);
    }
    inline zes_ras_handle_t toHandle() { return this; }
    bool isRasErrorSupported = false;
    zes_ras_error_type_t rasErrorType;
};

struct RasHandleContext {
    RasHandleContext(OsSysman *pOsSysman) : pOsSysman(pOsSysman){};
    ~RasHandleContext();

    void init();

    ze_result_t rasGet(uint32_t *pCount, zes_ras_handle_t *phRas);

    OsSysman *pOsSysman = nullptr;
    std::vector<Ras *> handleList = {};

  private:
    void createHandle(zes_ras_error_type_t type);
};

} // namespace L0
