What is Irqbalance
==================

Irqbalance is a daemon to help balance the cpu load generated by interrupts
across all of a systems cpus. Irqbalance identifies the highest volume
interrupt sources, and isolates each of them to a single unique cpu, so that
load is spread as much as possible over an entire processor set, while
minimizing cache miss rates for irq handlers.

## Building and Installing [![Build Status](https://travis-ci.org/Irqbalance/irqbalance.svg?branch=master)](https://travis-ci.org/Irqbalance/irqbalance)

```bash
./autogen.sh
./configure [options]
make
make install
```

## Developing Irqbalance

Irqbalance is currently hosted on github, and so developers are welcome to use
the issue/pull request/etc infrastructure found there.  However, most
development discussions take place on the irqbalance mailing list, which can be
subscribed to at:
http://lists.infradead.org/mailman/listinfo/irqbalance

New Developers are encouraged to use this mailing list to discuss ideas and
propose patches.

## Bug reporting

When something goes wrong, feel free to send us bugreport by one of the ways
described above. Your report should include:

* Irqbalance version you've been using (or commit hash)
* `/proc/interrupts` output
* `irqbalance --debug` output
* content of smp_affinity files - can be obtained by e.g.:
	`$ for i in $(seq 0 300); do grep . /proc/irq/$i/smp_affinity /dev/null 2>/dev/null; done`
* your hw hierarchy - e.g. `lstopo-no-graphics` output
