
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQItemDelegate.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QItemDelegate>
#include <QAbstractItemModel>
#include <QAbstractItemView>
#include <QChildEvent>
#include <QEvent>
#include <QFont>
#include <QHelpEvent>
#include <QItemEditorFactory>
#include <QMetaMethod>
#include <QModelIndex>
#include <QObject>
#include <QPainter>
#include <QPalette>
#include <QPixmap>
#include <QRect>
#include <QSize>
#include <QStyleOptionViewItem>
#include <QThread>
#include <QTimerEvent>
#include <QWidget>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QItemDelegate

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QItemDelegate::staticMetaObject);
}


// QWidget *QItemDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index)


static void _init_f_createEditor_c6860 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QWidget * > ();
}

static void _call_f_createEditor_c6860 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const QStyleOptionViewItem &arg2 = gsi::arg_reader<const QStyleOptionViewItem & >() (args, heap);
  const QModelIndex &arg3 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QWidget * > ((QWidget *)((QItemDelegate *)cls)->createEditor (arg1, arg2, arg3));
}


// bool QItemDelegate::hasClipping()


static void _init_f_hasClipping_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasClipping_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QItemDelegate *)cls)->hasClipping ());
}


// QItemEditorFactory *QItemDelegate::itemEditorFactory()


static void _init_f_itemEditorFactory_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QItemEditorFactory * > ();
}

static void _call_f_itemEditorFactory_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QItemEditorFactory * > ((QItemEditorFactory *)((QItemDelegate *)cls)->itemEditorFactory ());
}


// void QItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)


static void _init_f_paint_c6971 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_paint_c6971 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  const QStyleOptionViewItem &arg2 = gsi::arg_reader<const QStyleOptionViewItem & >() (args, heap);
  const QModelIndex &arg3 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemDelegate *)cls)->paint (arg1, arg2, arg3);
}


// void QItemDelegate::setClipping(bool clip)


static void _init_f_setClipping_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("clip");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setClipping_864 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  bool arg1 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemDelegate *)cls)->setClipping (arg1);
}


// void QItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index)


static void _init_f_setEditorData_c3602 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setEditorData_c3602 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemDelegate *)cls)->setEditorData (arg1, arg2);
}


// void QItemDelegate::setItemEditorFactory(QItemEditorFactory *factory)


static void _init_f_setItemEditorFactory_2445 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("factory");
  decl->add_arg<QItemEditorFactory * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setItemEditorFactory_2445 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QItemEditorFactory *arg1 = gsi::arg_reader<QItemEditorFactory * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemDelegate *)cls)->setItemEditorFactory (arg1);
}


// void QItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index)


static void _init_f_setModelData_c5913 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setModelData_c5913 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  QAbstractItemModel *arg2 = gsi::arg_reader<QAbstractItemModel * >() (args, heap);
  const QModelIndex &arg3 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemDelegate *)cls)->setModelData (arg1, arg2, arg3);
}


// QSize QItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index)


static void _init_f_sizeHint_c5653 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c5653 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStyleOptionViewItem &arg1 = gsi::arg_reader<const QStyleOptionViewItem & >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ret.write<QSize > ((QSize)((QItemDelegate *)cls)->sizeHint (arg1, arg2));
}


// void QItemDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index)


static void _init_f_updateEditorGeometry_c6860 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_updateEditorGeometry_c6860 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const QStyleOptionViewItem &arg2 = gsi::arg_reader<const QStyleOptionViewItem & >() (args, heap);
  const QModelIndex &arg3 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemDelegate *)cls)->updateEditorGeometry (arg1, arg2, arg3);
}


// static QString QItemDelegate::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QItemDelegate::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QItemDelegate () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("createEditor", "@brief Method QWidget *QItemDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis is a reimplementation of QAbstractItemDelegate::createEditor", true, &_init_f_createEditor_c6860, &_call_f_createEditor_c6860);
  methods += new qt_gsi::GenericMethod ("hasClipping|:clipping", "@brief Method bool QItemDelegate::hasClipping()\n", true, &_init_f_hasClipping_c0, &_call_f_hasClipping_c0);
  methods += new qt_gsi::GenericMethod (":itemEditorFactory", "@brief Method QItemEditorFactory *QItemDelegate::itemEditorFactory()\n", true, &_init_f_itemEditorFactory_c0, &_call_f_itemEditorFactory_c0);
  methods += new qt_gsi::GenericMethod ("paint", "@brief Method void QItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis is a reimplementation of QAbstractItemDelegate::paint", true, &_init_f_paint_c6971, &_call_f_paint_c6971);
  methods += new qt_gsi::GenericMethod ("setClipping|clipping=", "@brief Method void QItemDelegate::setClipping(bool clip)\n", false, &_init_f_setClipping_864, &_call_f_setClipping_864);
  methods += new qt_gsi::GenericMethod ("setEditorData", "@brief Method void QItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index)\nThis is a reimplementation of QAbstractItemDelegate::setEditorData", true, &_init_f_setEditorData_c3602, &_call_f_setEditorData_c3602);
  methods += new qt_gsi::GenericMethod ("setItemEditorFactory|itemEditorFactory=", "@brief Method void QItemDelegate::setItemEditorFactory(QItemEditorFactory *factory)\n", false, &_init_f_setItemEditorFactory_2445, &_call_f_setItemEditorFactory_2445);
  methods += new qt_gsi::GenericMethod ("setModelData", "@brief Method void QItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index)\nThis is a reimplementation of QAbstractItemDelegate::setModelData", true, &_init_f_setModelData_c5913, &_call_f_setModelData_c5913);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Method QSize QItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index)\nThis is a reimplementation of QAbstractItemDelegate::sizeHint", true, &_init_f_sizeHint_c5653, &_call_f_sizeHint_c5653);
  methods += new qt_gsi::GenericMethod ("updateEditorGeometry", "@brief Method void QItemDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis is a reimplementation of QAbstractItemDelegate::updateEditorGeometry", true, &_init_f_updateEditorGeometry_c6860, &_call_f_updateEditorGeometry_c6860);
  methods += gsi::qt_signal<QWidget *, const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & > ("closeEditor(QWidget *, QAbstractItemDelegate::EndEditHint)", "closeEditor", gsi::arg("editor"), gsi::arg("hint"), "@brief Signal declaration for QItemDelegate::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QWidget * > ("commitData(QWidget *)", "commitData", gsi::arg("editor"), "@brief Signal declaration for QItemDelegate::commitData(QWidget *editor)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QItemDelegate::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QItemDelegate::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QModelIndex & > ("sizeHintChanged(const QModelIndex &)", "sizeHintChanged", gsi::arg("arg1"), "@brief Signal declaration for QItemDelegate::sizeHintChanged(const QModelIndex &)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QItemDelegate::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QAbstractItemDelegate> &qtdecl_QAbstractItemDelegate ();

qt_gsi::QtNativeClass<QItemDelegate> decl_QItemDelegate (qtdecl_QAbstractItemDelegate (), "QtWidgets", "QItemDelegate_Native",
  methods_QItemDelegate (),
  "@hide\n@alias QItemDelegate");

GSI_QTWIDGETS_PUBLIC gsi::Class<QItemDelegate> &qtdecl_QItemDelegate () { return decl_QItemDelegate; }

}


class QItemDelegate_Adaptor : public QItemDelegate, public qt_gsi::QtObjectBase
{
public:

  virtual ~QItemDelegate_Adaptor();

  //  [adaptor ctor] QItemDelegate::QItemDelegate(QObject *parent)
  QItemDelegate_Adaptor() : QItemDelegate()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QItemDelegate::QItemDelegate(QObject *parent)
  QItemDelegate_Adaptor(QObject *parent) : QItemDelegate(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] QPixmap QItemDelegate::decoration(const QStyleOptionViewItem &option, const QVariant &variant)
  QPixmap fp_QItemDelegate_decoration_c5377 (const QStyleOptionViewItem &option, const QVariant &variant) const {
    return QItemDelegate::decoration(option, variant);
  }

  //  [expose] QRect QItemDelegate::doCheck(const QStyleOptionViewItem &option, const QRect &bounding, const QVariant &variant)
  QRect fp_QItemDelegate_doCheck_c7061 (const QStyleOptionViewItem &option, const QRect &bounding, const QVariant &variant) const {
    return QItemDelegate::doCheck(option, bounding, variant);
  }

  //  [expose] void QItemDelegate::doLayout(const QStyleOptionViewItem &option, QRect *checkRect, QRect *iconRect, QRect *textRect, bool hint)
  void fp_QItemDelegate_doLayout_c7101 (const QStyleOptionViewItem &option, QRect *checkRect, QRect *iconRect, QRect *textRect, bool hint) const {
    QItemDelegate::doLayout(option, checkRect, iconRect, textRect, hint);
  }

  //  [expose] void QItemDelegate::drawBackground(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)
  void fp_QItemDelegate_drawBackground_c6971 (QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const {
    QItemDelegate::drawBackground(painter, option, index);
  }

  //  [expose] bool QItemDelegate::isSignalConnected(const QMetaMethod &signal)
  bool fp_QItemDelegate_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QItemDelegate::isSignalConnected(signal);
  }

  //  [expose] int QItemDelegate::receivers(const char *signal)
  int fp_QItemDelegate_receivers_c1731 (const char *signal) const {
    return QItemDelegate::receivers(signal);
  }

  //  [expose] QRect QItemDelegate::rect(const QStyleOptionViewItem &option, const QModelIndex &index, int role)
  QRect fp_QItemDelegate_rect_c6312 (const QStyleOptionViewItem &option, const QModelIndex &index, int role) const {
    return QItemDelegate::rect(option, index, role);
  }

  //  [expose] QPixmap QItemDelegate::selectedPixmap(const QPixmap &pixmap, const QPalette &palette, bool enabled)
  static QPixmap fp_QItemDelegate_selectedPixmap_4778 (const QPixmap &pixmap, const QPalette &palette, bool enabled) {
    return QItemDelegate::selectedPixmap(pixmap, palette, enabled);
  }

  //  [expose] QObject *QItemDelegate::sender()
  QObject * fp_QItemDelegate_sender_c0 () const {
    return QItemDelegate::sender();
  }

  //  [expose] int QItemDelegate::senderSignalIndex()
  int fp_QItemDelegate_senderSignalIndex_c0 () const {
    return QItemDelegate::senderSignalIndex();
  }

  //  [expose] QStyleOptionViewItem QItemDelegate::setOptions(const QModelIndex &index, const QStyleOptionViewItem &option)
  QStyleOptionViewItem fp_QItemDelegate_setOptions_c5653 (const QModelIndex &index, const QStyleOptionViewItem &option) const {
    return QItemDelegate::setOptions(index, option);
  }

  //  [expose] QRect QItemDelegate::textRectangle(QPainter *painter, const QRect &rect, const QFont &font, const QString &text)
  QRect fp_QItemDelegate_textRectangle_c6720 (QPainter *painter, const QRect &rect, const QFont &font, const QString &text) const {
    return QItemDelegate::textRectangle(painter, rect, font, text);
  }

  //  [emitter impl] void QItemDelegate::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)
  void emitter_QItemDelegate_closeEditor_4926(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)
  {
    emit QItemDelegate::closeEditor(editor, hint);
  }

  //  [emitter impl] void QItemDelegate::commitData(QWidget *editor)
  void emitter_QItemDelegate_commitData_1315(QWidget *editor)
  {
    emit QItemDelegate::commitData(editor);
  }

  //  [adaptor impl] QWidget *QItemDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index)
  QWidget * cbs_createEditor_c6860_0(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    return QItemDelegate::createEditor(parent, option, index);
  }

  virtual QWidget * createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    if (cb_createEditor_c6860_0.can_issue()) {
      return cb_createEditor_c6860_0.issue<QItemDelegate_Adaptor, QWidget *, QWidget *, const QStyleOptionViewItem &, const QModelIndex &>(&QItemDelegate_Adaptor::cbs_createEditor_c6860_0, parent, option, index);
    } else {
      return QItemDelegate::createEditor(parent, option, index);
    }
  }

  //  [adaptor impl] void QItemDelegate::destroyEditor(QWidget *editor, const QModelIndex &index)
  void cbs_destroyEditor_c3602_0(QWidget *editor, const QModelIndex &index) const
  {
    QItemDelegate::destroyEditor(editor, index);
  }

  virtual void destroyEditor(QWidget *editor, const QModelIndex &index) const
  {
    if (cb_destroyEditor_c3602_0.can_issue()) {
      cb_destroyEditor_c3602_0.issue<QItemDelegate_Adaptor, QWidget *, const QModelIndex &>(&QItemDelegate_Adaptor::cbs_destroyEditor_c3602_0, editor, index);
    } else {
      QItemDelegate::destroyEditor(editor, index);
    }
  }

  //  [emitter impl] void QItemDelegate::destroyed(QObject *)
  void emitter_QItemDelegate_destroyed_1302(QObject *arg1)
  {
    emit QItemDelegate::destroyed(arg1);
  }

  //  [adaptor impl] bool QItemDelegate::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QItemDelegate::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QItemDelegate_Adaptor, bool, QEvent *>(&QItemDelegate_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QItemDelegate::event(_event);
    }
  }

  //  [adaptor impl] bool QItemDelegate::helpEvent(QHelpEvent *event, QAbstractItemView *view, const QStyleOptionViewItem &option, const QModelIndex &index)
  bool cbs_helpEvent_9380_0(QHelpEvent *event, QAbstractItemView *view, const QStyleOptionViewItem &option, const QModelIndex &index)
  {
    return QItemDelegate::helpEvent(event, view, option, index);
  }

  virtual bool helpEvent(QHelpEvent *event, QAbstractItemView *view, const QStyleOptionViewItem &option, const QModelIndex &index)
  {
    if (cb_helpEvent_9380_0.can_issue()) {
      return cb_helpEvent_9380_0.issue<QItemDelegate_Adaptor, bool, QHelpEvent *, QAbstractItemView *, const QStyleOptionViewItem &, const QModelIndex &>(&QItemDelegate_Adaptor::cbs_helpEvent_9380_0, event, view, option, index);
    } else {
      return QItemDelegate::helpEvent(event, view, option, index);
    }
  }

  //  [emitter impl] void QItemDelegate::objectNameChanged(const QString &objectName)
  void emitter_QItemDelegate_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QItemDelegate::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] void QItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)
  void cbs_paint_c6971_0(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    QItemDelegate::paint(painter, option, index);
  }

  virtual void paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    if (cb_paint_c6971_0.can_issue()) {
      cb_paint_c6971_0.issue<QItemDelegate_Adaptor, QPainter *, const QStyleOptionViewItem &, const QModelIndex &>(&QItemDelegate_Adaptor::cbs_paint_c6971_0, painter, option, index);
    } else {
      QItemDelegate::paint(painter, option, index);
    }
  }

  //  [adaptor impl] QList<int> QItemDelegate::paintingRoles()
  QList<int> cbs_paintingRoles_c0_0() const
  {
    return QItemDelegate::paintingRoles();
  }

  virtual QList<int> paintingRoles() const
  {
    if (cb_paintingRoles_c0_0.can_issue()) {
      return cb_paintingRoles_c0_0.issue<QItemDelegate_Adaptor, QList<int> >(&QItemDelegate_Adaptor::cbs_paintingRoles_c0_0);
    } else {
      return QItemDelegate::paintingRoles();
    }
  }

  //  [adaptor impl] void QItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index)
  void cbs_setEditorData_c3602_0(QWidget *editor, const QModelIndex &index) const
  {
    QItemDelegate::setEditorData(editor, index);
  }

  virtual void setEditorData(QWidget *editor, const QModelIndex &index) const
  {
    if (cb_setEditorData_c3602_0.can_issue()) {
      cb_setEditorData_c3602_0.issue<QItemDelegate_Adaptor, QWidget *, const QModelIndex &>(&QItemDelegate_Adaptor::cbs_setEditorData_c3602_0, editor, index);
    } else {
      QItemDelegate::setEditorData(editor, index);
    }
  }

  //  [adaptor impl] void QItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index)
  void cbs_setModelData_c5913_0(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const
  {
    QItemDelegate::setModelData(editor, model, index);
  }

  virtual void setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index) const
  {
    if (cb_setModelData_c5913_0.can_issue()) {
      cb_setModelData_c5913_0.issue<QItemDelegate_Adaptor, QWidget *, QAbstractItemModel *, const QModelIndex &>(&QItemDelegate_Adaptor::cbs_setModelData_c5913_0, editor, model, index);
    } else {
      QItemDelegate::setModelData(editor, model, index);
    }
  }

  //  [adaptor impl] QSize QItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index)
  QSize cbs_sizeHint_c5653_0(const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    return QItemDelegate::sizeHint(option, index);
  }

  virtual QSize sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    if (cb_sizeHint_c5653_0.can_issue()) {
      return cb_sizeHint_c5653_0.issue<QItemDelegate_Adaptor, QSize, const QStyleOptionViewItem &, const QModelIndex &>(&QItemDelegate_Adaptor::cbs_sizeHint_c5653_0, option, index);
    } else {
      return QItemDelegate::sizeHint(option, index);
    }
  }

  //  [emitter impl] void QItemDelegate::sizeHintChanged(const QModelIndex &)
  void emitter_QItemDelegate_sizeHintChanged_2395(const QModelIndex &arg1)
  {
    emit QItemDelegate::sizeHintChanged(arg1);
  }

  //  [adaptor impl] void QItemDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index)
  void cbs_updateEditorGeometry_c6860_0(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    QItemDelegate::updateEditorGeometry(editor, option, index);
  }

  virtual void updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index) const
  {
    if (cb_updateEditorGeometry_c6860_0.can_issue()) {
      cb_updateEditorGeometry_c6860_0.issue<QItemDelegate_Adaptor, QWidget *, const QStyleOptionViewItem &, const QModelIndex &>(&QItemDelegate_Adaptor::cbs_updateEditorGeometry_c6860_0, editor, option, index);
    } else {
      QItemDelegate::updateEditorGeometry(editor, option, index);
    }
  }

  //  [adaptor impl] void QItemDelegate::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QItemDelegate::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QItemDelegate_Adaptor, QChildEvent *>(&QItemDelegate_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QItemDelegate::childEvent(event);
    }
  }

  //  [adaptor impl] void QItemDelegate::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QItemDelegate::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QItemDelegate_Adaptor, QEvent *>(&QItemDelegate_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QItemDelegate::customEvent(event);
    }
  }

  //  [adaptor impl] void QItemDelegate::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QItemDelegate::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QItemDelegate_Adaptor, const QMetaMethod &>(&QItemDelegate_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QItemDelegate::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QItemDelegate::drawCheck(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, Qt::CheckState state)
  void cbs_drawCheck_c8000_0(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, const qt_gsi::Converter<Qt::CheckState>::target_type & state) const
  {
    QItemDelegate::drawCheck(painter, option, rect, qt_gsi::QtToCppAdaptor<Qt::CheckState>(state).cref());
  }

  virtual void drawCheck(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, Qt::CheckState state) const
  {
    if (cb_drawCheck_c8000_0.can_issue()) {
      cb_drawCheck_c8000_0.issue<QItemDelegate_Adaptor, QPainter *, const QStyleOptionViewItem &, const QRect &, const qt_gsi::Converter<Qt::CheckState>::target_type &>(&QItemDelegate_Adaptor::cbs_drawCheck_c8000_0, painter, option, rect, qt_gsi::CppToQtAdaptor<Qt::CheckState>(state));
    } else {
      QItemDelegate::drawCheck(painter, option, rect, state);
    }
  }

  //  [adaptor impl] void QItemDelegate::drawDecoration(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, const QPixmap &pixmap)
  void cbs_drawDecoration_c8277_0(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, const QPixmap &pixmap) const
  {
    QItemDelegate::drawDecoration(painter, option, rect, pixmap);
  }

  virtual void drawDecoration(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, const QPixmap &pixmap) const
  {
    if (cb_drawDecoration_c8277_0.can_issue()) {
      cb_drawDecoration_c8277_0.issue<QItemDelegate_Adaptor, QPainter *, const QStyleOptionViewItem &, const QRect &, const QPixmap &>(&QItemDelegate_Adaptor::cbs_drawDecoration_c8277_0, painter, option, rect, pixmap);
    } else {
      QItemDelegate::drawDecoration(painter, option, rect, pixmap);
    }
  }

  //  [adaptor impl] void QItemDelegate::drawDisplay(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, const QString &text)
  void cbs_drawDisplay_c8285_0(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, const QString &text) const
  {
    QItemDelegate::drawDisplay(painter, option, rect, text);
  }

  virtual void drawDisplay(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, const QString &text) const
  {
    if (cb_drawDisplay_c8285_0.can_issue()) {
      cb_drawDisplay_c8285_0.issue<QItemDelegate_Adaptor, QPainter *, const QStyleOptionViewItem &, const QRect &, const QString &>(&QItemDelegate_Adaptor::cbs_drawDisplay_c8285_0, painter, option, rect, text);
    } else {
      QItemDelegate::drawDisplay(painter, option, rect, text);
    }
  }

  //  [adaptor impl] void QItemDelegate::drawFocus(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect)
  void cbs_drawFocus_c6368_0(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect) const
  {
    QItemDelegate::drawFocus(painter, option, rect);
  }

  virtual void drawFocus(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect) const
  {
    if (cb_drawFocus_c6368_0.can_issue()) {
      cb_drawFocus_c6368_0.issue<QItemDelegate_Adaptor, QPainter *, const QStyleOptionViewItem &, const QRect &>(&QItemDelegate_Adaptor::cbs_drawFocus_c6368_0, painter, option, rect);
    } else {
      QItemDelegate::drawFocus(painter, option, rect);
    }
  }

  //  [adaptor impl] bool QItemDelegate::editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)
  bool cbs_editorEvent_9073_0(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)
  {
    return QItemDelegate::editorEvent(event, model, option, index);
  }

  virtual bool editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)
  {
    if (cb_editorEvent_9073_0.can_issue()) {
      return cb_editorEvent_9073_0.issue<QItemDelegate_Adaptor, bool, QEvent *, QAbstractItemModel *, const QStyleOptionViewItem &, const QModelIndex &>(&QItemDelegate_Adaptor::cbs_editorEvent_9073_0, event, model, option, index);
    } else {
      return QItemDelegate::editorEvent(event, model, option, index);
    }
  }

  //  [adaptor impl] bool QItemDelegate::eventFilter(QObject *object, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *object, QEvent *event)
  {
    return QItemDelegate::eventFilter(object, event);
  }

  virtual bool eventFilter(QObject *object, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QItemDelegate_Adaptor, bool, QObject *, QEvent *>(&QItemDelegate_Adaptor::cbs_eventFilter_2411_0, object, event);
    } else {
      return QItemDelegate::eventFilter(object, event);
    }
  }

  //  [adaptor impl] void QItemDelegate::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QItemDelegate::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QItemDelegate_Adaptor, QTimerEvent *>(&QItemDelegate_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QItemDelegate::timerEvent(event);
    }
  }

  gsi::Callback cb_createEditor_c6860_0;
  gsi::Callback cb_destroyEditor_c3602_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_helpEvent_9380_0;
  gsi::Callback cb_paint_c6971_0;
  gsi::Callback cb_paintingRoles_c0_0;
  gsi::Callback cb_setEditorData_c3602_0;
  gsi::Callback cb_setModelData_c5913_0;
  gsi::Callback cb_sizeHint_c5653_0;
  gsi::Callback cb_updateEditorGeometry_c6860_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_drawCheck_c8000_0;
  gsi::Callback cb_drawDecoration_c8277_0;
  gsi::Callback cb_drawDisplay_c8285_0;
  gsi::Callback cb_drawFocus_c6368_0;
  gsi::Callback cb_editorEvent_9073_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QItemDelegate_Adaptor::~QItemDelegate_Adaptor() { }

//  Constructor QItemDelegate::QItemDelegate(QObject *parent) (adaptor class)

static void _init_ctor_QItemDelegate_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QItemDelegate_Adaptor> ();
}

static void _call_ctor_QItemDelegate_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QItemDelegate_Adaptor *> (new QItemDelegate_Adaptor (arg1));
}


// void QItemDelegate::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemDelegate_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QItemDelegate::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)

static void _init_emitter_closeEditor_4926 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("hint", true, "QAbstractItemDelegate::NoHint");
  decl->add_arg<const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_closeEditor_4926 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & arg2 = args ? gsi::arg_reader<const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & >() (args, heap) : gsi::arg_maker<const qt_gsi::Converter<QAbstractItemDelegate::EndEditHint>::target_type & >() (qt_gsi::CppToQtReadAdaptor<QAbstractItemDelegate::EndEditHint>(heap, QAbstractItemDelegate::NoHint), heap);
  ((QItemDelegate_Adaptor *)cls)->emitter_QItemDelegate_closeEditor_4926 (arg1, arg2);
}


// emitter void QItemDelegate::commitData(QWidget *editor)

static void _init_emitter_commitData_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_commitData_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  ((QItemDelegate_Adaptor *)cls)->emitter_QItemDelegate_commitData_1315 (arg1);
}


// QWidget *QItemDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_createEditor_c6860_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QWidget * > ();
}

static void _call_cbs_createEditor_c6860_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  ret.write<QWidget * > ((QWidget *)((QItemDelegate_Adaptor *)cls)->cbs_createEditor_c6860_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_createEditor_c6860_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_createEditor_c6860_0 = cb;
}


// void QItemDelegate::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemDelegate_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// exposed QPixmap QItemDelegate::decoration(const QStyleOptionViewItem &option, const QVariant &variant)

static void _init_fp_decoration_c5377 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("variant");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<QPixmap > ();
}

static void _call_fp_decoration_c5377 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStyleOptionViewItem &arg1 = gsi::arg_reader<const QStyleOptionViewItem & >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  ret.write<QPixmap > ((QPixmap)((QItemDelegate_Adaptor *)cls)->fp_QItemDelegate_decoration_c5377 (arg1, arg2));
}


// void QItemDelegate::destroyEditor(QWidget *editor, const QModelIndex &index)

static void _init_cbs_destroyEditor_c3602_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_destroyEditor_c3602_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  const QModelIndex &arg2 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemDelegate_Adaptor *)cls)->cbs_destroyEditor_c3602_0 (arg1, arg2);
}

static void _set_callback_cbs_destroyEditor_c3602_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_destroyEditor_c3602_0 = cb;
}


// emitter void QItemDelegate::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QItemDelegate_Adaptor *)cls)->emitter_QItemDelegate_destroyed_1302 (arg1);
}


// void QItemDelegate::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemDelegate_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// exposed QRect QItemDelegate::doCheck(const QStyleOptionViewItem &option, const QRect &bounding, const QVariant &variant)

static void _init_fp_doCheck_c7061 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("bounding");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("variant");
  decl->add_arg<const QVariant & > (argspec_2);
  decl->set_return<QRect > ();
}

static void _call_fp_doCheck_c7061 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStyleOptionViewItem &arg1 = gsi::arg_reader<const QStyleOptionViewItem & >() (args, heap);
  const QRect &arg2 = gsi::arg_reader<const QRect & >() (args, heap);
  const QVariant &arg3 = gsi::arg_reader<const QVariant & >() (args, heap);
  ret.write<QRect > ((QRect)((QItemDelegate_Adaptor *)cls)->fp_QItemDelegate_doCheck_c7061 (arg1, arg2, arg3));
}


// exposed void QItemDelegate::doLayout(const QStyleOptionViewItem &option, QRect *checkRect, QRect *iconRect, QRect *textRect, bool hint)

static void _init_fp_doLayout_c7101 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("checkRect");
  decl->add_arg<QRect * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("iconRect");
  decl->add_arg<QRect * > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("textRect");
  decl->add_arg<QRect * > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("hint");
  decl->add_arg<bool > (argspec_4);
  decl->set_return<void > ();
}

static void _call_fp_doLayout_c7101 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStyleOptionViewItem &arg1 = gsi::arg_reader<const QStyleOptionViewItem & >() (args, heap);
  QRect *arg2 = gsi::arg_reader<QRect * >() (args, heap);
  QRect *arg3 = gsi::arg_reader<QRect * >() (args, heap);
  QRect *arg4 = gsi::arg_reader<QRect * >() (args, heap);
  bool arg5 = gsi::arg_reader<bool >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemDelegate_Adaptor *)cls)->fp_QItemDelegate_doLayout_c7101 (arg1, arg2, arg3, arg4, arg5);
}


// exposed void QItemDelegate::drawBackground(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_fp_drawBackground_c6971 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_drawBackground_c6971 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  const QStyleOptionViewItem &arg2 = gsi::arg_reader<const QStyleOptionViewItem & >() (args, heap);
  const QModelIndex &arg3 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemDelegate_Adaptor *)cls)->fp_QItemDelegate_drawBackground_c6971 (arg1, arg2, arg3);
}


// void QItemDelegate::drawCheck(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, Qt::CheckState state)

static void _init_cbs_drawCheck_c8000_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("rect");
  decl->add_arg<const QRect & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("state");
  decl->add_arg<const qt_gsi::Converter<Qt::CheckState>::target_type & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawCheck_c8000_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > (heap);
  const QRect &arg3 = args.read<const QRect & > (heap);
  const qt_gsi::Converter<Qt::CheckState>::target_type & arg4 = args.read<const qt_gsi::Converter<Qt::CheckState>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemDelegate_Adaptor *)cls)->cbs_drawCheck_c8000_0 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawCheck_c8000_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_drawCheck_c8000_0 = cb;
}


// void QItemDelegate::drawDecoration(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, const QPixmap &pixmap)

static void _init_cbs_drawDecoration_c8277_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("rect");
  decl->add_arg<const QRect & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawDecoration_c8277_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > (heap);
  const QRect &arg3 = args.read<const QRect & > (heap);
  const QPixmap &arg4 = args.read<const QPixmap & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemDelegate_Adaptor *)cls)->cbs_drawDecoration_c8277_0 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawDecoration_c8277_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_drawDecoration_c8277_0 = cb;
}


// void QItemDelegate::drawDisplay(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, const QString &text)

static void _init_cbs_drawDisplay_c8285_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("rect");
  decl->add_arg<const QRect & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("text");
  decl->add_arg<const QString & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_cbs_drawDisplay_c8285_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > (heap);
  const QRect &arg3 = args.read<const QRect & > (heap);
  const QString &arg4 = args.read<const QString & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemDelegate_Adaptor *)cls)->cbs_drawDisplay_c8285_0 (arg1, arg2, arg3, arg4);
}

static void _set_callback_cbs_drawDisplay_c8285_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_drawDisplay_c8285_0 = cb;
}


// void QItemDelegate::drawFocus(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect)

static void _init_cbs_drawFocus_c6368_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("rect");
  decl->add_arg<const QRect & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_drawFocus_c6368_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > (heap);
  const QRect &arg3 = args.read<const QRect & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemDelegate_Adaptor *)cls)->cbs_drawFocus_c6368_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_drawFocus_c6368_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_drawFocus_c6368_0 = cb;
}


// bool QItemDelegate::editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_editorEvent_9073_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("index");
  decl->add_arg<const QModelIndex & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_cbs_editorEvent_9073_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  QAbstractItemModel *arg2 = args.read<QAbstractItemModel * > (heap);
  const QStyleOptionViewItem &arg3 = args.read<const QStyleOptionViewItem & > (heap);
  const QModelIndex &arg4 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QItemDelegate_Adaptor *)cls)->cbs_editorEvent_9073_0 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_editorEvent_9073_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_editorEvent_9073_0 = cb;
}


// bool QItemDelegate::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QItemDelegate_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QItemDelegate::eventFilter(QObject *object, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("object");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QItemDelegate_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// bool QItemDelegate::helpEvent(QHelpEvent *event, QAbstractItemView *view, const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_helpEvent_9380_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QHelpEvent * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("view");
  decl->add_arg<QAbstractItemView * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("index");
  decl->add_arg<const QModelIndex & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_cbs_helpEvent_9380_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QHelpEvent *arg1 = args.read<QHelpEvent * > (heap);
  QAbstractItemView *arg2 = args.read<QAbstractItemView * > (heap);
  const QStyleOptionViewItem &arg3 = args.read<const QStyleOptionViewItem & > (heap);
  const QModelIndex &arg4 = args.read<const QModelIndex & > (heap);
  ret.write<bool > ((bool)((QItemDelegate_Adaptor *)cls)->cbs_helpEvent_9380_0 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_helpEvent_9380_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_helpEvent_9380_0 = cb;
}


// exposed bool QItemDelegate::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QItemDelegate_Adaptor *)cls)->fp_QItemDelegate_isSignalConnected_c2394 (arg1));
}


// emitter void QItemDelegate::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QItemDelegate_Adaptor *)cls)->emitter_QItemDelegate_objectNameChanged_4567 (arg1);
}


// void QItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_paint_c6971_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_paint_c6971_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemDelegate_Adaptor *)cls)->cbs_paint_c6971_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_paint_c6971_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_paint_c6971_0 = cb;
}


// QList<int> QItemDelegate::paintingRoles()

static void _init_cbs_paintingRoles_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<int> > ();
}

static void _call_cbs_paintingRoles_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<int> > ((QList<int>)((QItemDelegate_Adaptor *)cls)->cbs_paintingRoles_c0_0 ());
}

static void _set_callback_cbs_paintingRoles_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_paintingRoles_c0_0 = cb;
}


// exposed int QItemDelegate::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QItemDelegate_Adaptor *)cls)->fp_QItemDelegate_receivers_c1731 (arg1));
}


// exposed QRect QItemDelegate::rect(const QStyleOptionViewItem &option, const QModelIndex &index, int role)

static void _init_fp_rect_c6312 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QRect > ();
}

static void _call_fp_rect_c6312 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStyleOptionViewItem &arg1 = gsi::arg_reader<const QStyleOptionViewItem & >() (args, heap);
  const QModelIndex &arg2 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  int arg3 = gsi::arg_reader<int >() (args, heap);
  ret.write<QRect > ((QRect)((QItemDelegate_Adaptor *)cls)->fp_QItemDelegate_rect_c6312 (arg1, arg2, arg3));
}


// exposed QPixmap QItemDelegate::selectedPixmap(const QPixmap &pixmap, const QPalette &palette, bool enabled)

static void _init_fp_selectedPixmap_4778 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pixmap");
  decl->add_arg<const QPixmap & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("palette");
  decl->add_arg<const QPalette & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("enabled");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_fp_selectedPixmap_4778 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPixmap &arg1 = gsi::arg_reader<const QPixmap & >() (args, heap);
  const QPalette &arg2 = gsi::arg_reader<const QPalette & >() (args, heap);
  bool arg3 = gsi::arg_reader<bool >() (args, heap);
  ret.write<QPixmap > ((QPixmap)QItemDelegate_Adaptor::fp_QItemDelegate_selectedPixmap_4778 (arg1, arg2, arg3));
}


// exposed QObject *QItemDelegate::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QItemDelegate_Adaptor *)cls)->fp_QItemDelegate_sender_c0 ());
}


// exposed int QItemDelegate::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QItemDelegate_Adaptor *)cls)->fp_QItemDelegate_senderSignalIndex_c0 ());
}


// void QItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index)

static void _init_cbs_setEditorData_c3602_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_setEditorData_c3602_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  const QModelIndex &arg2 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemDelegate_Adaptor *)cls)->cbs_setEditorData_c3602_0 (arg1, arg2);
}

static void _set_callback_cbs_setEditorData_c3602_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_setEditorData_c3602_0 = cb;
}


// void QItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index)

static void _init_cbs_setModelData_c5913_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("model");
  decl->add_arg<QAbstractItemModel * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_setModelData_c5913_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  QAbstractItemModel *arg2 = args.read<QAbstractItemModel * > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemDelegate_Adaptor *)cls)->cbs_setModelData_c5913_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_setModelData_c5913_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_setModelData_c5913_0 = cb;
}


// exposed QStyleOptionViewItem QItemDelegate::setOptions(const QModelIndex &index, const QStyleOptionViewItem &option)

static void _init_fp_setOptions_c5653 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  decl->set_return<QStyleOptionViewItem > ();
}

static void _call_fp_setOptions_c5653 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  const QStyleOptionViewItem &arg2 = gsi::arg_reader<const QStyleOptionViewItem & >() (args, heap);
  ret.write<QStyleOptionViewItem > ((QStyleOptionViewItem)((QItemDelegate_Adaptor *)cls)->fp_QItemDelegate_setOptions_c5653 (arg1, arg2));
}


// QSize QItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_sizeHint_c5653_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("index");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c5653_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QStyleOptionViewItem &arg1 = args.read<const QStyleOptionViewItem & > (heap);
  const QModelIndex &arg2 = args.read<const QModelIndex & > (heap);
  ret.write<QSize > ((QSize)((QItemDelegate_Adaptor *)cls)->cbs_sizeHint_c5653_0 (arg1, arg2));
}

static void _set_callback_cbs_sizeHint_c5653_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_sizeHint_c5653_0 = cb;
}


// emitter void QItemDelegate::sizeHintChanged(const QModelIndex &)

static void _init_emitter_sizeHintChanged_2395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_sizeHintChanged_2395 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QModelIndex &arg1 = gsi::arg_reader<const QModelIndex & >() (args, heap);
  ((QItemDelegate_Adaptor *)cls)->emitter_QItemDelegate_sizeHintChanged_2395 (arg1);
}


// exposed QRect QItemDelegate::textRectangle(QPainter *painter, const QRect &rect, const QFont &font, const QString &text)

static void _init_fp_textRectangle_c6720 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("font");
  decl->add_arg<const QFont & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("text");
  decl->add_arg<const QString & > (argspec_3);
  decl->set_return<QRect > ();
}

static void _call_fp_textRectangle_c6720 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = gsi::arg_reader<QPainter * >() (args, heap);
  const QRect &arg2 = gsi::arg_reader<const QRect & >() (args, heap);
  const QFont &arg3 = gsi::arg_reader<const QFont & >() (args, heap);
  const QString &arg4 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QRect > ((QRect)((QItemDelegate_Adaptor *)cls)->fp_QItemDelegate_textRectangle_c6720 (arg1, arg2, arg3, arg4));
}


// void QItemDelegate::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemDelegate_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QItemDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index)

static void _init_cbs_updateEditorGeometry_c6860_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editor");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("option");
  decl->add_arg<const QStyleOptionViewItem & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("index");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_updateEditorGeometry_c6860_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  const QStyleOptionViewItem &arg2 = args.read<const QStyleOptionViewItem & > (heap);
  const QModelIndex &arg3 = args.read<const QModelIndex & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QItemDelegate_Adaptor *)cls)->cbs_updateEditorGeometry_c6860_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_updateEditorGeometry_c6860_0 (void *cls, const gsi::Callback &cb)
{
  ((QItemDelegate_Adaptor *)cls)->cb_updateEditorGeometry_c6860_0 = cb;
}


namespace gsi
{

gsi::Class<QItemDelegate> &qtdecl_QItemDelegate ();

static gsi::Methods methods_QItemDelegate_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QItemDelegate::QItemDelegate(QObject *parent)\nThis method creates an object of class QItemDelegate.", &_init_ctor_QItemDelegate_Adaptor_1302, &_call_ctor_QItemDelegate_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QItemDelegate::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_closeEditor", "@brief Emitter for signal void QItemDelegate::closeEditor(QWidget *editor, QAbstractItemDelegate::EndEditHint hint)\nCall this method to emit this signal.", false, &_init_emitter_closeEditor_4926, &_call_emitter_closeEditor_4926);
  methods += new qt_gsi::GenericMethod ("emit_commitData", "@brief Emitter for signal void QItemDelegate::commitData(QWidget *editor)\nCall this method to emit this signal.", false, &_init_emitter_commitData_1315, &_call_emitter_commitData_1315);
  methods += new qt_gsi::GenericMethod ("createEditor", "@brief Virtual method QWidget *QItemDelegate::createEditor(QWidget *parent, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_createEditor_c6860_0, &_call_cbs_createEditor_c6860_0);
  methods += new qt_gsi::GenericMethod ("createEditor", "@hide", true, &_init_cbs_createEditor_c6860_0, &_call_cbs_createEditor_c6860_0, &_set_callback_cbs_createEditor_c6860_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QItemDelegate::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*decoration", "@brief Method QPixmap QItemDelegate::decoration(const QStyleOptionViewItem &option, const QVariant &variant)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_decoration_c5377, &_call_fp_decoration_c5377);
  methods += new qt_gsi::GenericMethod ("destroyEditor", "@brief Virtual method void QItemDelegate::destroyEditor(QWidget *editor, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_destroyEditor_c3602_0, &_call_cbs_destroyEditor_c3602_0);
  methods += new qt_gsi::GenericMethod ("destroyEditor", "@hide", true, &_init_cbs_destroyEditor_c3602_0, &_call_cbs_destroyEditor_c3602_0, &_set_callback_cbs_destroyEditor_c3602_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QItemDelegate::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QItemDelegate::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*doCheck", "@brief Method QRect QItemDelegate::doCheck(const QStyleOptionViewItem &option, const QRect &bounding, const QVariant &variant)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_doCheck_c7061, &_call_fp_doCheck_c7061);
  methods += new qt_gsi::GenericMethod ("*doLayout", "@brief Method void QItemDelegate::doLayout(const QStyleOptionViewItem &option, QRect *checkRect, QRect *iconRect, QRect *textRect, bool hint)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_doLayout_c7101, &_call_fp_doLayout_c7101);
  methods += new qt_gsi::GenericMethod ("*drawBackground", "@brief Method void QItemDelegate::drawBackground(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_drawBackground_c6971, &_call_fp_drawBackground_c6971);
  methods += new qt_gsi::GenericMethod ("*drawCheck", "@brief Virtual method void QItemDelegate::drawCheck(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, Qt::CheckState state)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawCheck_c8000_0, &_call_cbs_drawCheck_c8000_0);
  methods += new qt_gsi::GenericMethod ("*drawCheck", "@hide", true, &_init_cbs_drawCheck_c8000_0, &_call_cbs_drawCheck_c8000_0, &_set_callback_cbs_drawCheck_c8000_0);
  methods += new qt_gsi::GenericMethod ("*drawDecoration", "@brief Virtual method void QItemDelegate::drawDecoration(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, const QPixmap &pixmap)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawDecoration_c8277_0, &_call_cbs_drawDecoration_c8277_0);
  methods += new qt_gsi::GenericMethod ("*drawDecoration", "@hide", true, &_init_cbs_drawDecoration_c8277_0, &_call_cbs_drawDecoration_c8277_0, &_set_callback_cbs_drawDecoration_c8277_0);
  methods += new qt_gsi::GenericMethod ("*drawDisplay", "@brief Virtual method void QItemDelegate::drawDisplay(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect, const QString &text)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawDisplay_c8285_0, &_call_cbs_drawDisplay_c8285_0);
  methods += new qt_gsi::GenericMethod ("*drawDisplay", "@hide", true, &_init_cbs_drawDisplay_c8285_0, &_call_cbs_drawDisplay_c8285_0, &_set_callback_cbs_drawDisplay_c8285_0);
  methods += new qt_gsi::GenericMethod ("*drawFocus", "@brief Virtual method void QItemDelegate::drawFocus(QPainter *painter, const QStyleOptionViewItem &option, const QRect &rect)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_drawFocus_c6368_0, &_call_cbs_drawFocus_c6368_0);
  methods += new qt_gsi::GenericMethod ("*drawFocus", "@hide", true, &_init_cbs_drawFocus_c6368_0, &_call_cbs_drawFocus_c6368_0, &_set_callback_cbs_drawFocus_c6368_0);
  methods += new qt_gsi::GenericMethod ("*editorEvent", "@brief Virtual method bool QItemDelegate::editorEvent(QEvent *event, QAbstractItemModel *model, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_editorEvent_9073_0, &_call_cbs_editorEvent_9073_0);
  methods += new qt_gsi::GenericMethod ("*editorEvent", "@hide", false, &_init_cbs_editorEvent_9073_0, &_call_cbs_editorEvent_9073_0, &_set_callback_cbs_editorEvent_9073_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QItemDelegate::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QItemDelegate::eventFilter(QObject *object, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("helpEvent", "@brief Virtual method bool QItemDelegate::helpEvent(QHelpEvent *event, QAbstractItemView *view, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_helpEvent_9380_0, &_call_cbs_helpEvent_9380_0);
  methods += new qt_gsi::GenericMethod ("helpEvent", "@hide", false, &_init_cbs_helpEvent_9380_0, &_call_cbs_helpEvent_9380_0, &_set_callback_cbs_helpEvent_9380_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QItemDelegate::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QItemDelegate::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("paint", "@brief Virtual method void QItemDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paint_c6971_0, &_call_cbs_paint_c6971_0);
  methods += new qt_gsi::GenericMethod ("paint", "@hide", true, &_init_cbs_paint_c6971_0, &_call_cbs_paint_c6971_0, &_set_callback_cbs_paint_c6971_0);
  methods += new qt_gsi::GenericMethod ("paintingRoles", "@brief Virtual method QList<int> QItemDelegate::paintingRoles()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintingRoles_c0_0, &_call_cbs_paintingRoles_c0_0);
  methods += new qt_gsi::GenericMethod ("paintingRoles", "@hide", true, &_init_cbs_paintingRoles_c0_0, &_call_cbs_paintingRoles_c0_0, &_set_callback_cbs_paintingRoles_c0_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QItemDelegate::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*rect", "@brief Method QRect QItemDelegate::rect(const QStyleOptionViewItem &option, const QModelIndex &index, int role)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_rect_c6312, &_call_fp_rect_c6312);
  methods += new qt_gsi::GenericStaticMethod ("*selectedPixmap", "@brief Method QPixmap QItemDelegate::selectedPixmap(const QPixmap &pixmap, const QPalette &palette, bool enabled)\nThis method is protected and can only be called from inside a derived class.", &_init_fp_selectedPixmap_4778, &_call_fp_selectedPixmap_4778);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QItemDelegate::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QItemDelegate::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setEditorData", "@brief Virtual method void QItemDelegate::setEditorData(QWidget *editor, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_setEditorData_c3602_0, &_call_cbs_setEditorData_c3602_0);
  methods += new qt_gsi::GenericMethod ("setEditorData", "@hide", true, &_init_cbs_setEditorData_c3602_0, &_call_cbs_setEditorData_c3602_0, &_set_callback_cbs_setEditorData_c3602_0);
  methods += new qt_gsi::GenericMethod ("setModelData", "@brief Virtual method void QItemDelegate::setModelData(QWidget *editor, QAbstractItemModel *model, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_setModelData_c5913_0, &_call_cbs_setModelData_c5913_0);
  methods += new qt_gsi::GenericMethod ("setModelData", "@hide", true, &_init_cbs_setModelData_c5913_0, &_call_cbs_setModelData_c5913_0, &_set_callback_cbs_setModelData_c5913_0);
  methods += new qt_gsi::GenericMethod ("*setOptions", "@brief Method QStyleOptionViewItem QItemDelegate::setOptions(const QModelIndex &index, const QStyleOptionViewItem &option)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_setOptions_c5653, &_call_fp_setOptions_c5653);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QItemDelegate::sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c5653_0, &_call_cbs_sizeHint_c5653_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c5653_0, &_call_cbs_sizeHint_c5653_0, &_set_callback_cbs_sizeHint_c5653_0);
  methods += new qt_gsi::GenericMethod ("emit_sizeHintChanged", "@brief Emitter for signal void QItemDelegate::sizeHintChanged(const QModelIndex &)\nCall this method to emit this signal.", false, &_init_emitter_sizeHintChanged_2395, &_call_emitter_sizeHintChanged_2395);
  methods += new qt_gsi::GenericMethod ("*textRectangle", "@brief Method QRect QItemDelegate::textRectangle(QPainter *painter, const QRect &rect, const QFont &font, const QString &text)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_textRectangle_c6720, &_call_fp_textRectangle_c6720);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QItemDelegate::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("updateEditorGeometry", "@brief Virtual method void QItemDelegate::updateEditorGeometry(QWidget *editor, const QStyleOptionViewItem &option, const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_updateEditorGeometry_c6860_0, &_call_cbs_updateEditorGeometry_c6860_0);
  methods += new qt_gsi::GenericMethod ("updateEditorGeometry", "@hide", true, &_init_cbs_updateEditorGeometry_c6860_0, &_call_cbs_updateEditorGeometry_c6860_0, &_set_callback_cbs_updateEditorGeometry_c6860_0);
  return methods;
}

gsi::Class<QItemDelegate_Adaptor> decl_QItemDelegate_Adaptor (qtdecl_QItemDelegate (), "QtWidgets", "QItemDelegate",
  methods_QItemDelegate_Adaptor (),
  "@qt\n@brief Binding of QItemDelegate");

}

