#!/usr/bin/awk -f

# Copyright (c) 2020 Yubico AB. All rights reserved.
# Use of this source code is governed by a BSD-style
# license that can be found in the LICENSE file.

NR == 1 {
	print "# Copyright (c) 2020 Yubico AB. All rights reserved."
	print "# Use of this source code is governed by a BSD-style"
	print "# license that can be found in the LICENSE file."
	print ""
	print "# This file is automatically generated, and should"
	print "# be used with udev 188 or newer."
	print ""
	print "ACTION!=\"add|change\", GOTO=\"fido_end\""

	next
}

$1 == "vendor" {
	sub("0x", "", $3)
	vendors[$2, "id"] = $3

	f = 4
	while (f <= NF) {
		vendors[$2, "name"] = vendors[$2, "name"] " " $f
		f++
	}
}

$1 == "product" {
	sub("0x", "", $3)
	name = ""

	f = 4
	while (f <= NF) {
		name = name " " $f
		f++
	}

	line = "\n#" name " by" vendors[$2, "name"]"\n"
	line = line"KERNEL==\"hidraw*\""
	line = line", SUBSYSTEM==\"hidraw\""
	line = line", ATTRS{idVendor}==\""vendors[$2, "id"]"\""
	line = line", ATTRS{idProduct}==\""$3"\""
	line = line", TAG+=\"uaccess\""
	line = line", GROUP=\"plugdev\""
	line = line", MODE=\"0660\""

	print line
}

END {
	print "\nLABEL=\"fido_end\""
}
