// Copyright (c) 2019 - 2021, Osamu Watanabe
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
//    modification, are permitted provided that the following conditions are met:
//
// 1. Redistributions of source code must retain the above copyright notice, this
// list of conditions and the following disclaimer.
//
// 2. Redistributions in binary form must reproduce the above copyright notice,
// this list of conditions and the following disclaimer in the documentation
// and/or other materials provided with the distribution.
//
// 3. Neither the name of the copyright holder nor the names of its
// contributors may be used to endorse or promote products derived from
// this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
//    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
//    FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
//    DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
//    SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
//    CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#pragma once

// table entries consist of emb_k(4bit), l_w(3bit), cwd(7bit), from LSB to MSB
static const uint16_t enc_CxtVLC_table0[2048] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0340, 0x1FF1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0030, 0x0000, 0x3FF2, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x08D0, 0x0FF3, 0x2FF2, 0x2FF2,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0130,
    0x0000, 0x0000, 0x0000, 0x09E4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0750, 0x07F5, 0x0000, 0x0000, 0x11E4, 0x11E4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01E0, 0x0000, 0x37F0, 0x0000, 0x37F0, 0x0000, 0x37F0, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x17F0, 0x06E2, 0x27F2, 0x27F2, 0x06E2,
    0x06E2, 0x27F2, 0x27F2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0230, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1EE8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0EE0, 0x16E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x16E0, 0x16E0, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x00D0, 0x0000, 0x3BFA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1AE8,
    0x0000, 0x1AE8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1BF0, 0x2BF1, 0x04E1, 0x2BF1, 0x0000, 0x0000,
    0x0000, 0x0000, 0x04E1, 0x2BF1, 0x04E1, 0x2BF1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0F50, 0x0000, 0x0000,
    0x0000, 0x0AEC, 0x0000, 0x0000, 0x0000, 0x12EC, 0x0000, 0x0000, 0x0000, 0x0BFC, 0x0000, 0x0000, 0x0000,
    0x33F0, 0x13F1, 0x0000, 0x0000, 0x23F5, 0x13F1, 0x0000, 0x0000, 0x03FD, 0x13F1, 0x0000, 0x0000, 0x23F5,
    0x13F1, 0x0000, 0x0000, 0x3DF0, 0x0000, 0x25F2, 0x0000, 0x1DFE, 0x0000, 0x25F2, 0x0000, 0x02EA, 0x0000,
    0x25F2, 0x0000, 0x02EA, 0x0000, 0x25F2, 0x0000, 0x2DF0, 0x19FF, 0x0CEE, 0x0CEE, 0x14EF, 0x05FF, 0x39FE,
    0x39FE, 0x1CEF, 0x0DF9, 0x35FB, 0x0DF9, 0x15FF, 0x0DF9, 0x35FB, 0x0DF9, 0x0020, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0740,
    0x0FF1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0340, 0x0000, 0x1DE2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0DE0, 0x1EE0, 0x1EE0, 0x1EE0, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0540, 0x0000, 0x0000, 0x0000, 0x15E4,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x05E0, 0x3FF5,
    0x0000, 0x0000, 0x19E4, 0x19E4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x09E0, 0x0000, 0x11E0, 0x0000, 0x11E0, 0x0000, 0x11E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x1FF0, 0x01E2, 0x2FF2, 0x2FF2, 0x01E2, 0x01E2, 0x2FF2, 0x2FF2, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0140, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0EE8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x16E0, 0x06E0, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x06E0, 0x06E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x1AE0, 0x0000, 0x37FA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0AE8, 0x0000, 0x0AE8, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x17F0, 0x27F1, 0x08E1, 0x27F1, 0x0000, 0x0000, 0x0000, 0x0000, 0x08E1, 0x27F1,
    0x08E1, 0x27F1, 0x0000, 0x0000, 0x0000, 0x0000, 0x00D0, 0x0000, 0x0000, 0x0000, 0x02EC, 0x0000, 0x0000,
    0x0000, 0x12E8, 0x0000, 0x0000, 0x0000, 0x12E8, 0x0000, 0x0000, 0x0000, 0x07F0, 0x0BF1, 0x0000, 0x0000,
    0x1CE5, 0x0BF1, 0x0000, 0x0000, 0x3BFD, 0x0BF1, 0x0000, 0x0000, 0x1CE5, 0x0BF1, 0x0000, 0x0000, 0x1BF0,
    0x0000, 0x2BF2, 0x0000, 0x33FE, 0x0000, 0x2BF2, 0x0000, 0x0CEA, 0x0000, 0x2BF2, 0x0000, 0x0CEA, 0x0000,
    0x2BF2, 0x0000, 0x03F0, 0x23FF, 0x04EA, 0x04EA, 0x18EE, 0x18EE, 0x04EA, 0x04EA, 0x14EB, 0x13F8, 0x13F8,
    0x13F8, 0x14EB, 0x13F8, 0x13F8, 0x13F8, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0740, 0x0DE1, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0340, 0x0000,
    0x1FF2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x15E0, 0x19E1, 0x3FF3, 0x19E1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0540, 0x0000, 0x0000, 0x0000, 0x05E4, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00D0, 0x09E5, 0x0000, 0x0000, 0x11E5, 0x17F5,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01E0, 0x0000, 0x2FF0,
    0x0000, 0x2FF0, 0x0000, 0x2FF0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0FF0, 0x08E3, 0x37F2, 0x37F2, 0x1BF7, 0x08E3, 0x37F2, 0x37F2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0140, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x27F8, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1EE0, 0x0EE0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0EE0, 0x0EE0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x16E0, 0x0000, 0x06E0, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x06E0, 0x0000, 0x06E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07F0,
    0x1AE2, 0x3BF2, 0x3BF2, 0x0000, 0x0000, 0x0000, 0x0000, 0x1AE2, 0x1AE2, 0x3BF2, 0x3BF2, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0AE0, 0x0000, 0x0000, 0x0000, 0x12E4, 0x0000, 0x0000, 0x0000, 0x2BFC, 0x0000, 0x0000,
    0x0000, 0x12E4, 0x0000, 0x0000, 0x0000, 0x0BF0, 0x33FD, 0x0000, 0x0000, 0x1CEC, 0x1CEC, 0x0000, 0x0000,
    0x02E8, 0x02E8, 0x0000, 0x0000, 0x02E8, 0x02E8, 0x0000, 0x0000, 0x13F0, 0x0000, 0x3DF2, 0x0000, 0x0CE2,
    0x0000, 0x3DF2, 0x0000, 0x0CE2, 0x0000, 0x3DF2, 0x0000, 0x0CE2, 0x0000, 0x3DF2, 0x0000, 0x23F0, 0x14EF,
    0x03F3, 0x04E1, 0x18E7, 0x04E1, 0x03F3, 0x04E1, 0x1DFF, 0x04E1, 0x03F3, 0x04E1, 0x18E7, 0x04E1, 0x03F3,
    0x04E1, 0x0030, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0240, 0x1EE1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0650, 0x0000, 0x27F2, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0EE0, 0x02E1, 0x3FF3,
    0x02E1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0B50, 0x0000, 0x0000, 0x0000, 0x16E4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0350, 0x06E5, 0x0000, 0x0000, 0x1AE5, 0x0D55, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1FF0, 0x0000, 0x0FF6, 0x0000, 0x2FF4, 0x0000, 0x2FF4,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x37F0, 0x12E7, 0x07F7, 0x3BF7,
    0x0AE6, 0x0AE6, 0x17F6, 0x17F6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0550,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x03F8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x1CE0, 0x1BF1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2BF9, 0x1BF1, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0CE0, 0x0000, 0x0BFA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x14E8, 0x0000, 0x14E8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x33F0, 0x13FB, 0x04E3, 0x23F1, 0x0000,
    0x0000, 0x0000, 0x0000, 0x3DFB, 0x23F1, 0x04E3, 0x23F1, 0x0000, 0x0000, 0x0000, 0x0000, 0x18E0, 0x0000,
    0x0000, 0x0000, 0x08E4, 0x0000, 0x0000, 0x0000, 0x1DFC, 0x0000, 0x0000, 0x0000, 0x08E4, 0x0000, 0x0000,
    0x0000, 0x2DF0, 0x10ED, 0x0000, 0x0000, 0x00ED, 0x15FD, 0x0000, 0x0000, 0x25FD, 0x0DF9, 0x0000, 0x0000,
    0x35FD, 0x0DF9, 0x0000, 0x0000, 0x05F0, 0x0000, 0x19FE, 0x0000, 0x39FE, 0x0000, 0x09F4, 0x0000, 0x1F6C,
    0x0000, 0x1F6C, 0x0000, 0x09F4, 0x0000, 0x09F4, 0x0000, 0x29F0, 0x0E5F, 0x176F, 0x21FF, 0x015F, 0x0F6F,
    0x11FE, 0x11FE, 0x095F, 0x31FB, 0x076A, 0x076A, 0x01FF, 0x31FB, 0x076A, 0x076A, 0x0020, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0740, 0x1FF1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0340, 0x0000, 0x0DE2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x15E0, 0x3FF3, 0x1EE2, 0x1EE2, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0540, 0x0000, 0x0000, 0x0000,
    0x2FF4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x05E0,
    0x19E0, 0x0000, 0x0000, 0x19E0, 0x19E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x09E0, 0x0000, 0x11E0, 0x0000, 0x11E0, 0x0000, 0x11E0, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0FF0, 0x01E4, 0x01E4, 0x01E4, 0x37F4, 0x37F4, 0x37F4, 0x37F4,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0140, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0EE8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x08E0, 0x3BF0,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3BF0, 0x3BF0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x00D0, 0x0000, 0x16EA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x06EA, 0x0000, 0x17FA, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x27F0, 0x1AE0, 0x07FB, 0x1AE0, 0x0000, 0x0000, 0x0000, 0x0000, 0x1AE0,
    0x1AE0, 0x1AE0, 0x1AE0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0AE0, 0x0000, 0x0000, 0x0000, 0x1BFC, 0x0000,
    0x0000, 0x0000, 0x12E8, 0x0000, 0x0000, 0x0000, 0x12E8, 0x0000, 0x0000, 0x0000, 0x2BF0, 0x03F1, 0x0000,
    0x0000, 0x02E1, 0x03F1, 0x0000, 0x0000, 0x02E1, 0x03F1, 0x0000, 0x0000, 0x02E1, 0x03F1, 0x0000, 0x0000,
    0x0BF0, 0x0000, 0x33FE, 0x0000, 0x1CE4, 0x0000, 0x1CE4, 0x0000, 0x0CEC, 0x0000, 0x0CEC, 0x0000, 0x1CE4,
    0x0000, 0x1CE4, 0x0000, 0x13F0, 0x14E9, 0x04E7, 0x14E9, 0x1DFF, 0x14E9, 0x3DF7, 0x14E9, 0x18EB, 0x23F9,
    0x04E7, 0x23F9, 0x18EB, 0x23F9, 0x3DF7, 0x23F9, 0x0030, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0D50, 0x3FF1, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0550,
    0x0000, 0x0EE2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x16E0, 0x1FF3, 0x1CE3, 0x2FF3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0950, 0x0000, 0x0000, 0x0000, 0x0FF4, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x06E0, 0x37F5, 0x0000, 0x0000, 0x1AE4,
    0x1AE4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0AE0, 0x0000,
    0x12E2, 0x0000, 0x17F6, 0x0000, 0x12E2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x27F0, 0x1BF7, 0x3BF7, 0x07F7, 0x02E6, 0x02E6, 0x2BF6, 0x2BF6, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0150, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0CE8,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1360, 0x33F9, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0BF8, 0x0BF8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0E50, 0x0000, 0x04EA,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x18EA, 0x0000, 0x14EA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x13F0, 0x3DFB, 0x10EB, 0x23FB, 0x0000, 0x0000, 0x0000, 0x0000, 0x08E9, 0x03F9, 0x08E9, 0x03F9, 0x0000,
    0x0000, 0x0000, 0x0000, 0x00E0, 0x0000, 0x0000, 0x0000, 0x1DFC, 0x0000, 0x0000, 0x0000, 0x1F68, 0x0000,
    0x0000, 0x0000, 0x1F68, 0x0000, 0x0000, 0x0000, 0x2DF0, 0x15FD, 0x0000, 0x0000, 0x176D, 0x0DFD, 0x0000,
    0x0000, 0x0F69, 0x35F9, 0x0000, 0x0000, 0x0F69, 0x35F9, 0x0000, 0x0000, 0x25F0, 0x0000, 0x076E, 0x0000,
    0x29FE, 0x0000, 0x05F6, 0x0000, 0x1B6E, 0x0000, 0x19FE, 0x0000, 0x39FE, 0x0000, 0x05F6, 0x0000, 0x09F0,
    0x036F, 0x025F, 0x3EFF, 0x065F, 0x31F7, 0x0B67, 0x21F7, 0x0A5F, 0x01FD, 0x1EFF, 0x01FD, 0x11FF, 0x31F7,
    0x0B67, 0x21F7, 0x0030, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0240, 0x01E1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0650, 0x0000, 0x06E2, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0D50, 0x0EE3,
    0x16E3, 0x1EE3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0550, 0x0000, 0x0000, 0x0000, 0x1FF4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x1AE0, 0x0AE1, 0x0000, 0x0000, 0x3FF5, 0x0AE1, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x12E0, 0x0000, 0x2FF2, 0x0000, 0x0FF6, 0x0000,
    0x2FF2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x37F0, 0x1B67, 0x3BF7,
    0x17F7, 0x02E6, 0x02E6, 0x27F6, 0x27F6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0950, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x07F8, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x1CE0, 0x1BF1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2BF9, 0x1BF1,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0CE0, 0x0000, 0x14E2, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0BFA, 0x0000, 0x14E2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x33F0, 0x04E9, 0x18EB, 0x04E9,
    0x0000, 0x0000, 0x0000, 0x0000, 0x3DFB, 0x23F9, 0x13FB, 0x23F9, 0x0000, 0x0000, 0x0000, 0x0000, 0x08E0,
    0x0000, 0x0000, 0x0000, 0x1DFC, 0x0000, 0x0000, 0x0000, 0x10EC, 0x0000, 0x0000, 0x0000, 0x03FC, 0x0000,
    0x0000, 0x0000, 0x2DF0, 0x35FD, 0x0000, 0x0000, 0x00E5, 0x19F5, 0x0000, 0x0000, 0x0DFC, 0x0DFC, 0x0000,
    0x0000, 0x00E5, 0x19F5, 0x0000, 0x0000, 0x15F0, 0x0000, 0x25FE, 0x0000, 0x29FE, 0x0000, 0x05F2, 0x0000,
    0x1F6E, 0x0000, 0x05F2, 0x0000, 0x39FE, 0x0000, 0x05F2, 0x0000, 0x09F0, 0x0E5F, 0x015F, 0x076F, 0x136F,
    0x11FF, 0x0F66, 0x0F66, 0x036F, 0x31FB, 0x176E, 0x176E, 0x0B6F, 0x31FB, 0x0F66, 0x0F66, 0x0950, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x02E0, 0x3FF1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x1CE0, 0x0000, 0x1FF2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2FF0, 0x17F3, 0x37F3, 0x0FF3, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x27F0, 0x0000, 0x0000,
    0x0000, 0x07F4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x2BF0, 0x0CE1, 0x0000, 0x0000, 0x3BF5, 0x0CE1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x1BF0, 0x0000, 0x14E0, 0x0000, 0x14E0, 0x0000, 0x14E0, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0BF0, 0x04E7, 0x23F7, 0x13F7, 0x03F7, 0x0DF7, 0x33F6,
    0x33F6, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3DF0, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x1DF8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2DF0,
    0x18E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x18E0, 0x18E0, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x29F0, 0x0000, 0x08E2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x35FA, 0x0000, 0x08E2,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x15F0, 0x39FB, 0x10EB, 0x05FB, 0x0000, 0x0000, 0x0000, 0x0000,
    0x09FB, 0x25F9, 0x19FB, 0x25F9, 0x0000, 0x0000, 0x0000, 0x0000, 0x31F0, 0x0000, 0x0000, 0x0000, 0x21FC,
    0x0000, 0x0000, 0x0000, 0x11F8, 0x0000, 0x0000, 0x0000, 0x11F8, 0x0000, 0x0000, 0x0000, 0x01F0, 0x00ED,
    0x0000, 0x0000, 0x1F6D, 0x2EFD, 0x0000, 0x0000, 0x0EFD, 0x3EF9, 0x0000, 0x0000, 0x1EFD, 0x3EF9, 0x0000,
    0x0000, 0x36F0, 0x0000, 0x0F6E, 0x0000, 0x3AFE, 0x0000, 0x16F6, 0x0000, 0x076E, 0x0000, 0x06FE, 0x0000,
    0x26FE, 0x0000, 0x16F6, 0x0000, 0x0AF0, 0x004F, 0x064F, 0x055F, 0x044F, 0x0D5F, 0x1B6F, 0x2AFF, 0x024F,
    0x176F, 0x015F, 0x12FF, 0x0B6F, 0x1AFF, 0x32FF, 0x035F};

static const uint16_t enc_CxtVLC_table1[2048] = {
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0030, 0x13E1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0330, 0x0000, 0x0BE2, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x06D0, 0x1DE0, 0x1DE0, 0x1DE0,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0130,
    0x0000, 0x0000, 0x0000, 0x03E4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0AD0, 0x15E0, 0x0000, 0x0000, 0x15E0, 0x15E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00D0, 0x0000, 0x3FF0, 0x0000, 0x3FF0, 0x0000, 0x3FF0, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0FF0, 0x0DE0, 0x0DE0, 0x0DE0, 0x0DE0,
    0x0DE0, 0x0DE0, 0x0DE0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0230, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x02D8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0CD0, 0x09E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x09E0, 0x09E0, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x04D0, 0x0000, 0x1FFA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x05E8,
    0x0000, 0x05E8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2FF0, 0x19E0, 0x19E0, 0x19E0, 0x0000, 0x0000,
    0x0000, 0x0000, 0x19E0, 0x19E0, 0x19E0, 0x19E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x08D0, 0x0000, 0x0000,
    0x0000, 0x37FC, 0x0000, 0x0000, 0x0000, 0x11E8, 0x0000, 0x0000, 0x0000, 0x11E8, 0x0000, 0x0000, 0x0000,
    0x07F0, 0x01E0, 0x0000, 0x0000, 0x01E0, 0x01E0, 0x0000, 0x0000, 0x01E0, 0x01E0, 0x0000, 0x0000, 0x01E0,
    0x01E0, 0x0000, 0x0000, 0x17F0, 0x0000, 0x1EE4, 0x0000, 0x27F4, 0x0000, 0x27F4, 0x0000, 0x1EE4, 0x0000,
    0x1EE4, 0x0000, 0x27F4, 0x0000, 0x27F4, 0x0000, 0x3BF0, 0x1BF1, 0x0EE1, 0x1BF1, 0x0EE1, 0x1BF1, 0x0EE1,
    0x1BF1, 0x0EE1, 0x1BF1, 0x0EE1, 0x1BF1, 0x0EE1, 0x1BF1, 0x0EE1, 0x1BF1, 0x0010, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x02C0,
    0x3FF1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x04C0, 0x0000, 0x0FF2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0ED0, 0x1FF1, 0x2FF3, 0x1FF1, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x06D0, 0x0000, 0x0000, 0x0000, 0x1BF4,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01E0, 0x37F0,
    0x0000, 0x0000, 0x37F0, 0x37F0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x17F0, 0x0000, 0x27F0, 0x0000, 0x27F0, 0x0000, 0x27F0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x07F0, 0x3BF0, 0x3BF0, 0x3BF0, 0x3BF0, 0x3BF0, 0x3BF0, 0x3BF0, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00C0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0BF8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x05E0, 0x2BF0, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2BF0, 0x2BF0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x19E0, 0x0000, 0x33F0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x33F0, 0x0000, 0x33F0, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x13F0, 0x15F0, 0x15F0, 0x15F0, 0x0000, 0x0000, 0x0000, 0x0000, 0x15F0, 0x15F0,
    0x15F0, 0x15F0, 0x0000, 0x0000, 0x0000, 0x0000, 0x09E0, 0x0000, 0x0000, 0x0000, 0x23F0, 0x0000, 0x0000,
    0x0000, 0x23F0, 0x0000, 0x0000, 0x0000, 0x23F0, 0x0000, 0x0000, 0x0000, 0x03F0, 0x3DF0, 0x0000, 0x0000,
    0x3DF0, 0x3DF0, 0x0000, 0x0000, 0x3DF0, 0x3DF0, 0x0000, 0x0000, 0x3DF0, 0x3DF0, 0x0000, 0x0000, 0x1DF0,
    0x0000, 0x2DF0, 0x0000, 0x2DF0, 0x0000, 0x2DF0, 0x0000, 0x2DF0, 0x0000, 0x2DF0, 0x0000, 0x2DF0, 0x0000,
    0x2DF0, 0x0000, 0x0DF0, 0x11E4, 0x11E4, 0x11E4, 0x35F4, 0x35F4, 0x35F4, 0x35F4, 0x11E4, 0x11E4, 0x11E4,
    0x11E4, 0x35F4, 0x35F4, 0x35F4, 0x35F4, 0x0010, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x04C0, 0x3FF1, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00C0, 0x0000,
    0x11E2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x1EE0, 0x0FF3, 0x1FF2, 0x1FF2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0AD0, 0x0000, 0x0000, 0x0000, 0x2FF4, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01E0, 0x37F0, 0x0000, 0x0000, 0x37F0, 0x37F0,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x17F0, 0x0000, 0x27F0,
    0x0000, 0x27F0, 0x0000, 0x27F0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x07F0, 0x0BF0, 0x0BF0, 0x0BF0, 0x0BF0, 0x0BF0, 0x0BF0, 0x0BF0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x02D0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3BF8, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1BF0, 0x2BF0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x2BF0, 0x2BF0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0EE0, 0x0000, 0x16EA, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x33FA, 0x0000, 0x3DFA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x13F0,
    0x03F0, 0x23FB, 0x03F0, 0x0000, 0x0000, 0x0000, 0x0000, 0x03F0, 0x03F0, 0x03F0, 0x03F0, 0x0000, 0x0000,
    0x0000, 0x0000, 0x06E0, 0x0000, 0x0000, 0x0000, 0x1DF0, 0x0000, 0x0000, 0x0000, 0x1DF0, 0x0000, 0x0000,
    0x0000, 0x1DF0, 0x0000, 0x0000, 0x0000, 0x2DF0, 0x0DF0, 0x0000, 0x0000, 0x0DF0, 0x0DF0, 0x0000, 0x0000,
    0x0DF0, 0x0DF0, 0x0000, 0x0000, 0x0DF0, 0x0DF0, 0x0000, 0x0000, 0x35F0, 0x0000, 0x25F4, 0x0000, 0x15F4,
    0x0000, 0x15F4, 0x0000, 0x25F4, 0x0000, 0x25F4, 0x0000, 0x15F4, 0x0000, 0x15F4, 0x0000, 0x05F0, 0x19F5,
    0x29F7, 0x19F5, 0x39F4, 0x39F4, 0x39F4, 0x39F4, 0x09FF, 0x19F5, 0x29F7, 0x19F5, 0x39F4, 0x39F4, 0x39F4,
    0x39F4, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0540, 0x05E1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0140, 0x0000, 0x11E2, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0750, 0x09E3, 0x19E3,
    0x3FF3, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0B50, 0x0000, 0x0000, 0x0000, 0x1FF4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x01E0, 0x1EE1, 0x0000, 0x0000, 0x0FF5, 0x1EE1, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0EE0, 0x0000, 0x2FF0, 0x0000, 0x2FF0, 0x0000, 0x2FF0,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x16E0, 0x0F65, 0x37F7, 0x0F65,
    0x17F4, 0x17F4, 0x17F4, 0x17F4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0350,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x27F8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x06E0, 0x1AE0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1AE0, 0x1AE0, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0AE0, 0x0000, 0x12E2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x07FA, 0x0000, 0x12E2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x02E0, 0x3BFB, 0x0CEB, 0x0BFB, 0x0000,
    0x0000, 0x0000, 0x0000, 0x1CE8, 0x1CE8, 0x1CE8, 0x1CE8, 0x0000, 0x0000, 0x0000, 0x0000, 0x14E0, 0x0000,
    0x0000, 0x0000, 0x04E0, 0x0000, 0x0000, 0x0000, 0x04E0, 0x0000, 0x0000, 0x0000, 0x04E0, 0x0000, 0x0000,
    0x0000, 0x1BF0, 0x18E4, 0x0000, 0x0000, 0x2BF4, 0x2BF4, 0x0000, 0x0000, 0x18E4, 0x18E4, 0x0000, 0x0000,
    0x2BF4, 0x2BF4, 0x0000, 0x0000, 0x33F0, 0x0000, 0x35FE, 0x0000, 0x13F4, 0x0000, 0x13F4, 0x0000, 0x23FC,
    0x0000, 0x23FC, 0x0000, 0x13F4, 0x0000, 0x13F4, 0x0000, 0x08E0, 0x1F6F, 0x10EF, 0x3DF7, 0x15FF, 0x0DFF,
    0x03F6, 0x03F6, 0x00EF, 0x2DFA, 0x1DFF, 0x3DF7, 0x2DFA, 0x2DFA, 0x03F6, 0x03F6, 0x0010, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x06D0, 0x3FF1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0AD0, 0x0000, 0x1FF2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x2FF0, 0x37F0, 0x37F0, 0x37F0, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x04C0, 0x0000, 0x0000, 0x0000,
    0x11E4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x19E0,
    0x0FF0, 0x0000, 0x0000, 0x0FF0, 0x0FF0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x09E0, 0x0000, 0x17F0, 0x0000, 0x17F0, 0x0000, 0x17F0, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x27F0, 0x2BF0, 0x2BF0, 0x2BF0, 0x2BF0, 0x2BF0, 0x2BF0, 0x2BF0,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x00C0, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x07F8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x3BF0, 0x1BF0,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1BF0, 0x1BF0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0EE0, 0x0000, 0x0BF0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0BF0, 0x0000, 0x0BF0, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x33F0, 0x35F0, 0x35F0, 0x35F0, 0x0000, 0x0000, 0x0000, 0x0000, 0x35F0,
    0x35F0, 0x35F0, 0x35F0, 0x0000, 0x0000, 0x0000, 0x0000, 0x02D0, 0x0000, 0x0000, 0x0000, 0x03FC, 0x0000,
    0x0000, 0x0000, 0x23FC, 0x0000, 0x0000, 0x0000, 0x13FC, 0x0000, 0x0000, 0x0000, 0x3DF0, 0x1DF0, 0x0000,
    0x0000, 0x1DF0, 0x1DF0, 0x0000, 0x0000, 0x1DF0, 0x1DF0, 0x0000, 0x0000, 0x1DF0, 0x1DF0, 0x0000, 0x0000,
    0x2DF0, 0x0000, 0x0DF2, 0x0000, 0x01E2, 0x0000, 0x0DF2, 0x0000, 0x01E2, 0x0000, 0x0DF2, 0x0000, 0x01E2,
    0x0000, 0x0DF2, 0x0000, 0x15F0, 0x25F1, 0x05F3, 0x25F1, 0x1EE3, 0x25F1, 0x05F3, 0x25F1, 0x1EE3, 0x25F1,
    0x05F3, 0x25F1, 0x1EE3, 0x25F1, 0x05F3, 0x25F1, 0x0020, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0F50, 0x1DE1, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0550,
    0x0000, 0x1FF2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0DE0, 0x05E0, 0x05E0, 0x05E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0140, 0x0000, 0x0000, 0x0000, 0x15E4, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0750, 0x3FF5, 0x0000, 0x0000, 0x19E4,
    0x19E4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x09E0, 0x0000,
    0x37F0, 0x0000, 0x37F0, 0x0000, 0x37F0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x11E0, 0x0AE2, 0x2FF2, 0x2FF2, 0x0AE2, 0x0AE2, 0x2FF2, 0x2FF2, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0B50, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01E8,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1EE0, 0x0FF0, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0FF0, 0x0FF0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0EE0, 0x0000, 0x16E0,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x16E0, 0x0000, 0x16E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x06E0, 0x27F1, 0x1AE1, 0x27F1, 0x0000, 0x0000, 0x0000, 0x0000, 0x1AE1, 0x27F1, 0x1AE1, 0x27F1, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0350, 0x0000, 0x0000, 0x0000, 0x12E4, 0x0000, 0x0000, 0x0000, 0x17FC, 0x0000,
    0x0000, 0x0000, 0x12E4, 0x0000, 0x0000, 0x0000, 0x02E0, 0x3BF1, 0x0000, 0x0000, 0x1CE5, 0x3BF1, 0x0000,
    0x0000, 0x07FD, 0x3BF1, 0x0000, 0x0000, 0x1CE5, 0x3BF1, 0x0000, 0x0000, 0x0CE0, 0x0000, 0x2BF2, 0x0000,
    0x1BFE, 0x0000, 0x2BF2, 0x0000, 0x00EA, 0x0000, 0x2BF2, 0x0000, 0x00EA, 0x0000, 0x2BF2, 0x0000, 0x0D50,
    0x14EF, 0x10EF, 0x03FF, 0x18EF, 0x33FD, 0x13F7, 0x33FD, 0x08EF, 0x0BF9, 0x23FF, 0x0BF9, 0x04EF, 0x0BF9,
    0x13F7, 0x0BF9, 0x0030, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0140, 0x01E1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0640, 0x0000, 0x1EE2, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0EE0, 0x3FF3,
    0x06E2, 0x06E2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0240, 0x0000, 0x0000, 0x0000, 0x16E4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0550, 0x17F5, 0x0000, 0x0000, 0x1AE4, 0x1AE4, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0AE0, 0x0000, 0x1FF2, 0x0000, 0x2FF6, 0x0000,
    0x1FF2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x12E0, 0x0FF3, 0x14E2,
    0x14E2, 0x37F7, 0x0FF3, 0x14E2, 0x14E2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0B50, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x02E8, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x1CE0, 0x0CE0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0CE0, 0x0CE0,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0350, 0x0000, 0x04EA, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x27FA, 0x0000, 0x07FA, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0760, 0x23FB, 0x3BFB, 0x1BF2,
    0x0000, 0x0000, 0x0000, 0x0000, 0x2BFA, 0x2BFA, 0x1BF2, 0x1BF2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0D50,
    0x0000, 0x0000, 0x0000, 0x13FC, 0x0000, 0x0000, 0x0000, 0x33FC, 0x0000, 0x0000, 0x0000, 0x0BFC, 0x0000,
    0x0000, 0x0000, 0x18E0, 0x15FD, 0x0000, 0x0000, 0x03FD, 0x3DF4, 0x0000, 0x0000, 0x1DFC, 0x1DFC, 0x0000,
    0x0000, 0x3DF4, 0x3DF4, 0x0000, 0x0000, 0x08E0, 0x0000, 0x19FE, 0x0000, 0x2DFE, 0x0000, 0x0DF4, 0x0000,
    0x10EE, 0x0000, 0x35FE, 0x0000, 0x0DF4, 0x0000, 0x0DF4, 0x0000, 0x00E0, 0x11FF, 0x1F6F, 0x25F3, 0x176F,
    0x09FF, 0x05F7, 0x25F3, 0x0F6F, 0x29FB, 0x39FF, 0x25F3, 0x31FF, 0x29FB, 0x05F7, 0x25F3, 0x0240, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x19E0, 0x09E1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x11E0, 0x0000, 0x3FF2, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x01E0, 0x1FF1, 0x37F3, 0x1FF1, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x16E0, 0x0000, 0x0000,
    0x0000, 0x2FF4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0B50, 0x1EE1, 0x0000, 0x0000, 0x0FF5, 0x1EE1, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0EE0, 0x0000, 0x3BF0, 0x0000, 0x3BF0, 0x0000, 0x3BF0, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0350, 0x06E7, 0x2BF7, 0x07F7, 0x17F7, 0x27F4, 0x27F4,
    0x27F4, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x1AE0, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x1BF8, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0AE0,
    0x13F0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x13F0, 0x13F0, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x12E0, 0x0000, 0x14E0, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x14E0, 0x0000, 0x14E0,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0D50, 0x0BFB, 0x02E3, 0x33F1, 0x0000, 0x0000, 0x0000, 0x0000,
    0x3DFB, 0x33F1, 0x02E3, 0x33F1, 0x0000, 0x0000, 0x0000, 0x0000, 0x1CE0, 0x0000, 0x0000, 0x0000, 0x0CE0,
    0x0000, 0x0000, 0x0000, 0x0CE0, 0x0000, 0x0000, 0x0000, 0x0CE0, 0x0000, 0x0000, 0x0000, 0x0650, 0x23FD,
    0x0000, 0x0000, 0x04E5, 0x03F1, 0x0000, 0x0000, 0x0DFD, 0x03F1, 0x0000, 0x0000, 0x04E5, 0x03F1, 0x0000,
    0x0000, 0x18E0, 0x0000, 0x1DFE, 0x0000, 0x05FE, 0x0000, 0x2DF2, 0x0000, 0x1F6A, 0x0000, 0x2DF2, 0x0000,
    0x1F6A, 0x0000, 0x2DF2, 0x0000, 0x0030, 0x015F, 0x055F, 0x08EF, 0x0E5F, 0x176F, 0x10E7, 0x15FF, 0x095F,
    0x0F6B, 0x00EF, 0x25FF, 0x076F, 0x0F6B, 0x10E7, 0x35FF};

const uint32_t enc_UVLC_table0[1024] = {
    0x00000000, 0x00000101, 0x00000202, 0x00000404, 0x00000C04, 0x00000008, 0x00000808, 0x00001008,
    0x00001808, 0x00002008, 0x00002808, 0x00003008, 0x00003808, 0x00004008, 0x00004808, 0x00005008,
    0x00005808, 0x00006008, 0x00006808, 0x00007008, 0x00007808, 0x00008008, 0x00008808, 0x00009008,
    0x00009808, 0x0000A008, 0x0000A808, 0x0000B008, 0x0000B808, 0x0000C008, 0x0000C808, 0x0000D008,
    0x00000101, 0x00000302, 0x00000603, 0x00000405, 0x00001405, 0x00000009, 0x00001009, 0x00002009,
    0x00003009, 0x00004009, 0x00005009, 0x00006009, 0x00007009, 0x00008009, 0x00009009, 0x0000A009,
    0x0000B009, 0x0000C009, 0x0000D009, 0x0000E009, 0x0000F009, 0x00010009, 0x00011009, 0x00012009,
    0x00013009, 0x00014009, 0x00015009, 0x00016009, 0x00017009, 0x00018009, 0x00019009, 0x0001A009,
    0x00000202, 0x00000503, 0x00000A04, 0x00000C05, 0x00001C05, 0x00000809, 0x00001809, 0x00002809,
    0x00003809, 0x00004809, 0x00005809, 0x00006809, 0x00007809, 0x00008809, 0x00009809, 0x0000A809,
    0x0000B809, 0x0000C809, 0x0000D809, 0x0000E809, 0x0000F809, 0x00010809, 0x00011809, 0x00012809,
    0x00013809, 0x00014809, 0x00015809, 0x00016809, 0x00017809, 0x00018809, 0x00019809, 0x0001A809,
    0x00000404, 0x00000905, 0x00001206, 0x00000302, 0x00000603, 0x00000C05, 0x00001C05, 0x00000809,
    0x00001809, 0x00002809, 0x00003809, 0x00004809, 0x00005809, 0x00006809, 0x00007809, 0x00008809,
    0x00009809, 0x0000A809, 0x0000B809, 0x0000C809, 0x0000D809, 0x0000E809, 0x0000F809, 0x00010809,
    0x00011809, 0x00012809, 0x00013809, 0x00014809, 0x00015809, 0x00016809, 0x00017809, 0x00018809,
    0x00000C04, 0x00001905, 0x00003206, 0x00000503, 0x00000A04, 0x00001406, 0x00003406, 0x0000100A,
    0x0000300A, 0x0000500A, 0x0000700A, 0x0000900A, 0x0000B00A, 0x0000D00A, 0x0000F00A, 0x0001100A,
    0x0001300A, 0x0001500A, 0x0001700A, 0x0001900A, 0x0001B00A, 0x0001D00A, 0x0001F00A, 0x0002100A,
    0x0002300A, 0x0002500A, 0x0002700A, 0x0002900A, 0x0002B00A, 0x0002D00A, 0x0002F00A, 0x0003100A,
    0x00000008, 0x00000109, 0x0000020A, 0x00000905, 0x00001206, 0x00002408, 0x00006408, 0x0000200C,
    0x0000600C, 0x0000A00C, 0x0000E00C, 0x0001200C, 0x0001600C, 0x0001A00C, 0x0001E00C, 0x0002200C,
    0x0002600C, 0x0002A00C, 0x0002E00C, 0x0003200C, 0x0003600C, 0x0003A00C, 0x0003E00C, 0x0004200C,
    0x0004600C, 0x0004A00C, 0x0004E00C, 0x0005200C, 0x0005600C, 0x0005A00C, 0x0005E00C, 0x0006200C,
    0x00000808, 0x00001109, 0x0000220A, 0x00001905, 0x00003206, 0x0000A408, 0x0000E408, 0x0008200C,
    0x0008600C, 0x0008A00C, 0x0008E00C, 0x0009200C, 0x0009600C, 0x0009A00C, 0x0009E00C, 0x000A200C,
    0x000A600C, 0x000AA00C, 0x000AE00C, 0x000B200C, 0x000B600C, 0x000BA00C, 0x000BE00C, 0x000C200C,
    0x000C600C, 0x000CA00C, 0x000CE00C, 0x000D200C, 0x000D600C, 0x000DA00C, 0x000DE00C, 0x000E200C,
    0x00001008, 0x00002109, 0x0000420A, 0x00000109, 0x0000020A, 0x0000040C, 0x0000440C, 0x00000010,
    0x00004010, 0x00008010, 0x0000C010, 0x00010010, 0x00014010, 0x00018010, 0x0001C010, 0x00020010,
    0x00024010, 0x00028010, 0x0002C010, 0x00030010, 0x00034010, 0x00038010, 0x0003C010, 0x00040010,
    0x00044010, 0x00048010, 0x0004C010, 0x00050010, 0x00054010, 0x00058010, 0x0005C010, 0x00060010,
    0x00001808, 0x00003109, 0x0000620A, 0x00001109, 0x0000220A, 0x0000840C, 0x0000C40C, 0x00080010,
    0x00084010, 0x00088010, 0x0008C010, 0x00090010, 0x00094010, 0x00098010, 0x0009C010, 0x000A0010,
    0x000A4010, 0x000A8010, 0x000AC010, 0x000B0010, 0x000B4010, 0x000B8010, 0x000BC010, 0x000C0010,
    0x000C4010, 0x000C8010, 0x000CC010, 0x000D0010, 0x000D4010, 0x000D8010, 0x000DC010, 0x000E0010,
    0x00002008, 0x00004109, 0x0000820A, 0x00002109, 0x0000420A, 0x0001040C, 0x0001440C, 0x00100010,
    0x00104010, 0x00108010, 0x0010C010, 0x00110010, 0x00114010, 0x00118010, 0x0011C010, 0x00120010,
    0x00124010, 0x00128010, 0x0012C010, 0x00130010, 0x00134010, 0x00138010, 0x0013C010, 0x00140010,
    0x00144010, 0x00148010, 0x0014C010, 0x00150010, 0x00154010, 0x00158010, 0x0015C010, 0x00160010,
    0x00002808, 0x00005109, 0x0000A20A, 0x00003109, 0x0000620A, 0x0001840C, 0x0001C40C, 0x00180010,
    0x00184010, 0x00188010, 0x0018C010, 0x00190010, 0x00194010, 0x00198010, 0x0019C010, 0x001A0010,
    0x001A4010, 0x001A8010, 0x001AC010, 0x001B0010, 0x001B4010, 0x001B8010, 0x001BC010, 0x001C0010,
    0x001C4010, 0x001C8010, 0x001CC010, 0x001D0010, 0x001D4010, 0x001D8010, 0x001DC010, 0x001E0010,
    0x00003008, 0x00006109, 0x0000C20A, 0x00004109, 0x0000820A, 0x0002040C, 0x0002440C, 0x00200010,
    0x00204010, 0x00208010, 0x0020C010, 0x00210010, 0x00214010, 0x00218010, 0x0021C010, 0x00220010,
    0x00224010, 0x00228010, 0x0022C010, 0x00230010, 0x00234010, 0x00238010, 0x0023C010, 0x00240010,
    0x00244010, 0x00248010, 0x0024C010, 0x00250010, 0x00254010, 0x00258010, 0x0025C010, 0x00260010,
    0x00003808, 0x00007109, 0x0000E20A, 0x00005109, 0x0000A20A, 0x0002840C, 0x0002C40C, 0x00280010,
    0x00284010, 0x00288010, 0x0028C010, 0x00290010, 0x00294010, 0x00298010, 0x0029C010, 0x002A0010,
    0x002A4010, 0x002A8010, 0x002AC010, 0x002B0010, 0x002B4010, 0x002B8010, 0x002BC010, 0x002C0010,
    0x002C4010, 0x002C8010, 0x002CC010, 0x002D0010, 0x002D4010, 0x002D8010, 0x002DC010, 0x002E0010,
    0x00004008, 0x00008109, 0x0001020A, 0x00006109, 0x0000C20A, 0x0003040C, 0x0003440C, 0x00300010,
    0x00304010, 0x00308010, 0x0030C010, 0x00310010, 0x00314010, 0x00318010, 0x0031C010, 0x00320010,
    0x00324010, 0x00328010, 0x0032C010, 0x00330010, 0x00334010, 0x00338010, 0x0033C010, 0x00340010,
    0x00344010, 0x00348010, 0x0034C010, 0x00350010, 0x00354010, 0x00358010, 0x0035C010, 0x00360010,
    0x00004808, 0x00009109, 0x0001220A, 0x00007109, 0x0000E20A, 0x0003840C, 0x0003C40C, 0x00380010,
    0x00384010, 0x00388010, 0x0038C010, 0x00390010, 0x00394010, 0x00398010, 0x0039C010, 0x003A0010,
    0x003A4010, 0x003A8010, 0x003AC010, 0x003B0010, 0x003B4010, 0x003B8010, 0x003BC010, 0x003C0010,
    0x003C4010, 0x003C8010, 0x003CC010, 0x003D0010, 0x003D4010, 0x003D8010, 0x003DC010, 0x003E0010,
    0x00005008, 0x0000A109, 0x0001420A, 0x00008109, 0x0001020A, 0x0004040C, 0x0004440C, 0x00400010,
    0x00404010, 0x00408010, 0x0040C010, 0x00410010, 0x00414010, 0x00418010, 0x0041C010, 0x00420010,
    0x00424010, 0x00428010, 0x0042C010, 0x00430010, 0x00434010, 0x00438010, 0x0043C010, 0x00440010,
    0x00444010, 0x00448010, 0x0044C010, 0x00450010, 0x00454010, 0x00458010, 0x0045C010, 0x00460010,
    0x00005808, 0x0000B109, 0x0001620A, 0x00009109, 0x0001220A, 0x0004840C, 0x0004C40C, 0x00480010,
    0x00484010, 0x00488010, 0x0048C010, 0x00490010, 0x00494010, 0x00498010, 0x0049C010, 0x004A0010,
    0x004A4010, 0x004A8010, 0x004AC010, 0x004B0010, 0x004B4010, 0x004B8010, 0x004BC010, 0x004C0010,
    0x004C4010, 0x004C8010, 0x004CC010, 0x004D0010, 0x004D4010, 0x004D8010, 0x004DC010, 0x004E0010,
    0x00006008, 0x0000C109, 0x0001820A, 0x0000A109, 0x0001420A, 0x0005040C, 0x0005440C, 0x00500010,
    0x00504010, 0x00508010, 0x0050C010, 0x00510010, 0x00514010, 0x00518010, 0x0051C010, 0x00520010,
    0x00524010, 0x00528010, 0x0052C010, 0x00530010, 0x00534010, 0x00538010, 0x0053C010, 0x00540010,
    0x00544010, 0x00548010, 0x0054C010, 0x00550010, 0x00554010, 0x00558010, 0x0055C010, 0x00560010,
    0x00006808, 0x0000D109, 0x0001A20A, 0x0000B109, 0x0001620A, 0x0005840C, 0x0005C40C, 0x00580010,
    0x00584010, 0x00588010, 0x0058C010, 0x00590010, 0x00594010, 0x00598010, 0x0059C010, 0x005A0010,
    0x005A4010, 0x005A8010, 0x005AC010, 0x005B0010, 0x005B4010, 0x005B8010, 0x005BC010, 0x005C0010,
    0x005C4010, 0x005C8010, 0x005CC010, 0x005D0010, 0x005D4010, 0x005D8010, 0x005DC010, 0x005E0010,
    0x00007008, 0x0000E109, 0x0001C20A, 0x0000C109, 0x0001820A, 0x0006040C, 0x0006440C, 0x00600010,
    0x00604010, 0x00608010, 0x0060C010, 0x00610010, 0x00614010, 0x00618010, 0x0061C010, 0x00620010,
    0x00624010, 0x00628010, 0x0062C010, 0x00630010, 0x00634010, 0x00638010, 0x0063C010, 0x00640010,
    0x00644010, 0x00648010, 0x0064C010, 0x00650010, 0x00654010, 0x00658010, 0x0065C010, 0x00660010,
    0x00007808, 0x0000F109, 0x0001E20A, 0x0000D109, 0x0001A20A, 0x0006840C, 0x0006C40C, 0x00680010,
    0x00684010, 0x00688010, 0x0068C010, 0x00690010, 0x00694010, 0x00698010, 0x0069C010, 0x006A0010,
    0x006A4010, 0x006A8010, 0x006AC010, 0x006B0010, 0x006B4010, 0x006B8010, 0x006BC010, 0x006C0010,
    0x006C4010, 0x006C8010, 0x006CC010, 0x006D0010, 0x006D4010, 0x006D8010, 0x006DC010, 0x006E0010,
    0x00008008, 0x00010109, 0x0002020A, 0x0000E109, 0x0001C20A, 0x0007040C, 0x0007440C, 0x00700010,
    0x00704010, 0x00708010, 0x0070C010, 0x00710010, 0x00714010, 0x00718010, 0x0071C010, 0x00720010,
    0x00724010, 0x00728010, 0x0072C010, 0x00730010, 0x00734010, 0x00738010, 0x0073C010, 0x00740010,
    0x00744010, 0x00748010, 0x0074C010, 0x00750010, 0x00754010, 0x00758010, 0x0075C010, 0x00760010,
    0x00008808, 0x00011109, 0x0002220A, 0x0000F109, 0x0001E20A, 0x0007840C, 0x0007C40C, 0x00780010,
    0x00784010, 0x00788010, 0x0078C010, 0x00790010, 0x00794010, 0x00798010, 0x0079C010, 0x007A0010,
    0x007A4010, 0x007A8010, 0x007AC010, 0x007B0010, 0x007B4010, 0x007B8010, 0x007BC010, 0x007C0010,
    0x007C4010, 0x007C8010, 0x007CC010, 0x007D0010, 0x007D4010, 0x007D8010, 0x007DC010, 0x007E0010,
    0x00009008, 0x00012109, 0x0002420A, 0x00010109, 0x0002020A, 0x0008040C, 0x0008440C, 0x00800010,
    0x00804010, 0x00808010, 0x0080C010, 0x00810010, 0x00814010, 0x00818010, 0x0081C010, 0x00820010,
    0x00824010, 0x00828010, 0x0082C010, 0x00830010, 0x00834010, 0x00838010, 0x0083C010, 0x00840010,
    0x00844010, 0x00848010, 0x0084C010, 0x00850010, 0x00854010, 0x00858010, 0x0085C010, 0x00860010,
    0x00009808, 0x00013109, 0x0002620A, 0x00011109, 0x0002220A, 0x0008840C, 0x0008C40C, 0x00880010,
    0x00884010, 0x00888010, 0x0088C010, 0x00890010, 0x00894010, 0x00898010, 0x0089C010, 0x008A0010,
    0x008A4010, 0x008A8010, 0x008AC010, 0x008B0010, 0x008B4010, 0x008B8010, 0x008BC010, 0x008C0010,
    0x008C4010, 0x008C8010, 0x008CC010, 0x008D0010, 0x008D4010, 0x008D8010, 0x008DC010, 0x008E0010,
    0x0000A008, 0x00014109, 0x0002820A, 0x00012109, 0x0002420A, 0x0009040C, 0x0009440C, 0x00900010,
    0x00904010, 0x00908010, 0x0090C010, 0x00910010, 0x00914010, 0x00918010, 0x0091C010, 0x00920010,
    0x00924010, 0x00928010, 0x0092C010, 0x00930010, 0x00934010, 0x00938010, 0x0093C010, 0x00940010,
    0x00944010, 0x00948010, 0x0094C010, 0x00950010, 0x00954010, 0x00958010, 0x0095C010, 0x00960010,
    0x0000A808, 0x00015109, 0x0002A20A, 0x00013109, 0x0002620A, 0x0009840C, 0x0009C40C, 0x00980010,
    0x00984010, 0x00988010, 0x0098C010, 0x00990010, 0x00994010, 0x00998010, 0x0099C010, 0x009A0010,
    0x009A4010, 0x009A8010, 0x009AC010, 0x009B0010, 0x009B4010, 0x009B8010, 0x009BC010, 0x009C0010,
    0x009C4010, 0x009C8010, 0x009CC010, 0x009D0010, 0x009D4010, 0x009D8010, 0x009DC010, 0x009E0010,
    0x0000B008, 0x00016109, 0x0002C20A, 0x00014109, 0x0002820A, 0x000A040C, 0x000A440C, 0x00A00010,
    0x00A04010, 0x00A08010, 0x00A0C010, 0x00A10010, 0x00A14010, 0x00A18010, 0x00A1C010, 0x00A20010,
    0x00A24010, 0x00A28010, 0x00A2C010, 0x00A30010, 0x00A34010, 0x00A38010, 0x00A3C010, 0x00A40010,
    0x00A44010, 0x00A48010, 0x00A4C010, 0x00A50010, 0x00A54010, 0x00A58010, 0x00A5C010, 0x00A60010,
    0x0000B808, 0x00017109, 0x0002E20A, 0x00015109, 0x0002A20A, 0x000A840C, 0x000AC40C, 0x00A80010,
    0x00A84010, 0x00A88010, 0x00A8C010, 0x00A90010, 0x00A94010, 0x00A98010, 0x00A9C010, 0x00AA0010,
    0x00AA4010, 0x00AA8010, 0x00AAC010, 0x00AB0010, 0x00AB4010, 0x00AB8010, 0x00ABC010, 0x00AC0010,
    0x00AC4010, 0x00AC8010, 0x00ACC010, 0x00AD0010, 0x00AD4010, 0x00AD8010, 0x00ADC010, 0x00AE0010,
    0x0000C008, 0x00018109, 0x0003020A, 0x00016109, 0x0002C20A, 0x000B040C, 0x000B440C, 0x00B00010,
    0x00B04010, 0x00B08010, 0x00B0C010, 0x00B10010, 0x00B14010, 0x00B18010, 0x00B1C010, 0x00B20010,
    0x00B24010, 0x00B28010, 0x00B2C010, 0x00B30010, 0x00B34010, 0x00B38010, 0x00B3C010, 0x00B40010,
    0x00B44010, 0x00B48010, 0x00B4C010, 0x00B50010, 0x00B54010, 0x00B58010, 0x00B5C010, 0x00B60010,
    0x0000C808, 0x00019109, 0x0003220A, 0x00017109, 0x0002E20A, 0x000B840C, 0x000BC40C, 0x00B80010,
    0x00B84010, 0x00B88010, 0x00B8C010, 0x00B90010, 0x00B94010, 0x00B98010, 0x00B9C010, 0x00BA0010,
    0x00BA4010, 0x00BA8010, 0x00BAC010, 0x00BB0010, 0x00BB4010, 0x00BB8010, 0x00BBC010, 0x00BC0010,
    0x00BC4010, 0x00BC8010, 0x00BCC010, 0x00BD0010, 0x00BD4010, 0x00BD8010, 0x00BDC010, 0x00BE0010,
    0x0000D008, 0x0001A109, 0x0003420A, 0x00018109, 0x0003020A, 0x000C040C, 0x000C440C, 0x00C00010,
    0x00C04010, 0x00C08010, 0x00C0C010, 0x00C10010, 0x00C14010, 0x00C18010, 0x00C1C010, 0x00C20010,
    0x00C24010, 0x00C28010, 0x00C2C010, 0x00C30010, 0x00C34010, 0x00C38010, 0x00C3C010, 0x00C40010,
    0x00C44010, 0x00C48010, 0x00C4C010, 0x00C50010, 0x00C54010, 0x00C58010, 0x00C5C010, 0x00C60010};

const uint32_t enc_UVLC_table1[1024] = {
    0x00000000, 0x00000101, 0x00000202, 0x00000404, 0x00000C04, 0x00000008, 0x00000808, 0x00001008,
    0x00001808, 0x00002008, 0x00002808, 0x00003008, 0x00003808, 0x00004008, 0x00004808, 0x00005008,
    0x00005808, 0x00006008, 0x00006808, 0x00007008, 0x00007808, 0x00008008, 0x00008808, 0x00009008,
    0x00009808, 0x0000A008, 0x0000A808, 0x0000B008, 0x0000B808, 0x0000C008, 0x0000C808, 0x0000D008,
    0x00000101, 0x00000302, 0x00000603, 0x00000C05, 0x00001C05, 0x00000809, 0x00001809, 0x00002809,
    0x00003809, 0x00004809, 0x00005809, 0x00006809, 0x00007809, 0x00008809, 0x00009809, 0x0000A809,
    0x0000B809, 0x0000C809, 0x0000D809, 0x0000E809, 0x0000F809, 0x00010809, 0x00011809, 0x00012809,
    0x00013809, 0x00014809, 0x00015809, 0x00016809, 0x00017809, 0x00018809, 0x00019809, 0x0001A809,
    0x00000202, 0x00000503, 0x00000A04, 0x00001406, 0x00003406, 0x0000100A, 0x0000300A, 0x0000500A,
    0x0000700A, 0x0000900A, 0x0000B00A, 0x0000D00A, 0x0000F00A, 0x0001100A, 0x0001300A, 0x0001500A,
    0x0001700A, 0x0001900A, 0x0001B00A, 0x0001D00A, 0x0001F00A, 0x0002100A, 0x0002300A, 0x0002500A,
    0x0002700A, 0x0002900A, 0x0002B00A, 0x0002D00A, 0x0002F00A, 0x0003100A, 0x0003300A, 0x0003500A,
    0x00000404, 0x00000905, 0x00001206, 0x00002408, 0x00006408, 0x0000200C, 0x0000600C, 0x0000A00C,
    0x0000E00C, 0x0001200C, 0x0001600C, 0x0001A00C, 0x0001E00C, 0x0002200C, 0x0002600C, 0x0002A00C,
    0x0002E00C, 0x0003200C, 0x0003600C, 0x0003A00C, 0x0003E00C, 0x0004200C, 0x0004600C, 0x0004A00C,
    0x0004E00C, 0x0005200C, 0x0005600C, 0x0005A00C, 0x0005E00C, 0x0006200C, 0x0006600C, 0x0006A00C,
    0x00000C04, 0x00001905, 0x00003206, 0x0000A408, 0x0000E408, 0x0008200C, 0x0008600C, 0x0008A00C,
    0x0008E00C, 0x0009200C, 0x0009600C, 0x0009A00C, 0x0009E00C, 0x000A200C, 0x000A600C, 0x000AA00C,
    0x000AE00C, 0x000B200C, 0x000B600C, 0x000BA00C, 0x000BE00C, 0x000C200C, 0x000C600C, 0x000CA00C,
    0x000CE00C, 0x000D200C, 0x000D600C, 0x000DA00C, 0x000DE00C, 0x000E200C, 0x000E600C, 0x000EA00C,
    0x00000008, 0x00000109, 0x0000020A, 0x0000040C, 0x0000440C, 0x00000010, 0x00004010, 0x00008010,
    0x0000C010, 0x00010010, 0x00014010, 0x00018010, 0x0001C010, 0x00020010, 0x00024010, 0x00028010,
    0x0002C010, 0x00030010, 0x00034010, 0x00038010, 0x0003C010, 0x00040010, 0x00044010, 0x00048010,
    0x0004C010, 0x00050010, 0x00054010, 0x00058010, 0x0005C010, 0x00060010, 0x00064010, 0x00068010,
    0x00000808, 0x00001109, 0x0000220A, 0x0000840C, 0x0000C40C, 0x00080010, 0x00084010, 0x00088010,
    0x0008C010, 0x00090010, 0x00094010, 0x00098010, 0x0009C010, 0x000A0010, 0x000A4010, 0x000A8010,
    0x000AC010, 0x000B0010, 0x000B4010, 0x000B8010, 0x000BC010, 0x000C0010, 0x000C4010, 0x000C8010,
    0x000CC010, 0x000D0010, 0x000D4010, 0x000D8010, 0x000DC010, 0x000E0010, 0x000E4010, 0x000E8010,
    0x00001008, 0x00002109, 0x0000420A, 0x0001040C, 0x0001440C, 0x00100010, 0x00104010, 0x00108010,
    0x0010C010, 0x00110010, 0x00114010, 0x00118010, 0x0011C010, 0x00120010, 0x00124010, 0x00128010,
    0x0012C010, 0x00130010, 0x00134010, 0x00138010, 0x0013C010, 0x00140010, 0x00144010, 0x00148010,
    0x0014C010, 0x00150010, 0x00154010, 0x00158010, 0x0015C010, 0x00160010, 0x00164010, 0x00168010,
    0x00001808, 0x00003109, 0x0000620A, 0x0001840C, 0x0001C40C, 0x00180010, 0x00184010, 0x00188010,
    0x0018C010, 0x00190010, 0x00194010, 0x00198010, 0x0019C010, 0x001A0010, 0x001A4010, 0x001A8010,
    0x001AC010, 0x001B0010, 0x001B4010, 0x001B8010, 0x001BC010, 0x001C0010, 0x001C4010, 0x001C8010,
    0x001CC010, 0x001D0010, 0x001D4010, 0x001D8010, 0x001DC010, 0x001E0010, 0x001E4010, 0x001E8010,
    0x00002008, 0x00004109, 0x0000820A, 0x0002040C, 0x0002440C, 0x00200010, 0x00204010, 0x00208010,
    0x0020C010, 0x00210010, 0x00214010, 0x00218010, 0x0021C010, 0x00220010, 0x00224010, 0x00228010,
    0x0022C010, 0x00230010, 0x00234010, 0x00238010, 0x0023C010, 0x00240010, 0x00244010, 0x00248010,
    0x0024C010, 0x00250010, 0x00254010, 0x00258010, 0x0025C010, 0x00260010, 0x00264010, 0x00268010,
    0x00002808, 0x00005109, 0x0000A20A, 0x0002840C, 0x0002C40C, 0x00280010, 0x00284010, 0x00288010,
    0x0028C010, 0x00290010, 0x00294010, 0x00298010, 0x0029C010, 0x002A0010, 0x002A4010, 0x002A8010,
    0x002AC010, 0x002B0010, 0x002B4010, 0x002B8010, 0x002BC010, 0x002C0010, 0x002C4010, 0x002C8010,
    0x002CC010, 0x002D0010, 0x002D4010, 0x002D8010, 0x002DC010, 0x002E0010, 0x002E4010, 0x002E8010,
    0x00003008, 0x00006109, 0x0000C20A, 0x0003040C, 0x0003440C, 0x00300010, 0x00304010, 0x00308010,
    0x0030C010, 0x00310010, 0x00314010, 0x00318010, 0x0031C010, 0x00320010, 0x00324010, 0x00328010,
    0x0032C010, 0x00330010, 0x00334010, 0x00338010, 0x0033C010, 0x00340010, 0x00344010, 0x00348010,
    0x0034C010, 0x00350010, 0x00354010, 0x00358010, 0x0035C010, 0x00360010, 0x00364010, 0x00368010,
    0x00003808, 0x00007109, 0x0000E20A, 0x0003840C, 0x0003C40C, 0x00380010, 0x00384010, 0x00388010,
    0x0038C010, 0x00390010, 0x00394010, 0x00398010, 0x0039C010, 0x003A0010, 0x003A4010, 0x003A8010,
    0x003AC010, 0x003B0010, 0x003B4010, 0x003B8010, 0x003BC010, 0x003C0010, 0x003C4010, 0x003C8010,
    0x003CC010, 0x003D0010, 0x003D4010, 0x003D8010, 0x003DC010, 0x003E0010, 0x003E4010, 0x003E8010,
    0x00004008, 0x00008109, 0x0001020A, 0x0004040C, 0x0004440C, 0x00400010, 0x00404010, 0x00408010,
    0x0040C010, 0x00410010, 0x00414010, 0x00418010, 0x0041C010, 0x00420010, 0x00424010, 0x00428010,
    0x0042C010, 0x00430010, 0x00434010, 0x00438010, 0x0043C010, 0x00440010, 0x00444010, 0x00448010,
    0x0044C010, 0x00450010, 0x00454010, 0x00458010, 0x0045C010, 0x00460010, 0x00464010, 0x00468010,
    0x00004808, 0x00009109, 0x0001220A, 0x0004840C, 0x0004C40C, 0x00480010, 0x00484010, 0x00488010,
    0x0048C010, 0x00490010, 0x00494010, 0x00498010, 0x0049C010, 0x004A0010, 0x004A4010, 0x004A8010,
    0x004AC010, 0x004B0010, 0x004B4010, 0x004B8010, 0x004BC010, 0x004C0010, 0x004C4010, 0x004C8010,
    0x004CC010, 0x004D0010, 0x004D4010, 0x004D8010, 0x004DC010, 0x004E0010, 0x004E4010, 0x004E8010,
    0x00005008, 0x0000A109, 0x0001420A, 0x0005040C, 0x0005440C, 0x00500010, 0x00504010, 0x00508010,
    0x0050C010, 0x00510010, 0x00514010, 0x00518010, 0x0051C010, 0x00520010, 0x00524010, 0x00528010,
    0x0052C010, 0x00530010, 0x00534010, 0x00538010, 0x0053C010, 0x00540010, 0x00544010, 0x00548010,
    0x0054C010, 0x00550010, 0x00554010, 0x00558010, 0x0055C010, 0x00560010, 0x00564010, 0x00568010,
    0x00005808, 0x0000B109, 0x0001620A, 0x0005840C, 0x0005C40C, 0x00580010, 0x00584010, 0x00588010,
    0x0058C010, 0x00590010, 0x00594010, 0x00598010, 0x0059C010, 0x005A0010, 0x005A4010, 0x005A8010,
    0x005AC010, 0x005B0010, 0x005B4010, 0x005B8010, 0x005BC010, 0x005C0010, 0x005C4010, 0x005C8010,
    0x005CC010, 0x005D0010, 0x005D4010, 0x005D8010, 0x005DC010, 0x005E0010, 0x005E4010, 0x005E8010,
    0x00006008, 0x0000C109, 0x0001820A, 0x0006040C, 0x0006440C, 0x00600010, 0x00604010, 0x00608010,
    0x0060C010, 0x00610010, 0x00614010, 0x00618010, 0x0061C010, 0x00620010, 0x00624010, 0x00628010,
    0x0062C010, 0x00630010, 0x00634010, 0x00638010, 0x0063C010, 0x00640010, 0x00644010, 0x00648010,
    0x0064C010, 0x00650010, 0x00654010, 0x00658010, 0x0065C010, 0x00660010, 0x00664010, 0x00668010,
    0x00006808, 0x0000D109, 0x0001A20A, 0x0006840C, 0x0006C40C, 0x00680010, 0x00684010, 0x00688010,
    0x0068C010, 0x00690010, 0x00694010, 0x00698010, 0x0069C010, 0x006A0010, 0x006A4010, 0x006A8010,
    0x006AC010, 0x006B0010, 0x006B4010, 0x006B8010, 0x006BC010, 0x006C0010, 0x006C4010, 0x006C8010,
    0x006CC010, 0x006D0010, 0x006D4010, 0x006D8010, 0x006DC010, 0x006E0010, 0x006E4010, 0x006E8010,
    0x00007008, 0x0000E109, 0x0001C20A, 0x0007040C, 0x0007440C, 0x00700010, 0x00704010, 0x00708010,
    0x0070C010, 0x00710010, 0x00714010, 0x00718010, 0x0071C010, 0x00720010, 0x00724010, 0x00728010,
    0x0072C010, 0x00730010, 0x00734010, 0x00738010, 0x0073C010, 0x00740010, 0x00744010, 0x00748010,
    0x0074C010, 0x00750010, 0x00754010, 0x00758010, 0x0075C010, 0x00760010, 0x00764010, 0x00768010,
    0x00007808, 0x0000F109, 0x0001E20A, 0x0007840C, 0x0007C40C, 0x00780010, 0x00784010, 0x00788010,
    0x0078C010, 0x00790010, 0x00794010, 0x00798010, 0x0079C010, 0x007A0010, 0x007A4010, 0x007A8010,
    0x007AC010, 0x007B0010, 0x007B4010, 0x007B8010, 0x007BC010, 0x007C0010, 0x007C4010, 0x007C8010,
    0x007CC010, 0x007D0010, 0x007D4010, 0x007D8010, 0x007DC010, 0x007E0010, 0x007E4010, 0x007E8010,
    0x00008008, 0x00010109, 0x0002020A, 0x0008040C, 0x0008440C, 0x00800010, 0x00804010, 0x00808010,
    0x0080C010, 0x00810010, 0x00814010, 0x00818010, 0x0081C010, 0x00820010, 0x00824010, 0x00828010,
    0x0082C010, 0x00830010, 0x00834010, 0x00838010, 0x0083C010, 0x00840010, 0x00844010, 0x00848010,
    0x0084C010, 0x00850010, 0x00854010, 0x00858010, 0x0085C010, 0x00860010, 0x00864010, 0x00868010,
    0x00008808, 0x00011109, 0x0002220A, 0x0008840C, 0x0008C40C, 0x00880010, 0x00884010, 0x00888010,
    0x0088C010, 0x00890010, 0x00894010, 0x00898010, 0x0089C010, 0x008A0010, 0x008A4010, 0x008A8010,
    0x008AC010, 0x008B0010, 0x008B4010, 0x008B8010, 0x008BC010, 0x008C0010, 0x008C4010, 0x008C8010,
    0x008CC010, 0x008D0010, 0x008D4010, 0x008D8010, 0x008DC010, 0x008E0010, 0x008E4010, 0x008E8010,
    0x00009008, 0x00012109, 0x0002420A, 0x0009040C, 0x0009440C, 0x00900010, 0x00904010, 0x00908010,
    0x0090C010, 0x00910010, 0x00914010, 0x00918010, 0x0091C010, 0x00920010, 0x00924010, 0x00928010,
    0x0092C010, 0x00930010, 0x00934010, 0x00938010, 0x0093C010, 0x00940010, 0x00944010, 0x00948010,
    0x0094C010, 0x00950010, 0x00954010, 0x00958010, 0x0095C010, 0x00960010, 0x00964010, 0x00968010,
    0x00009808, 0x00013109, 0x0002620A, 0x0009840C, 0x0009C40C, 0x00980010, 0x00984010, 0x00988010,
    0x0098C010, 0x00990010, 0x00994010, 0x00998010, 0x0099C010, 0x009A0010, 0x009A4010, 0x009A8010,
    0x009AC010, 0x009B0010, 0x009B4010, 0x009B8010, 0x009BC010, 0x009C0010, 0x009C4010, 0x009C8010,
    0x009CC010, 0x009D0010, 0x009D4010, 0x009D8010, 0x009DC010, 0x009E0010, 0x009E4010, 0x009E8010,
    0x0000A008, 0x00014109, 0x0002820A, 0x000A040C, 0x000A440C, 0x00A00010, 0x00A04010, 0x00A08010,
    0x00A0C010, 0x00A10010, 0x00A14010, 0x00A18010, 0x00A1C010, 0x00A20010, 0x00A24010, 0x00A28010,
    0x00A2C010, 0x00A30010, 0x00A34010, 0x00A38010, 0x00A3C010, 0x00A40010, 0x00A44010, 0x00A48010,
    0x00A4C010, 0x00A50010, 0x00A54010, 0x00A58010, 0x00A5C010, 0x00A60010, 0x00A64010, 0x00A68010,
    0x0000A808, 0x00015109, 0x0002A20A, 0x000A840C, 0x000AC40C, 0x00A80010, 0x00A84010, 0x00A88010,
    0x00A8C010, 0x00A90010, 0x00A94010, 0x00A98010, 0x00A9C010, 0x00AA0010, 0x00AA4010, 0x00AA8010,
    0x00AAC010, 0x00AB0010, 0x00AB4010, 0x00AB8010, 0x00ABC010, 0x00AC0010, 0x00AC4010, 0x00AC8010,
    0x00ACC010, 0x00AD0010, 0x00AD4010, 0x00AD8010, 0x00ADC010, 0x00AE0010, 0x00AE4010, 0x00AE8010,
    0x0000B008, 0x00016109, 0x0002C20A, 0x000B040C, 0x000B440C, 0x00B00010, 0x00B04010, 0x00B08010,
    0x00B0C010, 0x00B10010, 0x00B14010, 0x00B18010, 0x00B1C010, 0x00B20010, 0x00B24010, 0x00B28010,
    0x00B2C010, 0x00B30010, 0x00B34010, 0x00B38010, 0x00B3C010, 0x00B40010, 0x00B44010, 0x00B48010,
    0x00B4C010, 0x00B50010, 0x00B54010, 0x00B58010, 0x00B5C010, 0x00B60010, 0x00B64010, 0x00B68010,
    0x0000B808, 0x00017109, 0x0002E20A, 0x000B840C, 0x000BC40C, 0x00B80010, 0x00B84010, 0x00B88010,
    0x00B8C010, 0x00B90010, 0x00B94010, 0x00B98010, 0x00B9C010, 0x00BA0010, 0x00BA4010, 0x00BA8010,
    0x00BAC010, 0x00BB0010, 0x00BB4010, 0x00BB8010, 0x00BBC010, 0x00BC0010, 0x00BC4010, 0x00BC8010,
    0x00BCC010, 0x00BD0010, 0x00BD4010, 0x00BD8010, 0x00BDC010, 0x00BE0010, 0x00BE4010, 0x00BE8010,
    0x0000C008, 0x00018109, 0x0003020A, 0x000C040C, 0x000C440C, 0x00C00010, 0x00C04010, 0x00C08010,
    0x00C0C010, 0x00C10010, 0x00C14010, 0x00C18010, 0x00C1C010, 0x00C20010, 0x00C24010, 0x00C28010,
    0x00C2C010, 0x00C30010, 0x00C34010, 0x00C38010, 0x00C3C010, 0x00C40010, 0x00C44010, 0x00C48010,
    0x00C4C010, 0x00C50010, 0x00C54010, 0x00C58010, 0x00C5C010, 0x00C60010, 0x00C64010, 0x00C68010,
    0x0000C808, 0x00019109, 0x0003220A, 0x000C840C, 0x000CC40C, 0x00C80010, 0x00C84010, 0x00C88010,
    0x00C8C010, 0x00C90010, 0x00C94010, 0x00C98010, 0x00C9C010, 0x00CA0010, 0x00CA4010, 0x00CA8010,
    0x00CAC010, 0x00CB0010, 0x00CB4010, 0x00CB8010, 0x00CBC010, 0x00CC0010, 0x00CC4010, 0x00CC8010,
    0x00CCC010, 0x00CD0010, 0x00CD4010, 0x00CD8010, 0x00CDC010, 0x00CE0010, 0x00CE4010, 0x00CE8010,
    0x0000D008, 0x0001A109, 0x0003420A, 0x000D040C, 0x000D440C, 0x00D00010, 0x00D04010, 0x00D08010,
    0x00D0C010, 0x00D10010, 0x00D14010, 0x00D18010, 0x00D1C010, 0x00D20010, 0x00D24010, 0x00D28010,
    0x00D2C010, 0x00D30010, 0x00D34010, 0x00D38010, 0x00D3C010, 0x00D40010, 0x00D44010, 0x00D48010,
    0x00D4C010, 0x00D50010, 0x00D54010, 0x00D58010, 0x00D5C010, 0x00D60010, 0x00D64010, 0x00D68010};