/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


package org.netbeans.modules.j2ee.deployment.plugins.spi;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

/**
 * This interface represents a "provider" for the Ant deployment.
 * <p>
 * The j2eeserver uses {@link OptionalDeploymentManagerFactory} to optains an 
 * instance of the AntDeploymentProvider from the server integration plugin.
 *
 * @author sherold
 *
 * @since 1.18
 */
public interface AntDeploymentProvider {
    
    /**
     * Generates the Ant deployment build script for the given module type to 
     * the specified output stream.
     * <p>
     * See {@link org.netbeans.modules.j2ee.deployment.devmodules.api.AntDeploymentHelper#writeDeploymentScript(File,Object,String)}
     * for what targets and properties is the Ant deployment build script required 
     * to define and what predefined properties it might use.
     *
     * @param os the output stream the deployment build script should be generated 
     *           to.
     * @param moduleType the module type the build script should handle. Use the
     *                   constants defined in the {@link org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule}.
     * @throws IOException if a problem during generating the build script occurs.
     */
    void writeDeploymentScript(OutputStream os, Object moduleType) throws IOException;
    
    /**
     * Return the server instance specific deployment properties file used by 
     * the deployment build script generated by the {@link #writeDeploymentScript(OutputStream,Object)}.
     *
     * @return the deployment properties file.
     */
    File getDeploymentPropertiesFile();
}
