/* test_overflow.c --- Test for CVE-2019-17455 overflow bug for libntlm.
 * Copyright (C) 2020-2024 Simon Josefsson
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This file is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this file; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 */

#include <config.h>

#include <string.h>
#include <stdio.h>

#include "ntlm.h"

int
main (void)
{
  char u[1024];
  char d[1024];
  char buf[sizeof (tSmbNtlmAuthRequest) + 5];
  tSmbNtlmAuthRequest *request = (void *) &buf;
  size_t i;

  memset (u, '1', 1024);
  memset (d, '2', 1024);
  u[1023] = '\0';
  d[1023] = '\0';

  memset (buf, '3', sizeof (buf));

  printf ("Before call:\n");
  for (i = sizeof (tSmbNtlmAuthRequest) - 5; i < sizeof (buf); i++)
    printf ("str[end + %d] = %02x\n",
	    (int) (i - sizeof (tSmbNtlmAuthRequest)), (unsigned int) buf[i]);

  buildSmbNtlmAuthRequest (request, u, d);

  printf ("After call:\n");
  for (i = sizeof (tSmbNtlmAuthRequest) - 5; i < sizeof (buf); i++)
    printf ("str[end + %d] = %02x\n",
	    (int) (i - sizeof (tSmbNtlmAuthRequest)), (unsigned int) buf[i]);

  for (i = sizeof (tSmbNtlmAuthRequest); i < sizeof (buf); i++)
    if (buf[i] != '3')
      return 1;

  return 0;
}
