/* powerpc-linux.elf-fold.h
   created from powerpc-linux.elf-fold.bin, 4464 (0x1170) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2024 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2024 Laszlo Molnar
   Copyright (C) 2000-2024 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_POWERPC_LINUX_ELF_FOLD_SIZE    4464
#define STUB_POWERPC_LINUX_ELF_FOLD_ADLER32 0x82b88b67
#define STUB_POWERPC_LINUX_ELF_FOLD_CRC32   0x8c75b666

unsigned char stub_powerpc_linux_elf_fold[4464] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  2,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   0,  2,  0, 20,  0,  0,  0,  1,  0, 16,  0,128,  0,  0,  0, 52,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0,  0, 52,  0, 32,  0,  2,  0,  0,
/* 0x0030 */   0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0,  0,  0, 16,  0,  0,
/* 0x0040 */   0, 16,  0,  0,  0,  0, 17,112,  0,  0, 17,112,  0,  0,  0,  5,
/* 0x0050 */   0,  1,  0,  0,  0,  0,  0,  1,  0,  0, 17,112,  0,  0,  0,  0,
/* 0x0060 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0070 */   0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0080 */ 255,255,240,  0,125,104,  2,166, 72,  0,  0,  5,124,104,  2,166,
/* 0x0090 */ 125,104,  3,166,128, 99,255,244, 78,128,  0, 32, 96,  0,  0,  0,
/* 0x00a0 */  72,  0,  0,125, 40,  6,  0,208, 76,130,  0, 32, 84,132,240,191,
/* 0x00b0 */  77,130,  0, 32, 60,  0,  0, 16,124,  4,  0, 64, 65,128,  0,  8,
/* 0x00c0 */ 124,  4,  3,120, 56,165,  1, 32,124,103, 27,120, 56, 99,255,252,
/* 0x00d0 */ 124,137,  3,166, 72,  0,  0, 28, 85, 96,  2,186,124,  3,  0, 80,
/* 0x00e0 */ 124,  0, 58, 20, 80, 11,  1,186,145, 99,  0,  0, 78, 64,  0, 32,
/* 0x00f0 */ 133, 99,  0,  4, 85, 96, 85,190,124,  0, 40, 64, 65,162,255,220,
/* 0x0100 */  66,  0,255,240, 78,128,  0, 32, 32, 32, 32, 61, 47,112,114,111,
/* 0x0110 */  99, 47,115,101,108,102, 47,101,120,101,  0,  0,126,200,  2,166,
/* 0x0120 */  56,129,255,252, 56, 33,239,252, 56, 97,255,252, 59, 90,255,252,
/* 0x0130 */ 132,  4,  0,  4,127,132,208, 64,148,  3,  0,  4, 65,156,255,244,
/* 0x0140 */  59, 67,  0,  8,148,  3,  0,  4,128,  4,  0,  4, 43,128,  0,  0,
/* 0x0150 */ 144,  3,  0,  4,132,  4,  0,  8,148,  3,  0,  8, 64,158,255,236,
/* 0x0160 */  58,163,  0,  4,126,154,168, 80,128, 22,  0,100, 58,100,  0,  4,
/* 0x0170 */ 148,  3,  0,  4, 58, 67,  0,  4, 56,128,  0,  0, 56,118,  0,104,
/* 0x0180 */  72,  0,  1,125,124,123, 27,120, 56,160, 15,255,126, 68,147,120,
/* 0x0190 */  56,118,  0,104, 72,  0,  1, 81, 56,178,255,252, 44,  3,  0,  0,
/* 0x01a0 */  65,129,  0, 12, 56,182,  0,100, 56, 96,  0, 16, 56, 99,  0,  4,
/* 0x01b0 */ 124,133, 26, 20,124,105,  3,166,126, 99,155,120, 56,160,  0,  0,
/* 0x01c0 */ 156,163,255,255,140,  4,255,255,156,  3,255,255, 66,  0,255,248,
/* 0x01d0 */ 144,122,255,248, 84, 99,  0, 58,124, 32, 34,120,124,  0, 26,120,
/* 0x01e0 */  84,  0,  7,126,124, 96, 24, 80,126,164,171,120,127, 84, 24, 80,
/* 0x01f0 */ 132,  4,255,252,127,132,  8, 64,148,  3,255,252, 65,157,255,244,
/* 0x0200 */ 124, 97, 27,120,148, 33,247,240,127,  3,195,120,126,228,187,120,
/* 0x0210 */  56,161,  0, 16,127, 70,211,120,127,231,251,120,126,200,179,120,
/* 0x0220 */ 127, 41,203,120, 72,  0, 13, 77, 56, 33,  8, 16,124,127, 27,120,
/* 0x0230 */ 128,153,  0,104,127, 35,203,120, 72,  0,  0,165,128,153,  0,104,
/* 0x0240 */ 127, 35,203,120, 72,  0,  0,209, 57,  0,  0,  0,127,103,219,120,
/* 0x0250 */  44,  7,  0,  0, 65,128,  0, 32, 56,192,  0,  2, 56,160,  0,  1,
/* 0x0260 */ 124,158,  0,208, 56, 96,  0,  0, 72,  0,  0, 89,127, 99,219,120,
/* 0x0270 */  72,  0,  0,149,127, 67,211,120,128,  3,  0,  0,128,131,  0,  4,
/* 0x0280 */  56, 99,  0,  8, 43,128,  0,  0, 64,158,255,240,124,137,  3,166,
/* 0x0290 */ 127,163,235,120,127,132,227,120, 56,  0,  0, 91,127,232,  3,166,
/* 0x02a0 */ 184,161,  0, 32, 56, 33,  0,144, 78,128,  4, 32, 56,  0, 15,255,
/* 0x02b0 */ 124, 96,  0, 56,124, 96, 24, 80,124,132,  2, 20, 72,  0,  0, 80,
/* 0x02c0 */  56,  0,  0, 90, 68,  0,  0,  2, 64,163,  0,  8, 56, 96,255,255,
/* 0x02d0 */  78,128,  0, 32, 56,  0,  0,  1, 72,  0,  0,  8, 56,  0,  0, 45,
/* 0x02e0 */  72,  0,  0,  8, 56,  0,  0, 85, 72,  0,  0,  8, 56,  0,  0,  4,
/* 0x02f0 */  72,  0,  0,  8, 56,  0,  0,  3, 72,  0,  0,  8, 56,  0,  0,  5,
/* 0x0300 */  72,  0,  0,  8, 56,  0,  0,  6, 72,  0,  0,  8, 56,  0,  0,125,
/* 0x0310 */  72,  0,  0,  8, 56,  0,  0, 91, 75,255,255,172,124,128,  0,  8,
/* 0x0320 */  78,128,  0, 32,148, 33,255,208,124,  8,  2,166,147,225,  0, 44,
/* 0x0330 */ 144,  1,  0, 52,124, 63, 11,120,144,127,  0,  8,144,159,  0, 12,
/* 0x0340 */ 144,191,  0, 16,129, 63,  0,  8,128,  9,  0,  4,144, 31,  0, 20,
/* 0x0350 */ 128, 31,  0, 12,144, 31,  0, 24,129, 63,  0,  8,129, 41,  0,  0,
/* 0x0360 */ 128, 31,  0, 16,127,137,  0, 64, 64,156,  0, 12, 56, 96,  0,127,
/* 0x0370 */  75,255,255,101,128, 31,  0, 16,144, 31,  0, 28,129, 63,  0, 28,
/* 0x0380 */  56,  9,255,255,124,  9,  3,120,145, 63,  0, 28, 56,  0,255,255,
/* 0x0390 */ 127,137,  0,  0, 65,158,  0, 48,129,127,  0, 24,129, 63,  0, 20,
/* 0x03a0 */ 136,  9,  0,  0,152, 11,  0,  0,129, 63,  0, 20, 56,  9,  0,  1,
/* 0x03b0 */ 144, 31,  0, 20,129, 63,  0, 24, 56,  9,  0,  1,144, 31,  0, 24,
/* 0x03c0 */  75,255,255,188,129,127,  0,  8,129, 63,  0,  8,129, 41,  0,  4,
/* 0x03d0 */ 128, 31,  0, 16,124,  9,  2, 20,144, 11,  0,  4,129,127,  0,  8,
/* 0x03e0 */ 129, 63,  0,  8,129, 41,  0,  0,128, 31,  0, 16,124,  0, 72, 80,
/* 0x03f0 */ 144, 11,  0,  0,129, 97,  0,  0,128, 11,  0,  4,124,  8,  3,166,
/* 0x0400 */ 131,235,255,252,125, 97, 91,120, 78,128,  0, 32,148, 33,255,176,
/* 0x0410 */ 124,  8,  2,166,147,225,  0, 76,144,  1,  0, 84,124, 63, 11,120,
/* 0x0420 */ 144,127,  0,  8,144,159,  0, 12,144,191,  0, 16,144,223,  0, 20,
/* 0x0430 */ 129, 63,  0, 12,128,  9,  0,  0, 47,128,  0,  0, 65,158,  1,228,
/* 0x0440 */  56, 31,  0, 32,128,127,  0,  8,124,  4,  3,120, 56,160,  0, 12,
/* 0x0450 */  75,255,254,213,128, 31,  0, 32, 47,128,  0,  0, 64,158,  0, 48,
/* 0x0460 */ 128, 31,  0, 36, 61, 32, 33, 88, 97, 41, 80, 85,127,128, 72,  0,
/* 0x0470 */  65,158,  0,  8, 72,  0,  0, 36,129, 63,  0,  8,128,  9,  0,  0,
/* 0x0480 */  47,128,  0,  0, 65,158,  1,156, 72,  0,  0, 16,128, 31,  0, 36,
/* 0x0490 */  47,128,  0,  0, 64,158,  0, 12, 56, 96,  0,127, 75,255,254, 57,
/* 0x04a0 */ 128, 31,  0, 36,129, 63,  0, 32,127,128, 72, 64, 65,157,255,236,
/* 0x04b0 */ 129, 63,  0, 12,129,127,  0, 32,128,  9,  0,  0,127,139,  0, 64,
/* 0x04c0 */  65,157,255,216,128, 31,  0, 36,129, 63,  0, 32,127,128, 72, 64,
/* 0x04d0 */  64,156,  1,  8,128, 31,  0, 32,144, 31,  0, 48,129, 63,  0,  8,
/* 0x04e0 */ 129,127,  0, 12, 57, 95,  0, 48,136, 31,  0, 40, 84,  0,  6, 62,
/* 0x04f0 */ 129, 31,  0, 16,125,  9,  3,166,128,105,  0,  4,128,159,  0, 36,
/* 0x0500 */ 128,171,  0,  4,125, 70, 83,120,124,  7,  3,120, 78,128,  4, 33,
/* 0x0510 */ 124, 96, 27,120,144, 31,  0, 52,128, 31,  0, 52, 47,128,  0,  0,
/* 0x0520 */  64,158,255,120,128, 31,  0, 32,129, 63,  0, 48,127,128, 72,  0,
/* 0x0530 */  64,158,255,104,136, 31,  0, 41, 84,  0,  6, 62, 47,128,  0,  0,
/* 0x0540 */  65,158,  0,100,128, 31,  0, 20, 47,128,  0,  0, 65,158,  0, 88,
/* 0x0550 */ 128, 31,  0, 48, 43,128,  2,  0, 65,157,  0, 28,129, 63,  0, 12,
/* 0x0560 */ 129, 41,  0,  0,128, 31,  0, 32,127,137,  0,  0, 65,158,  0,  8,
/* 0x0570 */  72,  0,  0, 52,129, 63,  0, 12,136, 31,  0, 42, 84, 11,  6, 62,
/* 0x0580 */ 136, 31,  0, 41, 84,  0,  6, 62,129, 31,  0, 20,125,  9,  3,166,
/* 0x0590 */ 128,105,  0,  4,128,159,  0, 48,125,101, 91,120,124,  6,  3,120,
/* 0x05a0 */  78,128,  4, 33,129,127,  0,  8,129, 63,  0,  8,129, 41,  0,  4,
/* 0x05b0 */ 128, 31,  0, 36,124,  9,  2, 20,144, 11,  0,  4,129,127,  0,  8,
/* 0x05c0 */ 129, 63,  0,  8,129, 41,  0,  0,128, 31,  0, 36,124,  0, 72, 80,
/* 0x05d0 */ 144, 11,  0,  0, 72,  0,  0, 24,129, 63,  0, 12,128,127,  0,  8,
/* 0x05e0 */ 128,137,  0,  4,128,191,  0, 36, 75,255,253, 61,129,127,  0, 12,
/* 0x05f0 */ 129, 63,  0, 12,129, 41,  0,  4,128, 31,  0, 32,124,  9,  2, 20,
/* 0x0600 */ 144, 11,  0,  4,129,127,  0, 12,129, 63,  0, 12,129, 41,  0,  0,
/* 0x0610 */ 128, 31,  0, 32,124,  0, 72, 80,144, 11,  0,  0, 75,255,254, 20,
/* 0x0620 */ 129, 97,  0,  0,128, 11,  0,  4,124,  8,  3,166,131,235,255,252,
/* 0x0630 */ 125, 97, 91,120, 78,128,  0, 32,148, 33,255,208,124,  8,  2,166,
/* 0x0640 */ 147,225,  0, 44,144,  1,  0, 52,124, 63, 11,120,144,127,  0,  8,
/* 0x0650 */ 144,159,  0, 12,144,191,  0, 16, 56,  0,  0,  0,144, 31,  0, 20,
/* 0x0660 */  56,  0,  0,  0,144, 31,  0, 24,129, 63,  0,  8,128,  9,  0,  0,
/* 0x0670 */  47,128,  0,  1, 64,158,  1, 40,129, 63,  0,  8,128,  9,  0, 24,
/* 0x0680 */  84,  0,  7,254, 47,128,  0,  0, 65,158,  1, 20,129, 63,  0,  8,
/* 0x0690 */ 129,127,  0,  8,129, 41,  0, 20,128, 11,  0,  8,125, 41,  2, 20,
/* 0x06a0 */ 128, 31,  0, 12,124,  9,  2, 20,144, 31,  0, 24,129, 63,  0,  8,
/* 0x06b0 */ 129,127,  0,  8,129, 41,  0, 20,128, 11,  0, 16,127,137,  0,  0,
/* 0x06c0 */  64,158,  0, 28,128, 31,  0, 24,125, 32,  0,208,128, 31,  0, 16,
/* 0x06d0 */ 125, 32,  0, 56, 43,128,  0,  7, 65,157,  0,104,129,127,  0,  8,
/* 0x06e0 */ 128, 31,  0, 12, 29, 32,  0, 52,128, 11,  0,  8,125, 41,  2, 20,
/* 0x06f0 */  56,  9,  0,  8,144, 31,  0, 24,129, 63,  0,  8,128,  9,  0,  4,
/* 0x0700 */  47,128,  0,  0, 65,158,  0, 60, 56,  0,  0,  1,144, 31,  0, 20,
/* 0x0710 */  56, 96,  0,  0, 56,128, 16,  0, 56,160,  0,  3, 56,192,  0, 34,
/* 0x0720 */  56,224,255,255, 57,  0,  0,  0, 75,255,251,153,144,127,  0, 24,
/* 0x0730 */ 128, 31,  0, 24, 47,128,  0,  0, 64,158,  0,  8, 72,  0,  0, 88,
/* 0x0740 */ 129, 63,  0, 24, 56,  9,  0,  3, 84,  0,  0, 58,144, 31,  0, 24,
/* 0x0750 */ 129, 63,  0, 24, 60,  0, 68,  0, 96,  0,  0,  2,144,  9,  0,  0,
/* 0x0760 */ 129, 63,  0, 24, 57, 41,  0,  4, 60,  0, 78,128, 96,  0,  0, 32,
/* 0x0770 */ 144,  9,  0,  0,128, 31,  0, 20, 47,128,  0,  0, 65,158,  0, 32,
/* 0x0780 */ 128,127,  0, 24, 56,128,  0,  8, 56,160,  0,  5, 75,255,251, 33,
/* 0x0790 */  72,  0,  0, 12, 56,  0,  0,  0,144, 31,  0, 24,128, 31,  0, 24,
/* 0x07a0 */ 124,  3,  3,120,129, 97,  0,  0,128, 11,  0,  4,124,  8,  3,166,
/* 0x07b0 */ 131,235,255,252,125, 97, 91,120, 78,128,  0, 32,148, 33,255,224,
/* 0x07c0 */ 147,225,  0, 28,124, 63, 11,120,144,127,  0,  8,144,159,  0, 12,
/* 0x07d0 */ 128, 31,  0, 12, 47,128,  0,  0, 65,158,  0, 52,129, 63,  0,  8,
/* 0x07e0 */ 125, 43, 75,120, 56,  0,  0,  0,152, 11,  0,  0, 57, 41,  0,  1,
/* 0x07f0 */ 145, 63,  0,  8,129, 63,  0, 12, 56,  9,255,255,144, 31,  0, 12,
/* 0x0800 */  47,128,  0,  0, 65,158,  0,  8, 75,255,255,212,129, 97,  0,  0,
/* 0x0810 */ 131,235,255,252,125, 97, 91,120, 78,128,  0, 32,148, 33,255,208,
/* 0x0820 */ 124,  8,  2,166,147,225,  0, 44,144,  1,  0, 52,124, 63, 11,120,
/* 0x0830 */ 144,127,  0,  8,144,159,  0, 12,144,191,  0, 16,128, 31,  0,  8,
/* 0x0840 */  47,128,  0,  0, 65,158,  0,204,128, 31,  0,  8, 84,  0,  7,254,
/* 0x0850 */  47,128,  0,  0, 64,158,  0,188, 56,  0,  0,  0,144, 31,  0, 20,
/* 0x0860 */  56,  0,  0,  0,144, 31,  0, 24,129, 63,  0,  8,129, 41,  0,  0,
/* 0x0870 */ 128, 31,  0, 12,127,137,  0,  0, 64,158,  0, 32,129, 63,  0,  8,
/* 0x0880 */ 128, 31,  0, 16,144,  9,  0,  4,129, 63,  0, 24, 56,  9,  0,  1,
/* 0x0890 */ 144, 31,  0, 24, 72,  0,  0, 28,129, 63,  0,  8,128,  9,  0,  0,
/* 0x08a0 */  47,128,  0,  1, 64,158,  0, 12,128, 31,  0,  8,144, 31,  0, 20,
/* 0x08b0 */ 129, 63,  0,  8,128,  9,  0,  0, 47,128,  0,  0, 64,158,  0, 68,
/* 0x08c0 */ 128, 31,  0, 24, 47,128,  0,  0, 65,158,  0,  8, 72,  0,  0, 68,
/* 0x08d0 */ 128, 31,  0, 20, 47,128,  0,  0, 65,158,  0, 32,129, 63,  0, 20,
/* 0x08e0 */ 128, 31,  0, 12,144,  9,  0,  0,129, 63,  0, 20,128, 31,  0, 16,
/* 0x08f0 */ 144,  9,  0,  4, 72,  0,  0, 28, 56, 96,  0,127, 75,255,249,217,
/* 0x0900 */ 129, 63,  0,  8, 56,  9,  0,  8,144, 31,  0,  8, 75,255,255, 92,
/* 0x0910 */ 129, 97,  0,  0,128, 11,  0,  4,124,  8,  3,166,131,235,255,252,
/* 0x0920 */ 125, 97, 91,120, 78,128,  0, 32,148, 33,255,208,124,  8,  2,166,
/* 0x0930 */ 147,225,  0, 44,144,  1,  0, 52,124, 63, 11,120,144,127,  0,  8,
/* 0x0940 */ 144,159,  0, 12,144,191,  0, 16,144,223,  0, 20, 75,255,247, 57,
/* 0x0950 */ 124, 96, 27,120,144, 31,  0, 24, 56,  0,255,255,144, 31,  0, 28,
/* 0x0960 */  56,  0,  0,  0,144, 31,  0, 32, 56,  0,  0,  0,144, 31,  0, 36,
/* 0x0970 */ 129, 63,  0, 16, 56,  9,255,255,144, 31,  0, 16, 47,128,  0,  0,
/* 0x0980 */  65,156,  0,124,129, 63,  0, 12,128,  9,  0,  0, 47,128,  0,  1,
/* 0x0990 */  64,158,  0, 92,129, 63,  0, 12,129, 41,  0,  8,128, 31,  0, 28,
/* 0x09a0 */ 127,137,  0, 64, 64,156,  0, 16,129, 63,  0, 12,128,  9,  0,  8,
/* 0x09b0 */ 144, 31,  0, 28,129, 63,  0, 12,129,127,  0, 12,129, 41,  0, 20,
/* 0x09c0 */ 128, 11,  0,  8,125, 41,  2, 20,128, 31,  0, 32,127,137,  0, 64,
/* 0x09d0 */  64,157,  0, 28,129, 63,  0, 12,129,127,  0, 12,129, 41,  0, 20,
/* 0x09e0 */ 128, 11,  0,  8,124,  9,  2, 20,144, 31,  0, 32,129, 63,  0, 12,
/* 0x09f0 */  56,  9,  0, 32,144, 31,  0, 12, 75,255,255,120,129, 63,  0, 28,
/* 0x0a00 */ 128, 31,  0, 24,125, 32,  0, 56,144, 31,  0, 28,129, 63,  0, 32,
/* 0x0a10 */ 128, 31,  0, 28,125, 32, 72, 80,128, 31,  0, 24,125, 32, 72, 80,
/* 0x0a20 */  57, 41,255,255,128, 31,  0, 24,125, 32,  0, 56,144, 31,  0, 32,
/* 0x0a30 */ 128, 31,  0,  8, 96,  0,  0, 34,128,127,  0, 28,128,159,  0, 32,
/* 0x0a40 */  56,160,  0,  0,124,  6,  3,120, 56,224,255,255, 57,  0,  0,  0,
/* 0x0a50 */  75,255,248,113,144,127,  0, 36,129,127,  0, 20,129, 63,  0, 32,
/* 0x0a60 */ 128, 31,  0, 36,124,  9,  2, 20,144, 11,  0,  0,129, 63,  0, 36,
/* 0x0a70 */ 128, 31,  0, 28,124,  0, 72, 80,124,  3,  3,120,129, 97,  0,  0,
/* 0x0a80 */ 128, 11,  0,  4,124,  8,  3,166,131,235,255,252,125, 97, 91,120,
/* 0x0a90 */  78,128,  0, 32,148, 33,255,144,124,  8,  2,166,147,225,  0,108,
/* 0x0aa0 */ 144,  1,  0,116,124, 63, 11,120,144,127,  0,  8,144,159,  0, 12,
/* 0x0ab0 */ 144,191,  0, 16,144,223,  0, 20,144,255,  0, 24,145, 31,  0, 28,
/* 0x0ac0 */  75,255,245,197,124, 96, 27,120,124,  0,  0,248,144, 31,  0, 32,
/* 0x0ad0 */ 129, 63,  0, 12,129, 41,  0, 28,128, 31,  0, 12,124,  9,  2, 20,
/* 0x0ae0 */ 144, 31,  0, 36,128, 31,  0, 16, 47,128,  0,  0, 65,158,  0,128,
/* 0x0af0 */ 129, 63,  0, 24,128,  9,  0,  0,144, 31,  0, 48,129, 63,  0, 48,
/* 0x0b00 */  56,  9,  0, 52,144, 31,  0, 52,129, 63,  0, 48,160,  9,  0, 16,
/* 0x0b10 */  84,  0,  4, 62, 47,128,  0,  2, 64,158,  0, 28,129, 63,  0, 52,
/* 0x0b20 */ 128,  9,  0,  8,144, 31,  0, 48, 56,  0,  0,  0,144, 31,  0, 44,
/* 0x0b30 */  72,  0,  0, 36,129, 63,  0, 52, 57, 41,  0, 32,129,127,  0, 48,
/* 0x0b40 */ 128,  9,  0,  8,124,  0, 88, 80,144, 31,  0, 48,128, 31,  0, 48,
/* 0x0b50 */ 144, 31,  0, 44,129, 63,  0, 52,129, 41,  0, 20,128, 31,  0, 48,
/* 0x0b60 */ 124,  9,  2, 20,144, 31,  0, 40, 72,  0,  0, 84,129, 63,  0, 12,
/* 0x0b70 */ 160,  9,  0, 16, 84,  0,  4, 62, 47,128,  0,  3, 65,158,  0, 16,
/* 0x0b80 */  56,  0,  0, 16,144, 31,  0, 84, 72,  0,  0, 12, 56,  0,  0,  0,
/* 0x0b90 */ 144, 31,  0, 84,129, 63,  0, 12,160,  9,  0, 44, 84,  0,  4, 62,
/* 0x0ba0 */  57, 63,  0, 40,128,127,  0, 84,128,159,  0, 36,124,  5,  3,120,
/* 0x0bb0 */ 125, 38, 75,120, 75,255,253,117,144,127,  0, 44, 56,  0,  0,  0,
/* 0x0bc0 */ 144, 31,  0, 52,129, 63,  0, 12,160,  9,  0, 44, 84,  9,  4, 62,
/* 0x0bd0 */ 128, 31,  0, 52,127,137,  0,  0, 64,157,  3, 84,128, 31,  0, 16,
/* 0x0be0 */  47,128,  0,  0, 65,158,  0, 56,129, 63,  0, 36,128,  9,  0,  0,
/* 0x0bf0 */  47,128,  0,  6, 64,158,  0, 40,129, 63,  0, 36,129, 41,  0,  8,
/* 0x0c00 */ 128, 31,  0, 44,124,  9,  2, 20,128,127,  0, 20, 56,128,  0,  3,
/* 0x0c10 */ 124,  5,  3,120, 75,255,252,  9, 72,  0,  2,248,129, 63,  0, 36,
/* 0x0c20 */ 128,  9,  0,  0, 47,128,  0,  1, 64,158,  2,232,129, 63,  0, 36,
/* 0x0c30 */ 128,  9,  0, 20, 47,128,  0,  0, 65,158,  2,216,128, 31,  0, 16,
/* 0x0c40 */  47,128,  0,  0, 65,158,  0,120,129, 63,  0, 36,128,  9,  0,  4,
/* 0x0c50 */  47,128,  0,  0, 64,158,  0,104,129, 63,  0, 36,129, 41,  0,  8,
/* 0x0c60 */ 128, 31,  0, 44,125,105,  2, 20,129, 63,  0, 12,128,  9,  0, 28,
/* 0x0c70 */ 124, 11,  2, 20,128,127,  0, 20, 56,128,  0,  3,124,  5,  3,120,
/* 0x0c80 */  75,255,251,157,129, 63,  0, 12,160,  9,  0, 44, 84,  0,  4, 62,
/* 0x0c90 */ 128,127,  0, 20, 56,128,  0,  5,124,  5,  3,120, 75,255,251,129,
/* 0x0ca0 */ 129, 63,  0, 12,160,  9,  0, 42, 84,  0,  4, 62,128,127,  0, 20,
/* 0x0cb0 */  56,128,  0,  4,124,  5,  3,120, 75,255,251,101,129, 63,  0, 36,
/* 0x0cc0 */ 128,  9,  0, 24, 84,  0,  7,126, 84,  9, 16, 58, 60,  0,115, 81,
/* 0x0cd0 */  96,  0, 98, 64,124,  0, 76, 48, 84,  0,  7,126,144, 31,  0, 48,
/* 0x0ce0 */ 129, 63,  0, 36,128,  9,  0, 16,144, 31,  0, 56,144, 31,  0, 64,
/* 0x0cf0 */ 129, 63,  0, 36,129, 41,  0,  8,128, 31,  0, 44,124,  9,  2, 20,
/* 0x0d00 */ 144, 31,  0, 60,144, 31,  0, 68,129, 63,  0, 36,129, 41,  0, 20,
/* 0x0d10 */ 128, 31,  0, 68,124,  9,  2, 20,144, 31,  0, 72,129, 63,  0, 68,
/* 0x0d20 */ 128, 31,  0, 32,125, 32,  0, 56,144, 31,  0, 76,129, 63,  0, 64,
/* 0x0d30 */ 128, 31,  0, 76,124,  9,  2, 20,144, 31,  0, 64,129, 63,  0, 68,
/* 0x0d40 */ 128, 31,  0, 76,124,  0, 72, 80,144, 31,  0, 68,128, 31,  0, 16,
/* 0x0d50 */  47,128,  0,  0, 65,158,  0,120,128,127,  0, 68,128,159,  0, 64,
/* 0x0d60 */  56,160,  0,  3, 56,192,  0, 50, 56,224,255,255, 57,  0,  0,  0,
/* 0x0d70 */  75,255,245, 81,124, 96, 27,120,129, 63,  0, 68,127,128, 72,  0,
/* 0x0d80 */  65,158,  0,  8, 72,  0,  1, 32, 56, 31,  0, 56,144, 31,  0, 88,
/* 0x0d90 */ 128, 31,  0, 48, 84,  0,  7,122, 47,128,  0,  0, 65,158,  0, 16,
/* 0x0da0 */ 128, 31,  0, 28,144, 31,  0, 92, 72,  0,  0, 12, 56,  0,  0,  0,
/* 0x0db0 */ 144, 31,  0, 92,128,127,  0, 16,128,159,  0, 88,128,191,  0,  8,
/* 0x0dc0 */ 128,223,  0, 92, 75,255,246, 73, 72,  0,  0, 68,129, 63,  0, 36,
/* 0x0dd0 */ 129, 41,  0,  4,128, 31,  0, 76,124,  0, 72, 80,128,127,  0, 68,
/* 0x0de0 */ 128,159,  0, 64,128,191,  0, 48, 56,192,  0, 18,128,255,  0,  8,
/* 0x0df0 */ 124,  8,  3,120, 75,255,244,205,124,105, 27,120,128, 31,  0, 68,
/* 0x0e00 */ 127,137,  0,  0, 65,158,  0,  8, 72,  0,  0,156,128, 31,  0, 64,
/* 0x0e10 */ 125, 32,  0,208,128, 31,  0, 32,125, 32,  0, 56,144, 31,  0, 76,
/* 0x0e20 */ 128, 31,  0, 48, 84,  0,  7,188, 47,128,  0,  0, 65,158,  0, 28,
/* 0x0e30 */ 128, 31,  0, 68,129, 63,  0, 64,124,  0, 74, 20,124,  3,  3,120,
/* 0x0e40 */ 128,159,  0, 76, 75,255,249,121,128, 31,  0, 16, 47,128,  0,  0,
/* 0x0e50 */  65,158,  0, 92,128,127,  0, 36,128,159,  0, 44,128,191,  0, 32,
/* 0x0e60 */  75,255,247,217,124, 96, 27,120,144, 31,  0, 80,128, 31,  0, 80,
/* 0x0e70 */  47,128,  0,  0, 65,158,  0, 20,128,127,  0, 20, 56,128,  0,  0,
/* 0x0e80 */ 128,191,  0, 80, 75,255,249,153,128,127,  0, 68,128,159,  0, 64,
/* 0x0e90 */ 128,191,  0, 48, 75,255,244, 25,124, 96, 27,120, 47,128,  0,  0,
/* 0x0ea0 */  65,158,  0, 12, 56, 96,  0,127, 75,255,244, 45,129, 63,  0, 64,
/* 0x0eb0 */ 128, 31,  0, 76,125, 41,  2, 20,128, 31,  0, 68,124,  0, 74, 20,
/* 0x0ec0 */ 144, 31,  0, 68,129, 63,  0, 68,128, 31,  0, 72,127,137,  0, 64,
/* 0x0ed0 */  64,156,  0, 64,129, 63,  0, 72,128, 31,  0, 68,124,  0, 72, 80,
/* 0x0ee0 */ 128,127,  0, 68,124,  4,  3,120,128,191,  0, 48, 56,192,  0, 50,
/* 0x0ef0 */  56,224,255,255, 57,  0,  0,  0, 75,255,243,201,124,105, 27,120,
/* 0x0f00 */ 128, 31,  0, 68,127,137,  0,  0, 65,158,  0,  8, 72,  0,  0,  0,
/* 0x0f10 */ 129, 63,  0, 36, 56,  9,  0, 32,144, 31,  0, 36,129, 63,  0, 52,
/* 0x0f20 */  56,  9,  0,  1,144, 31,  0, 52, 75,255,252,156,128, 31,  0, 24,
/* 0x0f30 */  47,128,  0,  0, 65,158,  0, 16,129, 63,  0, 24,128, 31,  0, 44,
/* 0x0f40 */ 144,  9,  0,  0,129, 63,  0, 12,129, 41,  0, 24,128, 31,  0, 44,
/* 0x0f50 */ 124,  9,  2, 20,124,  3,  3,120,129, 97,  0,  0,128, 11,  0,  4,
/* 0x0f60 */ 124,  8,  3,166,131,235,255,252,125, 97, 91,120, 78,128,  0, 32,
/* 0x0f70 */ 148, 33,255,160,124,  8,  2,166,147,225,  0, 92,144,  1,  0,100,
/* 0x0f80 */ 124, 63, 11,120,144,127,  0,  8,144,159,  0, 12,144,191,  0, 16,
/* 0x0f90 */ 144,223,  0, 20,144,255,  0, 24,145, 31,  0, 28,145, 63,  0, 32,
/* 0x0fa0 */ 129, 63,  0,  8,129, 41,  0,  4, 56,  9,  0, 12,144, 31,  0, 36,
/* 0x0fb0 */ 128, 31,  0, 16,144, 31,  0, 44,129, 63,  0,  8,128,  9,  0,  0,
/* 0x0fc0 */ 144, 31,  0, 40,128, 31,  0,  8,144, 31,  0, 52,128, 31,  0, 12,
/* 0x0fd0 */ 144, 31,  0, 48, 56, 31,  0, 48, 57, 63,  0, 40,124,  3,  3,120,
/* 0x0fe0 */ 125, 36, 75,120,128,191,  0, 24, 56,192,  0,  0, 75,255,244, 33,
/* 0x0ff0 */ 129, 63,  0, 52,128, 31,  0, 36,124,  0, 72, 80,144, 31,  0, 52,
/* 0x1000 */ 128, 31,  0, 12,144, 31,  0, 48,128, 31,  0, 32,144, 31,  0, 56,
/* 0x1010 */ 129, 63,  0, 16, 56,  9,  0, 52,144, 31,  0, 60, 56, 31,  0, 48,
/* 0x1020 */  57, 63,  0, 56,128,127,  0, 24,128,159,  0, 16,124,  5,  3,120,
/* 0x1030 */ 128,223,  0, 20,125, 39, 75,120,129, 31,  0, 28, 75,255,250, 89,
/* 0x1040 */ 124, 96, 27,120,144, 31,  0, 64,128,127,  0, 20, 56,128,  0,  9,
/* 0x1050 */ 128,191,  0, 64, 75,255,247,201, 56,  0,  0,  0,144, 31,  0, 68,
/* 0x1060 */ 129, 63,  0, 16, 56,  9,  0, 52,144, 31,  0, 60,129, 63,  0, 16,
/* 0x1070 */ 160,  9,  0, 44, 84,  9,  4, 62,128, 31,  0, 68,127,137,  0,  0,
/* 0x1080 */  64,157,  0,208,129, 63,  0, 60,128,  9,  0,  0, 47,128,  0,  3,
/* 0x1090 */  64,158,  0,164,129, 63,  0, 60,129, 41,  0,  8,128, 31,  0, 56,
/* 0x10a0 */ 124,  9,  2, 20,124,  3,  3,120, 56,128,  0,  0, 56,160,  0,  0,
/* 0x10b0 */  75,255,242, 77,124, 96, 27,120,144, 31,  0, 72,128, 31,  0, 72,
/* 0x10c0 */  47,128,  0,  0, 64,156,  0,  8, 72,  0,  0, 32,128,127,  0, 72,
/* 0x10d0 */ 128,159,  0, 16, 56,160,  2,  0, 75,255,242, 29,124, 96, 27,120,
/* 0x10e0 */  47,128,  2,  0, 65,158,  0, 12, 56, 96,  0,127, 75,255,241,233,
/* 0x10f0 */  56, 31,  0, 56,128,127,  0, 72,128,159,  0, 16, 56,160,  0,  0,
/* 0x1100 */ 128,223,  0, 20,124,  7,  3,120, 57,  0,  0,  0, 75,255,249,137,
/* 0x1110 */ 124, 96, 27,120,144, 31,  0, 64,128,127,  0, 20, 56,128,  0,  7,
/* 0x1120 */ 128,191,  0, 56, 75,255,246,249,128,127,  0, 72, 75,255,241,217,
/* 0x1130 */  72,  0,  0, 32,129, 63,  0, 60, 56,  9,  0, 32,144, 31,  0, 60,
/* 0x1140 */ 129, 63,  0, 68, 56,  9,  0,  1,144, 31,  0, 68, 75,255,255, 32,
/* 0x1150 */ 128, 31,  0, 64,124,  3,  3,120,129, 97,  0,  0,128, 11,  0,  4,
/* 0x1160 */ 124,  8,  3,166,131,235,255,252,125, 97, 91,120, 78,128,  0, 32
};
