/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import spec.jbb.JBBProperties;
import spec.jbb.JBBmain;
import spec.jbb.RunSequencer;
import spec.reporter.MultiVMReport;
import spec.reporter.MultiVMTxtReport;

public class Controller {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,Licensed Materials - Property of SPEC";
    private static int port = 1500;
    private static String host = "localhost";
    private static String defaultOutputDir = JBBmain.defaultOutputDir;
    private static String outputDir = null;
    private static String propFile = JBBmain.defaultPropsFileName;
    private static String runOutputSubDir = null;
    private static int[] sequenceOfWarehouses;
    private static int numInst;

    private static void readProperties() {
        JBBProperties jBBProperties = new JBBProperties(propFile);
        if (!jBBProperties.getProps()) {
            System.out.println("ERROR:  Properties File error; please start again");
            return;
        }
        outputDir = jBBProperties.getOptionalProperty("input.output_directory");
        if (outputDir == null) {
            outputDir = defaultOutputDir;
        }
        int n = 0;
        if (jBBProperties.sequenceOfWarehouses == null) {
            int n2 = (jBBProperties.endingNumberWarehouses - jBBProperties.startingNumberWarehouses) / jBBProperties.incrementNumberWarehouses + 1;
            sequenceOfWarehouses = new int[n2];
            for (int i = jBBProperties.startingNumberWarehouses; i <= jBBProperties.endingNumberWarehouses; i += jBBProperties.incrementNumberWarehouses) {
                Controller.sequenceOfWarehouses[n] = i;
                ++n;
            }
        } else {
            int n3 = jBBProperties.sequenceOfWarehouses.length;
            sequenceOfWarehouses = new int[n3];
            sequenceOfWarehouses = jBBProperties.sequenceOfWarehouses;
        }
        numInst = jBBProperties.jvm_instances;
    }

    private static void setOutputDirectory() {
        RunSequencer runSequencer = new RunSequencer(outputDir, "SPECjbbMultiJVM.", null);
        runOutputSubDir = outputDir + File.separator + "SPECjbbMultiJVM." + runSequencer.getSeqString();
        if (!Controller.initOutputDir(runOutputSubDir)) {
            return;
        }
    }

    private static boolean initOutputDir(String string) {
        File file = new File(string);
        if (file.exists()) {
            if (!file.isDirectory()) {
                System.out.println("ERROR:  Specified input.output_directory is not a directory:  " + string);
                return false;
            }
        } else if (!file.mkdirs()) {
            System.out.println("ERROR:  Cannot create input.output_directory:  " + string);
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        int n = 0;
        while (n != stringArray.length) {
            if (stringArray[n].matches("-port")) {
                port = Integer.parseInt(stringArray[n + 1]);
                n += 2;
                continue;
            }
            if (!stringArray[n].matches("-propfile")) continue;
            propFile = stringArray[n + 1];
            n += 2;
        }
        Controller.readProperties();
        Controller.setOutputDirectory();
        ServerSocket[] serverSocketArray = new ServerSocket[numInst + 1];
        Socket[] socketArray = new Socket[numInst + 1];
        BufferedReader[] bufferedReaderArray = new BufferedReader[numInst + 1];
        PrintWriter[] printWriterArray = new PrintWriter[numInst + 1];
        try {
            Object object;
            Object object2;
            int n2;
            int n3;
            for (n3 = 1; n3 <= numInst; ++n3) {
                serverSocketArray[n3] = new ServerSocket(port + n3);
                socketArray[n3] = serverSocketArray[n3].accept();
                System.out.println("Accepted client " + socketArray[n3].getInetAddress() + ":" + socketArray[n3].getPort());
                bufferedReaderArray[n3] = new BufferedReader(new InputStreamReader(socketArray[n3].getInputStream()));
                printWriterArray[n3] = new PrintWriter(new OutputStreamWriter(socketArray[n3].getOutputStream()));
            }
            for (n3 = 0; n3 < sequenceOfWarehouses.length; ++n3) {
                String string;
                int n4 = sequenceOfWarehouses[n3];
                for (n2 = 1; n2 <= numInst; ++n2) {
                    string = "NULL";
                    object2 = n2 + ":READY";
                    while (!string.matches((String)object2)) {
                        string = bufferedReaderArray[n2].readLine();
                    }
                }
                for (n2 = 1; n2 <= numInst; ++n2) {
                    string = n2 + ":START";
                    printWriterArray[n2].println(string);
                    printWriterArray[n2].flush();
                }
                if (n3 != sequenceOfWarehouses.length - 1) continue;
                System.out.println(n4 + " wh: Reading FINISHED state from the jbb instances");
                for (n2 = 1; n2 <= numInst; ++n2) {
                    System.out.println("Waiting for FINISHED from " + n2);
                    string = "NULL";
                    object2 = n2 + ":FINISHED";
                    object = n2 + ":EXIT";
                    while (!string.matches((String)object2)) {
                        string = bufferedReaderArray[n2].readLine();
                    }
                    printWriterArray[n2].println((String)object);
                    System.out.println("Got" + string);
                }
            }
            System.out.println("Waiting 20 seconds for all jvm instance to exit");
            System.out.println("Received FINISHED from all jvm instances, now summarize the reports...");
            n3 = 0;
            String string = null;
            n2 = 0;
            boolean bl = true;
            object2 = new MultiVMReport(runOutputSubDir, n3 != 0, string, n2 != 0, bl);
            ((MultiVMReport)object2).print(runOutputSubDir + File.separator + "index.html");
            object = new MultiVMTxtReport(string, runOutputSubDir, n3 != 0);
            ((MultiVMTxtReport)object).print(runOutputSubDir + File.separator + "MultiVMReport.txt");
            System.out.println("benchmark run complete.");
            System.exit(0);
        }
        catch (Exception exception) {
            System.err.println(exception + ": error");
            System.exit(1);
        }
    }

    static {
        numInst = 1;
    }
}

