// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_ASSEMBLER_COND_RD_RN_RM_MUL_A32_H_
#define VIXL_ASSEMBLER_COND_RD_RN_RM_MUL_A32_H_

const byte kInstruction_mul_hi_r1_r9_r5[] = {
  0x99, 0x05, 0x01, 0x80 // mul hi r1 r9 r5
};
const byte kInstruction_mul_pl_r8_r6_r2[] = {
  0x96, 0x02, 0x08, 0x50 // mul pl r8 r6 r2
};
const byte kInstruction_mul_hi_r5_r8_r2[] = {
  0x98, 0x02, 0x05, 0x80 // mul hi r5 r8 r2
};
const byte kInstruction_mul_vc_r9_r2_r7[] = {
  0x92, 0x07, 0x09, 0x70 // mul vc r9 r2 r7
};
const byte kInstruction_mul_lt_r4_r6_r3[] = {
  0x96, 0x03, 0x04, 0xb0 // mul lt r4 r6 r3
};
const byte kInstruction_mul_le_r11_r6_r2[] = {
  0x96, 0x02, 0x0b, 0xd0 // mul le r11 r6 r2
};
const byte kInstruction_mul_cc_r8_r14_r4[] = {
  0x9e, 0x04, 0x08, 0x30 // mul cc r8 r14 r4
};
const byte kInstruction_mul_le_r5_r14_r6[] = {
  0x9e, 0x06, 0x05, 0xd0 // mul le r5 r14 r6
};
const byte kInstruction_mul_lt_r6_r1_r0[] = {
  0x91, 0x00, 0x06, 0xb0 // mul lt r6 r1 r0
};
const byte kInstruction_mul_lt_r5_r0_r9[] = {
  0x90, 0x09, 0x05, 0xb0 // mul lt r5 r0 r9
};
const byte kInstruction_mul_le_r8_r12_r7[] = {
  0x9c, 0x07, 0x08, 0xd0 // mul le r8 r12 r7
};
const byte kInstruction_mul_eq_r7_r14_r6[] = {
  0x9e, 0x06, 0x07, 0x00 // mul eq r7 r14 r6
};
const byte kInstruction_mul_cs_r7_r4_r6[] = {
  0x94, 0x06, 0x07, 0x20 // mul cs r7 r4 r6
};
const byte kInstruction_mul_gt_r9_r6_r9[] = {
  0x96, 0x09, 0x09, 0xc0 // mul gt r9 r6 r9
};
const byte kInstruction_mul_ne_r13_r9_r1[] = {
  0x99, 0x01, 0x0d, 0x10 // mul ne r13 r9 r1
};
const byte kInstruction_mul_ge_r13_r1_r13[] = {
  0x91, 0x0d, 0x0d, 0xa0 // mul ge r13 r1 r13
};
const byte kInstruction_mul_ls_r8_r10_r2[] = {
  0x9a, 0x02, 0x08, 0x90 // mul ls r8 r10 r2
};
const byte kInstruction_mul_hi_r0_r13_r5[] = {
  0x9d, 0x05, 0x00, 0x80 // mul hi r0 r13 r5
};
const byte kInstruction_mul_pl_r13_r7_r8[] = {
  0x97, 0x08, 0x0d, 0x50 // mul pl r13 r7 r8
};
const byte kInstruction_mul_ge_r4_r13_r11[] = {
  0x9d, 0x0b, 0x04, 0xa0 // mul ge r4 r13 r11
};
const byte kInstruction_mul_cs_r5_r10_r5[] = {
  0x9a, 0x05, 0x05, 0x20 // mul cs r5 r10 r5
};
const byte kInstruction_mul_cs_r5_r4_r3[] = {
  0x94, 0x03, 0x05, 0x20 // mul cs r5 r4 r3
};
const byte kInstruction_mul_ls_r6_r14_r8[] = {
  0x9e, 0x08, 0x06, 0x90 // mul ls r6 r14 r8
};
const byte kInstruction_mul_vs_r3_r8_r6[] = {
  0x98, 0x06, 0x03, 0x60 // mul vs r3 r8 r6
};
const byte kInstruction_mul_vc_r7_r12_r3[] = {
  0x9c, 0x03, 0x07, 0x70 // mul vc r7 r12 r3
};
const byte kInstruction_mul_ge_r1_r4_r1[] = {
  0x94, 0x01, 0x01, 0xa0 // mul ge r1 r4 r1
};
const byte kInstruction_mul_cc_r4_r7_r10[] = {
  0x97, 0x0a, 0x04, 0x30 // mul cc r4 r7 r10
};
const byte kInstruction_mul_cc_r2_r0_r13[] = {
  0x90, 0x0d, 0x02, 0x30 // mul cc r2 r0 r13
};
const byte kInstruction_mul_vs_r9_r6_r8[] = {
  0x96, 0x08, 0x09, 0x60 // mul vs r9 r6 r8
};
const byte kInstruction_mul_cs_r14_r11_r13[] = {
  0x9b, 0x0d, 0x0e, 0x20 // mul cs r14 r11 r13
};
const byte kInstruction_mul_pl_r5_r8_r4[] = {
  0x98, 0x04, 0x05, 0x50 // mul pl r5 r8 r4
};
const byte kInstruction_mul_pl_r2_r3_r7[] = {
  0x93, 0x07, 0x02, 0x50 // mul pl r2 r3 r7
};
const byte kInstruction_mul_cs_r7_r12_r14[] = {
  0x9c, 0x0e, 0x07, 0x20 // mul cs r7 r12 r14
};
const byte kInstruction_mul_hi_r6_r6_r1[] = {
  0x96, 0x01, 0x06, 0x80 // mul hi r6 r6 r1
};
const byte kInstruction_mul_cc_r6_r9_r6[] = {
  0x99, 0x06, 0x06, 0x30 // mul cc r6 r9 r6
};
const byte kInstruction_mul_ne_r12_r12_r0[] = {
  0x9c, 0x00, 0x0c, 0x10 // mul ne r12 r12 r0
};
const byte kInstruction_mul_cc_r9_r3_r8[] = {
  0x93, 0x08, 0x09, 0x30 // mul cc r9 r3 r8
};
const byte kInstruction_mul_mi_r13_r6_r1[] = {
  0x96, 0x01, 0x0d, 0x40 // mul mi r13 r6 r1
};
const byte kInstruction_mul_lt_r4_r8_r6[] = {
  0x98, 0x06, 0x04, 0xb0 // mul lt r4 r8 r6
};
const byte kInstruction_mul_hi_r11_r5_r9[] = {
  0x95, 0x09, 0x0b, 0x80 // mul hi r11 r5 r9
};
const byte kInstruction_mul_cc_r6_r10_r6[] = {
  0x9a, 0x06, 0x06, 0x30 // mul cc r6 r10 r6
};
const byte kInstruction_mul_eq_r10_r10_r5[] = {
  0x9a, 0x05, 0x0a, 0x00 // mul eq r10 r10 r5
};
const byte kInstruction_mul_al_r5_r4_r11[] = {
  0x94, 0x0b, 0x05, 0xe0 // mul al r5 r4 r11
};
const byte kInstruction_mul_pl_r11_r11_r2[] = {
  0x9b, 0x02, 0x0b, 0x50 // mul pl r11 r11 r2
};
const byte kInstruction_mul_ls_r6_r14_r12[] = {
  0x9e, 0x0c, 0x06, 0x90 // mul ls r6 r14 r12
};
const byte kInstruction_mul_vc_r7_r7_r2[] = {
  0x97, 0x02, 0x07, 0x70 // mul vc r7 r7 r2
};
const byte kInstruction_mul_eq_r10_r8_r4[] = {
  0x98, 0x04, 0x0a, 0x00 // mul eq r10 r8 r4
};
const byte kInstruction_mul_al_r14_r7_r2[] = {
  0x97, 0x02, 0x0e, 0xe0 // mul al r14 r7 r2
};
const byte kInstruction_mul_cs_r3_r11_r10[] = {
  0x9b, 0x0a, 0x03, 0x20 // mul cs r3 r11 r10
};
const byte kInstruction_mul_ls_r11_r4_r0[] = {
  0x94, 0x00, 0x0b, 0x90 // mul ls r11 r4 r0
};
const byte kInstruction_mul_hi_r11_r8_r9[] = {
  0x98, 0x09, 0x0b, 0x80 // mul hi r11 r8 r9
};
const byte kInstruction_mul_vs_r2_r14_r13[] = {
  0x9e, 0x0d, 0x02, 0x60 // mul vs r2 r14 r13
};
const byte kInstruction_mul_al_r1_r13_r9[] = {
  0x9d, 0x09, 0x01, 0xe0 // mul al r1 r13 r9
};
const byte kInstruction_mul_eq_r3_r9_r13[] = {
  0x99, 0x0d, 0x03, 0x00 // mul eq r3 r9 r13
};
const byte kInstruction_mul_ge_r10_r3_r13[] = {
  0x93, 0x0d, 0x0a, 0xa0 // mul ge r10 r3 r13
};
const byte kInstruction_mul_pl_r8_r5_r10[] = {
  0x95, 0x0a, 0x08, 0x50 // mul pl r8 r5 r10
};
const byte kInstruction_mul_vc_r8_r11_r6[] = {
  0x9b, 0x06, 0x08, 0x70 // mul vc r8 r11 r6
};
const byte kInstruction_mul_eq_r0_r0_r5[] = {
  0x90, 0x05, 0x00, 0x00 // mul eq r0 r0 r5
};
const byte kInstruction_mul_ne_r6_r5_r8[] = {
  0x95, 0x08, 0x06, 0x10 // mul ne r6 r5 r8
};
const byte kInstruction_mul_hi_r5_r13_r3[] = {
  0x9d, 0x03, 0x05, 0x80 // mul hi r5 r13 r3
};
const byte kInstruction_mul_ne_r11_r14_r14[] = {
  0x9e, 0x0e, 0x0b, 0x10 // mul ne r11 r14 r14
};
const byte kInstruction_mul_mi_r1_r0_r6[] = {
  0x90, 0x06, 0x01, 0x40 // mul mi r1 r0 r6
};
const byte kInstruction_mul_le_r14_r8_r2[] = {
  0x98, 0x02, 0x0e, 0xd0 // mul le r14 r8 r2
};
const byte kInstruction_mul_eq_r9_r6_r5[] = {
  0x96, 0x05, 0x09, 0x00 // mul eq r9 r6 r5
};
const byte kInstruction_mul_eq_r11_r0_r13[] = {
  0x90, 0x0d, 0x0b, 0x00 // mul eq r11 r0 r13
};
const byte kInstruction_mul_pl_r4_r5_r14[] = {
  0x95, 0x0e, 0x04, 0x50 // mul pl r4 r5 r14
};
const byte kInstruction_mul_cs_r13_r5_r13[] = {
  0x95, 0x0d, 0x0d, 0x20 // mul cs r13 r5 r13
};
const byte kInstruction_mul_mi_r0_r13_r8[] = {
  0x9d, 0x08, 0x00, 0x40 // mul mi r0 r13 r8
};
const byte kInstruction_mul_lt_r2_r13_r3[] = {
  0x9d, 0x03, 0x02, 0xb0 // mul lt r2 r13 r3
};
const byte kInstruction_mul_ls_r8_r1_r11[] = {
  0x91, 0x0b, 0x08, 0x90 // mul ls r8 r1 r11
};
const byte kInstruction_mul_vc_r14_r11_r8[] = {
  0x9b, 0x08, 0x0e, 0x70 // mul vc r14 r11 r8
};
const byte kInstruction_mul_lt_r4_r13_r12[] = {
  0x9d, 0x0c, 0x04, 0xb0 // mul lt r4 r13 r12
};
const byte kInstruction_mul_eq_r2_r1_r14[] = {
  0x91, 0x0e, 0x02, 0x00 // mul eq r2 r1 r14
};
const byte kInstruction_mul_eq_r9_r4_r14[] = {
  0x94, 0x0e, 0x09, 0x00 // mul eq r9 r4 r14
};
const byte kInstruction_mul_hi_r10_r6_r13[] = {
  0x96, 0x0d, 0x0a, 0x80 // mul hi r10 r6 r13
};
const byte kInstruction_mul_ge_r12_r9_r4[] = {
  0x99, 0x04, 0x0c, 0xa0 // mul ge r12 r9 r4
};
const byte kInstruction_mul_le_r9_r11_r14[] = {
  0x9b, 0x0e, 0x09, 0xd0 // mul le r9 r11 r14
};
const byte kInstruction_mul_ls_r0_r9_r5[] = {
  0x99, 0x05, 0x00, 0x90 // mul ls r0 r9 r5
};
const byte kInstruction_mul_mi_r2_r3_r8[] = {
  0x93, 0x08, 0x02, 0x40 // mul mi r2 r3 r8
};
const byte kInstruction_mul_ne_r14_r10_r14[] = {
  0x9a, 0x0e, 0x0e, 0x10 // mul ne r14 r10 r14
};
const byte kInstruction_mul_eq_r6_r2_r10[] = {
  0x92, 0x0a, 0x06, 0x00 // mul eq r6 r2 r10
};
const byte kInstruction_mul_lt_r11_r0_r12[] = {
  0x90, 0x0c, 0x0b, 0xb0 // mul lt r11 r0 r12
};
const byte kInstruction_mul_ne_r1_r12_r10[] = {
  0x9c, 0x0a, 0x01, 0x10 // mul ne r1 r12 r10
};
const byte kInstruction_mul_cc_r1_r0_r2[] = {
  0x90, 0x02, 0x01, 0x30 // mul cc r1 r0 r2
};
const byte kInstruction_mul_al_r5_r5_r7[] = {
  0x95, 0x07, 0x05, 0xe0 // mul al r5 r5 r7
};
const byte kInstruction_mul_hi_r7_r13_r1[] = {
  0x9d, 0x01, 0x07, 0x80 // mul hi r7 r13 r1
};
const byte kInstruction_mul_cs_r4_r4_r9[] = {
  0x94, 0x09, 0x04, 0x20 // mul cs r4 r4 r9
};
const byte kInstruction_mul_eq_r14_r4_r14[] = {
  0x94, 0x0e, 0x0e, 0x00 // mul eq r14 r4 r14
};
const byte kInstruction_mul_vs_r10_r5_r14[] = {
  0x95, 0x0e, 0x0a, 0x60 // mul vs r10 r5 r14
};
const byte kInstruction_mul_gt_r4_r3_r11[] = {
  0x93, 0x0b, 0x04, 0xc0 // mul gt r4 r3 r11
};
const byte kInstruction_mul_ne_r14_r10_r12[] = {
  0x9a, 0x0c, 0x0e, 0x10 // mul ne r14 r10 r12
};
const byte kInstruction_mul_vs_r2_r11_r0[] = {
  0x9b, 0x00, 0x02, 0x60 // mul vs r2 r11 r0
};
const byte kInstruction_mul_ge_r5_r12_r7[] = {
  0x9c, 0x07, 0x05, 0xa0 // mul ge r5 r12 r7
};
const byte kInstruction_mul_mi_r7_r14_r6[] = {
  0x9e, 0x06, 0x07, 0x40 // mul mi r7 r14 r6
};
const byte kInstruction_mul_gt_r8_r3_r8[] = {
  0x93, 0x08, 0x08, 0xc0 // mul gt r8 r3 r8
};
const byte kInstruction_mul_hi_r9_r14_r3[] = {
  0x9e, 0x03, 0x09, 0x80 // mul hi r9 r14 r3
};
const byte kInstruction_mul_vc_r2_r11_r2[] = {
  0x9b, 0x02, 0x02, 0x70 // mul vc r2 r11 r2
};
const byte kInstruction_mul_hi_r11_r7_r12[] = {
  0x97, 0x0c, 0x0b, 0x80 // mul hi r11 r7 r12
};
const byte kInstruction_mul_cs_r6_r4_r11[] = {
  0x94, 0x0b, 0x06, 0x20 // mul cs r6 r4 r11
};
const byte kInstruction_mul_cs_r12_r5_r9[] = {
  0x95, 0x09, 0x0c, 0x20 // mul cs r12 r5 r9
};
const byte kInstruction_mul_ls_r5_r10_r5[] = {
  0x9a, 0x05, 0x05, 0x90 // mul ls r5 r10 r5
};
const byte kInstruction_mul_ls_r0_r9_r13[] = {
  0x99, 0x0d, 0x00, 0x90 // mul ls r0 r9 r13
};
const byte kInstruction_mul_lt_r3_r3_r5[] = {
  0x93, 0x05, 0x03, 0xb0 // mul lt r3 r3 r5
};
const byte kInstruction_mul_mi_r0_r12_r8[] = {
  0x9c, 0x08, 0x00, 0x40 // mul mi r0 r12 r8
};
const byte kInstruction_mul_pl_r3_r12_r12[] = {
  0x9c, 0x0c, 0x03, 0x50 // mul pl r3 r12 r12
};
const byte kInstruction_mul_eq_r8_r12_r5[] = {
  0x9c, 0x05, 0x08, 0x00 // mul eq r8 r12 r5
};
const byte kInstruction_mul_cc_r7_r8_r1[] = {
  0x98, 0x01, 0x07, 0x30 // mul cc r7 r8 r1
};
const byte kInstruction_mul_hi_r2_r13_r10[] = {
  0x9d, 0x0a, 0x02, 0x80 // mul hi r2 r13 r10
};
const byte kInstruction_mul_al_r7_r10_r10[] = {
  0x9a, 0x0a, 0x07, 0xe0 // mul al r7 r10 r10
};
const byte kInstruction_mul_vc_r1_r12_r2[] = {
  0x9c, 0x02, 0x01, 0x70 // mul vc r1 r12 r2
};
const byte kInstruction_mul_cc_r8_r5_r8[] = {
  0x95, 0x08, 0x08, 0x30 // mul cc r8 r5 r8
};
const byte kInstruction_mul_ls_r3_r7_r9[] = {
  0x97, 0x09, 0x03, 0x90 // mul ls r3 r7 r9
};
const byte kInstruction_mul_al_r8_r10_r8[] = {
  0x9a, 0x08, 0x08, 0xe0 // mul al r8 r10 r8
};
const byte kInstruction_mul_lt_r4_r12_r10[] = {
  0x9c, 0x0a, 0x04, 0xb0 // mul lt r4 r12 r10
};
const byte kInstruction_mul_ge_r10_r5_r11[] = {
  0x95, 0x0b, 0x0a, 0xa0 // mul ge r10 r5 r11
};
const byte kInstruction_mul_ls_r3_r14_r4[] = {
  0x9e, 0x04, 0x03, 0x90 // mul ls r3 r14 r4
};
const byte kInstruction_mul_hi_r3_r6_r12[] = {
  0x96, 0x0c, 0x03, 0x80 // mul hi r3 r6 r12
};
const byte kInstruction_mul_hi_r6_r0_r4[] = {
  0x90, 0x04, 0x06, 0x80 // mul hi r6 r0 r4
};
const byte kInstruction_mul_al_r11_r6_r0[] = {
  0x96, 0x00, 0x0b, 0xe0 // mul al r11 r6 r0
};
const byte kInstruction_mul_mi_r3_r1_r9[] = {
  0x91, 0x09, 0x03, 0x40 // mul mi r3 r1 r9
};
const byte kInstruction_mul_mi_r12_r13_r0[] = {
  0x9d, 0x00, 0x0c, 0x40 // mul mi r12 r13 r0
};
const byte kInstruction_mul_le_r1_r2_r5[] = {
  0x92, 0x05, 0x01, 0xd0 // mul le r1 r2 r5
};
const byte kInstruction_mul_hi_r4_r3_r14[] = {
  0x93, 0x0e, 0x04, 0x80 // mul hi r4 r3 r14
};
const byte kInstruction_mul_eq_r6_r11_r11[] = {
  0x9b, 0x0b, 0x06, 0x00 // mul eq r6 r11 r11
};
const byte kInstruction_mul_cc_r14_r11_r14[] = {
  0x9b, 0x0e, 0x0e, 0x30 // mul cc r14 r11 r14
};
const byte kInstruction_mul_hi_r4_r10_r0[] = {
  0x9a, 0x00, 0x04, 0x80 // mul hi r4 r10 r0
};
const byte kInstruction_mul_cc_r7_r11_r1[] = {
  0x9b, 0x01, 0x07, 0x30 // mul cc r7 r11 r1
};
const byte kInstruction_mul_mi_r14_r6_r10[] = {
  0x96, 0x0a, 0x0e, 0x40 // mul mi r14 r6 r10
};
const byte kInstruction_mul_eq_r2_r0_r11[] = {
  0x90, 0x0b, 0x02, 0x00 // mul eq r2 r0 r11
};
const byte kInstruction_mul_mi_r13_r5_r12[] = {
  0x95, 0x0c, 0x0d, 0x40 // mul mi r13 r5 r12
};
const byte kInstruction_mul_eq_r2_r12_r5[] = {
  0x9c, 0x05, 0x02, 0x00 // mul eq r2 r12 r5
};
const byte kInstruction_mul_le_r12_r0_r2[] = {
  0x90, 0x02, 0x0c, 0xd0 // mul le r12 r0 r2
};
const byte kInstruction_mul_vc_r10_r10_r9[] = {
  0x9a, 0x09, 0x0a, 0x70 // mul vc r10 r10 r9
};
const byte kInstruction_mul_ls_r11_r11_r8[] = {
  0x9b, 0x08, 0x0b, 0x90 // mul ls r11 r11 r8
};
const byte kInstruction_mul_hi_r10_r11_r9[] = {
  0x9b, 0x09, 0x0a, 0x80 // mul hi r10 r11 r9
};
const byte kInstruction_mul_vs_r7_r12_r14[] = {
  0x9c, 0x0e, 0x07, 0x60 // mul vs r7 r12 r14
};
const byte kInstruction_mul_gt_r11_r14_r12[] = {
  0x9e, 0x0c, 0x0b, 0xc0 // mul gt r11 r14 r12
};
const byte kInstruction_mul_vs_r0_r12_r8[] = {
  0x9c, 0x08, 0x00, 0x60 // mul vs r0 r12 r8
};
const byte kInstruction_mul_al_r0_r5_r7[] = {
  0x95, 0x07, 0x00, 0xe0 // mul al r0 r5 r7
};
const byte kInstruction_mul_hi_r5_r13_r8[] = {
  0x9d, 0x08, 0x05, 0x80 // mul hi r5 r13 r8
};
const byte kInstruction_mul_le_r9_r9_r7[] = {
  0x99, 0x07, 0x09, 0xd0 // mul le r9 r9 r7
};
const byte kInstruction_mul_cc_r4_r9_r5[] = {
  0x99, 0x05, 0x04, 0x30 // mul cc r4 r9 r5
};
const byte kInstruction_mul_vs_r8_r1_r3[] = {
  0x91, 0x03, 0x08, 0x60 // mul vs r8 r1 r3
};
const byte kInstruction_mul_cc_r0_r10_r12[] = {
  0x9a, 0x0c, 0x00, 0x30 // mul cc r0 r10 r12
};
const byte kInstruction_mul_eq_r7_r14_r0[] = {
  0x9e, 0x00, 0x07, 0x00 // mul eq r7 r14 r0
};
const byte kInstruction_mul_vs_r12_r9_r11[] = {
  0x99, 0x0b, 0x0c, 0x60 // mul vs r12 r9 r11
};
const byte kInstruction_mul_gt_r5_r9_r11[] = {
  0x99, 0x0b, 0x05, 0xc0 // mul gt r5 r9 r11
};
const byte kInstruction_mul_cs_r14_r13_r7[] = {
  0x9d, 0x07, 0x0e, 0x20 // mul cs r14 r13 r7
};
const byte kInstruction_mul_mi_r11_r3_r10[] = {
  0x93, 0x0a, 0x0b, 0x40 // mul mi r11 r3 r10
};
const byte kInstruction_mul_hi_r11_r8_r12[] = {
  0x98, 0x0c, 0x0b, 0x80 // mul hi r11 r8 r12
};
const byte kInstruction_mul_cs_r3_r8_r13[] = {
  0x98, 0x0d, 0x03, 0x20 // mul cs r3 r8 r13
};
const byte kInstruction_mul_pl_r10_r12_r6[] = {
  0x9c, 0x06, 0x0a, 0x50 // mul pl r10 r12 r6
};
const byte kInstruction_mul_vc_r7_r3_r2[] = {
  0x93, 0x02, 0x07, 0x70 // mul vc r7 r3 r2
};
const byte kInstruction_mul_mi_r9_r0_r8[] = {
  0x90, 0x08, 0x09, 0x40 // mul mi r9 r0 r8
};
const byte kInstruction_mul_eq_r2_r13_r7[] = {
  0x9d, 0x07, 0x02, 0x00 // mul eq r2 r13 r7
};
const byte kInstruction_mul_ne_r2_r14_r0[] = {
  0x9e, 0x00, 0x02, 0x10 // mul ne r2 r14 r0
};
const byte kInstruction_mul_vs_r4_r10_r0[] = {
  0x9a, 0x00, 0x04, 0x60 // mul vs r4 r10 r0
};
const byte kInstruction_mul_ls_r0_r2_r2[] = {
  0x92, 0x02, 0x00, 0x90 // mul ls r0 r2 r2
};
const byte kInstruction_mul_cc_r1_r6_r0[] = {
  0x96, 0x00, 0x01, 0x30 // mul cc r1 r6 r0
};
const byte kInstruction_mul_lt_r12_r0_r8[] = {
  0x90, 0x08, 0x0c, 0xb0 // mul lt r12 r0 r8
};
const byte kInstruction_mul_cc_r9_r3_r14[] = {
  0x93, 0x0e, 0x09, 0x30 // mul cc r9 r3 r14
};
const byte kInstruction_mul_vs_r7_r9_r1[] = {
  0x99, 0x01, 0x07, 0x60 // mul vs r7 r9 r1
};
const byte kInstruction_mul_eq_r11_r9_r14[] = {
  0x99, 0x0e, 0x0b, 0x00 // mul eq r11 r9 r14
};
const byte kInstruction_mul_pl_r6_r10_r4[] = {
  0x9a, 0x04, 0x06, 0x50 // mul pl r6 r10 r4
};
const byte kInstruction_mul_ne_r8_r5_r6[] = {
  0x95, 0x06, 0x08, 0x10 // mul ne r8 r5 r6
};
const byte kInstruction_mul_cs_r0_r6_r2[] = {
  0x96, 0x02, 0x00, 0x20 // mul cs r0 r6 r2
};
const byte kInstruction_mul_eq_r11_r12_r4[] = {
  0x9c, 0x04, 0x0b, 0x00 // mul eq r11 r12 r4
};
const byte kInstruction_mul_lt_r14_r3_r14[] = {
  0x93, 0x0e, 0x0e, 0xb0 // mul lt r14 r3 r14
};
const byte kInstruction_mul_le_r7_r12_r14[] = {
  0x9c, 0x0e, 0x07, 0xd0 // mul le r7 r12 r14
};
const byte kInstruction_mul_hi_r2_r9_r9[] = {
  0x99, 0x09, 0x02, 0x80 // mul hi r2 r9 r9
};
const byte kInstruction_mul_ne_r8_r1_r0[] = {
  0x91, 0x00, 0x08, 0x10 // mul ne r8 r1 r0
};
const byte kInstruction_mul_cc_r5_r11_r2[] = {
  0x9b, 0x02, 0x05, 0x30 // mul cc r5 r11 r2
};
const byte kInstruction_mul_hi_r0_r1_r2[] = {
  0x91, 0x02, 0x00, 0x80 // mul hi r0 r1 r2
};
const byte kInstruction_mul_al_r4_r9_r4[] = {
  0x99, 0x04, 0x04, 0xe0 // mul al r4 r9 r4
};
const byte kInstruction_mul_cs_r12_r7_r14[] = {
  0x97, 0x0e, 0x0c, 0x20 // mul cs r12 r7 r14
};
const byte kInstruction_mul_cc_r4_r12_r10[] = {
  0x9c, 0x0a, 0x04, 0x30 // mul cc r4 r12 r10
};
const byte kInstruction_mul_al_r3_r5_r10[] = {
  0x95, 0x0a, 0x03, 0xe0 // mul al r3 r5 r10
};
const byte kInstruction_mul_mi_r5_r3_r7[] = {
  0x93, 0x07, 0x05, 0x40 // mul mi r5 r3 r7
};
const byte kInstruction_mul_ls_r10_r6_r2[] = {
  0x96, 0x02, 0x0a, 0x90 // mul ls r10 r6 r2
};
const byte kInstruction_mul_mi_r0_r12_r11[] = {
  0x9c, 0x0b, 0x00, 0x40 // mul mi r0 r12 r11
};
const byte kInstruction_mul_vc_r12_r5_r6[] = {
  0x95, 0x06, 0x0c, 0x70 // mul vc r12 r5 r6
};
const byte kInstruction_mul_cs_r3_r9_r4[] = {
  0x99, 0x04, 0x03, 0x20 // mul cs r3 r9 r4
};
const byte kInstruction_mul_ls_r4_r9_r11[] = {
  0x99, 0x0b, 0x04, 0x90 // mul ls r4 r9 r11
};
const byte kInstruction_mul_le_r14_r8_r13[] = {
  0x98, 0x0d, 0x0e, 0xd0 // mul le r14 r8 r13
};
const byte kInstruction_mul_gt_r4_r10_r8[] = {
  0x9a, 0x08, 0x04, 0xc0 // mul gt r4 r10 r8
};
const byte kInstruction_mul_al_r6_r9_r9[] = {
  0x99, 0x09, 0x06, 0xe0 // mul al r6 r9 r9
};
const byte kInstruction_mul_ne_r8_r5_r12[] = {
  0x95, 0x0c, 0x08, 0x10 // mul ne r8 r5 r12
};
const byte kInstruction_mul_ne_r0_r4_r8[] = {
  0x94, 0x08, 0x00, 0x10 // mul ne r0 r4 r8
};
const byte kInstruction_mul_mi_r7_r13_r3[] = {
  0x9d, 0x03, 0x07, 0x40 // mul mi r7 r13 r3
};
const byte kInstruction_mul_cc_r11_r7_r0[] = {
  0x97, 0x00, 0x0b, 0x30 // mul cc r11 r7 r0
};
const byte kInstruction_mul_hi_r1_r0_r12[] = {
  0x90, 0x0c, 0x01, 0x80 // mul hi r1 r0 r12
};
const byte kInstruction_mul_lt_r8_r9_r3[] = {
  0x99, 0x03, 0x08, 0xb0 // mul lt r8 r9 r3
};
const byte kInstruction_mul_al_r0_r2_r1[] = {
  0x92, 0x01, 0x00, 0xe0 // mul al r0 r2 r1
};
const byte kInstruction_mul_vs_r4_r3_r14[] = {
  0x93, 0x0e, 0x04, 0x60 // mul vs r4 r3 r14
};
const byte kInstruction_mul_ge_r2_r11_r1[] = {
  0x9b, 0x01, 0x02, 0xa0 // mul ge r2 r11 r1
};
const byte kInstruction_mul_lt_r12_r9_r6[] = {
  0x99, 0x06, 0x0c, 0xb0 // mul lt r12 r9 r6
};
const byte kInstruction_mul_ls_r8_r2_r7[] = {
  0x92, 0x07, 0x08, 0x90 // mul ls r8 r2 r7
};
const byte kInstruction_mul_le_r8_r13_r3[] = {
  0x9d, 0x03, 0x08, 0xd0 // mul le r8 r13 r3
};
const byte kInstruction_mul_eq_r11_r13_r14[] = {
  0x9d, 0x0e, 0x0b, 0x00 // mul eq r11 r13 r14
};
const byte kInstruction_mul_lt_r1_r6_r13[] = {
  0x96, 0x0d, 0x01, 0xb0 // mul lt r1 r6 r13
};
const byte kInstruction_mul_cs_r3_r8_r11[] = {
  0x98, 0x0b, 0x03, 0x20 // mul cs r3 r8 r11
};
const byte kInstruction_mul_pl_r12_r5_r4[] = {
  0x95, 0x04, 0x0c, 0x50 // mul pl r12 r5 r4
};
const byte kInstruction_mul_eq_r8_r7_r2[] = {
  0x97, 0x02, 0x08, 0x00 // mul eq r8 r7 r2
};
const byte kInstruction_mul_ls_r2_r12_r2[] = {
  0x9c, 0x02, 0x02, 0x90 // mul ls r2 r12 r2
};
const byte kInstruction_mul_le_r14_r2_r3[] = {
  0x92, 0x03, 0x0e, 0xd0 // mul le r14 r2 r3
};
const byte kInstruction_mul_ge_r10_r11_r6[] = {
  0x9b, 0x06, 0x0a, 0xa0 // mul ge r10 r11 r6
};
const byte kInstruction_mul_hi_r0_r2_r2[] = {
  0x92, 0x02, 0x00, 0x80 // mul hi r0 r2 r2
};
const byte kInstruction_mul_ge_r2_r0_r2[] = {
  0x90, 0x02, 0x02, 0xa0 // mul ge r2 r0 r2
};
const byte kInstruction_mul_vs_r11_r14_r0[] = {
  0x9e, 0x00, 0x0b, 0x60 // mul vs r11 r14 r0
};
const byte kInstruction_mul_lt_r2_r0_r1[] = {
  0x90, 0x01, 0x02, 0xb0 // mul lt r2 r0 r1
};
const byte kInstruction_mul_cs_r2_r5_r11[] = {
  0x95, 0x0b, 0x02, 0x20 // mul cs r2 r5 r11
};
const byte kInstruction_mul_ls_r7_r14_r5[] = {
  0x9e, 0x05, 0x07, 0x90 // mul ls r7 r14 r5
};
const byte kInstruction_mul_pl_r0_r0_r3[] = {
  0x90, 0x03, 0x00, 0x50 // mul pl r0 r0 r3
};
const byte kInstruction_mul_ge_r6_r8_r8[] = {
  0x98, 0x08, 0x06, 0xa0 // mul ge r6 r8 r8
};
const byte kInstruction_mul_le_r11_r1_r10[] = {
  0x91, 0x0a, 0x0b, 0xd0 // mul le r11 r1 r10
};
const byte kInstruction_mul_vs_r5_r2_r7[] = {
  0x92, 0x07, 0x05, 0x60 // mul vs r5 r2 r7
};
const byte kInstruction_mul_ne_r4_r4_r8[] = {
  0x94, 0x08, 0x04, 0x10 // mul ne r4 r4 r8
};
const byte kInstruction_mul_cc_r9_r14_r13[] = {
  0x9e, 0x0d, 0x09, 0x30 // mul cc r9 r14 r13
};
const byte kInstruction_mul_hi_r14_r6_r3[] = {
  0x96, 0x03, 0x0e, 0x80 // mul hi r14 r6 r3
};
const byte kInstruction_mul_al_r0_r8_r0[] = {
  0x98, 0x00, 0x00, 0xe0 // mul al r0 r8 r0
};
const byte kInstruction_mul_lt_r6_r11_r1[] = {
  0x9b, 0x01, 0x06, 0xb0 // mul lt r6 r11 r1
};
const byte kInstruction_mul_ge_r7_r6_r12[] = {
  0x96, 0x0c, 0x07, 0xa0 // mul ge r7 r6 r12
};
const byte kInstruction_mul_cs_r4_r6_r14[] = {
  0x96, 0x0e, 0x04, 0x20 // mul cs r4 r6 r14
};
const byte kInstruction_mul_cs_r7_r6_r7[] = {
  0x96, 0x07, 0x07, 0x20 // mul cs r7 r6 r7
};
const byte kInstruction_mul_cs_r3_r7_r10[] = {
  0x97, 0x0a, 0x03, 0x20 // mul cs r3 r7 r10
};
const byte kInstruction_mul_ne_r0_r2_r1[] = {
  0x92, 0x01, 0x00, 0x10 // mul ne r0 r2 r1
};
const byte kInstruction_mul_vs_r9_r10_r13[] = {
  0x9a, 0x0d, 0x09, 0x60 // mul vs r9 r10 r13
};
const byte kInstruction_mul_vc_r11_r14_r12[] = {
  0x9e, 0x0c, 0x0b, 0x70 // mul vc r11 r14 r12
};
const byte kInstruction_mul_ge_r14_r8_r7[] = {
  0x98, 0x07, 0x0e, 0xa0 // mul ge r14 r8 r7
};
const byte kInstruction_mul_lt_r13_r0_r11[] = {
  0x90, 0x0b, 0x0d, 0xb0 // mul lt r13 r0 r11
};
const byte kInstruction_mul_lt_r14_r13_r4[] = {
  0x9d, 0x04, 0x0e, 0xb0 // mul lt r14 r13 r4
};
const byte kInstruction_mul_al_r1_r10_r9[] = {
  0x9a, 0x09, 0x01, 0xe0 // mul al r1 r10 r9
};
const byte kInstruction_mul_ge_r11_r14_r11[] = {
  0x9e, 0x0b, 0x0b, 0xa0 // mul ge r11 r14 r11
};
const byte kInstruction_mul_cs_r11_r4_r11[] = {
  0x94, 0x0b, 0x0b, 0x20 // mul cs r11 r4 r11
};
const byte kInstruction_mul_ge_r0_r14_r7[] = {
  0x9e, 0x07, 0x00, 0xa0 // mul ge r0 r14 r7
};
const byte kInstruction_mul_mi_r1_r2_r9[] = {
  0x92, 0x09, 0x01, 0x40 // mul mi r1 r2 r9
};
const byte kInstruction_mul_eq_r5_r12_r3[] = {
  0x9c, 0x03, 0x05, 0x00 // mul eq r5 r12 r3
};
const byte kInstruction_mul_ge_r1_r5_r12[] = {
  0x95, 0x0c, 0x01, 0xa0 // mul ge r1 r5 r12
};
const byte kInstruction_mul_lt_r10_r11_r4[] = {
  0x9b, 0x04, 0x0a, 0xb0 // mul lt r10 r11 r4
};
const byte kInstruction_mul_le_r1_r1_r5[] = {
  0x91, 0x05, 0x01, 0xd0 // mul le r1 r1 r5
};
const byte kInstruction_mul_al_r9_r1_r8[] = {
  0x91, 0x08, 0x09, 0xe0 // mul al r9 r1 r8
};
const byte kInstruction_mul_ne_r6_r8_r4[] = {
  0x98, 0x04, 0x06, 0x10 // mul ne r6 r8 r4
};
const byte kInstruction_mul_ge_r12_r2_r9[] = {
  0x92, 0x09, 0x0c, 0xa0 // mul ge r12 r2 r9
};
const byte kInstruction_mul_pl_r4_r3_r10[] = {
  0x93, 0x0a, 0x04, 0x50 // mul pl r4 r3 r10
};
const byte kInstruction_mul_eq_r14_r4_r11[] = {
  0x94, 0x0b, 0x0e, 0x00 // mul eq r14 r4 r11
};
const byte kInstruction_mul_cc_r9_r7_r6[] = {
  0x97, 0x06, 0x09, 0x30 // mul cc r9 r7 r6
};
const byte kInstruction_mul_ge_r12_r4_r5[] = {
  0x94, 0x05, 0x0c, 0xa0 // mul ge r12 r4 r5
};
const byte kInstruction_mul_hi_r2_r3_r4[] = {
  0x93, 0x04, 0x02, 0x80 // mul hi r2 r3 r4
};
const byte kInstruction_mul_cs_r0_r3_r1[] = {
  0x93, 0x01, 0x00, 0x20 // mul cs r0 r3 r1
};
const byte kInstruction_mul_hi_r6_r2_r8[] = {
  0x92, 0x08, 0x06, 0x80 // mul hi r6 r2 r8
};
const byte kInstruction_mul_cc_r3_r14_r13[] = {
  0x9e, 0x0d, 0x03, 0x30 // mul cc r3 r14 r13
};
const byte kInstruction_mul_gt_r11_r4_r7[] = {
  0x94, 0x07, 0x0b, 0xc0 // mul gt r11 r4 r7
};
const byte kInstruction_mul_hi_r5_r0_r12[] = {
  0x90, 0x0c, 0x05, 0x80 // mul hi r5 r0 r12
};
const byte kInstruction_mul_gt_r0_r14_r14[] = {
  0x9e, 0x0e, 0x00, 0xc0 // mul gt r0 r14 r14
};
const byte kInstruction_mul_hi_r9_r0_r10[] = {
  0x90, 0x0a, 0x09, 0x80 // mul hi r9 r0 r10
};
const byte kInstruction_mul_vc_r7_r11_r8[] = {
  0x9b, 0x08, 0x07, 0x70 // mul vc r7 r11 r8
};
const byte kInstruction_mul_pl_r11_r9_r6[] = {
  0x99, 0x06, 0x0b, 0x50 // mul pl r11 r9 r6
};
const byte kInstruction_mul_al_r3_r3_r7[] = {
  0x93, 0x07, 0x03, 0xe0 // mul al r3 r3 r7
};
const byte kInstruction_mul_mi_r5_r7_r9[] = {
  0x97, 0x09, 0x05, 0x40 // mul mi r5 r7 r9
};
const byte kInstruction_mul_cc_r11_r2_r4[] = {
  0x92, 0x04, 0x0b, 0x30 // mul cc r11 r2 r4
};
const byte kInstruction_mul_cc_r9_r13_r10[] = {
  0x9d, 0x0a, 0x09, 0x30 // mul cc r9 r13 r10
};
const byte kInstruction_mul_al_r5_r2_r6[] = {
  0x92, 0x06, 0x05, 0xe0 // mul al r5 r2 r6
};
const byte kInstruction_mul_ge_r9_r4_r6[] = {
  0x94, 0x06, 0x09, 0xa0 // mul ge r9 r4 r6
};
const byte kInstruction_mul_ls_r3_r3_r4[] = {
  0x93, 0x04, 0x03, 0x90 // mul ls r3 r3 r4
};
const byte kInstruction_mul_ge_r14_r1_r8[] = {
  0x91, 0x08, 0x0e, 0xa0 // mul ge r14 r1 r8
};
const byte kInstruction_mul_ls_r7_r12_r7[] = {
  0x9c, 0x07, 0x07, 0x90 // mul ls r7 r12 r7
};
const byte kInstruction_mul_al_r11_r10_r5[] = {
  0x9a, 0x05, 0x0b, 0xe0 // mul al r11 r10 r5
};
const byte kInstruction_mul_al_r7_r4_r6[] = {
  0x94, 0x06, 0x07, 0xe0 // mul al r7 r4 r6
};
const byte kInstruction_mul_vs_r12_r4_r10[] = {
  0x94, 0x0a, 0x0c, 0x60 // mul vs r12 r4 r10
};
const byte kInstruction_mul_eq_r4_r4_r4[] = {
  0x94, 0x04, 0x04, 0x00 // mul eq r4 r4 r4
};
const byte kInstruction_mul_vs_r6_r6_r12[] = {
  0x96, 0x0c, 0x06, 0x60 // mul vs r6 r6 r12
};
const byte kInstruction_mul_pl_r9_r3_r5[] = {
  0x93, 0x05, 0x09, 0x50 // mul pl r9 r3 r5
};
const byte kInstruction_mul_eq_r6_r5_r13[] = {
  0x95, 0x0d, 0x06, 0x00 // mul eq r6 r5 r13
};
const byte kInstruction_mul_cc_r8_r2_r12[] = {
  0x92, 0x0c, 0x08, 0x30 // mul cc r8 r2 r12
};
const byte kInstruction_mul_le_r4_r2_r0[] = {
  0x92, 0x00, 0x04, 0xd0 // mul le r4 r2 r0
};
const byte kInstruction_mul_lt_r7_r9_r8[] = {
  0x99, 0x08, 0x07, 0xb0 // mul lt r7 r9 r8
};
const byte kInstruction_mul_le_r4_r7_r11[] = {
  0x97, 0x0b, 0x04, 0xd0 // mul le r4 r7 r11
};
const byte kInstruction_mul_eq_r5_r7_r5[] = {
  0x97, 0x05, 0x05, 0x00 // mul eq r5 r7 r5
};
const byte kInstruction_mul_vc_r10_r7_r12[] = {
  0x97, 0x0c, 0x0a, 0x70 // mul vc r10 r7 r12
};
const byte kInstruction_mul_eq_r7_r10_r6[] = {
  0x9a, 0x06, 0x07, 0x00 // mul eq r7 r10 r6
};
const byte kInstruction_mul_pl_r1_r12_r2[] = {
  0x9c, 0x02, 0x01, 0x50 // mul pl r1 r12 r2
};
const byte kInstruction_mul_le_r14_r6_r6[] = {
  0x96, 0x06, 0x0e, 0xd0 // mul le r14 r6 r6
};
const byte kInstruction_mul_ne_r3_r8_r8[] = {
  0x98, 0x08, 0x03, 0x10 // mul ne r3 r8 r8
};
const byte kInstruction_mul_eq_r4_r12_r8[] = {
  0x9c, 0x08, 0x04, 0x00 // mul eq r4 r12 r8
};
const byte kInstruction_mul_ge_r11_r2_r3[] = {
  0x92, 0x03, 0x0b, 0xa0 // mul ge r11 r2 r3
};
const byte kInstruction_mul_hi_r12_r6_r11[] = {
  0x96, 0x0b, 0x0c, 0x80 // mul hi r12 r6 r11
};
const byte kInstruction_mul_cs_r4_r5_r10[] = {
  0x95, 0x0a, 0x04, 0x20 // mul cs r4 r5 r10
};
const byte kInstruction_mul_ge_r10_r2_r10[] = {
  0x92, 0x0a, 0x0a, 0xa0 // mul ge r10 r2 r10
};
const byte kInstruction_mul_ge_r5_r14_r6[] = {
  0x9e, 0x06, 0x05, 0xa0 // mul ge r5 r14 r6
};
const byte kInstruction_mul_gt_r13_r7_r5[] = {
  0x97, 0x05, 0x0d, 0xc0 // mul gt r13 r7 r5
};
const byte kInstruction_mul_ge_r13_r4_r12[] = {
  0x94, 0x0c, 0x0d, 0xa0 // mul ge r13 r4 r12
};
const byte kInstruction_mul_lt_r8_r10_r14[] = {
  0x9a, 0x0e, 0x08, 0xb0 // mul lt r8 r10 r14
};
const byte kInstruction_mul_le_r4_r3_r13[] = {
  0x93, 0x0d, 0x04, 0xd0 // mul le r4 r3 r13
};
const byte kInstruction_mul_pl_r0_r9_r0[] = {
  0x99, 0x00, 0x00, 0x50 // mul pl r0 r9 r0
};
const byte kInstruction_mul_eq_r2_r3_r1[] = {
  0x93, 0x01, 0x02, 0x00 // mul eq r2 r3 r1
};
const byte kInstruction_mul_vc_r0_r0_r3[] = {
  0x90, 0x03, 0x00, 0x70 // mul vc r0 r0 r3
};
const byte kInstruction_mul_mi_r10_r8_r11[] = {
  0x98, 0x0b, 0x0a, 0x40 // mul mi r10 r8 r11
};
const byte kInstruction_mul_mi_r5_r14_r14[] = {
  0x9e, 0x0e, 0x05, 0x40 // mul mi r5 r14 r14
};
const byte kInstruction_mul_gt_r5_r11_r2[] = {
  0x9b, 0x02, 0x05, 0xc0 // mul gt r5 r11 r2
};
const byte kInstruction_mul_al_r4_r7_r11[] = {
  0x97, 0x0b, 0x04, 0xe0 // mul al r4 r7 r11
};
const TestResult kReferencemul[] = {
  {
    ARRAY_SIZE(kInstruction_mul_hi_r1_r9_r5),
    kInstruction_mul_hi_r1_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_mul_pl_r8_r6_r2),
    kInstruction_mul_pl_r8_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r5_r8_r2),
    kInstruction_mul_hi_r5_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vc_r9_r2_r7),
    kInstruction_mul_vc_r9_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_mul_lt_r4_r6_r3),
    kInstruction_mul_lt_r4_r6_r3,
  },
  {
    ARRAY_SIZE(kInstruction_mul_le_r11_r6_r2),
    kInstruction_mul_le_r11_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cc_r8_r14_r4),
    kInstruction_mul_cc_r8_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_mul_le_r5_r14_r6),
    kInstruction_mul_le_r5_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_mul_lt_r6_r1_r0),
    kInstruction_mul_lt_r6_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_mul_lt_r5_r0_r9),
    kInstruction_mul_lt_r5_r0_r9,
  },
  {
    ARRAY_SIZE(kInstruction_mul_le_r8_r12_r7),
    kInstruction_mul_le_r8_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r7_r14_r6),
    kInstruction_mul_eq_r7_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cs_r7_r4_r6),
    kInstruction_mul_cs_r7_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_mul_gt_r9_r6_r9),
    kInstruction_mul_gt_r9_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ne_r13_r9_r1),
    kInstruction_mul_ne_r13_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ge_r13_r1_r13),
    kInstruction_mul_ge_r13_r1_r13,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ls_r8_r10_r2),
    kInstruction_mul_ls_r8_r10_r2,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r0_r13_r5),
    kInstruction_mul_hi_r0_r13_r5,
  },
  {
    ARRAY_SIZE(kInstruction_mul_pl_r13_r7_r8),
    kInstruction_mul_pl_r13_r7_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ge_r4_r13_r11),
    kInstruction_mul_ge_r4_r13_r11,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cs_r5_r10_r5),
    kInstruction_mul_cs_r5_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cs_r5_r4_r3),
    kInstruction_mul_cs_r5_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ls_r6_r14_r8),
    kInstruction_mul_ls_r6_r14_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vs_r3_r8_r6),
    kInstruction_mul_vs_r3_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vc_r7_r12_r3),
    kInstruction_mul_vc_r7_r12_r3,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ge_r1_r4_r1),
    kInstruction_mul_ge_r1_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cc_r4_r7_r10),
    kInstruction_mul_cc_r4_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cc_r2_r0_r13),
    kInstruction_mul_cc_r2_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vs_r9_r6_r8),
    kInstruction_mul_vs_r9_r6_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cs_r14_r11_r13),
    kInstruction_mul_cs_r14_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_mul_pl_r5_r8_r4),
    kInstruction_mul_pl_r5_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_mul_pl_r2_r3_r7),
    kInstruction_mul_pl_r2_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cs_r7_r12_r14),
    kInstruction_mul_cs_r7_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r6_r6_r1),
    kInstruction_mul_hi_r6_r6_r1,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cc_r6_r9_r6),
    kInstruction_mul_cc_r6_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ne_r12_r12_r0),
    kInstruction_mul_ne_r12_r12_r0,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cc_r9_r3_r8),
    kInstruction_mul_cc_r9_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_mi_r13_r6_r1),
    kInstruction_mul_mi_r13_r6_r1,
  },
  {
    ARRAY_SIZE(kInstruction_mul_lt_r4_r8_r6),
    kInstruction_mul_lt_r4_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r11_r5_r9),
    kInstruction_mul_hi_r11_r5_r9,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cc_r6_r10_r6),
    kInstruction_mul_cc_r6_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r10_r10_r5),
    kInstruction_mul_eq_r10_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_mul_al_r5_r4_r11),
    kInstruction_mul_al_r5_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_mul_pl_r11_r11_r2),
    kInstruction_mul_pl_r11_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ls_r6_r14_r12),
    kInstruction_mul_ls_r6_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vc_r7_r7_r2),
    kInstruction_mul_vc_r7_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r10_r8_r4),
    kInstruction_mul_eq_r10_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_mul_al_r14_r7_r2),
    kInstruction_mul_al_r14_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cs_r3_r11_r10),
    kInstruction_mul_cs_r3_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ls_r11_r4_r0),
    kInstruction_mul_ls_r11_r4_r0,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r11_r8_r9),
    kInstruction_mul_hi_r11_r8_r9,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vs_r2_r14_r13),
    kInstruction_mul_vs_r2_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_mul_al_r1_r13_r9),
    kInstruction_mul_al_r1_r13_r9,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r3_r9_r13),
    kInstruction_mul_eq_r3_r9_r13,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ge_r10_r3_r13),
    kInstruction_mul_ge_r10_r3_r13,
  },
  {
    ARRAY_SIZE(kInstruction_mul_pl_r8_r5_r10),
    kInstruction_mul_pl_r8_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vc_r8_r11_r6),
    kInstruction_mul_vc_r8_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r0_r0_r5),
    kInstruction_mul_eq_r0_r0_r5,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ne_r6_r5_r8),
    kInstruction_mul_ne_r6_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r5_r13_r3),
    kInstruction_mul_hi_r5_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ne_r11_r14_r14),
    kInstruction_mul_ne_r11_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_mul_mi_r1_r0_r6),
    kInstruction_mul_mi_r1_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_mul_le_r14_r8_r2),
    kInstruction_mul_le_r14_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r9_r6_r5),
    kInstruction_mul_eq_r9_r6_r5,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r11_r0_r13),
    kInstruction_mul_eq_r11_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_mul_pl_r4_r5_r14),
    kInstruction_mul_pl_r4_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cs_r13_r5_r13),
    kInstruction_mul_cs_r13_r5_r13,
  },
  {
    ARRAY_SIZE(kInstruction_mul_mi_r0_r13_r8),
    kInstruction_mul_mi_r0_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_lt_r2_r13_r3),
    kInstruction_mul_lt_r2_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ls_r8_r1_r11),
    kInstruction_mul_ls_r8_r1_r11,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vc_r14_r11_r8),
    kInstruction_mul_vc_r14_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_lt_r4_r13_r12),
    kInstruction_mul_lt_r4_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r2_r1_r14),
    kInstruction_mul_eq_r2_r1_r14,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r9_r4_r14),
    kInstruction_mul_eq_r9_r4_r14,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r10_r6_r13),
    kInstruction_mul_hi_r10_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ge_r12_r9_r4),
    kInstruction_mul_ge_r12_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_mul_le_r9_r11_r14),
    kInstruction_mul_le_r9_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ls_r0_r9_r5),
    kInstruction_mul_ls_r0_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_mul_mi_r2_r3_r8),
    kInstruction_mul_mi_r2_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ne_r14_r10_r14),
    kInstruction_mul_ne_r14_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r6_r2_r10),
    kInstruction_mul_eq_r6_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_mul_lt_r11_r0_r12),
    kInstruction_mul_lt_r11_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ne_r1_r12_r10),
    kInstruction_mul_ne_r1_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cc_r1_r0_r2),
    kInstruction_mul_cc_r1_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_mul_al_r5_r5_r7),
    kInstruction_mul_al_r5_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r7_r13_r1),
    kInstruction_mul_hi_r7_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cs_r4_r4_r9),
    kInstruction_mul_cs_r4_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r14_r4_r14),
    kInstruction_mul_eq_r14_r4_r14,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vs_r10_r5_r14),
    kInstruction_mul_vs_r10_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_mul_gt_r4_r3_r11),
    kInstruction_mul_gt_r4_r3_r11,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ne_r14_r10_r12),
    kInstruction_mul_ne_r14_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vs_r2_r11_r0),
    kInstruction_mul_vs_r2_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ge_r5_r12_r7),
    kInstruction_mul_ge_r5_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_mul_mi_r7_r14_r6),
    kInstruction_mul_mi_r7_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_mul_gt_r8_r3_r8),
    kInstruction_mul_gt_r8_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r9_r14_r3),
    kInstruction_mul_hi_r9_r14_r3,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vc_r2_r11_r2),
    kInstruction_mul_vc_r2_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r11_r7_r12),
    kInstruction_mul_hi_r11_r7_r12,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cs_r6_r4_r11),
    kInstruction_mul_cs_r6_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cs_r12_r5_r9),
    kInstruction_mul_cs_r12_r5_r9,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ls_r5_r10_r5),
    kInstruction_mul_ls_r5_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ls_r0_r9_r13),
    kInstruction_mul_ls_r0_r9_r13,
  },
  {
    ARRAY_SIZE(kInstruction_mul_lt_r3_r3_r5),
    kInstruction_mul_lt_r3_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_mul_mi_r0_r12_r8),
    kInstruction_mul_mi_r0_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_pl_r3_r12_r12),
    kInstruction_mul_pl_r3_r12_r12,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r8_r12_r5),
    kInstruction_mul_eq_r8_r12_r5,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cc_r7_r8_r1),
    kInstruction_mul_cc_r7_r8_r1,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r2_r13_r10),
    kInstruction_mul_hi_r2_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_mul_al_r7_r10_r10),
    kInstruction_mul_al_r7_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vc_r1_r12_r2),
    kInstruction_mul_vc_r1_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cc_r8_r5_r8),
    kInstruction_mul_cc_r8_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ls_r3_r7_r9),
    kInstruction_mul_ls_r3_r7_r9,
  },
  {
    ARRAY_SIZE(kInstruction_mul_al_r8_r10_r8),
    kInstruction_mul_al_r8_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_lt_r4_r12_r10),
    kInstruction_mul_lt_r4_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ge_r10_r5_r11),
    kInstruction_mul_ge_r10_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ls_r3_r14_r4),
    kInstruction_mul_ls_r3_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r3_r6_r12),
    kInstruction_mul_hi_r3_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r6_r0_r4),
    kInstruction_mul_hi_r6_r0_r4,
  },
  {
    ARRAY_SIZE(kInstruction_mul_al_r11_r6_r0),
    kInstruction_mul_al_r11_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_mul_mi_r3_r1_r9),
    kInstruction_mul_mi_r3_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_mul_mi_r12_r13_r0),
    kInstruction_mul_mi_r12_r13_r0,
  },
  {
    ARRAY_SIZE(kInstruction_mul_le_r1_r2_r5),
    kInstruction_mul_le_r1_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r4_r3_r14),
    kInstruction_mul_hi_r4_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r6_r11_r11),
    kInstruction_mul_eq_r6_r11_r11,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cc_r14_r11_r14),
    kInstruction_mul_cc_r14_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r4_r10_r0),
    kInstruction_mul_hi_r4_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cc_r7_r11_r1),
    kInstruction_mul_cc_r7_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_mul_mi_r14_r6_r10),
    kInstruction_mul_mi_r14_r6_r10,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r2_r0_r11),
    kInstruction_mul_eq_r2_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_mul_mi_r13_r5_r12),
    kInstruction_mul_mi_r13_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r2_r12_r5),
    kInstruction_mul_eq_r2_r12_r5,
  },
  {
    ARRAY_SIZE(kInstruction_mul_le_r12_r0_r2),
    kInstruction_mul_le_r12_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vc_r10_r10_r9),
    kInstruction_mul_vc_r10_r10_r9,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ls_r11_r11_r8),
    kInstruction_mul_ls_r11_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r10_r11_r9),
    kInstruction_mul_hi_r10_r11_r9,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vs_r7_r12_r14),
    kInstruction_mul_vs_r7_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_mul_gt_r11_r14_r12),
    kInstruction_mul_gt_r11_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vs_r0_r12_r8),
    kInstruction_mul_vs_r0_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_al_r0_r5_r7),
    kInstruction_mul_al_r0_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r5_r13_r8),
    kInstruction_mul_hi_r5_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_le_r9_r9_r7),
    kInstruction_mul_le_r9_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cc_r4_r9_r5),
    kInstruction_mul_cc_r4_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vs_r8_r1_r3),
    kInstruction_mul_vs_r8_r1_r3,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cc_r0_r10_r12),
    kInstruction_mul_cc_r0_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r7_r14_r0),
    kInstruction_mul_eq_r7_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vs_r12_r9_r11),
    kInstruction_mul_vs_r12_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_mul_gt_r5_r9_r11),
    kInstruction_mul_gt_r5_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cs_r14_r13_r7),
    kInstruction_mul_cs_r14_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_mul_mi_r11_r3_r10),
    kInstruction_mul_mi_r11_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r11_r8_r12),
    kInstruction_mul_hi_r11_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cs_r3_r8_r13),
    kInstruction_mul_cs_r3_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_mul_pl_r10_r12_r6),
    kInstruction_mul_pl_r10_r12_r6,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vc_r7_r3_r2),
    kInstruction_mul_vc_r7_r3_r2,
  },
  {
    ARRAY_SIZE(kInstruction_mul_mi_r9_r0_r8),
    kInstruction_mul_mi_r9_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r2_r13_r7),
    kInstruction_mul_eq_r2_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ne_r2_r14_r0),
    kInstruction_mul_ne_r2_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vs_r4_r10_r0),
    kInstruction_mul_vs_r4_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ls_r0_r2_r2),
    kInstruction_mul_ls_r0_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cc_r1_r6_r0),
    kInstruction_mul_cc_r1_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_mul_lt_r12_r0_r8),
    kInstruction_mul_lt_r12_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cc_r9_r3_r14),
    kInstruction_mul_cc_r9_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vs_r7_r9_r1),
    kInstruction_mul_vs_r7_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r11_r9_r14),
    kInstruction_mul_eq_r11_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_mul_pl_r6_r10_r4),
    kInstruction_mul_pl_r6_r10_r4,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ne_r8_r5_r6),
    kInstruction_mul_ne_r8_r5_r6,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cs_r0_r6_r2),
    kInstruction_mul_cs_r0_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r11_r12_r4),
    kInstruction_mul_eq_r11_r12_r4,
  },
  {
    ARRAY_SIZE(kInstruction_mul_lt_r14_r3_r14),
    kInstruction_mul_lt_r14_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_mul_le_r7_r12_r14),
    kInstruction_mul_le_r7_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r2_r9_r9),
    kInstruction_mul_hi_r2_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ne_r8_r1_r0),
    kInstruction_mul_ne_r8_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cc_r5_r11_r2),
    kInstruction_mul_cc_r5_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r0_r1_r2),
    kInstruction_mul_hi_r0_r1_r2,
  },
  {
    ARRAY_SIZE(kInstruction_mul_al_r4_r9_r4),
    kInstruction_mul_al_r4_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cs_r12_r7_r14),
    kInstruction_mul_cs_r12_r7_r14,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cc_r4_r12_r10),
    kInstruction_mul_cc_r4_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_mul_al_r3_r5_r10),
    kInstruction_mul_al_r3_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_mul_mi_r5_r3_r7),
    kInstruction_mul_mi_r5_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ls_r10_r6_r2),
    kInstruction_mul_ls_r10_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_mul_mi_r0_r12_r11),
    kInstruction_mul_mi_r0_r12_r11,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vc_r12_r5_r6),
    kInstruction_mul_vc_r12_r5_r6,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cs_r3_r9_r4),
    kInstruction_mul_cs_r3_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ls_r4_r9_r11),
    kInstruction_mul_ls_r4_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_mul_le_r14_r8_r13),
    kInstruction_mul_le_r14_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_mul_gt_r4_r10_r8),
    kInstruction_mul_gt_r4_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_al_r6_r9_r9),
    kInstruction_mul_al_r6_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ne_r8_r5_r12),
    kInstruction_mul_ne_r8_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ne_r0_r4_r8),
    kInstruction_mul_ne_r0_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_mi_r7_r13_r3),
    kInstruction_mul_mi_r7_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cc_r11_r7_r0),
    kInstruction_mul_cc_r11_r7_r0,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r1_r0_r12),
    kInstruction_mul_hi_r1_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_mul_lt_r8_r9_r3),
    kInstruction_mul_lt_r8_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_mul_al_r0_r2_r1),
    kInstruction_mul_al_r0_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vs_r4_r3_r14),
    kInstruction_mul_vs_r4_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ge_r2_r11_r1),
    kInstruction_mul_ge_r2_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_mul_lt_r12_r9_r6),
    kInstruction_mul_lt_r12_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ls_r8_r2_r7),
    kInstruction_mul_ls_r8_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_mul_le_r8_r13_r3),
    kInstruction_mul_le_r8_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r11_r13_r14),
    kInstruction_mul_eq_r11_r13_r14,
  },
  {
    ARRAY_SIZE(kInstruction_mul_lt_r1_r6_r13),
    kInstruction_mul_lt_r1_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cs_r3_r8_r11),
    kInstruction_mul_cs_r3_r8_r11,
  },
  {
    ARRAY_SIZE(kInstruction_mul_pl_r12_r5_r4),
    kInstruction_mul_pl_r12_r5_r4,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r8_r7_r2),
    kInstruction_mul_eq_r8_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ls_r2_r12_r2),
    kInstruction_mul_ls_r2_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_mul_le_r14_r2_r3),
    kInstruction_mul_le_r14_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ge_r10_r11_r6),
    kInstruction_mul_ge_r10_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r0_r2_r2),
    kInstruction_mul_hi_r0_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ge_r2_r0_r2),
    kInstruction_mul_ge_r2_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vs_r11_r14_r0),
    kInstruction_mul_vs_r11_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_mul_lt_r2_r0_r1),
    kInstruction_mul_lt_r2_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cs_r2_r5_r11),
    kInstruction_mul_cs_r2_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ls_r7_r14_r5),
    kInstruction_mul_ls_r7_r14_r5,
  },
  {
    ARRAY_SIZE(kInstruction_mul_pl_r0_r0_r3),
    kInstruction_mul_pl_r0_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ge_r6_r8_r8),
    kInstruction_mul_ge_r6_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_le_r11_r1_r10),
    kInstruction_mul_le_r11_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vs_r5_r2_r7),
    kInstruction_mul_vs_r5_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ne_r4_r4_r8),
    kInstruction_mul_ne_r4_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cc_r9_r14_r13),
    kInstruction_mul_cc_r9_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r14_r6_r3),
    kInstruction_mul_hi_r14_r6_r3,
  },
  {
    ARRAY_SIZE(kInstruction_mul_al_r0_r8_r0),
    kInstruction_mul_al_r0_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_mul_lt_r6_r11_r1),
    kInstruction_mul_lt_r6_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ge_r7_r6_r12),
    kInstruction_mul_ge_r7_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cs_r4_r6_r14),
    kInstruction_mul_cs_r4_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cs_r7_r6_r7),
    kInstruction_mul_cs_r7_r6_r7,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cs_r3_r7_r10),
    kInstruction_mul_cs_r3_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ne_r0_r2_r1),
    kInstruction_mul_ne_r0_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vs_r9_r10_r13),
    kInstruction_mul_vs_r9_r10_r13,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vc_r11_r14_r12),
    kInstruction_mul_vc_r11_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ge_r14_r8_r7),
    kInstruction_mul_ge_r14_r8_r7,
  },
  {
    ARRAY_SIZE(kInstruction_mul_lt_r13_r0_r11),
    kInstruction_mul_lt_r13_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_mul_lt_r14_r13_r4),
    kInstruction_mul_lt_r14_r13_r4,
  },
  {
    ARRAY_SIZE(kInstruction_mul_al_r1_r10_r9),
    kInstruction_mul_al_r1_r10_r9,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ge_r11_r14_r11),
    kInstruction_mul_ge_r11_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cs_r11_r4_r11),
    kInstruction_mul_cs_r11_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ge_r0_r14_r7),
    kInstruction_mul_ge_r0_r14_r7,
  },
  {
    ARRAY_SIZE(kInstruction_mul_mi_r1_r2_r9),
    kInstruction_mul_mi_r1_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r5_r12_r3),
    kInstruction_mul_eq_r5_r12_r3,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ge_r1_r5_r12),
    kInstruction_mul_ge_r1_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_mul_lt_r10_r11_r4),
    kInstruction_mul_lt_r10_r11_r4,
  },
  {
    ARRAY_SIZE(kInstruction_mul_le_r1_r1_r5),
    kInstruction_mul_le_r1_r1_r5,
  },
  {
    ARRAY_SIZE(kInstruction_mul_al_r9_r1_r8),
    kInstruction_mul_al_r9_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ne_r6_r8_r4),
    kInstruction_mul_ne_r6_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ge_r12_r2_r9),
    kInstruction_mul_ge_r12_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_mul_pl_r4_r3_r10),
    kInstruction_mul_pl_r4_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r14_r4_r11),
    kInstruction_mul_eq_r14_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cc_r9_r7_r6),
    kInstruction_mul_cc_r9_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ge_r12_r4_r5),
    kInstruction_mul_ge_r12_r4_r5,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r2_r3_r4),
    kInstruction_mul_hi_r2_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cs_r0_r3_r1),
    kInstruction_mul_cs_r0_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r6_r2_r8),
    kInstruction_mul_hi_r6_r2_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cc_r3_r14_r13),
    kInstruction_mul_cc_r3_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_mul_gt_r11_r4_r7),
    kInstruction_mul_gt_r11_r4_r7,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r5_r0_r12),
    kInstruction_mul_hi_r5_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_mul_gt_r0_r14_r14),
    kInstruction_mul_gt_r0_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r9_r0_r10),
    kInstruction_mul_hi_r9_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vc_r7_r11_r8),
    kInstruction_mul_vc_r7_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_pl_r11_r9_r6),
    kInstruction_mul_pl_r11_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_mul_al_r3_r3_r7),
    kInstruction_mul_al_r3_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_mul_mi_r5_r7_r9),
    kInstruction_mul_mi_r5_r7_r9,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cc_r11_r2_r4),
    kInstruction_mul_cc_r11_r2_r4,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cc_r9_r13_r10),
    kInstruction_mul_cc_r9_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_mul_al_r5_r2_r6),
    kInstruction_mul_al_r5_r2_r6,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ge_r9_r4_r6),
    kInstruction_mul_ge_r9_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ls_r3_r3_r4),
    kInstruction_mul_ls_r3_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ge_r14_r1_r8),
    kInstruction_mul_ge_r14_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ls_r7_r12_r7),
    kInstruction_mul_ls_r7_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_mul_al_r11_r10_r5),
    kInstruction_mul_al_r11_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_mul_al_r7_r4_r6),
    kInstruction_mul_al_r7_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vs_r12_r4_r10),
    kInstruction_mul_vs_r12_r4_r10,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r4_r4_r4),
    kInstruction_mul_eq_r4_r4_r4,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vs_r6_r6_r12),
    kInstruction_mul_vs_r6_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_mul_pl_r9_r3_r5),
    kInstruction_mul_pl_r9_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r6_r5_r13),
    kInstruction_mul_eq_r6_r5_r13,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cc_r8_r2_r12),
    kInstruction_mul_cc_r8_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_mul_le_r4_r2_r0),
    kInstruction_mul_le_r4_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_mul_lt_r7_r9_r8),
    kInstruction_mul_lt_r7_r9_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_le_r4_r7_r11),
    kInstruction_mul_le_r4_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r5_r7_r5),
    kInstruction_mul_eq_r5_r7_r5,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vc_r10_r7_r12),
    kInstruction_mul_vc_r10_r7_r12,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r7_r10_r6),
    kInstruction_mul_eq_r7_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_mul_pl_r1_r12_r2),
    kInstruction_mul_pl_r1_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_mul_le_r14_r6_r6),
    kInstruction_mul_le_r14_r6_r6,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ne_r3_r8_r8),
    kInstruction_mul_ne_r3_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r4_r12_r8),
    kInstruction_mul_eq_r4_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ge_r11_r2_r3),
    kInstruction_mul_ge_r11_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_mul_hi_r12_r6_r11),
    kInstruction_mul_hi_r12_r6_r11,
  },
  {
    ARRAY_SIZE(kInstruction_mul_cs_r4_r5_r10),
    kInstruction_mul_cs_r4_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ge_r10_r2_r10),
    kInstruction_mul_ge_r10_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ge_r5_r14_r6),
    kInstruction_mul_ge_r5_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_mul_gt_r13_r7_r5),
    kInstruction_mul_gt_r13_r7_r5,
  },
  {
    ARRAY_SIZE(kInstruction_mul_ge_r13_r4_r12),
    kInstruction_mul_ge_r13_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_mul_lt_r8_r10_r14),
    kInstruction_mul_lt_r8_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_mul_le_r4_r3_r13),
    kInstruction_mul_le_r4_r3_r13,
  },
  {
    ARRAY_SIZE(kInstruction_mul_pl_r0_r9_r0),
    kInstruction_mul_pl_r0_r9_r0,
  },
  {
    ARRAY_SIZE(kInstruction_mul_eq_r2_r3_r1),
    kInstruction_mul_eq_r2_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_mul_vc_r0_r0_r3),
    kInstruction_mul_vc_r0_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_mul_mi_r10_r8_r11),
    kInstruction_mul_mi_r10_r8_r11,
  },
  {
    ARRAY_SIZE(kInstruction_mul_mi_r5_r14_r14),
    kInstruction_mul_mi_r5_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_mul_gt_r5_r11_r2),
    kInstruction_mul_gt_r5_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_mul_al_r4_r7_r11),
    kInstruction_mul_al_r4_r7_r11,
  },
};

#endif  // VIXL_ASSEMBLER_COND_RD_RN_RM_MUL_A32_H_
