//
// Copyright (c) ZeroC, Inc. All rights reserved.
//

import Ice
import TestCommon

func allTests(_ helper: TestHelper) throws {
    func test(_ value: Bool, file: String = #file, line: Int = #line) throws {
        try helper.test(value, file: file, line: line)
    }
    let output = helper.getWriter()

    output.write("testing default values... ")
    do {
        let v = Struct1()
        try test(!v.boolFalse)
        try test(v.boolTrue)
        try test(v.b == 254)
        try test(v.s == 16000)
        try test(v.i == 3)
        try test(v.l == 4)
        try test(v.f == Float32(5.1))
        try test(v.d == Double(6.2))
        try test(v.str == "foo \\ \"bar\n \r\n\t\u{000b}\u{000C}\u{0007}\u{0008}? \u{0007} \u{0007}")
        try test(v.c1 == Color.red)
        try test(v.c2 == Color.green)
        try test(v.c3 == Color.blue)
        try test(v.nc1 == NestedColor.red)
        try test(v.nc2 == NestedColor.green)
        try test(v.nc3 == NestedColor.blue)
        try test(v.noDefault == "")
        try test(v.zeroI == 0)
        try test(v.zeroL == 0)
        try test(v.zeroF == 0)
        try test(v.zeroDotF == 0)
        try test(v.zeroD == 0)
        try test(v.zeroDotD == 0)
    }

    do {
        let v = Struct2()
        try test(v.boolTrue == ConstBool)
        try test(v.b == ConstByte)
        try test(v.s == ConstShort)
        try test(v.i == ConstInt)
        try test(v.l == ConstLong)
        try test(v.f == ConstFloat)
        try test(v.d == ConstDouble)
        try test(v.str == ConstString)
        try test(v.c1 == ConstColor1)
        try test(v.c2 == ConstColor2)
        try test(v.c3 == ConstColor3)
        try test(v.nc1 == ConstNestedColor1)
        try test(v.nc2 == ConstNestedColor2)
        try test(v.nc3 == ConstNestedColor3)
        try test(v.zeroI == ConstZeroI)
        try test(v.zeroL == ConstZeroL)
        try test(v.zeroF == ConstZeroF)
        try test(v.zeroDotF == ConstZeroDotF)
        try test(v.zeroD == ConstZeroD)
        try test(v.zeroDotD == ConstZeroDotD)
    }

    do {
        let v = Struct3()
        try test(!v.boolFalse)
        try test(v.boolTrue)
        try test(v.b == 1)
        try test(v.s == 2)
        try test(v.i == 3)
        try test(v.l == 4)
        try test(v.f == 5.1)
        try test(v.d == 6.2)
        try test(v.str == "foo \\ \"bar\n \r\n\t\u{000b}\u{000C}\u{0007}\u{0008}? \u{0007} \u{0007}")
        try test(v.c1 == Color.red)
        try test(v.c2 == Color.green)
        try test(v.c3 == Color.blue)
        try test(v.nc1 == NestedColor.red)
        try test(v.nc2 == NestedColor.green)
        try test(v.nc3 == NestedColor.blue)
        try test(v.noDefault == "")
        try test(v.zeroI == 0)
        try test(v.zeroL == 0)
        try test(v.zeroF == 0)
        try test(v.zeroDotF == 0)
        try test(v.zeroD == 0)
        try test(v.zeroDotD == 0)
    }

    do {
        let v = Base()
        try test(!v.boolFalse)
        try test(v.boolTrue)
        try test(v.b == 1)
        try test(v.s == 2)
        try test(v.i == 3)
        try test(v.l == 4)
        try test(v.f == 5.1)
        try test(v.d == 6.2)
        try test(v.str == "foo \\ \"bar\n \r\n\t\u{000b}\u{000C}\u{0007}\u{0008}? \u{0007} \u{0007}")
        try test(v.noDefault == "")
        try test(v.zeroI == 0)
        try test(v.zeroL == 0)
        try test(v.zeroF == 0)
        try test(v.zeroDotF == 0)
        try test(v.zeroD == 0)
        try test(v.zeroDotD == 0)
    }

    do {
        let v = Derived()
        try test(!v.boolFalse)
        try test(v.boolTrue)
        try test(v.b == 1)
        try test(v.s == 2)
        try test(v.i == 3)
        try test(v.l == 4)
        try test(v.f == 5.1)
        try test(v.d == 6.2)
        try test(v.str == "foo \\ \"bar\n \r\n\t\u{000b}\u{000c}\u{0007}\u{0008}? \u{0007} \u{0007}")
        try test(v.c1 == Color.red)
        try test(v.c2 == Color.green)
        try test(v.c3 == Color.blue)
        try test(v.nc1 == NestedColor.red)
        try test(v.nc2 == NestedColor.green)
        try test(v.nc3 == NestedColor.blue)
        try test(v.noDefault == "")
        try test(v.zeroI == 0)
        try test(v.zeroL == 0)
        try test(v.zeroF == 0)
        try test(v.zeroDotF == 0)
        try test(v.zeroD == 0)
        try test(v.zeroDotD == 0)
    }

    do {
        let v = BaseEx()
        try test(!v.boolFalse)
        try test(v.boolTrue)
        try test(v.b == 1)
        try test(v.s == 2)
        try test(v.i == 3)
        try test(v.l == 4)
        try test(v.f == 5.1)
        try test(v.d == 6.2)
        try test(v.str == "foo \\ \"bar\n \r\n\t\u{000b}\u{000c}\u{0007}\u{0008}? \u{0007} \u{0007}")
        try test(v.noDefault == "")
        try test(v.zeroI == 0)
        try test(v.zeroL == 0)
        try test(v.zeroF == 0)
        try test(v.zeroDotF == 0)
        try test(v.zeroD == 0)
        try test(v.zeroDotD == 0)
    }

    do {
        let v = DerivedEx()
        try test(!v.boolFalse)
        try test(v.boolTrue)
        try test(v.b == 1)
        try test(v.s == 2)
        try test(v.i == 3)
        try test(v.l == 4)
        try test(v.f == 5.1)
        try test(v.d == 6.2)
        try test(v.str == "foo \\ \"bar\n \r\n\t\u{000b}\u{000c}\u{0007}\u{0008}? \u{0007} \u{0007}")
        try test(v.noDefault == "")
        try test(v.c1 == Color.red)
        try test(v.c2 == Color.green)
        try test(v.c3 == Color.blue)
        try test(v.nc1 == NestedColor.red)
        try test(v.nc2 == NestedColor.green)
        try test(v.nc3 == NestedColor.blue)
        try test(v.zeroI == 0)
        try test(v.zeroL == 0)
        try test(v.zeroF == 0)
        try test(v.zeroDotF == 0)
        try test(v.zeroD == 0)
        try test(v.zeroDotD == 0)
    }
    output.writeLine("ok")
}
