// ----------------------------------------------------------------------------
//
//  Copyright (C) 2010-2017 Fons Adriaensen <fons@linuxaudio.org>
//    
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ----------------------------------------------------------------------------


#ifndef __JCLIENT_H
#define __JCLIENT_H


#include <inttypes.h>
#include <stdlib.h>
#include <math.h>
#include <clthreads.h>
#include <jack/jack.h>
#include "dyncom1.h"
#include "global.h"


class Jclient : public A_thread
{
public:

    Jclient (const char *jname, const char *jserv, int nchan);
    ~Jclient (void);

    const char *jack_name (void) const { return _clname; }
    Dyncom1 *dyncom (void) const { return (Dyncom1 *) _dyncom; }

private:

    void  init_jack (const char *jname, const char *jserv, int nchan);
    void  close_jack (void);
    void  jack_shutdown (void);
    int   jack_process (int nframes);

    virtual void thr_main (void) {}

    jack_client_t  *_client;
    const char     *_clname;
    jack_port_t    *_inpports [MAXCH];
    jack_port_t    *_outports [MAXCH];
    int             _fsamp;
    int             _nchan;
    Dyncom1        *_dyncom;
    bool            _active;

    static void jack_static_shutdown (void *arg);
    static int  jack_static_process (jack_nframes_t nframes, void *arg);
};


#endif
