/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import proguard.obfuscate.NameFactory;
import proguard.obfuscate.SimpleNameFactory;

public class DictionaryNameFactory
implements NameFactory {
    private static final char COMMENT_CHARACTER = '#';
    private final List names;
    private final NameFactory nameFactory;
    private int index = 0;

    public DictionaryNameFactory(URL uRL, NameFactory nameFactory) throws IOException {
        this(uRL, true, nameFactory);
    }

    public DictionaryNameFactory(URL uRL, boolean bl, NameFactory nameFactory) throws IOException {
        this(new BufferedReader(new InputStreamReader(uRL.openStream(), "UTF-8")), bl, nameFactory);
    }

    public DictionaryNameFactory(File file, NameFactory nameFactory) throws IOException {
        this(file, true, nameFactory);
    }

    public DictionaryNameFactory(File file, boolean bl, NameFactory nameFactory) throws IOException {
        this(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8")), bl, nameFactory);
    }

    public DictionaryNameFactory(Reader reader, NameFactory nameFactory) throws IOException {
        this(reader, true, nameFactory);
    }

    public DictionaryNameFactory(Reader reader, boolean bl, NameFactory nameFactory) throws IOException {
        this.names = new ArrayList();
        this.nameFactory = nameFactory;
        try {
            StringBuffer stringBuffer = new StringBuffer();
            while (true) {
                int n;
                if ((n = reader.read()) != -1 && (bl ? (stringBuffer.length() == 0 ? Character.isJavaIdentifierStart((char)n) : Character.isJavaIdentifierPart((char)n)) : n != 10 && n != 13 && n != 35)) {
                    stringBuffer.append((char)n);
                    continue;
                }
                if (stringBuffer.length() > 0) {
                    String string = stringBuffer.toString();
                    if (!this.names.contains(string)) {
                        this.names.add(string);
                    }
                    stringBuffer.setLength(0);
                }
                if (n == 35) {
                    while ((n = reader.read()) != -1 && n != 10 && n != 13) {
                    }
                }
                if (n != -1) continue;
                return;
            }
        }
        finally {
            reader.close();
        }
    }

    public DictionaryNameFactory(DictionaryNameFactory dictionaryNameFactory, NameFactory nameFactory) {
        this.names = dictionaryNameFactory.names;
        this.nameFactory = nameFactory;
    }

    @Override
    public void reset() {
        this.index = 0;
        this.nameFactory.reset();
    }

    @Override
    public String nextName() {
        String string;
        if (this.index < this.names.size()) {
            string = (String)this.names.get(this.index++);
        } else {
            while (this.names.contains(string = this.nameFactory.nextName())) {
            }
        }
        return string;
    }

    public static void main(String[] stringArray) {
        try {
            DictionaryNameFactory dictionaryNameFactory = new DictionaryNameFactory(new File(stringArray[0]), (NameFactory)new SimpleNameFactory());
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
            for (int i = 0; i < 50; ++i) {
                printWriter.println("[" + dictionaryNameFactory.nextName() + "]");
            }
            printWriter.flush();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

